/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.accounttype;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostPriceResultInfo;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.AbstractAccountType;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.helper.CostPriceSourceTypeHelper;
import kd.fi.calx.algox.report.RptStatus;

public class WeightedAvgAT
extends AbstractAccountType {
    private String beforeQueueType = "0";
    private BigDecimal outUnitActualCost = BigDecimal.ZERO;
    private Map<Long, BigDecimal> elementUnitCost = new HashMap<Long, BigDecimal>();
    private LocalRow lastOutNotGroupedRow = null;
    private LocalRow lastRow = null;
    private boolean isMinusPrice = false;
    private boolean isExistInQueue = false;
    private boolean isGroupUnitCost = false;
    private boolean isDestBillOutCalRpt = false;
    private boolean isInBillUnitCost = true;
    private boolean isAllNotInZeroInOutBizType = false;
    private boolean isDestBillUnitCost = false;
    private boolean isExistOutAndGroupBill = false;
    private boolean isPresent = false;
    private boolean inBillAllAmtZero = true;
    private boolean inBillAllQtyZero = true;
    private boolean outBillAllUnitAmtZero = true;
    private int zeroCostMark = 2;
    private int presentMark = 1;
    private static final long serialVersionUID = -4921967014055433092L;
    private AccountTypeContext ctx;
    private boolean priceResultSuccess = false;
    private String priceResultNo;

    public WeightedAvgAT(AccountTypeContext ctx, DataSet dataSet, int runningMode, Map<Long, CostAccount> costAccountMap) {
        super(ctx, dataSet, runningMode, costAccountMap);
        this.ctx = ctx;
        this.zeroInOutBizTypeIds = (Set)ctx.getParamCache().getParamValue("zeroInOutBizTypeIds");
    }

    public boolean isInBillAllAmtZero() {
        return this.inBillAllAmtZero;
    }

    public void setInBillAllAmtZero(boolean inBillAllAmtZero) {
        this.inBillAllAmtZero = inBillAllAmtZero;
    }

    public boolean isInBillAllQtyZero() {
        return this.inBillAllQtyZero;
    }

    public void setInBillAllQtyZero(boolean inBillAllQtyZero) {
        this.inBillAllQtyZero = inBillAllQtyZero;
    }

    @Override
    protected String[] getOrderByField() {
        return new String[]{"queuetype", "bizdate", "auditdate"};
    }

    @Override
    protected void calculateOut(LocalRow row) {
        String currentRowType = row.getQueuetype();
        if ("0".equals(currentRowType)) {
            this.isExistInQueue = true;
        } else if ("1".equals(currentRowType) || row.isInGroup()) {
            this.isExistOutAndGroupBill = true;
        }
        Long bizTypeId = row.getBizTypeId();
        if (row.isDestBill() && "0".equals(currentRowType) && !this.zeroInOutBizTypeIds.contains(bizTypeId)) {
            this.isAllNotInZeroInOutBizType = true;
        }
        if ("0".equals(this.beforeQueueType) && "1".equals(currentRowType)) {
            this.calAvgActualCost(row);
        }
        this.beforeQueueType = currentRowType;
        if ("0".equals(currentRowType)) {
            this.calInQueueCost(row);
        } else {
            this.calOutQueueCost(row);
        }
        this.lastRow = row;
    }

    @Override
    protected void afterCalculated() {
        super.afterCalculated();
        this.insertCalRptLog();
    }

    private void insertCalRptLog() {
        int beginPrice = this.getBeginPrice();
        if (!this.isExistOutAndGroupBill) {
            this.isMinusPrice = true;
        }
        if (beginPrice == 0) {
            if (this.inBillAllAmtZero && !this.isInBillAllQtyZero() && this.outBillAllUnitAmtZero) {
                return;
            }
            if (!this.isExistInQueue && this.isMinusPrice) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u521d\u96f6\u5355\u4ef7\u4e14\u65e0\u5165\u5e93\u3002", (String)"WeightedAvgAT_9", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            }
            if (this.isExistInQueue && this.isInBillUnitCost && !this.isDestBillOutCalRpt && this.isMinusPrice) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u521d\u96f6\u5355\u4ef7\u4e14\u5165\u5e93\u5168\u4e3a0\u6210\u672c\u3002", (String)"WeightedAvgAT_10", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            } else if (!this.isExistInQueue && this.isDestBillUnitCost && this.isMinusPrice) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u521d\u96f6\u5355\u4ef7\u4e14\u5165\u5e93\u5168\u4e3a0\u6210\u672c\u3002", (String)"WeightedAvgAT_10", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            } else if (this.isInBillUnitCost && this.isDestBillUnitCost && this.isMinusPrice) {
                this.holder.setCalStatus(RptStatus.WARNING);
                this.holder.setLog(ResManager.loadKDString((String)"\u671f\u521d\u96f6\u5355\u4ef7\u4e14\u5165\u5e93\u5168\u4e3a0\u6210\u672c\u3002", (String)"WeightedAvgAT_10", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
            }
        }
        if (beginPrice == -1 && this.isMinusPrice) {
            this.holder.setCalStatus(RptStatus.WARNING);
            this.holder.setLog(ResManager.loadKDString((String)"\u671f\u521d\u8d1f\u5355\u4ef7", (String)"WeightedAvgAT_11", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
        }
        if (this.isGroupUnitCost && this.isAllNotInZeroInOutBizType && this.isDestBillOutCalRpt) {
            this.holder.setCalStatus(RptStatus.WARNING);
            this.holder.setLog(ResManager.loadKDString((String)"\u8de8\u6838\u7b97\u8303\u56f4\u6210\u7ec4\u5165\u5e93\u53550\u6210\u672c", (String)"WeightedAvgAT_12", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
        }
    }

    protected void calInQueueCost(LocalRow row) {
        boolean enableJoinCalute = row.isEnableJoinCalute();
        if (!enableJoinCalute) {
            row.setCostpriceSourceType(null);
            if (row.isDestBill() && row.isGroupCostCalculated().booleanValue()) {
                this.setDissAdjustCostPriceSourceDesign(row);
            }
            this.tempInGroupRow.add(row);
            return;
        }
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null);
            return;
        }
        if (row.isCostDetermined()) {
            if (2 == this.getRunningMode()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.getLastByCostPriceSource(row.getCostpricesource()));
            }
            this.joinCalculate(row, null);
            if (row.isDestBill()) {
                if (row.isGroupCostCalculated().booleanValue()) {
                    CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                    if (costAdjustInfo != null) {
                        this.joinCalculate(costAdjustInfo);
                    }
                } else {
                    this.tempInGroupRow.add(row);
                }
            }
        } else if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                this.joinCalculate(row, null);
            } else {
                if (row.isPriced()) {
                    CostPriceResultInfo priceResult = row.getPriceResult();
                    if (priceResult != null && priceResult.isSuccess()) {
                        row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                    }
                    this.joinCalculate(row, null);
                }
                this.tempInGroupRow.add(row);
            }
        } else {
            this.joinCalculate(row, null);
        }
        if (row.isDestBill() && row.isGroupCostCalculated().booleanValue() || row.isPriced() && row.getPriceResult().isSuccess()) {
            this.addCostUpdateInfo(row);
        } else if (!this.tempInGroupRow.contains(row)) {
            row.setIscalculated(true);
            this.addCostUpdateInfo(row);
        }
        if (!this.tempInGroupRow.contains(row)) {
            this.addQtyAmtMark(row);
        }
    }

    private void calOutQueueCost(LocalRow row) {
        boolean enableJoinCalute = row.isEnableJoinCalute();
        if (!enableJoinCalute) {
            row.setCostpriceSourceType(null);
            if (row.isDestBill() && row.isGroupCostCalculated().booleanValue()) {
                this.setDissAdjustCostPriceSourceDesign(row);
            }
            this.tempInGroupRow.add(row);
            return;
        }
        if ("2".equals(row.getRowtype())) {
            this.joinCalculate(row, null);
            return;
        }
        if (row.isCostDetermined()) {
            if (2 == this.getRunningMode()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.getLastByCostPriceSource(row.getCostpricesource()));
            }
            this.joinCalculate(row, null);
            if (row.isDestBill()) {
                this.tempInGroupRow.add(row);
            }
        } else if (row.isDestBill()) {
            if (row.isGroupCostCalculated().booleanValue()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                this.joinCalculate(row, null);
                this.addCostUpdateInfo(row);
                CostAdjustInfo costAdjustInfo = this.addGroupBillCostAdjustInfo(row);
                if (costAdjustInfo != null) {
                    this.joinCalculate(costAdjustInfo);
                }
            } else {
                this.tempInGroupRow.add(row);
            }
        } else {
            boolean designatedcost = row.isDesignatedcost();
            boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
            if (this.outUnitActualCost.compareTo(BigDecimal.ZERO) >= 0) {
                Map<Long, BigDecimal> elementCostMap;
                if (!designatedcost || designatedcost && coverdesigoutcost) {
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.CALCULATE_COST_SPECIFICATION.getValue());
                    for (Map.Entry<Long, BigDecimal> entry : this.elementUnitCost.entrySet()) {
                        row.setDirectUnitCost(entry.getKey(), entry.getValue());
                        row.setDirectCost(entry.getKey(), entry.getValue().multiply(row.getBaseqty()).setScale(row.getAmtprecision(), RoundingMode.HALF_UP));
                    }
                    row.setDirectUnitActualCost(this.outUnitActualCost);
                    row.refreshDirectActualCostByElement();
                    if (this.priceResultSuccess) {
                        row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                        row.setSrcbillno(this.priceResultNo);
                    }
                }
                if ("0".equals(row.getRowtype())) {
                    if (row.isPresent()) {
                        elementCostMap = row.getElementCostMap();
                        for (Long element : elementCostMap.keySet()) {
                            elementCostMap.put(element, BigDecimal.ZERO);
                            row.setDirectCost(element, BigDecimal.ZERO);
                            row.setDirectUnitCost(element, BigDecimal.ZERO);
                        }
                        row.setDirectUnitActualCost(BigDecimal.ZERO);
                        row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
                        row.refreshDirectActualCostByElement();
                        row.setMarkZero(this.presentMark);
                        row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                    }
                } else if (row.isInvTxZeroCost() || row.isEnableInBillZeroCost() && this.isInBillAllAmtZero()) {
                    elementCostMap = row.getElementCostMap();
                    for (Long element : elementCostMap.keySet()) {
                        elementCostMap.put(element, BigDecimal.ZERO);
                        row.setDirectCost(element, BigDecimal.ZERO);
                        row.setDirectUnitCost(element, BigDecimal.ZERO);
                    }
                    row.setDirectUnitActualCost(BigDecimal.ZERO);
                    row.setActualCost(BigDecimal.ZERO, Boolean.TRUE);
                    row.refreshDirectActualCostByElement();
                    row.setMarkZero(this.zeroCostMark);
                    row.setCostpriceSourceType(CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue());
                }
                this.addCostUpdateInfo(row);
            } else {
                this.holder.setCalStatus(RptStatus.ERROR);
            }
            row.setGroupCostCalculated(true);
            this.lastOutNotGroupedRow = null;
            if (!row.isInGroup() && !row.isInvTxZeroCost()) {
                if (coverdesigoutcost) {
                    this.lastOutNotGroupedRow = row;
                } else if (!designatedcost) {
                    this.lastOutNotGroupedRow = row;
                }
            }
            this.joinCalculate(row, null);
        }
    }

    private boolean invalidCalBalOrPriceValid() {
        return this.isInvalidCalBal() || !this.isInvalidCalBal() && this.isInBillAllAmtZero() || this.isPresent;
    }

    protected void addQtyAmtMark(LocalRow row) {
        if ("0".equals(row.getQueuetype()) && !"2".equals(row.getRowtype())) {
            BigDecimal qty;
            BigDecimal bigDecimal = qty = row.getBaseqty() == null ? BigDecimal.ZERO : row.getBaseqty();
            if (BigDecimal.ZERO.compareTo(qty) != 0) {
                this.setInBillAllQtyZero(false);
            }
        }
    }

    @Override
    protected void beforeEndCalculated() {
        this.tempInGroupRow.sort(new Comparator<LocalRow>(){

            @Override
            public int compare(LocalRow row1, LocalRow row2) {
                if (row1.getBizDate().equals(row2.getBizDate())) {
                    if (row1.getAuditTime().equals(row2.getAuditTime())) {
                        if (row1.getQueuetype() == null || row2.getQueuetype() == null) {
                            String billno = row1 == null ? row1.getBillnumber() : row2.getBillnumber();
                            String msg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201c%1$s\u201d\u4e2d\uff0c\u5b58\u5728\u5e8f\u5217\u7c7b\u578b\u4e3a\u7a7a\u7684\u5206\u5f55\uff0c\u8ba1\u7b97\u7ec8\u6b62\u3002", (String)"WeightedAvgAT_6", (String)"fi-calx-algox", (Object[])new Object[0]), billno);
                            throw new KDBizException(msg);
                        }
                        return 0 - row1.getQueuetype().compareTo(row2.getQueuetype());
                    }
                    return row1.getAuditTime().compareTo(row2.getAuditTime());
                }
                return row1.getBizDate().compareTo(row2.getBizDate());
            }
        });
        ArrayList<LocalRow> rows = new ArrayList<LocalRow>(16);
        for (Iterator row : this.tempInGroupRow) {
            row = this.getGroupedRow(((LocalRow)((Object)row)).getEntryId());
            rows.add((LocalRow)((Object)row));
        }
        this.afterCalcGroupCost(rows);
        ArrayList<LocalRow> costNotDeterminedRows = new ArrayList<LocalRow>(16);
        for (LocalRow row : this.tempInGroupRow) {
            CostAdjustInfo costAdjustInfo;
            boolean enableJoinCalute = row.isEnableJoinCalute();
            if (!enableJoinCalute) {
                this.joinCalculate(row, ResManager.loadKDString((String)"(\u4e0d\u53c2\u4e0e\u52a0\u6743\u8ba1\u7b97)", (String)"WeightedAvgAT_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                continue;
            }
            if ((row = this.getGroupedRow(row.getEntryId())).isGroupCostCalculated().booleanValue() && !row.isCostDetermined()) {
                CostPriceSourceTypeHelper.setCostpriceSourceByGroup(row, this.ctx.enableCoverdesigoutcost());
                if ("0".equals(row.getQueuetype())) {
                    this.addCostUpdateInfo(row);
                    if (!row.isPriced()) {
                        this.joinCalculate(row, ResManager.loadKDString((String)"(\u4e0d\u53c2\u4e0e\u52a0\u6743\u8ba1\u7b97)", (String)"WeightedAvgAT_0", (String)"fi-calx-algox", (Object[])new Object[0]));
                        this.lastRow = row;
                    }
                } else {
                    this.addCostUpdateInfo(row);
                    this.joinCalculate(row, null);
                    this.lastRow = row;
                }
            } else if (!row.isCostDetermined() && !row.isPriced()) {
                costNotDeterminedRows.add(row);
            }
            if ((costAdjustInfo = this.addGroupBillCostAdjustInfo(row)) == null) continue;
            this.joinCalculate(costAdjustInfo);
        }
        if (!costNotDeterminedRows.isEmpty()) {
            this.holder.setCalStatus(RptStatus.WARNING);
        }
        for (LocalRow costNotDeterminedRow : costNotDeterminedRows) {
            this.joinCalculate(costNotDeterminedRow, ResManager.loadKDString((String)"(\u6210\u672c\u672a\u786e\u5b9a)", (String)"WeightedAvgAT_13", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        String creatediffbilltype = this.getCreateDiffBillType();
        if ("no".equals(creatediffbilltype)) {
            return;
        }
        Map<Long, BigDecimal> diffMap = this.getAdjustDiff();
        if (diffMap == null || diffMap.isEmpty()) {
            return;
        }
        if ("diffbalance".equals(creatediffbilltype)) {
            if (this.isAdjustLastOutNotGrouedRow(diffMap)) {
                this.adjustExceptionAmt();
                return;
            }
        } else if ("diffadjust".equals(creatediffbilltype)) {
            if (this.isAdjustLastOutNotGrouedRow(diffMap)) {
                this.adjustExceptionAmt();
                return;
            }
            if (this.lastRow != null) {
                this.createDiffAdjustBill();
            }
        }
    }

    private boolean isAdjustLastOutNotGrouedRow(Map<Long, BigDecimal> diffMap) {
        if (this.lastOutNotGroupedRow == null) {
            return false;
        }
        BigDecimal qty = this.lastOutNotGroupedRow.getBaseqty();
        for (Map.Entry<Long, BigDecimal> diffEntry : diffMap.entrySet()) {
            Long elementId = diffEntry.getKey();
            BigDecimal cost = diffEntry.getValue();
            BigDecimal billCost = this.lastOutNotGroupedRow.getCost(elementId);
            int signum = billCost.add(cost).signum();
            if (signum == 0 || signum == qty.signum()) continue;
            return false;
        }
        return true;
    }

    private void createDiffAdjustBill() {
        DynamicObject costAdjustOutBillType = (DynamicObject)this.ctx.getParamCache().getParamValue("costAdjustOutBillType");
        CostAdjustInfo adjustInfo = this.createCostAdjustInfo(this.lastRow, "B", "N", costAdjustOutBillType);
        for (Map.Entry<Long, BigDecimal> entry : this.getElementTotalCostMap().entrySet()) {
            BigDecimal totalCost = entry.getValue();
            Long elementId = entry.getKey();
            adjustInfo.setAdjustCost(this.getElementMap().get(elementId), totalCost);
        }
        this.joinCalculate(adjustInfo);
    }

    private Map<Long, BigDecimal> getAdjustDiff() {
        BigDecimal currentQty = this.getCurrentTotalQty();
        if (currentQty.compareTo(BigDecimal.ZERO) != 0) {
            return null;
        }
        HashMap<Long, BigDecimal> diffMap = new HashMap<Long, BigDecimal>(16);
        Map<Long, BigDecimal> elementCostMap = this.getElementTotalCostMap();
        BigDecimal diffRange = this.getDiffrange();
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        if (diffRange != null && currentTotalCost != null && currentTotalCost.abs().compareTo(diffRange) > 0) {
            return null;
        }
        for (Map.Entry<Long, BigDecimal> balance : elementCostMap.entrySet()) {
            Long elementid = balance.getKey();
            BigDecimal cost = balance.getValue();
            if (cost.compareTo(BigDecimal.ZERO) == 0) continue;
            diffMap.put(elementid, cost);
        }
        return diffMap;
    }

    private void joinCalculate(CostAdjustInfo adjustInfo) {
        if (adjustInfo == null) {
            return;
        }
        int index = this.holder.createNewEntry(adjustInfo);
        StringBuilder formula = new StringBuilder();
        formula.append(this.toBigDecimalString(adjustInfo.getAdjustAmt().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.holder.setInFormula(index, formula.toString());
        } else {
            this.holder.setOutFormula(index, formula.toString());
        }
        String invbillnum = CostPriceSourceTypeEnum.getCostAdjuestInvbillNum(adjustInfo);
        if (!StringUtils.isEmpty((CharSequence)invbillnum)) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355(\u5bf9\u5e94\u5e93\u5b58\u5355\u636e\u53f7\uff1a%1$s)", (String)"MoveAddAverageCalculate_14", (String)"fi-calx-algox", (Object[])new Object[0]), invbillnum);
            this.holder.setBillType(index, msg);
        }
        formula.setLength(0);
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        if ("A".equals(adjustInfo.getCallBillType())) {
            formula.append('+');
        } else {
            formula.append('-');
        }
        formula.append(this.toBigDecimalString(adjustInfo.getAdjustAmt().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        formula.append('=');
        this.holder.setBalanceFormula(index, formula.toString());
        Map<Long, CostSubElement> elementMap = this.getElementMap();
        HashMap<Long, Integer> subIndexMap = new HashMap<Long, Integer>(elementMap.size());
        for (Map.Entry<Long, CostSubElement> entry : elementMap.entrySet()) {
            Long elementId = entry.getKey();
            BigDecimal elementCost = adjustInfo.getAdjustCost(elementId);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(elementId);
            if (elementCost.compareTo(BigDecimal.ZERO) == 0 && elementTotalCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int subIndex = this.holder.createNewSubEntry(index, entry.getValue().getName());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(adjustInfo.getAdjustCost(elementId)));
            if ("A".equals(adjustInfo.getCallBillType())) {
                this.holder.setInFormula(subIndex, formula.toString());
            } else {
                this.holder.setOutFormula(subIndex, formula.toString());
            }
            formula.setLength(0);
            formula.append(this.toBigDecimalString(elementTotalCost.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            if ("A".equals(adjustInfo.getCallBillType())) {
                formula.append('+');
            } else {
                formula.append('-');
            }
            formula.append(this.toBigDecimalString(elementCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            formula.append('=');
            this.holder.setBalanceFormula(subIndex, formula.toString());
            subIndexMap.put(elementId, subIndex);
        }
        if ("A".equals(adjustInfo.getCallBillType())) {
            this.sumToTotal(adjustInfo);
        } else {
            this.substractToTotal(adjustInfo);
        }
        formula.setLength(0);
        currentTotalCost = this.getCurrentTotalCost();
        formula.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.appendBalanceFormula(index, formula.toString());
        for (Map.Entry<Long, CostSubElement> entry : subIndexMap.entrySet()) {
            formula.setLength(0);
            BigDecimal elementTotalCost = this.getElementTotalCostMap().get(entry.getKey());
            formula.append(this.toBigDecimalString(elementTotalCost));
            this.holder.appendBalanceFormula((Integer)((Object)entry.getValue()), formula.toString());
        }
    }

    private void adjustExceptionAmt() {
        Integer index = null;
        for (Map.Entry<Long, BigDecimal> entry : this.getElementTotalCostMap().entrySet()) {
            BigDecimal elementCost = entry.getValue();
            if (elementCost.compareTo(BigDecimal.ZERO) == 0) continue;
            if (index == null) {
                BigDecimal currentTotalCost = this.getCurrentTotalCost();
                index = this.holder.createNewEntry(this.lastOutNotGroupedRow);
                String msg = String.format(ResManager.loadKDString((String)"%1$s(\u5904\u7406\u671f\u672b\u5f02\u5e38\u4f59\u989d)", (String)"WeightedAvgAT_1", (String)"fi-calx-algox", (Object[])new Object[0]), this.lastOutNotGroupedRow.getBilltype());
                this.holder.setBillType(index, msg);
                StringBuilder formula = new StringBuilder();
                formula.append(this.toBigDecimalString(this.lastOutNotGroupedRow.getActualCost()));
                formula.append('+');
                formula.append(this.toBigDecimalString(currentTotalCost));
                formula.append('=');
                formula.append(this.toBigDecimalString(this.lastOutNotGroupedRow.getActualCost().add(currentTotalCost)));
                this.holder.setOutFormula(index, formula.toString());
                formula.setLength(0);
                formula.append(this.toBigDecimalString(currentTotalCost));
                formula.append('-');
                formula.append(this.toBigDecimalString(currentTotalCost));
                formula.append('=');
                formula.append(this.toBigDecimalString(BigDecimal.ZERO));
                this.holder.setBalanceFormula(index, formula.toString());
                this.lastOutNotGroupedRow.setActualCost(this.lastOutNotGroupedRow.getActualCost().add(currentTotalCost), true);
            }
            Long elementId = entry.getKey();
            BigDecimal cost = entry.getValue();
            int subIndex = this.holder.createNewSubEntry(index, this.getElementMap().get(elementId).getName());
            String msg = String.format(ResManager.loadKDString((String)"%1$s(\u5904\u7406\u671f\u672b\u5f02\u5e38\u4f59\u989d)", (String)"WeightedAvgAT_1", (String)"fi-calx-algox", (Object[])new Object[0]), this.lastOutNotGroupedRow.getBilltype());
            this.holder.setBillType(index, msg);
            StringBuilder formula = new StringBuilder();
            formula.append(this.toBigDecimalString(this.lastOutNotGroupedRow.getCost(elementId)));
            formula.append('+');
            formula.append(this.toBigDecimalString(cost));
            formula.append('=');
            formula.append(this.toBigDecimalString(this.lastOutNotGroupedRow.getCost(elementId).add(cost)));
            this.holder.setOutFormula(subIndex, formula.toString());
            this.addTotalCostElementCost(elementId, cost.negate());
            formula.setLength(0);
            formula.append(this.toBigDecimalString(cost));
            formula.append('-');
            formula.append(this.toBigDecimalString(cost));
            formula.append('=');
            formula.append(this.toBigDecimalString(BigDecimal.ZERO));
            this.holder.setBalanceFormula(subIndex, formula.toString());
            this.lastOutNotGroupedRow.setCost(elementId, this.lastOutNotGroupedRow.getCost(elementId).add(cost));
        }
        this.lastOutNotGroupedRow.refreshDirectActualCostByElement();
        this.addCostUpdateInfo(this.lastOutNotGroupedRow);
    }

    /*
     * WARNING - void declaration
     */
    protected void calAvgActualCost(LocalRow row) {
        CostPriceResultInfo priceResult;
        BigDecimal currentTotalQty = this.getCurrentTotalQty();
        BigDecimal currentTotalCost = this.getCurrentTotalCost();
        if (BigDecimal.ZERO.compareTo(currentTotalQty) != 0) {
            this.outUnitActualCost = currentTotalCost.divide(currentTotalQty, 10, RoundingMode.HALF_UP);
            for (Long elementId : this.getElementMap().keySet()) {
                BigDecimal unitElementCost = this.getElementTotalCost(elementId).divide(currentTotalQty, 10, RoundingMode.HALF_UP);
                this.elementUnitCost.put(elementId, unitElementCost);
            }
        } else {
            for (Long elementId : this.getElementMap().keySet()) {
                this.elementUnitCost.put(elementId, BigDecimal.ZERO);
            }
        }
        int lastPriceIndex = this.holder.createNewEntry();
        StringBuilder sb = new StringBuilder();
        this.holder.setBillType(lastPriceIndex, ResManager.loadKDString((String)"\u52a0\u6743\u8ba1\u7b97\u7ed3\u679c", (String)"WeightedAvgAT_3", (String)"fi-calx-algox", (Object[])new Object[0]));
        sb.append(this.toBigDecimalString(this.outUnitActualCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
        sb.append('=');
        sb.append(this.toBigDecimalString(currentTotalCost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        sb.append('/');
        sb.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
        this.holder.setInFormula(lastPriceIndex, sb.toString());
        for (Map.Entry entry : this.elementUnitCost.entrySet()) {
            sb.setLength(0);
            Long elementId = (Long)entry.getKey();
            BigDecimal unitCost = (BigDecimal)entry.getValue();
            if (unitCost.compareTo(BigDecimal.ZERO) == 0) continue;
            int n = this.holder.createNewSubEntry(lastPriceIndex, this.getElementMap().get(elementId).getName());
            sb.append(this.toBigDecimalString(unitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            sb.append('=');
            sb.append(this.toBigDecimalString(this.getElementTotalCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            sb.append('/');
            sb.append(this.toBigDecimalString(currentTotalQty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            this.holder.setInFormula(n, sb.toString());
        }
        if (!(this.outUnitActualCost.compareTo(BigDecimal.ZERO) != 0 || this.isBeginAmtAllZero() && this.isInBillAllAmtZero() && !this.isInBillAllQtyZero() && this.outBillAllUnitAmtZero)) {
            this.holder.setCalStatus(RptStatus.WARNING);
            this.holder.setLog(ResManager.loadKDString((String)"\u52a0\u6743\u5355\u4ef7\u4e3a\u96f6", (String)"WeightedAvgAT_8", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
        }
        if (this.outUnitActualCost.compareTo(BigDecimal.ZERO) == 0 && this.ctx.enableZeroPrice() && (!this.isBeginAmtAllZero() || !this.isInBillAllAmtZero() || this.getBeginPrice() == 0 && this.isBeginQtyAllZero() && this.isInBillAllQtyZero() && this.isInBillAllAmtZero())) {
            lastPriceIndex = this.holder.createNewEntry();
            sb.setLength(0);
            this.holder.setBillType(lastPriceIndex, ResManager.loadKDString((String)"\u96f6\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"WeightedAvgAT_5", (String)"fi-calx-algox", (Object[])new Object[0]));
            priceResult = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "E");
            if (!priceResult.isSuccess()) {
                this.holder.setInFormula(lastPriceIndex, priceResult.getErrMsg());
            } else {
                boolean bl = row.isDesignatedcost();
                boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
                if (!bl || bl && coverdesigoutcost) {
                    this.priceResultSuccess = true;
                    this.priceResultNo = priceResult.getSrcPriceName() + priceResult.getSrcBillno();
                    if (StringUtils.isEmpty((CharSequence)row.getSrcbillno())) {
                        row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
                        row.setSrcbillno(priceResult.getSrcPriceName() + priceResult.getSrcBillno());
                        this.priceResultNo = row.getSrcbillno();
                    }
                }
                for (Map.Entry entry : this.getElementMap().entrySet()) {
                    Long elementId = (Long)entry.getKey();
                    BigDecimal unitCost = priceResult.getCostSubElementUnitcostMap().get(elementId);
                    if (unitCost == null) {
                        unitCost = BigDecimal.ZERO;
                    }
                    this.elementUnitCost.put(elementId, unitCost);
                    this.outUnitActualCost = this.outUnitActualCost.add(unitCost);
                    if (unitCost.compareTo(BigDecimal.ZERO) == 0) continue;
                    int subIndex = this.holder.createNewSubEntry(lastPriceIndex, ((CostSubElement)entry.getValue()).getName());
                    this.holder.setInFormula(subIndex, priceResult.getSrcPriceName() + ":" + this.toBigDecimalString(unitCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                }
                sb.append(priceResult.getSrcPriceName());
                sb.append(':');
                sb.append(this.toBigDecimalString(this.outUnitActualCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                this.holder.setInFormula(lastPriceIndex, sb.toString());
            }
        }
        if (this.outUnitActualCost.compareTo(BigDecimal.ZERO) < 0 && this.ctx.enableAvgNegPrice()) {
            lastPriceIndex = this.holder.createNewEntry();
            sb.setLength(0);
            this.holder.setBillType(lastPriceIndex, ResManager.loadKDString((String)"\u52a0\u6743\u8d1f\u5355\u4ef7\u53d6\u4ef7\u7ed3\u679c", (String)"WeightedAvgAT_16", (String)"fi-calx-algox", (Object[])new Object[0]));
            priceResult = this.getCostPrice(row.getHeadid(), row.getEntryId(), row.getRowtype(), "L");
            if (!priceResult.isSuccess()) {
                this.holder.setInFormula(lastPriceIndex, priceResult.getErrMsg());
            } else {
                this.outUnitActualCost = BigDecimal.ZERO;
                for (Map.Entry<Long, CostSubElement> priceEntry : this.getElementMap().entrySet()) {
                    void var10_19;
                    Long elementId = priceEntry.getKey();
                    BigDecimal bigDecimal = priceResult.getCostSubElementUnitcostMap().get(elementId);
                    if (bigDecimal == null) {
                        BigDecimal bigDecimal2 = BigDecimal.ZERO;
                    }
                    this.elementUnitCost.put(elementId, (BigDecimal)var10_19);
                    this.outUnitActualCost = this.outUnitActualCost.add((BigDecimal)var10_19);
                    if (var10_19.compareTo(BigDecimal.ZERO) == 0) continue;
                    int subIndex = this.holder.createNewSubEntry(lastPriceIndex, priceEntry.getValue().getName());
                    this.holder.setInFormula(subIndex, priceResult.getSrcPriceName() + ":" + this.toBigDecimalString(var10_19.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                }
                sb.append(priceResult.getSrcPriceName());
                sb.append(':');
                sb.append(this.toBigDecimalString(this.outUnitActualCost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
                this.holder.setInFormula(lastPriceIndex, sb.toString());
                this.holder.setCalStatus(RptStatus.WARNING);
            }
        }
        if (this.outUnitActualCost.compareTo(BigDecimal.ZERO) < 0) {
            this.holder.appendInFormula(lastPriceIndex, " \n" + ResManager.loadKDString((String)"\u7ed3\u8f6c\u5931\u8d25\uff0c\u5355\u4ef7 < 0\uff0c\u5355\u636e\u6210\u672c\u672a\u66f4\u65b0\uff0c\u8be6\u7ec6\u60c5\u51b5\u8bf7\u67e5\u770b\u5355\u636e\u3002", (String)"WeightedAvgAT_4", (String)"fi-calx-algox", (Object[])new Object[0]));
            this.holder.setCalStatus(RptStatus.ERROR);
            this.holder.setLog(ResManager.loadKDString((String)"\u52a0\u6743\u8d1f\u5355\u4ef7", (String)"WeightedAvgAT_7", (String)"fi-calx-algox", (Object[])new Object[0]) + "\n");
        }
    }

    protected void joinCalculate(LocalRow row, String exDescription) {
        String rowType = row.getQueuetype();
        if ("0".equals(rowType)) {
            this.joinInCalculate(row, exDescription);
        }
        if ("1".equals(rowType)) {
            this.joinOutCalculate(row, exDescription);
        }
        if (row.isDestBill() && !this.tempInGroupRow.contains(row)) {
            this.isDestBillOutCalRpt = true;
            if (row.getUnitActualCost().compareTo(BigDecimal.ZERO) == 0) {
                this.isDestBillUnitCost = true;
            }
        }
    }

    private void joinInCalculate(LocalRow row, String exDescription) {
        String createtype;
        CostPriceResultInfo priceInfo;
        int parentIndex = this.holder.createNewEntry(row);
        BigDecimal unitactualcost = row.getUnitActualCost();
        BigDecimal qty = row.getBaseqty();
        BigDecimal actualcost = row.getActualCost();
        String billtypestr = row.getBilltype();
        boolean vouStr = false;
        String srcBillNo = null;
        boolean isGroupCost = false;
        if ("1".equals(row.getRowtype())) {
            String msg;
            String costPriceSourceStr;
            boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
            if (StringUtils.isEmpty((CharSequence)exDescription) && row.isPriced() && (priceInfo = row.getPriceResult()).isSuccess()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            }
            CostPriceSourceTypeEnum.setDescribeByCostpricesource(row, coverdesigoutcost, this.holder, parentIndex, exDescription);
            String costpricesource = row.getCostpricesource();
            String costpriceSourceType = row.getCostpriceSourceType();
            boolean designatedcost = row.isDesignatedcost();
            if (row.isVoucher()) {
                vouStr = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpricesource) && StringUtils.isNotEmpty((CharSequence)(costPriceSourceStr = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource))) && CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue().equals(costPriceSourceStr) && row.isDestBill()) {
                srcBillNo = row.getSrcbillno();
                isGroupCost = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpriceSourceType) && CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue().equals(costpriceSourceType) && (!designatedcost || designatedcost && coverdesigoutcost)) {
                srcBillNo = row.getSrcbillno();
            }
            if (vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_32", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,%2$s)", (String)"CalculateOutCostPlugin_35", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            } else if (vouStr && srcBillNo == null) {
                billtypestr = msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
            } else if (!vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_34", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(%2$s)", (String)"CalculateOutCostPlugin_36", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            }
            this.holder.setBillType(parentIndex, billtypestr);
        }
        if ("2".equals(row.getRowtype()) && StringUtils.isNotEmpty((CharSequence)(createtype = row.getCreatetype()))) {
            this.holder.setDescribe(parentIndex, CostAdjustBilCreateTypeEnum.getEnumDesc(createtype));
            if (row.isVoucher()) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(parentIndex, msg);
            }
        }
        if (exDescription != null) {
            this.holder.setBillType(parentIndex, billtypestr + exDescription);
        } else {
            String curBillType = "";
            if (row.isPriced()) {
                priceInfo = row.getPriceResult();
                if (priceInfo.isSuccess()) {
                    curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u4e8e\u53d6\u4ef7)", (String)"WeightedAvgAT_2", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                    this.holder.setBillType(parentIndex, curBillType);
                } else {
                    this.holder.setBillType(parentIndex, billtypestr + "(" + priceInfo.getErrMsg() + ")");
                }
            }
            if (row.isPresent()) {
                curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u8d60\u54c1)", (String)"WeightedAvgAT_15", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(parentIndex, curBillType);
            } else if (row.isInvTxZeroCost()) {
                curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u96f6\u6210\u672c)", (String)"WeightedAvgAT_14", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(parentIndex, curBillType);
            }
        }
        String rowType = row.getRowtype();
        Set<Map.Entry<Long, CostSubElement>> elementEntrys = this.getElementMap().entrySet();
        HashMap<Integer, Long> idxElementMap = new HashMap<Integer, Long>();
        if ("2".equals(rowType)) {
            this.holder.setInFormula(parentIndex, this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            for (Map.Entry<Long, CostSubElement> entry : elementEntrys) {
                if (row.getCost(entry.getKey()).compareTo(BigDecimal.ZERO) == 0) continue;
                int n = this.holder.createNewSubEntry(parentIndex, entry.getValue().getName());
                idxElementMap.put(n, entry.getKey());
                this.holder.setInFormula(n, this.toBigDecimalString(row.getCost(entry.getKey()).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            }
        } else {
            StringBuilder inFormula = new StringBuilder();
            inFormula.append(this.toBigDecimalString(qty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            inFormula.append('*');
            inFormula.append(this.toBigDecimalString(unitactualcost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            inFormula.append('=');
            inFormula.append(this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setInFormula(parentIndex, inFormula.toString());
            if (row.isInGroup() && unitactualcost.compareTo(BigDecimal.ZERO) <= 0) {
                this.isMinusPrice = true;
            }
            if (row.isInGroup() && unitactualcost.compareTo(BigDecimal.ZERO) == 0) {
                this.isGroupUnitCost = true;
            }
            if (unitactualcost.compareTo(BigDecimal.ZERO) != 0) {
                this.isInBillUnitCost = false;
            }
            if ("0".equals(row.getQueuetype()) && BigDecimal.ZERO.compareTo(actualcost) != 0) {
                this.setWeightInBillAmtAllZero(false);
                this.inBillAllAmtZero = false;
            }
            for (Map.Entry entry : elementEntrys) {
                if (row.getCost((Long)entry.getKey()).compareTo(BigDecimal.ZERO) == 0) continue;
                inFormula.setLength(0);
                Long elementId = (Long)entry.getKey();
                int subEntryIndex = this.holder.createNewSubEntry(parentIndex, ((CostSubElement)entry.getValue()).getName());
                idxElementMap.put(subEntryIndex, elementId);
                inFormula.append(this.toBigDecimalString(row.getCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
                this.holder.setInFormula(subEntryIndex, inFormula.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(this.toBigDecimalString(this.getCurrentTotalCost().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        sb.append('+');
        sb.append(this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        sb.append('=');
        HashMap balanceSbMap = new HashMap(idxElementMap.size());
        for (Map.Entry entry : idxElementMap.entrySet()) {
            StringBuilder balanceFormula = new StringBuilder();
            Long elementId = (Long)entry.getValue();
            balanceFormula.append(this.toBigDecimalString(this.getElementTotalCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            balanceFormula.append('+');
            balanceFormula.append(this.toBigDecimalString(row.getCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            balanceFormula.append('=');
            balanceSbMap.put(entry.getKey(), balanceFormula);
        }
        this.sumToTotal(row);
        sb.append(this.toBigDecimalString(this.getCurrentTotalCost().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(parentIndex, sb.toString());
        for (Map.Entry entry : idxElementMap.entrySet()) {
            Long elementId = (Long)entry.getValue();
            Integer subIndex = (Integer)entry.getKey();
            StringBuilder balanceFormula = (StringBuilder)balanceSbMap.get(subIndex);
            balanceFormula.append(this.toBigDecimalString(this.getElementTotalCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, balanceFormula.toString());
        }
    }

    private void joinOutCalculate(LocalRow row, String exDescription) {
        String createtype;
        CostPriceResultInfo priceInfo;
        int parentIndex = this.holder.createNewEntry(row);
        BigDecimal unitactualcost = row.getUnitActualCost();
        BigDecimal qty = row.getBaseqty();
        BigDecimal actualcost = row.getActualCost();
        String billtypestr = row.getBilltype();
        boolean vouStr = false;
        String srcBillNo = null;
        boolean isGroupCost = false;
        if ("1".equals(row.getRowtype())) {
            String msg;
            String costPriceSourceStr;
            boolean coverdesigoutcost = this.ctx.enableCoverdesigoutcost();
            if (StringUtils.isEmpty((CharSequence)exDescription) && row.isPriced() && (priceInfo = row.getPriceResult()).isSuccess()) {
                row.setCostpriceSourceType(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue());
            }
            CostPriceSourceTypeEnum.setDescribeByCostpricesource(row, coverdesigoutcost, this.holder, parentIndex, exDescription);
            String costpricesource = row.getCostpricesource();
            String costpriceSourceType = row.getCostpriceSourceType();
            boolean designatedcost = row.isDesignatedcost();
            if (row.isVoucher()) {
                vouStr = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpricesource) && StringUtils.isNotEmpty((CharSequence)(costPriceSourceStr = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource))) && CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue().equals(costPriceSourceStr) && row.isDestBill()) {
                srcBillNo = row.getSrcbillno();
                isGroupCost = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)costpriceSourceType) && CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue().equals(costpriceSourceType) && (!designatedcost || designatedcost && coverdesigoutcost)) {
                srcBillNo = row.getSrcbillno();
            }
            if (vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_32", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1,%2$s)", (String)"CalculateOutCostPlugin_35", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            } else if (vouStr && srcBillNo == null) {
                billtypestr = msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
            } else if (!vouStr && srcBillNo != null) {
                msg = null;
                msg = isGroupCost ? String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u5355\u53f7\uff1a%2$s)", (String)"CalculateOutCostPlugin_34", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo) : String.format(ResManager.loadKDString((String)"%1$s(%2$s)", (String)"CalculateOutCostPlugin_36", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr, srcBillNo);
                billtypestr = msg;
            }
            this.holder.setBillType(parentIndex, billtypestr);
        }
        if ("2".equals(row.getRowtype()) && StringUtils.isNotEmpty((CharSequence)(createtype = row.getCreatetype()))) {
            this.holder.setDescribe(parentIndex, CostAdjustBilCreateTypeEnum.getEnumDesc(createtype));
            if (row.isVoucher()) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s(\u5df2\u751f\u6210\u51ed\u8bc1)", (String)"CalculateOutCostPlugin_33", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(parentIndex, msg);
            }
        }
        if (exDescription != null) {
            this.holder.setBillType(parentIndex, billtypestr + exDescription);
        } else {
            String curBillType = "";
            if (row.isPriced()) {
                priceInfo = row.getPriceResult();
                if (priceInfo.isSuccess()) {
                    curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u4e8e\u53d6\u4ef7)", (String)"WeightedAvgAT_2", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                    this.holder.setBillType(parentIndex, curBillType);
                } else {
                    this.holder.setBillType(parentIndex, billtypestr + "(" + priceInfo.getErrMsg() + ")");
                }
            }
            if (row.isInvTxZeroCost()) {
                curBillType = String.format(ResManager.loadKDString((String)"%1$s(\u96f6\u6210\u672c)", (String)"WeightedAvgAT_14", (String)"fi-calx-algox", (Object[])new Object[0]), billtypestr);
                this.holder.setBillType(parentIndex, curBillType);
            }
        }
        String rowType = row.getRowtype();
        Set<Map.Entry<Long, CostSubElement>> elementEntrys = this.getElementMap().entrySet();
        HashMap<Integer, Long> idxElementMap = new HashMap<Integer, Long>();
        if ("2".equals(rowType)) {
            this.holder.setOutFormula(parentIndex, this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            for (Map.Entry<Long, CostSubElement> entry : elementEntrys) {
                if (row.getCost(entry.getKey()).compareTo(BigDecimal.ZERO) == 0) continue;
                int n = this.holder.createNewSubEntry(parentIndex, entry.getValue().getName());
                idxElementMap.put(n, entry.getKey());
                this.holder.setOutFormula(n, this.toBigDecimalString(row.getCost(entry.getKey()).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            }
        } else {
            StringBuilder inFormula = new StringBuilder();
            inFormula.append(this.toBigDecimalString(qty.setScale(this.getQtyPrecision(), RoundingMode.HALF_UP)));
            inFormula.append('*');
            inFormula.append(this.toBigDecimalString(unitactualcost.setScale(this.getPricePrecision(), RoundingMode.HALF_UP)));
            inFormula.append('=');
            inFormula.append(this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setOutFormula(parentIndex, inFormula.toString());
            if (unitactualcost.compareTo(BigDecimal.ZERO) <= 0) {
                this.isMinusPrice = true;
            }
            if ("1".equals(row.getQueuetype()) && BigDecimal.ZERO.compareTo(unitactualcost) != 0) {
                this.setWeightOutBillUnitAmtAllZero(false);
                this.outBillAllUnitAmtZero = false;
            }
            for (Map.Entry entry : elementEntrys) {
                if (row.getCost((Long)entry.getKey()).compareTo(BigDecimal.ZERO) == 0) continue;
                inFormula.setLength(0);
                Long elementId = (Long)entry.getKey();
                int subEntryIndex = this.holder.createNewSubEntry(parentIndex, ((CostSubElement)entry.getValue()).getName());
                idxElementMap.put(subEntryIndex, elementId);
                inFormula.append(this.toBigDecimalString(row.getCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
                this.holder.setOutFormula(subEntryIndex, inFormula.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(this.toBigDecimalString(this.getCurrentTotalCost().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        sb.append('-');
        sb.append(this.toBigDecimalString(actualcost.setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        sb.append('=');
        HashMap balanceSbMap = new HashMap(idxElementMap.size());
        for (Map.Entry entry : idxElementMap.entrySet()) {
            StringBuilder balanceFormula = new StringBuilder();
            Long elementId = (Long)entry.getValue();
            balanceFormula.append(this.toBigDecimalString(this.getElementTotalCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            balanceFormula.append('-');
            balanceFormula.append(this.toBigDecimalString(row.getCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            balanceFormula.append('=');
            balanceSbMap.put(entry.getKey(), balanceFormula);
        }
        this.substractToTotal(row);
        sb.append(this.toBigDecimalString(this.getCurrentTotalCost().setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
        this.holder.setBalanceFormula(parentIndex, sb.toString());
        for (Map.Entry entry : idxElementMap.entrySet()) {
            Long elementId = (Long)entry.getValue();
            Integer subIndex = (Integer)entry.getKey();
            StringBuilder balanceFormula = (StringBuilder)balanceSbMap.get(subIndex);
            balanceFormula.append(this.toBigDecimalString(this.getElementTotalCost(elementId).setScale(this.getAmtPrecision(), RoundingMode.HALF_UP)));
            this.holder.setBalanceFormula(subIndex, balanceFormula.toString());
        }
    }

    @Override
    protected DataSet filterEndDate(DataSet data, Date costatenddate) {
        if (costatenddate != null) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            map.put("costatenddate", costatenddate);
            data = data.filter("bizdate <= costatenddate", map).filter("rowtype in ('1','2')");
        }
        return data;
    }

    @Override
    protected boolean isUpdateDestBillAccountType() {
        return true;
    }

    private void setDissAdjustCostPriceSourceDesign(LocalRow row) {
        String costpricesource = row.getCostpricesource();
        String bizEntityObject = row.getBizEntityObject();
        costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
        if (this.ctx.enableCoverdesigoutcost() && (CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue().equals(costpricesource) || CostPriceSourceTypeEnum.CALCULATE_IN_SPECIFICATION.getValue().equals(costpricesource) || CostPriceSourceTypeEnum.EXP_BILL_SPECIFICATION.getValue().equals(costpricesource)) && ("im_disassemblebill".equals(bizEntityObject) || "im_adjustbill".equals(bizEntityObject))) {
            row.setCostpriceSourceType(CostPriceSourceTypeEnum.GROUP_COST_SPECIFICATION.getValue());
        }
    }
}

