/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.balance;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.balance.BalanceSourceEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.util.ArrayUtils;
import kd.fi.calx.algox.util.CommonUtils;

public class BalanceCalculator
implements Serializable {
    private static final long serialVersionUID = 6264083581216448622L;
    private static final Log logger = LogFactory.getLog(BalanceCalculator.class);
    private String updateSql = "update t_cal_balance set fperiodinqty = fperiodinqty + ?,fperiodinstandardcost = fperiodinstandardcost + ?,fperiodinactualcost = fperiodinactualcost + ?,fperiodincostdiff = fperiodincostdiff + ?,fperiodissueqty = fperiodissueqty + ?,fperiodissuestandardcost = fperiodissuestandardcost + ?,fperiodissueactualcost = fperiodissueactualcost + ?,fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?";
    private String detailUpdateSql = "update t_cal_balance_detail set fperiodinqty = fperiodinqty + ?,fperiodinstandardcost = fperiodinstandardcost + ?,fperiodinactualcost = fperiodinactualcost + ?,fperiodincostdiff = fperiodincostdiff + ?,fperiodissueqty = fperiodissueqty + ?,fperiodissuestandardcost = fperiodissuestandardcost + ?,fperiodissueactualcost = fperiodissueactualcost + ?,fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fdetailid = ?";
    private String calRagUpdateSql = "update t_cal_balance_a set fcalrangeid = ?,fcaldimensionid = ?,faccounttype = ? where fid = ?";
    private String endPeriodUpdateSql = "update t_cal_balance set fendperiod = ? where fid = ?";
    private int defaultEndPeriod = 999999;
    private String keysplit = "_";
    private DynamicObject costRecordBalRule;
    private DynamicObject costAdjustBalRule;
    private List<String> mainFieldSet = new ArrayList<String>();
    private List<String> dimFieldSet = new ArrayList<String>();
    private String dimFields = "";
    private String costElementFields = "costelement,costsubelement";
    private StringBuilder costRecordAliasSelectsFields = new StringBuilder();
    private StringBuilder costAdjustAliasSelectsFields = new StringBuilder();

    public BalanceCalculator() {
        this.init();
    }

    private void init() {
        QFilter q = new QFilter("sourceentitynumber", "=", (Object)"cal_costrecord");
        q.and("balancetablenumber", "=", (Object)"cal_balancemodel");
        q.and("custstatus", "=", (Object)"1");
        DynamicObject costRecordBalRule = null;
        DynamicObject costAdjustBalRule = null;
        try {
            costRecordBalRule = QueryServiceHelper.queryOne((String)"bal_balanceupdaterule", (String)"id,number", (QFilter[])new QFilter[]{q});
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u6838\u7b97\u4f59\u989d\u8868\u66f4\u65b0\u89c4\u5219\u5931\u8d25\uff1a", (Object)e);
        }
        q = new QFilter("sourceentitynumber", "=", (Object)"cal_costadjustbill");
        q.and("balancetablenumber", "=", (Object)"cal_balancemodel");
        q.and("custstatus", "=", (Object)"1");
        try {
            costAdjustBalRule = QueryServiceHelper.queryOne((String)"bal_balanceupdaterule", (String)"id,number", (QFilter[])new QFilter[]{q});
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u6838\u7b97\u4f59\u989d\u8868\u66f4\u65b0\u89c4\u5219\u5931\u8d25\uff1a", (Object)e);
        }
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
        if (fieldMap.get(BizDataType.MAIN) != null) {
            this.mainFieldSet.addAll((Collection)fieldMap.get(BizDataType.MAIN));
        }
        if (fieldMap.get(BizDataType.DIM) != null) {
            this.dimFieldSet.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        this.dimFieldSet.addAll(this.mainFieldSet);
        if (costRecordBalRule != null) {
            this.initBalanceFields(costRecordBalRule, "cal_costrecord", this.costRecordAliasSelectsFields);
        }
        if (costAdjustBalRule != null) {
            this.initBalanceFields(costAdjustBalRule, "cal_costadjustbill", this.costAdjustAliasSelectsFields);
        }
        if (this.dimFieldSet.isEmpty()) {
            this.dimFieldSet.add("costaccount");
            this.dimFieldSet.add("storageorgunit");
            this.dimFieldSet.add("ownertype");
            this.dimFieldSet.add("owner");
            this.dimFieldSet.add("material");
            this.dimFieldSet.add("assist");
            this.dimFieldSet.add("lot");
            this.dimFieldSet.add("warehouse");
            this.dimFieldSet.add("location");
            this.dimFieldSet.add("invtype");
            this.dimFieldSet.add("invstatus");
            this.dimFieldSet.add("project");
            this.dimFieldSet.add("mversion");
            this.dimFieldSet.add("configuredcode");
            this.dimFieldSet.add("tracknumber");
        }
        if (this.costRecordAliasSelectsFields.length() == 0) {
            this.costRecordAliasSelectsFields.append("costaccount as costaccount,storageorgunit as storageorgunit,entry.ownertype as ownertype,entry.owner as owner,entry.material as material,entry.assist as assist,entry.lot as lot,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.project as project,entry.mversion as mversion,entry.configuredcode as configuredcode,entry.tracknumber as tracknumber,");
        }
        if (this.costAdjustAliasSelectsFields.length() == 0) {
            this.costAdjustAliasSelectsFields.append("costaccount as costaccount,entryentity.storageorgunit as storageorgunit,entryentity.ownertype as ownertype,entryentity.owner as owner,entryentity.material as material,entryentity.assist as assist,entryentity.lot as lot,entryentity.warehouse as warehouse,entryentity.location as location,entryentity.invtype as invtype,entryentity.invstatus as invstatus,entryentity.project as project,entryentity.mversion as mversion,entryentity.configuredcode as configuredcode,entryentity.tracknumber as tracknumber,");
        }
        for (String dimField : this.dimFieldSet) {
            this.dimFields = this.dimFields + dimField + ",";
        }
    }

    private void initBalanceFields(DynamicObject balRule, String entityName, StringBuilder aliasFields) {
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String balUpdateRuleId = balRule.getString("id");
        BalanceUpdateRuleMetadata ruleMetadata = reader.loadMeta(balUpdateRuleId, false);
        BalanceFieldMapPolicy fieldMapPolicy = ruleMetadata.getRuleElement().getFieldMapPolicy();
        for (BalanceFieldMapItem fieldMapItem : fieldMapPolicy.getBalanceFieldMapItems()) {
            String sourceField;
            String convertType = fieldMapItem.getConvertType();
            String targetField = fieldMapItem.getTargetField();
            if (!"0".equals(convertType) || (sourceField = fieldMapItem.getSourceField()) == null) continue;
            if (bizEntityType.findProperty(sourceField).getParent() instanceof EntryType) {
                sourceField = bizEntityType.findProperty(sourceField).getParent().getName() + "." + sourceField;
            }
            aliasFields.append(sourceField).append(" as ").append(targetField).append(',');
        }
    }

    public void updateBalance4CostRecordReCal(Set<Long> entryIdSet) {
        this.addSnapShootBalance(entryIdSet);
        try (DataSet detailRecordSet = this.getCostRecords(entryIdSet, true);
             DataSet copyDetailRecordSet = detailRecordSet.copy();
             DataSet detailDataSet = this.getBalanceJoinData(detailRecordSet, true, false);
             DataSet recordset = this.getCostRecords(entryIdSet, false);
             DataSet dataSet = this.getBalanceJoinData(recordset, false, false);){
            this.updateBalance(detailDataSet, dataSet);
        }
    }

    public void updateBalance4CostAdjustReCal(Object[] entryIds) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return;
        }
        try (DataSet detailAdjustSet = this.getCostAdjusts(entryIds, true);
             DataSet detailDataSet = this.getBalanceJoinData(detailAdjustSet, true, false);
             DataSet adjustSet = this.getCostAdjusts(entryIds, false);
             DataSet dataSet = this.getBalanceJoinData(adjustSet, false, false);){
            this.updateBalance(detailDataSet, dataSet);
        }
    }

    public void updateBalance4CostRecord(DynamicObject[] records) {
        HashSet<Long> entryIdSet = new HashSet<Long>();
        for (DynamicObject record : records) {
            DynamicObjectCollection entryCol = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryCol) {
                entryIdSet.add(entry.getLong("id"));
            }
        }
        this.updateBalance4CostRecord(entryIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalance4CostRecord(Set<Long> entryIdSet) {
        this.addSnapShootBalance(entryIdSet);
        try (DataSet detailRecordSet = this.getCostRecords(entryIdSet, true);
             DataSet detailRecordSetCopy = detailRecordSet.copy();
             DataSet detailDataSet = this.getBalanceJoinData(detailRecordSet, true, false);
             DataSet recordset = this.getCostRecords(entryIdSet, false);
             DataSet dataSet = this.getBalanceJoinData(recordset, false, false);){
            this.createBalanceRecord4CostRecord(detailRecordSetCopy, BalanceSourceEnum.COSTRECORD_CREATE, true);
            this.updateBalance(detailDataSet, dataSet);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalance4CostRecordDel(Set<Long> entryIds) {
        this.deleteSnapShootBalance(entryIds);
        try (DataSet recordset = this.getCostRecords(entryIds, true);
             DataSet recordsetCopy = recordset.copy();
             DataSet dataSet = this.getBalanceJoinData(recordset, true, false);){
            this.createBalanceRecord4CostRecord(recordsetCopy, BalanceSourceEnum.COSTRECORD_DELETE, false);
            this.updateBalance(dataSet, true);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void createBalanceRecord4CostRecord(DataSet recordset, BalanceSourceEnum source, boolean isCreate) {
        Long entryid = null;
        DynamicObject updateRecord = null;
        LinkedList<DynamicObject> recordList = new LinkedList<DynamicObject>();
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        int batchSize = 100000;
        while (recordset.hasNext()) {
            Row row = recordset.next();
            if (!row.getLong("entryid").equals(entryid)) {
                entryid = row.getLong("entryid");
                updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_updaterecord");
                updateRecord.set("billno", row.get("billno"));
                updateRecord.set("billentity", (Object)"cal_costrecord_subentity");
                updateRecord.set("period", row.get("periodid"));
                updateRecord.set("inorout", row.get("calbilltype"));
                updateRecord.set("billid", row.get("id"));
                updateRecord.set("billentryid", row.get("entryid"));
                updateRecord.set("user", (Object)userId);
                updateRecord.set("actualcost", (Object)BigDecimal.ZERO);
                BigDecimal baseqty = null;
                baseqty = "IN".equals(updateRecord.getString("inorout")) ? row.getBigDecimal("inbaseqty") : row.getBigDecimal("outbaseqty");
                if (!isCreate) {
                    baseqty = baseqty.negate();
                }
                updateRecord.set("baseqty", (Object)baseqty);
                updateRecord.set("source", (Object)source.getValue());
                updateRecord.set("updatetime", (Object)date);
                for (String field : this.dimFieldSet) {
                    updateRecord.set(field, row.get(field));
                }
                if (recordList.size() >= batchSize) {
                    SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[recordList.size()]));
                    recordList.clear();
                }
                recordList.add(updateRecord);
            }
            if (updateRecord == null) continue;
            DynamicObject entry = updateRecord.getDynamicObjectCollection("entryentity").addNew();
            entry.set("costsubelement", (Object)row.getLong("costsubelement"));
            BigDecimal subactualcost = null;
            subactualcost = "IN".equals(updateRecord.getString("inorout")) ? row.getBigDecimal("inactualcost") : row.getBigDecimal("outactualcost");
            if (!isCreate) {
                subactualcost = subactualcost.negate();
            }
            entry.set("subactualcost", (Object)subactualcost);
            updateRecord.set("actualcost", (Object)updateRecord.getBigDecimal("actualcost").add(subactualcost));
        }
        if (!recordList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[recordList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalance4CostAdjust(Object[] entryIds) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return;
        }
        try (DataSet detailAdjustSet = this.getCostAdjusts(entryIds, true);
             DataSet detailAdjustSetCopy = detailAdjustSet.copy();
             DataSet detailDataSet = this.getBalanceJoinData(detailAdjustSet, true, false);
             DataSet adjustSet = this.getCostAdjusts(entryIds, false);
             DataSet dataSet = this.getBalanceJoinData(adjustSet, false, false);){
            this.createBalanceRecord4CostAdjust(detailAdjustSetCopy, BalanceSourceEnum.COSTADJUST_AUDIT, true);
            this.updateBalance(detailDataSet, dataSet);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void createBalanceRecord4CostAdjust(DataSet recordset, BalanceSourceEnum source, boolean isCreate) {
        Long entryid = null;
        DynamicObject updateRecord = null;
        LinkedList<DynamicObject> recordList = new LinkedList<DynamicObject>();
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        while (recordset.hasNext()) {
            Row row = recordset.next();
            if (!row.getLong("entryid").equals(entryid)) {
                entryid = row.getLong("entryid");
                updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_updaterecord");
                recordList.add(updateRecord);
                updateRecord.set("billno", row.get("billno"));
                updateRecord.set("billentity", (Object)"cal_costadjust_subentity");
                updateRecord.set("period", row.get("periodid"));
                updateRecord.set("inorout", row.get("calbilltype"));
                updateRecord.set("billid", row.get("id"));
                updateRecord.set("billentryid", row.get("entryid"));
                updateRecord.set("user", (Object)userId);
                updateRecord.set("actualcost", (Object)BigDecimal.ZERO);
                updateRecord.set("source", (Object)source.getValue());
                updateRecord.set("updatetime", (Object)date);
                for (String field : this.dimFieldSet) {
                    updateRecord.set(field, row.get(field));
                }
            }
            if (updateRecord == null) continue;
            DynamicObject entry = updateRecord.getDynamicObjectCollection("entryentity").addNew();
            entry.set("costsubelement", (Object)row.getLong("costsubelement"));
            BigDecimal subactualcost = null;
            subactualcost = "IN".equals(updateRecord.getString("inorout")) ? row.getBigDecimal("inactualcost") : row.getBigDecimal("outactualcost");
            if (!isCreate) {
                subactualcost = subactualcost.negate();
            }
            entry.set("subactualcost", (Object)subactualcost);
            updateRecord.set("actualcost", (Object)updateRecord.getBigDecimal("actualcost").add(subactualcost));
        }
        SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[recordList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalance4CostAdjustDel(Object[] entryIds) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return;
        }
        try (DataSet adjustSet = this.getCostAdjusts(entryIds, true);
             DataSet adjustSetCopy = adjustSet.copy();
             DataSet dataSet = this.getBalanceJoinData(adjustSet, true, false);){
            this.createBalanceRecord4CostAdjust(adjustSetCopy, BalanceSourceEnum.COSTADJUST_UNAUDIT, false);
            this.updateBalance(dataSet, true);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalance4Others(Object[] entryIds, BalanceSourceEnum source) {
        HashSet<Long> entryIdSet = new HashSet<Long>(1024);
        for (Object id : entryIds) {
            entryIdSet.add(Long.valueOf(id.toString()));
        }
        try (DataSet snapSet = this.getCostRecordsWithSnapShoot(entryIdSet);){
            if (snapSet.copy().isEmpty()) {
                return;
            }
            DataSet snapSetCopy = snapSet.copy();
            DataSet dataSet = this.getBalanceJoinData(snapSet, true, true);
            this.createBalanceRecord4CostRecord(snapSetCopy, source, true);
            this.updateBalance(dataSet, false);
            this.updateSnapShootBalance(entryIds);
            logger.info("updateBalance4Others\u5b8c\u6210" + System.currentTimeMillis());
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void updateSnapShootBalance(Object[] entryIds) {
        DynamicObject[] snapShoots;
        logger.info("updateSnapShootBalance" + System.currentTimeMillis());
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> actualCostMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> standardCostMap = new HashMap<Long, BigDecimal>(16);
        HashSet<Long> detailIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.baseunit,entry.baseqty,entry.accounttype,costaccount.enablestandardcost as enablestd", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id,entryid,standardcost,actualcost", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entry.id", "entryid").select(new String[]{"id as billid", "entry.baseunit", "entry.baseqty", "entry.accounttype", "enablestd"}, new String[]{"id as detailid", "standardcost", "actualcost"}).finish();){
            for (Row row : joinDataSet) {
                Long detailId = row.getLong("detailid");
                BigDecimal qty = row.getBigDecimal("entry.baseqty");
                BigDecimal standardCost = BigDecimal.ZERO;
                BigDecimal actualCost = null;
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(row.getString("entry.accounttype"))) {
                    actualCost = row.getBigDecimal("standardcost");
                    standardCost = row.getBigDecimal("standardcost");
                } else {
                    actualCost = row.getBigDecimal("actualcost");
                }
                if (row.getBoolean("enablestd").booleanValue()) {
                    standardCost = row.getBigDecimal("standardcost");
                }
                detailIds.add(detailId);
                qtyMap.put(detailId, qty);
                actualCostMap.put(detailId, actualCost);
                standardCostMap.put(detailId, standardCost);
            }
        }
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(entryIds.length);
        for (DynamicObject snapShoot : snapShoots = BusinessDataServiceHelper.load((String)"cal_balance_snapshoot", (String)"mainid,unit,qty,standardcost,actualcost", (QFilter[])new QFilter[]{new QFilter("mainid", "in", detailIds)})) {
            Long mainid = snapShoot.getLong("mainid");
            snapShoot.set("qty", qtyMap.get(mainid));
            snapShoot.set("standardcost", standardCostMap.get(mainid));
            snapShoot.set("actualcost", actualCostMap.get(mainid));
            if (set.size() >= 100000) {
                SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
                set.clear();
            }
            set.add(snapShoot);
        }
        if (!set.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
        }
    }

    private void deleteSnapShootBalance(Set<Long> entryIds) {
        HashSet<Long> detailSet = new HashSet<Long>(entryIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id,entryid", (QFilter[])new QFilter("entryid", "in", entryIds).toArray(), null);){
            for (Row row : dataSet) {
                detailSet.add(row.getLong("id"));
            }
        }
        QFilter q = new QFilter("mainid", "in", detailSet);
        DeleteServiceHelper.delete((String)"cal_balance_snapshoot", (QFilter[])new QFilter[]{q});
    }

    private void updateBalance(DataSet detailDataSet, DataSet dataSet) {
        ArrayList<Object[]> detailUpateList = new ArrayList<Object[]>();
        ArrayList<Object> updateList = new ArrayList<Object>();
        ArrayList updateBalanceCalRagList = new ArrayList();
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        ArrayList<Object> detailInsertList = new ArrayList<Object>();
        ArrayList<Object> endPeriodUpdateObjList = new ArrayList<Object>();
        HashMap<String, DynamicObject> detailInsertObjMap = new HashMap<String, DynamicObject>();
        HashMap<String, Boolean> hasBeforeCurrencData = new HashMap<String, Boolean>();
        HashMap<Long, Object[]> updateBalanceMap = new HashMap<Long, Object[]>();
        HashMap<Long, Object[]> updateBalanceCalRagMap = new HashMap<Long, Object[]>();
        HashMap<String, Long> beforeDetailMap = new HashMap<String, Long>();
        HashMap<String, Object[]> beforePeriodUpdateObjMap = new HashMap<String, Object[]>();
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u5faa\u73af\u94fe\u8868\u7ed3\u679c\uff1a" + System.currentTimeMillis());
        int count = 0;
        BigDecimal yearinqty = BigDecimal.ZERO;
        BigDecimal yearinstandradcost = BigDecimal.ZERO;
        BigDecimal yearinactualcost = BigDecimal.ZERO;
        BigDecimal yearincostdiff = BigDecimal.ZERO;
        BigDecimal yearissueqty = BigDecimal.ZERO;
        BigDecimal yearissuestandradcost = BigDecimal.ZERO;
        BigDecimal yearissueactualcost = BigDecimal.ZERO;
        BigDecimal yearissuecostdiff = BigDecimal.ZERO;
        Object bizDate = null;
        boolean isStandardCost = false;
        HashMap<String, Long> balMap = new HashMap<String, Long>();
        for (Row row : dataSet) {
            Long l = row.getLong("balanceid");
            StringBuilder dimKey = new StringBuilder();
            for (String field : this.dimFieldSet) {
                dimKey.append(row.get(field)).append(this.keysplit);
            }
            if (l != null && l != 0L) {
                balMap.put(dimKey.toString(), l);
                if (row.getString("relaacctp") != null && row.getString("relaacctp").equals(row.getString("acctype")) && row.getString("relacalrange").equals(row.getString("calrange")) && row.getString("relacaldimension").equals(row.getString("caldimension"))) continue;
                updateBalanceCalRagMap.put(l, new Object[]{row.getLong("calrange"), row.getLong("caldimension"), row.getString("acctype"), l});
                continue;
            }
            long costperiodid = row.getLong("costperiodid");
            long calsystemid = row.getLong("calsystem");
            long calorgid = row.getLong("calorg");
            long calpolicyid = row.getLong("calpolicy");
            long baseunitid = row.getLong("baseunit");
            int costyear = row.getInteger("costyear");
            int costmonth = row.getInteger("costmonth");
            Integer costperiod = costyear * 100 + costmonth;
            DynamicObject balanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance");
            long balId = DBServiceHelper.genLongIds((String)"t_cal_balance", (int)1)[0];
            balanceInfo.set("id", (Object)balId);
            balanceInfo.set("accsys", (Object)calsystemid);
            balanceInfo.set("calorg", (Object)calorgid);
            balanceInfo.set("calpolicy", (Object)calpolicyid);
            balanceInfo.set("periodid", (Object)costperiodid);
            balanceInfo.set("period", (Object)costperiod);
            balanceInfo.set("endperiod", (Object)this.defaultEndPeriod);
            balanceInfo.set("year", (Object)costyear);
            balanceInfo.set("month", (Object)costmonth);
            balanceInfo.set("bizdate", bizDate);
            balanceInfo.set("isstandardcost", (Object)isStandardCost);
            balanceInfo.set("baseunit", (Object)baseunitid);
            for (String field : this.dimFieldSet) {
                balanceInfo.set(field, row.get(field));
            }
            balanceInfo.set("calrange", (Object)row.getLong("calrange"));
            balanceInfo.set("caldimension", (Object)row.getLong("caldimension"));
            balanceInfo.set("accounttype", (Object)row.getString("acctype"));
            balMap.put(dimKey.toString(), balId);
            insertList.add(balanceInfo);
        }
        if (insertList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[0]));
        }
        for (Row row : detailDataSet) {
            Long l = row.getLong("detailid");
            Long balanceid = row.getLong("balanceid");
            StringBuilder dimKey = new StringBuilder();
            for (String field : this.dimFieldSet) {
                dimKey.append(row.get(field)).append(this.keysplit);
            }
            long balId = (Long)balMap.get(dimKey.toString());
            StringBuilder keySb = new StringBuilder(dimKey);
            for (String field : this.costElementFields.split(",")) {
                keySb.append(row.get(field)).append(this.keysplit);
            }
            String key = keySb.toString();
            BigDecimal inBaseQty = row.getBigDecimal("inbaseqty");
            BigDecimal inStandardCost = row.getBigDecimal("instandardcost");
            BigDecimal inActualCost = row.getBigDecimal("inactualcost");
            BigDecimal incostdiff = row.getBigDecimal("incostdiff");
            BigDecimal outBaseQty = row.getBigDecimal("outbaseqty");
            BigDecimal outStandardCost = row.getBigDecimal("outstandardcost");
            BigDecimal outActualCost = row.getBigDecimal("outactualcost");
            BigDecimal outcostdiff = row.getBigDecimal("outcostdiff");
            BigDecimal baseQty = inBaseQty.subtract(outBaseQty);
            BigDecimal standardCost = inStandardCost.subtract(outStandardCost);
            BigDecimal actualCost = inActualCost.subtract(outActualCost);
            BigDecimal costdiff = incostdiff.subtract(outcostdiff);
            BigDecimal beginqty = row.getBigDecimal("endqty");
            beginqty = beginqty == null ? BigDecimal.ZERO : beginqty;
            BigDecimal beginstandardcost = row.getBigDecimal("endstandardcost");
            beginstandardcost = beginstandardcost == null ? BigDecimal.ZERO : beginstandardcost;
            BigDecimal beginactualcost = row.getBigDecimal("endactualcost");
            beginactualcost = beginactualcost == null ? BigDecimal.ZERO : beginactualcost;
            BigDecimal begincostdiff = row.getBigDecimal("endcostdiff");
            begincostdiff = begincostdiff == null ? BigDecimal.ZERO : begincostdiff;
            BigDecimal endqty = beginqty.add(inBaseQty).subtract(outBaseQty);
            BigDecimal endstandardcost = beginstandardcost.add(inStandardCost).subtract(outStandardCost);
            BigDecimal endactualcost = beginactualcost.add(inActualCost).subtract(outActualCost);
            BigDecimal endcostdiff = begincostdiff.add(costdiff);
            int costyear = row.getInteger("costyear");
            int costmonth = row.getInteger("costmonth");
            Integer costperiod = costyear * 100 + costmonth;
            if (l == null) {
                updateList.add(new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, beginqty, beginstandardcost, beginactualcost, begincostdiff, endqty, endstandardcost, endactualcost, endcostdiff, balId});
                DynamicObject detailBalInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
                detailBalInfo.set("balid", (Object)balId);
                detailBalInfo.set("periodbeginqty", (Object)beginqty);
                detailBalInfo.set("beginstandardcost", (Object)beginstandardcost);
                detailBalInfo.set("periodbegincostdiff", (Object)begincostdiff);
                detailBalInfo.set("periodbeginactualcost", (Object)beginactualcost);
                detailBalInfo.set("periodinqty", (Object)inBaseQty);
                detailBalInfo.set("periodinstandardcost", (Object)inStandardCost);
                detailBalInfo.set("periodincostdiff", (Object)incostdiff);
                detailBalInfo.set("periodinactualcost", (Object)inActualCost);
                detailBalInfo.set("periodissueqty", (Object)outBaseQty);
                detailBalInfo.set("periodissuestandardcost", (Object)outStandardCost);
                detailBalInfo.set("periodissuecostdiff", (Object)outcostdiff);
                detailBalInfo.set("periodissueactualcost", (Object)outActualCost);
                detailBalInfo.set("periodendqty", (Object)endqty);
                detailBalInfo.set("periodendstandardcost", (Object)endstandardcost);
                detailBalInfo.set("periodendcostdiff", (Object)endcostdiff);
                detailBalInfo.set("periodendactualcost", (Object)endactualcost);
                detailBalInfo.set("yearinqty", (Object)yearinqty);
                detailBalInfo.set("yearinstandradcost", (Object)yearinstandradcost);
                detailBalInfo.set("yearincostdiff", (Object)yearincostdiff);
                detailBalInfo.set("yearinactualcost", (Object)yearinactualcost);
                detailBalInfo.set("yearissueqty", (Object)yearissueqty);
                detailBalInfo.set("yearissuestandradcost", (Object)yearissuestandradcost);
                detailBalInfo.set("yearissuecostdiff", (Object)yearissuecostdiff);
                detailBalInfo.set("yearissueactualcost", (Object)yearissueactualcost);
                for (String field : this.costElementFields.split(",")) {
                    detailBalInfo.set(field, row.get(field));
                }
                detailInsertList.add(detailBalInfo);
                continue;
            }
            Integer balanceperiod = row.getInteger("balanceperiod");
            if (balanceperiod < costperiod) {
                DynamicObject detailBalanceInfo = (DynamicObject)detailInsertObjMap.get(key);
                if (detailBalanceInfo == null) {
                    updateBalanceMap.put(l, new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, beginqty, beginstandardcost, beginactualcost, begincostdiff, endqty, endstandardcost, endactualcost, endcostdiff, balId});
                    beforeDetailMap.put(key, l);
                    detailBalanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
                    detailBalanceInfo.set("balid", (Object)balId);
                    detailBalanceInfo.set("periodbeginqty", (Object)beginqty);
                    detailBalanceInfo.set("beginstandardcost", (Object)beginstandardcost);
                    detailBalanceInfo.set("periodbegincostdiff", (Object)begincostdiff);
                    detailBalanceInfo.set("periodbeginactualcost", (Object)beginactualcost);
                    detailBalanceInfo.set("periodinqty", (Object)inBaseQty);
                    detailBalanceInfo.set("periodinstandardcost", (Object)inStandardCost);
                    detailBalanceInfo.set("periodincostdiff", (Object)incostdiff);
                    detailBalanceInfo.set("periodinactualcost", (Object)inActualCost);
                    detailBalanceInfo.set("periodissueqty", (Object)outBaseQty);
                    detailBalanceInfo.set("periodissuestandardcost", (Object)outStandardCost);
                    detailBalanceInfo.set("periodissuecostdiff", (Object)outcostdiff);
                    detailBalanceInfo.set("periodissueactualcost", (Object)outActualCost);
                    detailBalanceInfo.set("periodendqty", (Object)endqty);
                    detailBalanceInfo.set("periodendstandardcost", (Object)endstandardcost);
                    detailBalanceInfo.set("periodendcostdiff", (Object)endcostdiff);
                    detailBalanceInfo.set("periodendactualcost", (Object)endactualcost);
                    detailBalanceInfo.set("yearinqty", (Object)yearinqty);
                    detailBalanceInfo.set("yearinstandradcost", (Object)yearinstandradcost);
                    detailBalanceInfo.set("yearincostdiff", (Object)yearincostdiff);
                    detailBalanceInfo.set("yearinactualcost", (Object)yearinactualcost);
                    detailBalanceInfo.set("yearissueqty", (Object)yearissueqty);
                    detailBalanceInfo.set("yearissuestandradcost", (Object)yearissuestandradcost);
                    detailBalanceInfo.set("yearissuecostdiff", (Object)yearissuecostdiff);
                    detailBalanceInfo.set("yearissueactualcost", (Object)yearissueactualcost);
                    for (String field : this.costElementFields.split(",")) {
                        detailBalanceInfo.set(field, row.get(field));
                    }
                    detailInsertObjMap.put(key, detailBalanceInfo);
                } else {
                    detailBalanceInfo.set("periodbeginqty", (Object)beginqty);
                    detailBalanceInfo.set("beginstandardcost", (Object)beginstandardcost);
                    detailBalanceInfo.set("periodbeginactualcost", (Object)beginactualcost);
                    detailBalanceInfo.set("periodendqty", (Object)endqty);
                    detailBalanceInfo.set("periodendstandardcost", (Object)endstandardcost);
                    detailBalanceInfo.set("periodendactualcost", (Object)endactualcost);
                    detailBalanceInfo.set("periodbegincostdiff", (Object)begincostdiff);
                    detailBalanceInfo.set("periodendcostdiff", (Object)endcostdiff);
                    Long id = (Long)beforeDetailMap.get(key);
                    if (id != null) {
                        updateBalanceMap.remove(id);
                    }
                    updateBalanceMap.put(l, new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, beginqty, beginstandardcost, beginactualcost, begincostdiff, endqty, endstandardcost, endactualcost, endcostdiff, balId});
                    beforeDetailMap.put(key, l);
                }
                beforePeriodUpdateObjMap.put(key, new Object[]{costperiod, balanceid});
                hasBeforeCurrencData.put(key, true);
            } else if (costperiod.equals(balanceperiod)) {
                detailInsertObjMap.remove(key);
                beforePeriodUpdateObjMap.remove(key);
                detailUpateList.add(new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, l});
                Long id = (Long)beforeDetailMap.get(key);
                if (id != null) {
                    updateBalanceMap.remove(id);
                }
                updateBalanceMap.put(l, new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, balId});
                hasBeforeCurrencData.put(key, true);
            } else {
                DynamicObject insertObj = (DynamicObject)detailInsertObjMap.get(key);
                if (insertObj != null) {
                    endPeriodUpdateObjList.add(new Object[]{balanceperiod, balId});
                    detailInsertObjMap.remove(key);
                    detailInsertList.add(insertObj);
                } else {
                    Boolean hasData = (Boolean)hasBeforeCurrencData.get(key);
                    if (hasData == null) {
                        beginqty = BigDecimal.ZERO;
                        beginstandardcost = BigDecimal.ZERO;
                        beginactualcost = BigDecimal.ZERO;
                        begincostdiff = BigDecimal.ZERO;
                        endqty = inBaseQty.subtract(outBaseQty);
                        endstandardcost = inStandardCost.subtract(outStandardCost);
                        endactualcost = inActualCost.subtract(outActualCost);
                        endcostdiff = incostdiff.subtract(outcostdiff);
                        DynamicObject detailBalanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
                        detailBalanceInfo.set("balid", (Object)balId);
                        detailBalanceInfo.set("periodbeginqty", (Object)beginqty);
                        detailBalanceInfo.set("beginstandardcost", (Object)beginstandardcost);
                        detailBalanceInfo.set("periodbegincostdiff", (Object)begincostdiff);
                        detailBalanceInfo.set("periodbeginactualcost", (Object)beginactualcost);
                        detailBalanceInfo.set("periodinqty", (Object)inBaseQty);
                        detailBalanceInfo.set("periodinstandardcost", (Object)inStandardCost);
                        detailBalanceInfo.set("periodincostdiff", (Object)incostdiff);
                        detailBalanceInfo.set("periodinactualcost", (Object)inActualCost);
                        detailBalanceInfo.set("periodissueqty", (Object)outBaseQty);
                        detailBalanceInfo.set("periodissuestandardcost", (Object)outStandardCost);
                        detailBalanceInfo.set("periodissuecostdiff", (Object)outcostdiff);
                        detailBalanceInfo.set("periodissueactualcost", (Object)outActualCost);
                        detailBalanceInfo.set("periodendqty", (Object)endqty);
                        detailBalanceInfo.set("periodendstandardcost", (Object)endstandardcost);
                        detailBalanceInfo.set("periodendcostdiff", (Object)endcostdiff);
                        detailBalanceInfo.set("periodendactualcost", (Object)endactualcost);
                        detailBalanceInfo.set("yearinqty", (Object)yearinqty);
                        detailBalanceInfo.set("yearinstandradcost", (Object)yearinstandradcost);
                        detailBalanceInfo.set("yearincostdiff", (Object)yearincostdiff);
                        detailBalanceInfo.set("yearinactualcost", (Object)yearinactualcost);
                        detailBalanceInfo.set("yearissueqty", (Object)yearissueqty);
                        detailBalanceInfo.set("yearissuestandradcost", (Object)yearissuestandradcost);
                        detailBalanceInfo.set("yearissuecostdiff", (Object)yearissuecostdiff);
                        detailBalanceInfo.set("yearissueactualcost", (Object)yearissueactualcost);
                        for (String field : this.costElementFields.split(",")) {
                            detailBalanceInfo.set(field, row.get(field));
                        }
                        detailInsertList.add(detailBalanceInfo);
                        updateBalanceMap.put(l, new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, beginqty, beginstandardcost, beginactualcost, begincostdiff, endqty, endstandardcost, endactualcost, endcostdiff, balId});
                        hasBeforeCurrencData.put(key, false);
                        endPeriodUpdateObjList.add(new Object[]{balanceperiod, balId});
                    }
                }
                Object[] beforePeriodUpdateObj = (Object[])beforePeriodUpdateObjMap.get(key);
                if (beforePeriodUpdateObj != null) {
                    beforePeriodUpdateObjMap.remove(key);
                    endPeriodUpdateObjList.add(beforePeriodUpdateObj);
                }
                detailUpateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, baseQty, standardCost, actualCost, costdiff, l});
                updateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, baseQty, standardCost, actualCost, costdiff, balanceid});
            }
            ++count;
        }
        detailInsertList.addAll(detailInsertObjMap.values());
        endPeriodUpdateObjList.addAll(beforePeriodUpdateObjMap.values());
        updateList.addAll(updateBalanceMap.values());
        HashMap<Object, Object[]> mainBalMap = new HashMap<Object, Object[]>();
        for (Object[] objectArray : updateList) {
            Object balid = objectArray[16];
            Object[] o1 = (Object[])mainBalMap.get(balid);
            if (o1 != null) {
                this.addAmount(objectArray, o1, new int[]{1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15});
                continue;
            }
            mainBalMap.put(balid, objectArray);
        }
        updateList.clear();
        updateList.addAll(mainBalMap.values());
        logger.info("BalanceCalculatorNew-\u5faa\u73af\u7ed3\u675f\uff1a" + System.currentTimeMillis() + "\u4f9b\u5faa\u73af" + count + "\u6b21");
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u63d2\u5165\u4f59\u989d\uff1a" + System.currentTimeMillis() + "\u5171" + detailInsertList.size() + "\u6761");
        if (detailInsertList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])detailInsertList.toArray(new DynamicObject[0]));
        }
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u66f4\u65b0\u4f59\u989d\uff1a" + System.currentTimeMillis() + "\u5171" + detailUpateList.size() + "\u6761");
        if (detailUpateList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.detailUpdateSql, detailUpateList);
        }
        if (updateList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.updateSql, updateList);
        }
        updateBalanceCalRagList.clear();
        updateBalanceCalRagList.addAll(updateBalanceCalRagMap.values());
        if (updateBalanceCalRagList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.calRagUpdateSql, updateBalanceCalRagList);
        }
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u66f4\u65b0\u4f59\u989d\u7ed3\u675f\u671f\u95f4\uff1a" + System.currentTimeMillis() + "\u5171" + endPeriodUpdateObjList.size() + "\u6761");
        if (endPeriodUpdateObjList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.endPeriodUpdateSql, endPeriodUpdateObjList);
        }
    }

    private void addAmount(Object[] o, Object[] o1, int[] indexs) {
        for (int i : indexs) {
            o1[i] = ((BigDecimal)o1[i]).add((BigDecimal)o[i]);
        }
    }

    private void updateBalance(DataSet dataSet, boolean isNegate) {
        logger.info("updateBalance" + System.currentTimeMillis());
        final ArrayList<List<Object[]>> updateList_List = new ArrayList<List<Object[]>>();
        HashMap<Long, Object[]> mainBalMap = new HashMap<Long, Object[]>(16);
        final ArrayList<List<Object[]>> detailUpdateList_List = new ArrayList<List<Object[]>>();
        int batchSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        for (Row row : dataSet) {
            List<Object[]> detailUpdateList;
            List<Object[]> updateList;
            Object[] o;
            Object[] o1;
            Integer balanceperiod;
            int costmonth;
            int costyear;
            Integer costperiod;
            Long balanceid = row.getLong("balanceid");
            Long detailid = row.getLong("detailid");
            if (balanceid == null) {
                logger.info("\u672a\u5173\u8054\u5230\u4f59\u989d\u6570\u636e");
                continue;
            }
            BigDecimal inBaseQty = row.getBigDecimal("inbaseqty");
            BigDecimal inStandardCost = row.getBigDecimal("instandardcost");
            BigDecimal inActualCost = row.getBigDecimal("inactualcost");
            BigDecimal incostdiff = row.getBigDecimal("incostdiff");
            BigDecimal outBaseQty = row.getBigDecimal("outbaseqty");
            BigDecimal outStandardCost = row.getBigDecimal("outstandardcost");
            BigDecimal outActualCost = row.getBigDecimal("outactualcost");
            BigDecimal outcostdiff = row.getBigDecimal("outcostdiff");
            BigDecimal baseQty = inBaseQty.subtract(outBaseQty);
            BigDecimal standardCost = inStandardCost.subtract(outStandardCost);
            BigDecimal actualCost = inActualCost.subtract(outActualCost);
            BigDecimal costdiff = incostdiff.subtract(outcostdiff);
            BigDecimal beginqty = row.getBigDecimal("endqty");
            beginqty = beginqty == null ? BigDecimal.ZERO : beginqty;
            BigDecimal beginstandardcost = row.getBigDecimal("endstandardcost");
            beginstandardcost = beginstandardcost == null ? BigDecimal.ZERO : beginstandardcost;
            BigDecimal beginactualcost = row.getBigDecimal("endactualcost");
            beginactualcost = beginactualcost == null ? BigDecimal.ZERO : beginactualcost;
            BigDecimal begincostdiff = row.getBigDecimal("endcostdiff");
            BigDecimal bigDecimal = begincostdiff = begincostdiff == null ? BigDecimal.ZERO : begincostdiff;
            if (isNegate) {
                inBaseQty = inBaseQty.negate();
                inStandardCost = inStandardCost.negate();
                inActualCost = inActualCost.negate();
                incostdiff = incostdiff.negate();
                outBaseQty = outBaseQty.negate();
                outStandardCost = outStandardCost.negate();
                outActualCost = outActualCost.negate();
                outcostdiff = outcostdiff.negate();
                baseQty = baseQty.negate();
                standardCost = standardCost.negate();
                actualCost = actualCost.negate();
                costdiff = costdiff.negate();
            }
            if ((costperiod = Integer.valueOf((costyear = row.getInteger("costyear").intValue()) * 100 + (costmonth = row.getInteger("costmonth").intValue()))).equals(balanceperiod = row.getInteger("balanceperiod"))) {
                o1 = (Object[])mainBalMap.get(balanceid);
                o = new Object[]{inBaseQty, inStandardCost, inActualCost, BigDecimal.ZERO, outBaseQty, outStandardCost, outActualCost, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, balanceid};
                if (o1 != null) {
                    this.addAmount(o, o1, new int[]{1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15});
                } else {
                    mainBalMap.put(balanceid, o);
                    updateList = this.getCurrentList(updateList_List, batchSize);
                    updateList.add(o);
                }
                detailUpdateList = this.getCurrentList(detailUpdateList_List, batchSize);
                detailUpdateList.add(new Object[]{inBaseQty, inStandardCost, inActualCost, incostdiff, outBaseQty, outStandardCost, outActualCost, outcostdiff, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, detailid});
                continue;
            }
            if (costperiod >= balanceperiod) continue;
            o1 = (Object[])mainBalMap.get(balanceid);
            o = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, baseQty, standardCost, actualCost, costdiff, balanceid};
            if (o1 != null) {
                this.addAmount(o, o1, new int[]{1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15});
            } else {
                mainBalMap.put(balanceid, o);
                updateList = this.getCurrentList(updateList_List, batchSize);
                updateList.add(o);
            }
            detailUpdateList = this.getCurrentList(detailUpdateList_List, batchSize);
            detailUpdateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, baseQty, standardCost, actualCost, costdiff, baseQty, standardCost, actualCost, costdiff, detailid});
        }
        final CountDownLatch latch = new CountDownLatch(2);
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    for (List updateList : updateList_List) {
                        try {
                            TXHandle h = TX.requiresNew();
                            Throwable throwable = null;
                            try (PreparedStatement ps = DB.prepareStatement((DBRoute)CommonUtils.getCalDBRouteKey(), (String)BalanceCalculator.this.updateSql);){
                                for (Object[] values : updateList) {
                                    ps.setBigDecimal(1, (BigDecimal)values[0]);
                                    ps.setBigDecimal(2, (BigDecimal)values[1]);
                                    ps.setBigDecimal(3, (BigDecimal)values[2]);
                                    ps.setBigDecimal(4, (BigDecimal)values[3]);
                                    ps.setBigDecimal(5, (BigDecimal)values[4]);
                                    ps.setBigDecimal(6, (BigDecimal)values[5]);
                                    ps.setBigDecimal(7, (BigDecimal)values[6]);
                                    ps.setBigDecimal(8, (BigDecimal)values[7]);
                                    ps.setBigDecimal(9, (BigDecimal)values[8]);
                                    ps.setBigDecimal(10, (BigDecimal)values[9]);
                                    ps.setBigDecimal(11, (BigDecimal)values[10]);
                                    ps.setBigDecimal(12, (BigDecimal)values[11]);
                                    ps.setBigDecimal(13, (BigDecimal)values[12]);
                                    ps.setBigDecimal(14, (BigDecimal)values[13]);
                                    ps.setBigDecimal(15, (BigDecimal)values[14]);
                                    ps.setBigDecimal(16, (BigDecimal)values[15]);
                                    ps.setLong(17, (Long)values[16]);
                                    ps.addBatch();
                                }
                                ps.executeBatch();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (h == null) continue;
                                if (throwable != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                h.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("CountDownLatch -> countDown 1 error ", (Throwable)e);
                            throw new KDBizException(e.getMessage());
                            return;
                        }
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        });
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    for (List detailUpdateList : detailUpdateList_List) {
                        try {
                            TXHandle h = TX.requiresNew();
                            Throwable throwable = null;
                            try (PreparedStatement ps = DB.prepareStatement((DBRoute)CommonUtils.getCalDBRouteKey(), (String)BalanceCalculator.this.detailUpdateSql);){
                                for (Object[] values : detailUpdateList) {
                                    ps.setBigDecimal(1, (BigDecimal)values[0]);
                                    ps.setBigDecimal(2, (BigDecimal)values[1]);
                                    ps.setBigDecimal(3, (BigDecimal)values[2]);
                                    ps.setBigDecimal(4, (BigDecimal)values[3]);
                                    ps.setBigDecimal(5, (BigDecimal)values[4]);
                                    ps.setBigDecimal(6, (BigDecimal)values[5]);
                                    ps.setBigDecimal(7, (BigDecimal)values[6]);
                                    ps.setBigDecimal(8, (BigDecimal)values[7]);
                                    ps.setBigDecimal(9, (BigDecimal)values[8]);
                                    ps.setBigDecimal(10, (BigDecimal)values[9]);
                                    ps.setBigDecimal(11, (BigDecimal)values[10]);
                                    ps.setBigDecimal(12, (BigDecimal)values[11]);
                                    ps.setBigDecimal(13, (BigDecimal)values[12]);
                                    ps.setBigDecimal(14, (BigDecimal)values[13]);
                                    ps.setBigDecimal(15, (BigDecimal)values[14]);
                                    ps.setBigDecimal(16, (BigDecimal)values[15]);
                                    ps.setLong(17, (Long)values[16]);
                                    ps.addBatch();
                                }
                                ps.executeBatch();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (h == null) continue;
                                if (throwable != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                h.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("CountDownLatch -> countDown 2 error ", (Throwable)e);
                            throw new KDBizException(e.getMessage());
                            return;
                        }
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("BalanceCalculator->latch.await() error ", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private List<Object[]> getCurrentList(List<List<Object[]>> detailUpdateList_List, int batchSize) {
        List<Object> detailUpdateList = null;
        if (detailUpdateList_List.isEmpty()) {
            detailUpdateList = new ArrayList(batchSize);
            detailUpdateList_List.add(detailUpdateList);
        } else {
            detailUpdateList = detailUpdateList_List.get(detailUpdateList_List.size() - 1);
            if (detailUpdateList.size() >= batchSize) {
                detailUpdateList = new ArrayList(batchSize);
                detailUpdateList_List.add(detailUpdateList);
            }
        }
        return detailUpdateList;
    }

    private void addSnapShootBalance(Set<Long> entryIdSet) {
        LinkedList<DynamicObject> snapShootList = new LinkedList<DynamicObject>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.baseunit,entry.baseqty,entry.accounttype,costaccount.enablestandardcost", (QFilter[])new QFilter("entry.id", "in", entryIdSet).toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id,entryid,standardcost,actualcost", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray(), null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entry.id", "entryid").select(new String[]{"id as billid", "entry.baseunit", "entry.baseqty", "costaccount.enablestandardcost", "entry.accounttype"}, new String[]{"id as detailid", "standardcost", "actualcost"}).finish();){
            for (Row row : joinDataSet) {
                DynamicObject snapShoot = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_snapshoot");
                snapShoot.set("headid", row.get("billid"));
                snapShoot.set("mainid", row.get("detailid"));
                snapShoot.set("unit", row.get("entry.baseunit"));
                snapShoot.set("qty", row.get("entry.baseqty"));
                if (row.getBoolean("costaccount.enablestandardcost").booleanValue() || AccountTypeEnum.STANDARDCOST.getValue().equals(row.getString("entry.accounttype"))) {
                    snapShoot.set("standardcost", row.get("standardcost"));
                } else {
                    snapShoot.set("standardcost", (Object)0);
                }
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(row.getString("entry.accounttype"))) {
                    snapShoot.set("actualcost", row.get("standardcost"));
                } else {
                    snapShoot.set("actualcost", row.get("actualcost"));
                }
                snapShootList.add(snapShoot);
            }
        }
        SaveServiceHelper.save((DynamicObject[])snapShootList.toArray(new DynamicObject[snapShootList.size()]));
    }

    private DataSet getCostRecords(Set<Long> entryIds, boolean hasDetail) {
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u67e5\u8be2\u6210\u672c\u8bb0\u5f55\uff1a" + System.currentTimeMillis());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)("id,billno,bizdate,period as periodid,period.periodyear as year,period.periodnumber as month,calbilltype,costaccount.calsystem as calsystem,costaccount.calorg as calorg,costaccount.calpolicy as calpolicy,entry.id as entryid," + this.costRecordAliasSelectsFields + "costaccount.enablestandardcost as enablestd,entry.accounttype as acctype,entry.baseunit as baseunit,entry.baseqty as baseqty,entry.calrange as calrange,entry.caldimension caldimension,invscheme.isforwardamount as isinvschecal,entry.invtype.isforwardamount as isinvtypecal"), (QFilter[])new QFilter("entry.id", "in", entryIds).toArray(), null);
        if (hasDetail) {
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id,entryid,costelement,costsubelement,standardcost,actualcost", (QFilter[])new QFilter("entryid", "in", entryIds).toArray(), null);
            DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entryid", "entryid").select(ArrayUtils.concatAll(new String[]{"id", "billno", "bizdate", "periodid", "year", "month", "calbilltype", "calsystem", "calorg", "calpolicy", "entryid", "baseunit", "baseqty", "acctype", "enablestd", "calrange", "caldimension", "isinvschecal", "isinvtypecal"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"id as detailid", "costelement", "costsubelement", "standardcost", "actualcost"}).finish();
            joinDataSet = joinDataSet.select("id,billno,bizdate,periodid,year,month,calbilltype,calsystem,calorg,calpolicy,entryid,baseunit,baseqty,detailid,acctype,enablestd,calrange,caldimension," + this.dimFields + this.costElementFields + ",standardcost as standardcost,actualcost as actualcost,case when calbilltype = 'IN' then baseqty else 0 end as inbaseqty,case when calbilltype = 'IN' and (enablestd = TRUE or acctype = 'D') then standardcost else 0 end as instandardcost,case when (calbilltype = 'IN' and acctype <> 'D') then actualcost when (calbilltype = 'IN' and (acctype = 'D' and isinvschecal and isinvtypecal)) then standardcost else 0 end as inactualcost,case when calbilltype = 'IN' then 0 else baseqty end as outbaseqty,case when calbilltype = 'IN' or (enablestd = FALSE and acctype <> 'D') then 0 else standardcost end as outstandardcost,case when calbilltype = 'IN' then 0 when (calbilltype = 'OUT' and acctype <> 'D') then actualcost when (calbilltype = 'OUT' and (acctype = 'D' and isinvschecal and isinvtypecal)) then standardcost end as outactualcost,0 as incostdiff,0 as outcostdiff");
            return joinDataSet;
        }
        return dataSet;
    }

    private DataSet getCostAdjusts(Object[] entryIds, boolean hasDetail) {
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u67e5\u8be2\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
        QFilter qFilter = new QFilter("entryentity.id", "in", (Object)entryIds);
        qFilter.and("isupdatecost", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)("id,billno,bizdate,period as periodid,period.periodyear as year,period.periodnumber as month,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,createtype,difftype,billsrctype,costaccount.calsystem as calsystem,costaccount.calorg as calorg,costaccount.calpolicy as calpolicy,entryentity.id as entryid,entryentity.accounttype as acctype,entryentity.calrange as calrange,entryentity.caldimension caldimension," + this.costAdjustAliasSelectsFields + "entryentity.baseunit as baseunit"), (QFilter[])qFilter.toArray(), null);
        if (hasDetail) {
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_detail", (String)"id,entryid,costelement,costsubelement,adjustamt", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
            DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entryid", "entryid").select(ArrayUtils.concatAll(new String[]{"id", "billno", "bizdate", "periodid", "year", "month", "calbilltype", "createtype", "calsystem", "calorg", "calpolicy", "entryid", "baseunit", "difftype", "billsrctype", "acctype", "calrange", "caldimension"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"id as detailid", "costelement", "costsubelement", "adjustamt"}).finish();
            joinDataSet = joinDataSet.select("id,billno,bizdate,periodid,year,month,calbilltype,createtype,calsystem,calorg,calpolicy,entryid,baseunit,detailid,acctype,calrange,caldimension," + this.dimFields + this.costElementFields + ",0 as inbaseqty,case when createtype= 'C1' and difftype ='M' and calbilltype = 'IN' then 0-adjustamt else 0 end as instandardcost,case when calbilltype = 'IN' and ((acctype = 'D' and difftype <> 'B' and createtype <> 'C1') or (acctype <> 'D' and difftype = 'B') ) then adjustamt else 0 end as inactualcost,0 as outbaseqty,case when createtype ='C1' and difftype ='M' and calbilltype = 'OUT' then 0-adjustamt else 0 end as outstandardcost,case when calbilltype = 'OUT' and ((acctype = 'D' and difftype <> 'B' and createtype <> 'C1') or (acctype <> 'D' and difftype = 'B') ) then adjustamt else 0 end as outactualcost,case when calbilltype = 'IN' and difftype <> 'B'  then adjustamt else 0 end as incostdiff,case when calbilltype = 'OUT' and difftype <> 'B' then adjustamt else 0 end as outcostdiff");
            return joinDataSet;
        }
        return dataSet;
    }

    private DataSet getCostRecordsWithSnapShoot(Set<Long> entryIds) {
        logger.info("getCostRecordsWithSnapShoot" + System.currentTimeMillis());
        DataSet dataSet = this.getCostRecords(entryIds, true);
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id", (QFilter[])new QFilter("entryid", "in", entryIds).toArray(), null);
        HashSet<Long> detailIdSet = new HashSet<Long>(1024);
        for (Row row : detailDataSet) {
            detailIdSet.add(row.getLong("id"));
        }
        DataSet snapShootDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_snapshoot", (String)"mainid,unit,qty as snapshootqty,standardcost as snapshootstandardcost,actualcost as snapshootactualcost", (QFilter[])new QFilter("mainid", "in", detailIdSet).toArray(), null);
        dataSet = dataSet.join(snapShootDataSet, JoinType.INNER).on("detailid", "mainid").select(ArrayUtils.concatAll(new String[]{"id", "billno", "bizdate", "periodid", "year", "month", "calbilltype", "calsystem", "calorg", "calpolicy", "entryid", "baseunit", "detailid", "acctype", "calrange", "caldimension", "case when calbilltype = 'IN' then inbaseqty - snapshootqty else 0 end as inbaseqty", "case when calbilltype = 'IN' then instandardcost - snapshootstandardcost else 0 end as instandardcost", "case when calbilltype = 'IN' then inactualcost - snapshootactualcost else 0 end as inactualcost", "case when calbilltype = 'IN' then 0 else outbaseqty - snapshootqty end as outbaseqty", "case when calbilltype = 'IN' then 0 else outstandardcost - snapshootstandardcost end as outstandardcost", "case when calbilltype = 'IN' then 0 else outactualcost - snapshootactualcost end as outactualcost", "0 as incostdiff", "0 as outcostdiff"}, this.dimFieldSet.toArray(new String[0]), this.costElementFields.split(","))).finish();
        return dataSet;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet getBalanceJoinData(DataSet dataSet, boolean hasDetailBal, boolean isUpdate4Other) {
        logger.info("getBalanceJoinData" + System.currentTimeMillis());
        if (hasDetailBal) {
            void var11_25;
            dataSet = dataSet.groupBy(ArrayUtils.concatAll(new String[]{"periodid", "calsystem", "calorg", "calpolicy", "year", "month", "baseunit", "acctype", "calrange", "caldimension"}, this.dimFieldSet.toArray(new String[0]), this.costElementFields.split(","))).sum("inbaseqty").sum("instandardcost").sum("inactualcost").sum("outbaseqty").sum("outstandardcost").sum("outactualcost").sum("incostdiff").sum("outcostdiff").finish();
            HashMap dimFieldFilterMap = new HashMap(16);
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance");
            HashMap<String, Boolean> fieldProMap = new HashMap<String, Boolean>(16);
            DataSet copyDataSet = dataSet.copy();
            int minPeriod = 0;
            for (Object row : copyDataSet) {
                if (isUpdate4Other) {
                    int n = row.getInteger("year") * 100 + row.getInteger("month");
                    if (minPeriod == 0 || n < minPeriod) {
                        minPeriod = n;
                    }
                }
                for (String string : this.dimFieldSet) {
                    Boolean isBaseData;
                    HashSet<Object> set = (HashSet<Object>)dimFieldFilterMap.get(string);
                    if (set == null) {
                        set = new HashSet<Object>(32);
                        dimFieldFilterMap.put(string, set);
                    }
                    if ((isBaseData = (Boolean)fieldProMap.get(string)) == null) {
                        isBaseData = balEntityType.findProperty(string) instanceof BasedataProp;
                        fieldProMap.put(string, isBaseData);
                    }
                    if (isBaseData.booleanValue()) {
                        set.add(row.getLong(string));
                        continue;
                    }
                    set.add(row.getString(string));
                }
            }
            QFilter q = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
            if (isUpdate4Other) {
                q = new QFilter("period", ">=", (Object)minPeriod);
            }
            for (Map.Entry entry : dimFieldFilterMap.entrySet()) {
                q.and((String)entry.getKey(), "in", entry.getValue());
            }
            DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_subentity", (String)(this.dimFields + "id as balanceid,periodid,period,year,month,calrange as relacalrange,caldimension as relacaldimension,accounttype as relaacctp,entryentity.id as detailid,entryentity.costelement as costelement,entryentity.costsubelement as costsubelement,entryentity.sub_periodendqty as periodendqty,entryentity.sub_periodendstandardcost as periodendstandardcost,entryentity.sub_periodendcostdiff as periodendcostdiff,entryentity.sub_periodendactualcost as periodendactualcost,entryentity.sub_yearinqty as yearinqty,entryentity.sub_yearinstandradcost as yearinstandradcost,entryentity.sub_yearincostdiff as yearincostdiff,entryentity.sub_yearinactualcost as yearinactualcost,entryentity.sub_yearissueqty as yearissueqty,entryentity.sub_yearissuestandradcost as yearissuestandradcost,entryentity.sub_yearissuecostdiff as yearissuecostdiff,entryentity.sub_yearissueactualcost as yearissueactualcost,entryentity.sub_periodbeginqty as beginqty,entryentity.sub_beginstandardcost as beginstandardcost,entryentity.sub_periodbeginactualcost as beginactualcost,entryentity.sub_periodendqty as endqty,entryentity.sub_periodendstandardcost as endstandardcost,entryentity.sub_periodendactualcost as endactualcost,entryentity.sub_periodendcostdiff as endcostdiff"), (QFilter[])q.toArray(), null);
            JoinDataSet joinDataSet = dataSet.join(balanceSet, JoinType.LEFT);
            for (String field : this.dimFieldSet) {
                void var11_23;
                JoinDataSet joinDataSet2 = var11_23.on(field, field);
            }
            for (String field : this.costElementFields.split(",")) {
                JoinDataSet joinDataSet3 = var11_25.on(field, field);
            }
            dataSet = var11_25.select(ArrayUtils.concatAll(new String[]{"periodid as costperiodid", "year as costyear", "month as costmonth", "calsystem", "calorg", "calpolicy", "baseunit", "acctype", "calrange", "caldimension", "inbaseqty", "instandardcost", "inactualcost", "outbaseqty", "outstandardcost", "outactualcost", "incostdiff", "outcostdiff"}, this.dimFieldSet.toArray(new String[0]), this.costElementFields.split(",")), new String[]{"balanceid", "year as balanceyear", "month as balancemonth", "periodid as balanceperiodid", "period as balanceperiod", "detailid", "beginqty", "beginstandardcost", "beginactualcost", "endqty", "endstandardcost", "endactualcost", "endcostdiff", "relacalrange", "relacaldimension", "relaacctp"}).finish().orderBy(new String[]{"balanceperiod"});
        } else {
            void var11_31;
            dataSet = dataSet.groupBy(ArrayUtils.concatAll(new String[]{"periodid", "calsystem", "calorg", "calpolicy", "year", "month", "baseunit", "acctype", "calrange", "caldimension"}, new String[][]{this.dimFieldSet.toArray(new String[0])})).finish();
            DataSet copyDataSet = dataSet.copy();
            HashSet<Long> periodIdSet = new HashSet<Long>(16);
            HashMap dimFieldFilterMap = new HashMap(16);
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_balance");
            HashMap<String, Boolean> fieldProMap = new HashMap<String, Boolean>(16);
            for (Object row : copyDataSet) {
                periodIdSet.add(row.getLong("periodid"));
                for (String string : this.dimFieldSet) {
                    Boolean isBaseData;
                    HashSet<Object> set = (HashSet<Object>)dimFieldFilterMap.get(string);
                    if (set == null) {
                        set = new HashSet<Object>(32);
                        dimFieldFilterMap.put(string, set);
                    }
                    if ((isBaseData = (Boolean)fieldProMap.get(string)) == null) {
                        isBaseData = balEntityType.findProperty(string) instanceof BasedataProp;
                        fieldProMap.put(string, isBaseData);
                    }
                    if (isBaseData.booleanValue()) {
                        set.add(row.getLong(string));
                        continue;
                    }
                    set.add(row.getString(string));
                }
            }
            Iterator q = new QFilter("period", "<>", (Object)0);
            q.and("periodid", "in", periodIdSet);
            for (Map.Entry entry : dimFieldFilterMap.entrySet()) {
                q.and((String)entry.getKey(), "in", entry.getValue());
            }
            DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)(this.dimFields + "id as balanceid,periodid,period,calrange as relacalrange,caldimension as relacaldimension,accounttype as relaacctp"), (QFilter[])q.toArray(), null);
            JoinDataSet joinDataSet = dataSet.join(balanceSet, JoinType.LEFT);
            for (String field : this.dimFieldSet) {
                JoinDataSet joinDataSet4 = var11_31.on(field, field);
            }
            JoinDataSet joinDataSet5 = var11_31.on("periodid", "periodid");
            dataSet = joinDataSet5.select(ArrayUtils.concatAll(new String[]{"periodid as costperiodid", "year as costyear", "month as costmonth", "calsystem", "calorg", "calpolicy", "baseunit", "acctype", "calrange", "caldimension"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"balanceid", "year as balanceyear", "month as balancemonth", "periodid as balanceperiodid", "period as balanceperiod", "relacalrange", "relacaldimension", "relaacctp"}).finish();
        }
        return dataSet;
    }

    public DataSet getCostAdjustsBalance(Object[] billIds) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)("id,billno,period as periodid," + this.costAdjustAliasSelectsFields + "entryentity.id as entryid,entryentity.adjustamt as adjustamt"), (QFilter[])new QFilter("id", "in", (Object)billIds).toArray(), null);
        QFilter q = new QFilter("period", "<>", (Object)0);
        DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)(this.dimFields + "id as balanceid,periodid,period"), (QFilter[])q.toArray(), null);
        JoinDataSet joinDataSet = dataSet.join(balanceSet, JoinType.LEFT);
        for (String field : this.dimFieldSet) {
            joinDataSet = joinDataSet.on(field, field);
        }
        joinDataSet = joinDataSet.on("periodid", "periodid");
        dataSet = joinDataSet.select(new String[]{"id as costadjustbillid", "billno as costadjustbillno", "adjustamt"}, new String[]{"balanceid"}).finish();
        return dataSet;
    }

    public String getDimFields() {
        return this.dimFields;
    }

    public List<String> getDimFieldSet() {
        return this.dimFieldSet;
    }
}

