/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.util.ArrayUtils;
import kd.fi.calx.algox.util.CommonUtils;

public class PurPriceDiffCalculator {
    private static final Log logger = LogFactory.getLog(PurPriceDiffCalculator.class);
    private String updateSql = "update t_cal_purpricediff set fperiodincostdiff = fperiodincostdiff + ?, fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbegincostdiff = fperiodbegincostdiff + ?, fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?";
    private String detailUpdateSql = "update t_cal_purdiff_detail set fperiodincostdiff = fperiodincostdiff + ?, fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbegincostdiff = fperiodbegincostdiff + ?, fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?";
    private String endPeriodUpdateSql = "update t_cal_purpricediff set fendperiod = ? where fid = ?";
    private int defaultEndPeriod = 999999;
    private String keysplit = "_";
    private DynamicObject costAdjustBalRule;
    private Set<String> mainFieldSet = new HashSet<String>();
    private Set<String> dimFieldSet = new HashSet<String>(16);
    private StringBuilder costAdjustAliasSelectsFields = new StringBuilder(16);
    private StringBuilder dimFields = new StringBuilder();
    private String costElementFields = "costelement,costsubelement";

    public PurPriceDiffCalculator() {
        this.init();
    }

    private void init() {
        QFilter q = new QFilter("sourceentitynumber", "=", (Object)"cal_costadjust_subentity");
        q.and("balancetablenumber", "=", (Object)"cal_purpricediffmodel");
        q.and("custstatus", "=", (Object)"1");
        try {
            this.costAdjustBalRule = QueryServiceHelper.queryOne((String)"bal_balanceupdaterule", (String)"id,number", (QFilter[])new QFilter[]{q});
        }
        catch (Exception e) {
            logger.info(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u4f59\u989d\u8868\u66f4\u65b0\u89c4\u5219\u5931\u8d25\uff1a", (String)"PurPriceDiffCalculator_0", (String)"fi-cal-business", (Object[])new Object[0]), (Object)e);
        }
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_purpricediffmodel", bizDataTypeSet);
        if (fieldMap.get(BizDataType.MAIN) != null) {
            this.mainFieldSet.addAll((Collection)fieldMap.get(BizDataType.MAIN));
        }
        if (fieldMap.get(BizDataType.DIM) != null) {
            this.dimFieldSet.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        this.dimFieldSet.addAll(this.mainFieldSet);
        if (this.costAdjustBalRule != null) {
            this.initBalanceFields(this.costAdjustBalRule, "cal_costadjustbill", this.costAdjustAliasSelectsFields);
        }
        if (this.dimFieldSet.isEmpty()) {
            this.dimFieldSet.add("costaccount");
            this.dimFieldSet.add("storageorgunit");
            this.dimFieldSet.add("ownertype");
            this.dimFieldSet.add("owner");
            this.dimFieldSet.add("seqnum");
            this.dimFieldSet.add("material");
            this.dimFieldSet.add("mversion");
            this.dimFieldSet.add("assist");
            this.dimFieldSet.add("lot");
            this.dimFieldSet.add("warehouse");
            this.dimFieldSet.add("location");
            this.dimFieldSet.add("invtype");
            this.dimFieldSet.add("invstatus");
            this.dimFieldSet.add("project");
            this.dimFieldSet.add("createtype");
            this.dimFieldSet.add("configuredcode");
        }
        for (String dimField : this.dimFieldSet) {
            this.dimFields.append(dimField).append(',');
        }
        if (this.costAdjustAliasSelectsFields.length() == 0) {
            this.costAdjustAliasSelectsFields.append("createtype,costaccount as costaccount,entryentity.storageorgunit as storageorgunit,entryentity.ownertype as ownertype,entryentity.owner as owner,entryentity.material as material,entryentity.assist as assist,entryentity.lot as lot,entryentity.warehouse as warehouse,entryentity.location as location,entryentity.invtype as invtype,entryentity.invstatus as invstatus,entryentity.project as project,entryentity.mversion as mversion,entryentity.configuredcode as configuredcode");
        } else {
            this.costAdjustAliasSelectsFields.deleteCharAt(this.costAdjustAliasSelectsFields.length() - 1);
        }
    }

    private void initBalanceFields(DynamicObject balRule, String entityName, StringBuilder aliasFields) {
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String balUpdateRuleId = balRule.getString("id");
        BalanceUpdateRuleMetadata ruleMetadata = reader.loadMeta(balUpdateRuleId, false);
        BalanceFieldMapPolicy fieldMapPolicy = ruleMetadata.getRuleElement().getFieldMapPolicy();
        for (BalanceFieldMapItem fieldMapItem : fieldMapPolicy.getBalanceFieldMapItems()) {
            String sourceField;
            String convertType = fieldMapItem.getConvertType();
            String targetField = fieldMapItem.getTargetField();
            if (!"0".equals(convertType) || (sourceField = fieldMapItem.getSourceField()) == null) continue;
            if (bizEntityType.findProperty(sourceField).getParent() instanceof EntryType) {
                sourceField = bizEntityType.findProperty(sourceField).getParent().getName() + "." + sourceField;
            }
            aliasFields.append(sourceField).append(" as ").append(targetField).append(',');
        }
    }

    public void updatePurPriceDiff4CostAdjust(Object[] entryIds) {
        try (DataSet detailAdjustSet = this.getCostAdjusts(entryIds, true);
             DataSet detailDataSet = this.getBalanceJoinData(detailAdjustSet, true);
             DataSet adjustSet = this.getCostAdjusts(entryIds, false);
             DataSet dataSet = this.getBalanceJoinData(adjustSet, false);){
            this.updateBalance(detailDataSet, dataSet);
        }
    }

    public void updatePurPriceDiff4CostAdjustDel(Object[] entryIds) {
        try (DataSet adjustSet = this.getCostAdjusts(entryIds, true);
             DataSet dataSet = this.getBalanceJoinData(adjustSet, true);){
            this.updateBalance(dataSet, true);
        }
    }

    private void updateBalance(DataSet detailDataSet, DataSet dataSet) {
        ArrayList<Object[]> detailUpateList = new ArrayList<Object[]>(16);
        ArrayList<Object> updateList = new ArrayList<Object>(16);
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(16);
        ArrayList<Object> detailInsertList = new ArrayList<Object>(16);
        ArrayList<Object> endPeriodUpdateObjList = new ArrayList<Object>(16);
        HashMap<String, DynamicObject> detailInsertObjMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Boolean> hasBeforeCurrencData = new HashMap<String, Boolean>(16);
        HashMap<Long, Object[]> updateBalanceMap = new HashMap<Long, Object[]>(16);
        HashMap<String, Long> beforeDetailMap = new HashMap<String, Long>(16);
        HashMap<String, Object[]> beforePeriodUpdateObjMap = new HashMap<String, Object[]>(16);
        logger.info("PurPriceDiffCalculator-\u5f00\u59cb\u5faa\u73af\u94fe\u8868\u7ed3\u679c\uff1a" + System.currentTimeMillis());
        int count = 0;
        HashMap<String, Long> balMap = new HashMap<String, Long>(16);
        for (Row row : dataSet) {
            Long l = row.getLong("balanceid");
            StringBuilder dimKey = new StringBuilder();
            for (String field : this.dimFieldSet) {
                dimKey.append(row.get(field)).append(this.keysplit);
            }
            if (l != null && l != 0L) {
                balMap.put(dimKey.toString(), l);
                continue;
            }
            long costperiodid = row.getLong("costperiodid");
            long calsystemid = row.getLong("calsystem");
            long calorgid = row.getLong("calorg");
            long calpolicyid = row.getLong("calpolicy");
            int costyear = row.getInteger("costyear");
            int costmonth = row.getInteger("costmonth");
            Integer costperiod = costyear * 100 + costmonth;
            DynamicObject balanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff");
            long balId = DBServiceHelper.genLongIds((String)"t_cal_purpricediff", (int)1)[0];
            balanceInfo.set("id", (Object)balId);
            balanceInfo.set("accsys", (Object)calsystemid);
            balanceInfo.set("calorg", (Object)calorgid);
            balanceInfo.set("calpolicy", (Object)calpolicyid);
            balanceInfo.set("periodid", (Object)costperiodid);
            balanceInfo.set("period", (Object)costperiod);
            balanceInfo.set("endperiod", (Object)this.defaultEndPeriod);
            balanceInfo.set("year", (Object)costyear);
            balanceInfo.set("month", (Object)costmonth);
            for (String field : this.dimFieldSet) {
                balanceInfo.set(field, row.get(field));
            }
            balMap.put(dimKey.toString(), balId);
            insertList.add(balanceInfo);
        }
        if (insertList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[0]));
        }
        for (Row row : detailDataSet) {
            Long l = row.getLong("detailid");
            Long balanceid = row.getLong("balanceid");
            StringBuilder dimKey = new StringBuilder();
            for (String field : this.dimFieldSet) {
                dimKey.append(row.get(field)).append(this.keysplit);
            }
            long balId = (Long)balMap.get(dimKey.toString());
            StringBuilder keySb = new StringBuilder(dimKey);
            for (String field : this.costElementFields.split(",")) {
                keySb.append(row.get(field)).append(this.keysplit);
            }
            String key = keySb.toString();
            BigDecimal inCostDiff = row.getBigDecimal("incostdiff");
            inCostDiff = inCostDiff == null ? BigDecimal.ZERO : inCostDiff;
            BigDecimal issueCostDiff = row.getBigDecimal("issuecostdiff");
            issueCostDiff = issueCostDiff == null ? BigDecimal.ZERO : issueCostDiff;
            BigDecimal costDiff = inCostDiff.subtract(issueCostDiff);
            BigDecimal periodBeginCostDiff = row.getBigDecimal("periodendcostdiff");
            periodBeginCostDiff = periodBeginCostDiff == null ? BigDecimal.ZERO : periodBeginCostDiff;
            BigDecimal periodEndCostDiff = periodBeginCostDiff.add(costDiff);
            int costyear = row.getInteger("costyear");
            int costmonth = row.getInteger("costmonth");
            Integer costperiod = costyear * 100 + costmonth;
            if (l == null) {
                updateList.add(new Object[]{inCostDiff, issueCostDiff, periodBeginCostDiff, periodEndCostDiff, balId});
                DynamicObject detailBalInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff_detail");
                detailBalInfo.set("balid", (Object)balId);
                detailBalInfo.set("periodbegincostdiff", (Object)periodBeginCostDiff);
                detailBalInfo.set("periodincostdiff", (Object)inCostDiff);
                detailBalInfo.set("periodissuecostdiff", (Object)issueCostDiff);
                detailBalInfo.set("periodendcostdiff", (Object)periodEndCostDiff);
                for (String field : this.costElementFields.split(",")) {
                    detailBalInfo.set(field, row.get(field));
                }
                detailInsertList.add(detailBalInfo);
                continue;
            }
            Integer balanceperiod = row.getInteger("balanceperiod");
            if (balanceperiod < costperiod) {
                DynamicObject detailBalanceInfo = (DynamicObject)detailInsertObjMap.get(key);
                if (detailBalanceInfo == null) {
                    updateBalanceMap.put(l, new Object[]{inCostDiff, issueCostDiff, periodBeginCostDiff, periodEndCostDiff, balId});
                    beforeDetailMap.put(key, l);
                    detailBalanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff_detail");
                    detailBalanceInfo.set("balid", (Object)balId);
                    detailBalanceInfo.set("periodbegincostdiff", (Object)periodBeginCostDiff);
                    detailBalanceInfo.set("periodincostdiff", (Object)inCostDiff);
                    detailBalanceInfo.set("periodissuecostdiff", (Object)issueCostDiff);
                    detailBalanceInfo.set("periodendcostdiff", (Object)periodEndCostDiff);
                    for (String field : this.costElementFields.split(",")) {
                        detailBalanceInfo.set(field, row.get(field));
                    }
                    detailInsertObjMap.put(key, detailBalanceInfo);
                } else {
                    detailBalanceInfo.set("periodbegincostdiff", (Object)periodBeginCostDiff);
                    detailBalanceInfo.set("periodendcostdiff", (Object)periodEndCostDiff);
                    Long id = (Long)beforeDetailMap.get(key);
                    if (id != null) {
                        updateBalanceMap.remove(id);
                    }
                    updateBalanceMap.put(l, new Object[]{inCostDiff, issueCostDiff, periodBeginCostDiff, periodEndCostDiff, balId});
                    beforeDetailMap.put(key, l);
                }
                beforePeriodUpdateObjMap.put(key, new Object[]{costperiod, balanceid});
                hasBeforeCurrencData.put(key, true);
            } else if (costperiod.equals(balanceperiod)) {
                detailInsertObjMap.remove(key);
                beforePeriodUpdateObjMap.remove(key);
                detailUpateList.add(new Object[]{inCostDiff, issueCostDiff, BigDecimal.ZERO, costDiff, l});
                Long id = (Long)beforeDetailMap.get(key);
                if (id != null) {
                    updateBalanceMap.remove(id);
                }
                updateBalanceMap.put(l, new Object[]{inCostDiff, issueCostDiff, BigDecimal.ZERO, costDiff, balId});
                hasBeforeCurrencData.put(key, true);
            } else {
                DynamicObject insertObj = (DynamicObject)detailInsertObjMap.get(key);
                if (insertObj != null) {
                    endPeriodUpdateObjList.add(new Object[]{balanceperiod, balId});
                    detailInsertObjMap.remove(key);
                    detailInsertList.add(insertObj);
                } else {
                    Boolean hasData = (Boolean)hasBeforeCurrencData.get(key);
                    if (hasData == null) {
                        DynamicObject detailBalanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff_detail");
                        detailBalanceInfo.set("balid", (Object)balId);
                        detailBalanceInfo.set("periodbegincostdiff", (Object)BigDecimal.ZERO);
                        detailBalanceInfo.set("periodincostdiff", (Object)inCostDiff);
                        detailBalanceInfo.set("periodissuecostdiff", (Object)issueCostDiff);
                        detailBalanceInfo.set("periodendcostdiff", (Object)costDiff);
                        for (String field : this.costElementFields.split(",")) {
                            detailBalanceInfo.set(field, row.get(field));
                        }
                        detailInsertList.add(detailBalanceInfo);
                        updateBalanceMap.put(l, new Object[]{inCostDiff, issueCostDiff, BigDecimal.ZERO, costDiff, balId});
                        hasBeforeCurrencData.put(key, false);
                        endPeriodUpdateObjList.add(new Object[]{balanceperiod, balId});
                    }
                }
                Object[] beforePeriodUpdateObj = (Object[])beforePeriodUpdateObjMap.get(key);
                if (beforePeriodUpdateObj != null) {
                    beforePeriodUpdateObjMap.remove(key);
                    endPeriodUpdateObjList.add(beforePeriodUpdateObj);
                }
                detailUpateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, costDiff, costDiff, l});
                updateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, costDiff, costDiff, balanceid});
            }
            ++count;
        }
        detailInsertList.addAll(detailInsertObjMap.values());
        endPeriodUpdateObjList.addAll(beforePeriodUpdateObjMap.values());
        updateList.addAll(updateBalanceMap.values());
        HashMap<Object, Object[]> mainBalMap = new HashMap<Object, Object[]>();
        for (Object[] objectArray : updateList) {
            Object balid = objectArray[4];
            Object[] o1 = (Object[])mainBalMap.get(balid);
            if (o1 != null) {
                this.addAmount(objectArray, o1, new int[]{0, 1, 2, 3});
                continue;
            }
            mainBalMap.put(balid, objectArray);
        }
        updateList.clear();
        updateList.addAll(mainBalMap.values());
        logger.info("BalanceCalculatorNew-\u5faa\u73af\u7ed3\u675f\uff1a" + System.currentTimeMillis() + "\u4f9b\u5faa\u73af" + count + "\u6b21");
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u63d2\u5165\u4f59\u989d\uff1a" + System.currentTimeMillis() + "\u5171" + detailInsertList.size() + "\u6761");
        if (detailInsertList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])detailInsertList.toArray(new DynamicObject[0]));
        }
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u66f4\u65b0\u4f59\u989d\uff1a" + System.currentTimeMillis() + "\u5171" + detailUpateList.size() + "\u6761");
        if (detailUpateList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.detailUpdateSql, detailUpateList);
        }
        if (updateList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.updateSql, updateList);
        }
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u66f4\u65b0\u4f59\u989d\u7ed3\u675f\u671f\u95f4\uff1a" + System.currentTimeMillis() + "\u5171" + endPeriodUpdateObjList.size() + "\u6761");
        if (endPeriodUpdateObjList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.endPeriodUpdateSql, endPeriodUpdateObjList);
        }
    }

    private void addAmount(Object[] o, Object[] o1, int[] indexs) {
        for (int i : indexs) {
            o1[i] = ((BigDecimal)o1[i]).add((BigDecimal)o[i]);
        }
    }

    private void updateBalance(DataSet dataSet, boolean isNegate) {
        logger.info("PurPriceDiffCalculator-costadjustbilldel" + System.currentTimeMillis());
        ArrayList<Object> updateList = new ArrayList<Object>();
        ArrayList<Object[]> detailUpdateList = new ArrayList<Object[]>();
        for (Row row : dataSet) {
            Integer balanceperiod;
            int costmonth;
            int costyear;
            Integer costperiod;
            Long l = row.getLong("balanceid");
            Long detailid = row.getLong("detailid");
            if (l == null) {
                logger.info("\u672a\u5173\u8054\u5230\u4f59\u989d\u6570\u636e");
                continue;
            }
            BigDecimal inCostDiff = row.getBigDecimal("incostdiff");
            BigDecimal outCostDiff = row.getBigDecimal("issuecostdiff");
            if (isNegate) {
                inCostDiff = inCostDiff.negate();
                outCostDiff = outCostDiff.negate();
            }
            if ((costperiod = Integer.valueOf((costyear = row.getInteger("costyear").intValue()) * 100 + (costmonth = row.getInteger("costmonth").intValue()))).equals(balanceperiod = row.getInteger("balanceperiod"))) {
                updateList.add(new Object[]{inCostDiff, outCostDiff, BigDecimal.ZERO, inCostDiff.subtract(outCostDiff), l});
                detailUpdateList.add(new Object[]{inCostDiff, outCostDiff, BigDecimal.ZERO, inCostDiff.subtract(outCostDiff), detailid});
                continue;
            }
            if (costperiod >= balanceperiod) continue;
            updateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, inCostDiff.subtract(outCostDiff), inCostDiff.subtract(outCostDiff), l});
            detailUpdateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, inCostDiff.subtract(outCostDiff), inCostDiff.subtract(outCostDiff), detailid});
        }
        HashMap<Object, Object[]> mainBalMap = new HashMap<Object, Object[]>(16);
        for (Object[] objectArray : updateList) {
            Object balid = objectArray[4];
            Object[] o1 = (Object[])mainBalMap.get(balid);
            if (o1 != null) {
                this.addAmount(objectArray, o1, new int[]{0, 1, 2, 3});
                continue;
            }
            mainBalMap.put(balid, objectArray);
        }
        updateList.clear();
        updateList.addAll(mainBalMap.values());
        if (updateList.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.updateSql, updateList);
        }
        if (!detailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.detailUpdateSql, detailUpdateList);
        }
    }

    private DataSet getCostAdjusts(Object[] entryIds, boolean hasDetail) {
        logger.info("PurPriceDiffCalculator-\u5f00\u59cb\u67e5\u8be2\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjustbill", (String)("id,billno,bizdate,period as periodid,period.periodyear as year,period.periodnumber as month,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,billsrctype,difftype,costaccount.calsystem as calsystem,costaccount.calorg as calorg,costaccount.calpolicy as calpolicy,entryentity.id as entryid," + this.costAdjustAliasSelectsFields), (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", (Object)entryIds), new QFilter("difftype", "<>", (Object)"B")}, null);
        if (hasDetail) {
            DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_detail", (String)"id,entryid,costelement,costsubelement,adjustamt", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
            DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entryid", "entryid").select(ArrayUtils.concatAll(new String[]{"id", "billno", "bizdate", "periodid", "year", "month", "calbilltype", "calsystem", "calorg", "calpolicy", "entryid", "billsrctype", "difftype"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"id as detailid", "costelement", "costsubelement", "adjustamt"}).finish();
            joinDataSet = joinDataSet.select("id,billno,bizdate,periodid,year,month,calbilltype,calsystem,calorg,calpolicy,entryid,detailid,difftype," + this.dimFields + this.costElementFields + ",case when calbilltype = 'IN' and  difftype <> 'B' then adjustamt  else 0 end as incostdiff,case when calbilltype = 'OUT' and difftype <> 'B' then adjustamt else 0 end as issuecostdiff");
            return joinDataSet.select(this.getDiffType2CreateType(true));
        }
        return dataSet.select(this.getDiffType2CreateType(false));
    }

    private String getDiffType2CreateType(boolean hasDetail) {
        HashSet<String> dimFieldsNotCreateType = new HashSet<String>(this.dimFieldSet);
        dimFieldsNotCreateType.remove("createtype");
        if (hasDetail) {
            return "id,billno,bizdate,periodid,year,month,calbilltype,calsystem,calorg,calpolicy,entryid,detailid,difftype as createtype," + String.join((CharSequence)",", dimFieldsNotCreateType) + "," + this.costElementFields + ",incostdiff,issuecostdiff";
        }
        return "id,billno,bizdate,periodid,year,month,calbilltype,calsystem,calorg,calpolicy,entryid,difftype as createtype," + String.join((CharSequence)",", dimFieldsNotCreateType);
    }

    private DataSet getBalanceJoinData(DataSet dataSet, boolean hasDetailBal) {
        logger.info("getBalanceJoinData" + System.currentTimeMillis());
        if (hasDetailBal) {
            dataSet = dataSet.groupBy(ArrayUtils.concatAll(new String[]{"periodid", "calsystem", "calorg", "calpolicy", "year", "month"}, this.dimFieldSet.toArray(new String[0]), this.costElementFields.split(","))).sum("incostdiff").sum("issuecostdiff").finish();
            HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
            HashSet<Long> materialIdSet = new HashSet<Long>(16);
            DataSet copyDataSet = dataSet.copy();
            for (Row row : copyDataSet) {
                costAccountIdSet.add(row.getLong("costaccount"));
                materialIdSet.add(row.getLong("material"));
            }
            QFilter q = new QFilter("costaccount", "in", costAccountIdSet);
            q.and("material", "in", materialIdSet);
            DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purpricediff", (String)(this.dimFields + "id as balanceid,periodid,period,year,month"), (QFilter[])q.toArray(), null);
            HashSet<Long> balIdSet = new HashSet<Long>(16);
            DataSet copyBalanceSet = balanceSet.copy();
            for (Row row : copyBalanceSet) {
                balIdSet.add(row.getLong("balanceid"));
            }
            q = new QFilter("balid", "in", balIdSet);
            DataSet detailBalanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purpricediff_detail", (String)"id,balid,costelement,costsubelement,periodbegincostdiff,periodincostdiff,periodissuecostdiff,periodendcostdiff", (QFilter[])q.toArray(), null);
            DataSet balDataSet = balanceSet.join(detailBalanceSet, JoinType.INNER).on("balanceid", "balid").select(ArrayUtils.concatAll(new String[]{"balanceid", "periodid", "period", "year", "month"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), ArrayUtils.concatAll(new String[]{"id as detailid", "periodbegincostdiff", "periodincostdiff", "periodissuecostdiff", "periodendcostdiff"}, new String[][]{this.costElementFields.split(",")})).finish();
            JoinDataSet joinDataSet = dataSet.join(balDataSet, JoinType.LEFT);
            for (String field : this.dimFieldSet) {
                joinDataSet = joinDataSet.on(field, field);
            }
            for (String field : this.costElementFields.split(",")) {
                joinDataSet = joinDataSet.on(field, field);
            }
            dataSet = joinDataSet.select(ArrayUtils.concatAll(new String[]{"periodid as costperiodid", "year as costyear", "month as costmonth", "calsystem", "calorg", "calpolicy", "incostdiff", "issuecostdiff"}, this.dimFieldSet.toArray(new String[0]), this.costElementFields.split(",")), new String[]{"balanceid", "year as balanceyear", "month as balancemonth", "periodid as balanceperiodid", "period as balanceperiod", "detailid", "periodbegincostdiff", "periodincostdiff", "periodissuecostdiff", "periodendcostdiff"}).finish().orderBy(new String[]{"balanceperiod"});
            return dataSet;
        }
        dataSet = dataSet.groupBy(ArrayUtils.concatAll(new String[]{"periodid", "calsystem", "calorg", "calpolicy", "year", "month"}, new String[][]{this.dimFieldSet.toArray(new String[0])})).finish();
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (Row row : copyDataSet) {
            periodIdSet.add(row.getLong("periodid"));
            costAccountIdSet.add(row.getLong("costaccount"));
            materialIdSet.add(row.getLong("material"));
        }
        QFilter q = new QFilter("period", "<>", (Object)0);
        q.and("periodid", "in", periodIdSet);
        q.and("costaccount", "in", costAccountIdSet);
        q.and("material", "in", materialIdSet);
        DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_purpricediff", (String)(this.dimFields + "id as balanceid,periodid,period"), (QFilter[])q.toArray(), null);
        JoinDataSet joinDataSet = dataSet.join(balanceSet, JoinType.LEFT);
        for (String field : this.dimFieldSet) {
            joinDataSet = joinDataSet.on(field, field);
        }
        joinDataSet = joinDataSet.on("periodid", "periodid");
        dataSet = joinDataSet.select(ArrayUtils.concatAll(new String[]{"periodid as costperiodid", "year as costyear", "month as costmonth", "calsystem", "calorg", "calpolicy"}, new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"balanceid", "year as balanceyear", "month as balancemonth", "periodid as balanceperiodid", "period as balanceperiod"}).finish();
        return dataSet;
    }
}

