/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.constant;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.report.CalOutRptHolder;

public enum CostPriceSourceTypeEnum {
    DOCUMENT_SPECIFICATION("A", "1", CostPriceSourceTypeEnum.getDocumentSpecification()),
    CALCULATE_IN_SPECIFICATION("B", "1", CostPriceSourceTypeEnum.getCalculateInSpecification()),
    EXP_BILL_SPECIFICATION("C", "1", CostPriceSourceTypeEnum.getExpBillSpecification()),
    PAY_ABLE_SPECIFICATION("D", "1", CostPriceSourceTypeEnum.getPayableSpecification()),
    COST_PAY_ABLE_SPECIFICATION("E", "1", CostPriceSourceTypeEnum.getCostPayableSpecification()),
    GROUP_COST_SPECIFICATION("F", "0", CostPriceSourceTypeEnum.getGroupCostSpecification()),
    GET_COST_SPECIFICATION("G", "0", CostPriceSourceTypeEnum.getCostSpecification()),
    CALCULATE_COST_SPECIFICATION("H", "0", CostPriceSourceTypeEnum.getCalculateCostSpecification()),
    FEE_TEMP_SPECIFICATION("I", "1", CostPriceSourceTypeEnum.getFeeTempSpecification()),
    FEE_SHARE_SPECIFICATION("J", "1", CostPriceSourceTypeEnum.getFeeShareSpecification()),
    STAND_COST_SPECIFICATION("K", "1", CostPriceSourceTypeEnum.getStandCostSpecification());

    private String value;
    private String designated;
    private String desc;

    private static String getDocumentSpecification() {
        return ResManager.loadKDString((String)"\u5355\u636e\u6307\u5b9a", (String)"CostPriceSourceTypeEnum_0", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getCalculateInSpecification() {
        return ResManager.loadKDString((String)"\u5165\u5e93\u6c47\u603b\u6838\u7b97", (String)"CostPriceSourceTypeEnum_1", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getExpBillSpecification() {
        return ResManager.loadKDString((String)"\u5f02\u5e38\u6210\u672c\u5904\u7406", (String)"CostPriceSourceTypeEnum_2", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getPayableSpecification() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u53cd\u5199", (String)"CostPriceSourceTypeEnum_3", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getCostPayableSpecification() {
        return ResManager.loadKDString((String)"\u6210\u672c\u53cd\u5199", (String)"CostPriceSourceTypeEnum_4", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getGroupCostSpecification() {
        return ResManager.loadKDString((String)"\u6210\u7ec4\u6210\u672c", (String)"CostPriceSourceTypeEnum_5", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getCostSpecification() {
        return ResManager.loadKDString((String)"\u53d6\u4ef7\u6210\u672c", (String)"CostPriceSourceTypeEnum_6", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getCalculateCostSpecification() {
        return ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u672c", (String)"CostPriceSourceTypeEnum_7", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getFeeTempSpecification() {
        return ResManager.loadKDString((String)"\u8d39\u7528\u6682\u4f30", (String)"CostPriceSourceTypeEnum_8", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getFeeShareSpecification() {
        return ResManager.loadKDString((String)"\u8d39\u7528\u5206\u644a", (String)"CostPriceSourceTypeEnum_9", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    private static String getStandCostSpecification() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u53d6\u6807\u51c6\u6210\u672c", (String)"CostPriceSourceTypeEnum_10", (String)"fi-calx-algox", (Object[])new Object[0]);
    }

    public String getDesignated() {
        return this.designated;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private CostPriceSourceTypeEnum(String value, String designated, String desc) {
        this.value = value;
        this.designated = designated;
        this.desc = desc;
    }

    public static CostPriceSourceTypeEnum getEnumByValue(String value) {
        for (CostPriceSourceTypeEnum type : CostPriceSourceTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return null;
    }

    public static String getCostPriceSourceValue(String oldCostPriceSource, String newValue) {
        String newCostPriceSource = null;
        if (StringUtils.isEmpty((CharSequence)oldCostPriceSource)) {
            newCostPriceSource = newValue;
        } else {
            ArrayList<String> costPriceSourceList = new ArrayList<String>();
            String[] oldCostPriceSources = oldCostPriceSource.split(",");
            if (oldCostPriceSources != null) {
                for (String oldCostPriceSourcestr : oldCostPriceSources) {
                    if (StringUtils.isEmpty((CharSequence)oldCostPriceSourcestr)) continue;
                    costPriceSourceList.add(oldCostPriceSourcestr);
                }
            }
            if (costPriceSourceList.isEmpty()) {
                newCostPriceSource = newValue;
            } else {
                StringBuilder pricesourcesb = new StringBuilder();
                for (int i = 0; i < costPriceSourceList.size(); ++i) {
                    String priceSource = (String)costPriceSourceList.get(i);
                    if (newValue.equals(priceSource)) continue;
                    pricesourcesb.append(priceSource);
                    pricesourcesb.append(",");
                }
                pricesourcesb.append(newValue);
                newCostPriceSource = pricesourcesb.toString();
            }
        }
        newCostPriceSource = "," + newCostPriceSource + ",";
        return newCostPriceSource;
    }

    public static String getDeleteCostPriceSourceValue(String oldCostPriceSource, String delete) {
        String newCostPriceSource = null;
        if (StringUtils.isEmpty((CharSequence)oldCostPriceSource)) {
            return newCostPriceSource;
        }
        ArrayList<String> costPriceSourceList = new ArrayList<String>();
        String[] oldCostPriceSources = oldCostPriceSource.split(",");
        if (oldCostPriceSources != null) {
            for (String oldCostPriceSourcestr : oldCostPriceSources) {
                if (StringUtils.isEmpty((CharSequence)oldCostPriceSourcestr)) continue;
                costPriceSourceList.add(oldCostPriceSourcestr);
            }
        }
        if (costPriceSourceList.isEmpty()) {
            return newCostPriceSource;
        }
        StringBuilder pricesourcesb = new StringBuilder();
        for (int i = 0; i < costPriceSourceList.size(); ++i) {
            String priceSource = (String)costPriceSourceList.get(i);
            if (delete.equals(priceSource)) continue;
            pricesourcesb.append(priceSource);
            pricesourcesb.append(",");
        }
        if (pricesourcesb.length() > 0) {
            newCostPriceSource = pricesourcesb.substring(0, pricesourcesb.length() - 1);
        }
        newCostPriceSource = "," + newCostPriceSource + ",";
        return newCostPriceSource;
    }

    public static String getDesignatedByCostPriceSource(String oldCostPriceSource) {
        String designated = "0";
        if (StringUtils.isEmpty((CharSequence)oldCostPriceSource)) {
            return designated;
        }
        ArrayList<String> costPriceSourceList = new ArrayList<String>();
        String[] oldCostPriceSources = oldCostPriceSource.split(",");
        if (oldCostPriceSources != null) {
            for (String oldCostPriceSourcestr : oldCostPriceSources) {
                if (StringUtils.isEmpty((CharSequence)oldCostPriceSourcestr)) continue;
                costPriceSourceList.add(oldCostPriceSourcestr);
            }
        }
        if (costPriceSourceList.isEmpty()) {
            return designated;
        }
        for (int i = 0; i < costPriceSourceList.size(); ++i) {
            String priceSource = (String)costPriceSourceList.get(i);
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue(priceSource);
            if (costPriceSourceTypeEnum == null) continue;
            designated = costPriceSourceTypeEnum.getDesignated();
        }
        return designated;
    }

    public static String getCostpriceSourceSql() {
        return " update t_cal_calcostrecordentry set fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
    }

    public static String getLastByCostPriceSource(String oldCostPriceSource) {
        if (StringUtils.isEmpty((CharSequence)oldCostPriceSource)) {
            return null;
        }
        ArrayList<String> costPriceSourceList = new ArrayList<String>();
        String[] oldCostPriceSources = oldCostPriceSource.split(",");
        if (oldCostPriceSources != null) {
            for (String oldCostPriceSourcestr : oldCostPriceSources) {
                if (StringUtils.isEmpty((CharSequence)oldCostPriceSourcestr)) continue;
                costPriceSourceList.add(oldCostPriceSourcestr);
            }
        }
        if (costPriceSourceList.isEmpty()) {
            return null;
        }
        return (String)costPriceSourceList.get(costPriceSourceList.size() - 1);
    }

    public static String getAllNameByCostPriceSources(String oldCostPriceSource) {
        if (StringUtils.isEmpty((CharSequence)oldCostPriceSource)) {
            return null;
        }
        ArrayList<String> costPriceSourceList = new ArrayList<String>();
        String[] oldCostPriceSources = oldCostPriceSource.split(",");
        if (oldCostPriceSources != null) {
            for (String oldCostPriceSourcestr : oldCostPriceSources) {
                if (StringUtils.isEmpty((CharSequence)oldCostPriceSourcestr)) continue;
                costPriceSourceList.add(oldCostPriceSourcestr);
            }
        }
        if (costPriceSourceList.isEmpty()) {
            return null;
        }
        StringBuilder nameSb = new StringBuilder();
        for (int i = 0; i < costPriceSourceList.size(); ++i) {
            String priceSource = (String)costPriceSourceList.get(i);
            CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue(priceSource);
            if (costPriceSourceTypeEnum == null) continue;
            nameSb.append(costPriceSourceTypeEnum.getDesc());
            nameSb.append(",");
        }
        if (nameSb.length() > 0) {
            String str = nameSb.substring(0, nameSb.length() - 1);
            return str;
        }
        return null;
    }

    public static void setDescribeByCostpricesource(LocalRow row, boolean coverdesigoutcost, CalOutRptHolder holder, int index, String exDescription) {
        String costpricesource = row.getCostpricesource();
        String costpriceSourceType = row.getCostpriceSourceType();
        if (StringUtils.isNotEmpty((CharSequence)costpriceSourceType)) {
            String designated = CostPriceSourceTypeEnum.getDesignatedByCostPriceSource(costpriceSourceType);
            row.setDesignatedcost(false);
            if ("1".equals(designated)) {
                row.setDesignatedcost(true);
            }
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, costpriceSourceType);
            row.setCostpricesource(costpricesource);
        }
        boolean updateEntry = false;
        boolean designatedcost = row.isDesignatedcost();
        String calbilltype = row.getCalbilltype();
        String oldcostpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource(costpricesource);
        if (!(designatedcost && (!coverdesigoutcost || !designatedcost) || !"OUT".equals(calbilltype) || row.isInvTxZeroCost() || row.isCostDetermined() || GROUP_COST_SPECIFICATION.getValue().equals(costpriceSourceType) || GROUP_COST_SPECIFICATION.getValue().equals(oldcostpricesource) || GET_COST_SPECIFICATION.getValue().equals(costpriceSourceType) || GET_COST_SPECIFICATION.getValue().equals(oldcostpricesource) || !StringUtils.isEmpty((CharSequence)exDescription))) {
            updateEntry = true;
        }
        holder.getUpdateCostPriceMap().put(index, updateEntry);
        if (updateEntry) {
            row.setCostpriceSourceType(CALCULATE_COST_SPECIFICATION.getValue());
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, CALCULATE_COST_SPECIFICATION.getValue());
            String costPriceSourceStr = CostPriceSourceTypeEnum.getAllNameByCostPriceSources(costpricesource);
            if (StringUtils.isNotEmpty((CharSequence)costPriceSourceStr)) {
                row.setCostpricesource(costpricesource);
                holder.setDescribe(index, costPriceSourceStr);
            }
        } else {
            costpricesource = row.getCostpricesource();
            String costPriceSourceStr = CostPriceSourceTypeEnum.getAllNameByCostPriceSources(costpricesource);
            if (StringUtils.isNotEmpty((CharSequence)costPriceSourceStr)) {
                holder.setDescribe(index, costPriceSourceStr);
            }
        }
    }

    public static String getCostAdjuestInvbillNum(CostAdjustInfo adjustInfo) {
        DynamicObject costAdjustBill = adjustInfo.getCostAdjustBill();
        String invbillnum = null;
        if (costAdjustBill != null) {
            DynamicObjectCollection costAdjustBillEntrys = costAdjustBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject costAdjustBillEntry : costAdjustBillEntrys) {
                Long entryId = costAdjustBillEntry.getLong("id");
                Long adjustEntryId = adjustInfo.getCostAdjustEntryId();
                if (entryId == null || adjustEntryId == null || entryId.longValue() != adjustEntryId.longValue()) continue;
                invbillnum = costAdjustBillEntry.getString("invbillnum");
                break;
            }
        }
        return invbillnum;
    }
}

