/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.calx.algox.util.JsonUtils;

public class DeleteStdCostDiffBillTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DeleteStdCostDiffBillTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("taskID:" + this.taskId + "_DeleteStdCostDiffBillTask begin");
        Long taskParamId = JsonUtils.jsonToObj(map.get("paramid").toString(), Long.class);
        DynamicObject[] params = BusinessDataServiceHelper.load((String)"cal_taskparam", (String)"param_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskParamId)});
        List billIds = (List)SerializationUtils.fromJsonString((String)params[0].getString("param_tag"), List.class);
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])billIds.toArray(), (OperateOption)option);
        List idList = operResult.getSuccessPkIds();
        if (idList != null && !idList.isEmpty()) {
            QFilter deleFilter = new QFilter("id", "in", (Object)idList);
            DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
        } else {
            ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
            String voucherError = ResManager.loadKDString((String)"\u5355\u636e\u4e0b\u5df2\u6709\u751f\u6210\u51ed\u8bc1\u7684\u5408\u5e76\u5355\u3002", (String)"CalDiffBill4VoucherValidator_0", (String)"fi-cal-opplugin", (Object[])new Object[0]);
            Boolean isIgnore = Boolean.FALSE;
            for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                if (operatorInfo.getMessage().contains(voucherError)) {
                    isIgnore = Boolean.TRUE;
                }
                errors.add(operatorInfo.getMessage());
            }
            errors.add(operResult.getMessage());
            if (!isIgnore.booleanValue()) {
                throw new KDException(((Object)errors).toString());
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("--------------DeleteStdCostDiffBillTask->delete lot adjBillList size:" + billIds.size());
        logger.info("--------------DeleteStdCostDiffBillTask->delete lot adjBillList time:" + (endTime - beginTime));
        logger.info("DeleteStdCostDiffBillTask end");
    }
}

