/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.GroupBillInfo;
import kd.fi.calx.algox.diff.function.DealAlgoNoUpdateCalFields;
import kd.fi.calx.algox.diff.function.FilterDataSetFunction;
import kd.fi.calx.algox.diff.function.FilterNoAllocEntryIdsFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.BizGroupRecordHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalLogHelper;
import kd.fi.calx.algox.helper.JsonEntryServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import org.apache.commons.lang.StringUtils;

public class DiffAllocDataFactory {
    private static final Log logger = LogFactory.getLog(DiffAllocDataFactory.class);
    private static final String ALGOKEY = "kd.fi.calx.algox.diff.DiffAllocDataFactory";
    private DiffAllocParamter allocParam;
    private DiffAllocParamterEntry allocParamEntry;
    private RowMeta balanceDataMeta;
    private RowMeta costRecordDataMeta;
    private RowMeta costAdjDataMeta;
    private RowMeta stdCostBalaDataMeta;
    private RowMeta bizDataMeta;
    private RowMeta gbizDataMeta;
    private RowMeta groupDataMeta;
    protected Boolean isBizGroup = AcctGroupModelHelper.isBizGroupModel();
    private BizGroupRecordHelper bizGroupRecordHelper = null;
    private static String[] entryDiffField = new String[]{"diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y"};
    private static String[] subEntryDiffField = new String[]{"ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y"};
    private static final Set<String> billTypes = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("im_adjustbill");
            this.add("im_assembbill");
            this.add("im_disassemblebill");
            this.add("im_mdc_omproorder");
            this.add("im_mdc_omreturnorder");
        }
    };

    public void closeBizGroup() {
        if (this.bizGroupRecordHelper != null) {
            this.bizGroupRecordHelper.close();
        }
    }

    public DiffAllocDataFactory(DiffAllocParamter param, DiffAllocParamterEntry allocParamEntry) {
        this.allocParam = param;
        this.allocParamEntry = allocParamEntry;
        this.buildBalanceRowMeta();
        this.buildCostRecordRowMeta();
        this.buildCostAdjRowMeta();
        this.buildStdCostBalaRowMeta();
        this.buildBizRowMeta();
        this.buildBizGroupRowMeta();
        this.buildGroupDataRowMeta();
    }

    public Input[] getOutBillQtyByOrmInput() {
        if (!this.allocParam.isAllocByCostSys() && CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFF_CHECK_MATTRAN_BYCAL).booleanValue()) {
            this.checkIsHashMatTrans();
        }
        if (this.allocParam.isParallel()) {
            return this.getOutBillQtyByOrmInputByTask();
        }
        return this.getOutBillQtyByOrmInputByNomal();
    }

    private Input[] getOutBillQtyByOrmInputByNomal() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("entry.queuetype", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.id", "not in", this.allocParam.getCrossRecordEntryIds());
        inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizFieldByOrmInput(this.allocParamEntry), filter.toArray(), this.bizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private Input[] getOutBillQtyByOrmInputByTask() {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("entry.queuetype", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.id", "not in", this.allocParam.getCrossRecordEntryIds());
        int batch = CalDbParamServiceHelper.getInteger(CalDbParamConstant.DIFFALLOC_QUERYBATCH);
        int batchSize = this.allocParamEntry.getMatIdSet().size() / batch + batch;
        HashSet<Object> matIds = new HashSet<Object>(batchSize);
        for (Object matId : this.allocParamEntry.getMatIdSet()) {
            matIds.add(matId);
            if (matIds.size() < batchSize) continue;
            QFilter matFilter = new QFilter("entry.material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizFieldByOrmInput(this.allocParamEntry), new QFilter[]{filter, matFilter}, this.bizDataMeta));
            matIds = new HashSet(batchSize);
        }
        if (matIds.size() > 0) {
            QFilter matFilter = new QFilter("entry.material.id", "in", matIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getCostRecordBizFieldByOrmInput(this.allocParamEntry), new QFilter[]{filter, matFilter}, this.bizDataMeta));
        }
        return inputList.toArray(new Input[inputList.size()]);
    }

    protected DataSet getBizGroupDS() {
        if (this.bizGroupRecordHelper == null) {
            String selectFields = "groupid,iscompleted,type,bizbillid,costrecordentryid,weight,material,occupiedqty,0.0 as totalweight,calentryid,period";
            this.bizGroupRecordHelper = new BizGroupRecordHelper(this.allocParam, selectFields);
        }
        DataSet groupBillRecordDS = this.bizGroupRecordHelper.getGroupBillRecordDS();
        return groupBillRecordDS;
    }

    public Input[] getSrcGroupDataSet() {
        if (this.isBizGroup.booleanValue()) {
            DataSet groupDataSet = this.getBizGroupDS();
            groupDataSet = groupDataSet.select("groupid as bizgrouprecordid,costrecordentryid as calRecordEntryid,iscompleted,occupiedqty,type,weight,totalweight");
            return new Input[]{new DataSetInput(groupDataSet)};
        }
        ArrayList<Object> inputList = new ArrayList<Object>();
        Algo algo = Algo.create((String)ALGOKEY);
        QFilter acctGrpRecordFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
        acctGrpRecordFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.allocParamEntry));
        DataSet groupData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])acctGrpRecordFilter.toArray(), null);
        HashSet<Long> groupIds = new HashSet<Long>(10);
        for (Row row : groupData) {
            groupIds.add(row.getLong("id"));
            if (groupIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
            QFilter filter = new QFilter("id", "in", groupIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_account_grouprecord", "TO_CHAR(bizgrouprecordid) as bizgrouprecordid,entryentity.costrecordentryid as calRecordEntryid,iscompleted,entryentity.occupiedqty as occupiedqty,entryentity.type as type,entryentity.weight as weight,0.0 as totalweight", filter.toArray(), this.groupDataMeta));
            groupIds = new HashSet(10);
        }
        if (groupIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", groupIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_account_grouprecord", "TO_CHAR(bizgrouprecordid) as bizgrouprecordid,entryentity.costrecordentryid as calRecordEntryid,iscompleted,entryentity.occupiedqty as occupiedqty,entryentity.type as type,entryentity.weight as weight,0.0 as totalweight", filter.toArray(), this.groupDataMeta));
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(), this.groupDataMeta);
        inputList.add(new DataSetInput(emptySet, this.groupDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] getGroupBillDataSet() {
        ArrayList<Object> inputList = new ArrayList<Object>();
        Algo algo = Algo.create((String)ALGOKEY);
        HashSet<Long> costRecordEntryIds = new HashSet<Long>(1000);
        if (this.isBizGroup.booleanValue()) {
            DataSet groupDataSet = this.getBizGroupDS().select("costrecordentryid").distinct();
            for (Row row : groupDataSet) {
                costRecordEntryIds.add(row.getLong("costrecordentryid"));
            }
        } else {
            QFilter acctGrpRecordFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
            acctGrpRecordFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.allocParamEntry));
            DataSet groupData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])acctGrpRecordFilter.toArray(), null);
            HashSet groupIds = new HashSet<Long>(100);
            for (Row row : groupData) {
                groupIds.add(row.getLong("id"));
                if (groupIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter filter = new QFilter("id", "in", groupIds);
                filter.and("entryentity.type", "=", (Object)"1");
                DataSet groupMatData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"entryentity.costrecordentryid as costrecordentryid", (QFilter[])filter.toArray(), null);
                for (Row groupRow : groupMatData) {
                    Long costrecordEntryId = groupRow.getLong("costrecordentryid");
                    if (this.allocParam.getCrossRecordEntryIds().contains(costrecordEntryId)) continue;
                    costRecordEntryIds.add(costrecordEntryId);
                }
                groupIds = new HashSet(10);
            }
            if (groupIds.size() > 0) {
                QFilter filter = new QFilter("id", "in", groupIds);
                filter.and("entryentity.type", "=", (Object)"1");
                DataSet groupMatData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"entryentity.costrecordentryid as costrecordentryid", (QFilter[])filter.toArray(), null);
                for (Row groupRow : groupMatData) {
                    Long costrecordEntryId = groupRow.getLong("costrecordentryid");
                    if (this.allocParam.getCrossRecordEntryIds().contains(costrecordEntryId)) continue;
                    costRecordEntryIds.add(costrecordEntryId);
                }
            }
        }
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("entry.queuetype", "=", (Object)"0");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        if (costRecordEntryIds.size() < CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) {
            QFilter entryIdFilter = new QFilter("entry.id", "in", costRecordEntryIds);
            inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getGroupCostRecordBizField(this.allocParamEntry), new QFilter[]{filter, entryIdFilter}, this.gbizDataMeta));
        } else {
            HashSet<Long> tempCostRecordEntryIds = new HashSet<Long>(16);
            for (Long id : costRecordEntryIds) {
                tempCostRecordEntryIds.add(id);
                if (tempCostRecordEntryIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter entryIdFilter = new QFilter("entry.id", "in", tempCostRecordEntryIds);
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getGroupCostRecordBizField(this.allocParamEntry), new QFilter[]{filter, entryIdFilter}, this.gbizDataMeta));
                tempCostRecordEntryIds = new HashSet(10);
            }
            if (tempCostRecordEntryIds.size() > 0) {
                QFilter entryIdFilter = new QFilter("entry.id", "in", tempCostRecordEntryIds);
                inputList.add(new OrmInput(ALGOKEY, "cal_costrecord_subentity", this.getGroupCostRecordBizField(this.allocParamEntry), new QFilter[]{filter, entryIdFilter}, this.gbizDataMeta));
            }
        }
        DataSet emptySet = algo.createDataSet(new ArrayList(), this.gbizDataMeta);
        inputList.add(new DataSetInput(emptySet, this.gbizDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] getBalQtyIsZero(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffallocDims.contains("material")) {
            diffallocDims = diffallocDims + ",material";
        }
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffallocDims, "");
        String selectStr = "id,material.id as materialid," + dySelectStr + ",costelement as costelement,costsubelement as costsubelement,baseqty_bal as qty";
        List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(entry.getCostAccountId(), entry.getPeriodId(), "<=");
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        DataSet stdCostBalanceData = null;
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">", (Object)entry.getPeriod());
            filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
            filter.and(this.getMatFilter("material.id", this.allocParam, entry));
            filter.and("costsubelement.id", "=", (Object)773175233367685120L);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
            if (stdCostBalanceData == null) {
                stdCostBalanceData = dataSet;
                continue;
            }
            stdCostBalanceData = stdCostBalanceData.union(dataSet);
        }
        if (stdCostBalanceData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u671f\u521d\u6570\u636e", (String)"DiffAllocDataFactory_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        StringBuilder selectfields = new StringBuilder();
        selectfields.append(diffallocDims);
        selectfields.append(",qty");
        DataSet allDataSet = stdCostBalanceData.select(selectfields.toString());
        allDataSet = allDataSet.groupBy(diffallocDims.split(",")).sum("qty").finish().filter("qty == 0");
        for (Row row : allDataSet.copy()) {
            matIds.add(row.getLong("material"));
        }
        CalLogHelper.printLog("kd.fi.calx.algox.diff.DiffAllocDataFactory.getBalQtyIsZero:", allDataSet);
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        inputList.add(new DataSetInput(allDataSet, allDataSet.getRowMeta()));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public Input[] getTotalDiffData(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffallocDims.contains("material")) {
            diffallocDims = diffallocDims + ",material";
        }
        DataSet stdCostBalanceData = null;
        List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(entry.getCostAccountId(), entry.getPeriodId(), "<");
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)entry.getPeriod());
            filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
            filter.and("material.id", "in", matIds);
            if (stdCostBalanceData == null) {
                stdCostBalanceData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_standcost_bal", (String)this.getAllDiffFieldByNewBalance(entry), (QFilter[])filter.toArray(), (String)null);
                continue;
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_standcost_bal", (String)this.getAllDiffFieldByNewBalance(entry), (QFilter[])filter.toArray(), (String)null);
            stdCostBalanceData = stdCostBalanceData.union(dataSet);
        }
        if (stdCostBalanceData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u671f\u521d\u6570\u636e", (String)"DiffAllocDataFactory_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DataSet inputDiffDataSet = this.getInputDiffData(entry, matIds);
        DataSet totalDiffData = null;
        if (stdCostBalanceData != null) {
            stdCostBalanceData = stdCostBalanceData.select(inputDiffDataSet.getRowMeta().getFieldNames());
            totalDiffData = inputDiffDataSet.union(stdCostBalanceData);
        } else {
            totalDiffData = inputDiffDataSet;
        }
        String groupfields = diffallocDims + ",costelement,costsubelement";
        GroupbyDataSet groupbyDataSet = totalDiffData.groupBy(groupfields.split(","));
        groupbyDataSet.sum("ddiff_g");
        groupbyDataSet.sum("ddiff_h");
        groupbyDataSet.sum("ddiff_k");
        groupbyDataSet.sum("ddiff_m");
        groupbyDataSet.sum("ddiff_p");
        groupbyDataSet.sum("ddiff_q");
        groupbyDataSet.sum("ddiff_r");
        groupbyDataSet.sum("ddiff_s");
        groupbyDataSet.sum("ddiff_t");
        groupbyDataSet.sum("ddiff_c");
        groupbyDataSet.sum("ddiff_w");
        groupbyDataSet.sum("ddiff_x");
        groupbyDataSet.sum("ddiff_y");
        groupbyDataSet.sum("ddiff");
        stdCostBalanceData = groupbyDataSet.finish();
        QFilter balfilter = new QFilter("period", "<=", (Object)entry.getPeriod());
        balfilter.and("endperiod", ">", (Object)entry.getPeriod());
        balfilter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
        balfilter.and(this.getMatFilter("material.id", this.allocParam, entry));
        balfilter.and("costsubelement.id", "=", (Object)773175233367685120L);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffallocDims, "");
        String selectStr = dySelectStr + ",baseqty_bal as balqty";
        DataSet balQtyData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectStr, (QFilter[])balfilter.toArray(), (String)null);
        GroupbyDataSet groupbyBalDataSet = balQtyData.groupBy(diffallocDims.split(","));
        groupbyBalDataSet.sum("balqty");
        balQtyData = groupbyBalDataSet.finish();
        JoinDataSet joinAllDataSet = stdCostBalanceData.leftJoin(balQtyData);
        for (String field : diffallocDims.split(",")) {
            joinAllDataSet.on(field, field);
        }
        stdCostBalanceData = joinAllDataSet.select(stdCostBalanceData.getRowMeta().getFieldNames(), new String[]{"balqty"}).finish();
        CalLogHelper.printLog("kd.fi.calx.algox.diff.DiffAllocDataFactory.getTotalDiffData:", stdCostBalanceData);
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        inputList.add(new DataSetInput(stdCostBalanceData, stdCostBalanceData.getRowMeta()));
        return inputList.toArray(new Input[inputList.size()]);
    }

    public DataSet getInputDiffData(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)entry.getStartDate());
        filter.and("bookdate", "<=", (Object)entry.getEndDate());
        filter.and("period", "=", (Object)entry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and(new QFilter("entryentity.queuetype", "=", (Object)"0"));
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and("entryentity.material.id", "in", matIds);
        filter.and("isupdatecost", "=", (Object)true);
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffallocDims, "");
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g as ddiff_g,entryentity.subentryentity.ddiff_h as ddiff_h,entryentity.subentryentity.ddiff_k as ddiff_k,entryentity.subentryentity.ddiff_p as ddiff_p,entryentity.subentryentity.ddiff_q as ddiff_q,entryentity.subentryentity.ddiff_r as ddiff_r,entryentity.subentryentity.ddiff_m as ddiff_m,entryentity.subentryentity.ddiff_s as ddiff_s,entryentity.subentryentity.ddiff_t as ddiff_t,entryentity.subentryentity.ddiff_w as ddiff_w,entryentity.subentryentity.ddiff_x as ddiff_x,entryentity.subentryentity.ddiff_y as ddiff_y,entryentity.subentryentity.ddiff_c as ddiff_c,entryentity.subentryentity.sub_adjustamt as sub_adjustamt,entryentity.signnum as signnum,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet(ALGOKEY, "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        String selectFields = diffallocDims + ",costelement,costsubelement,ddiff_g*signnum as ddiff_g,ddiff_h*signnum as ddiff_h,ddiff_k*signnum as ddiff_k,ddiff_p*signnum as ddiff_p,ddiff_q*signnum as ddiff_q,ddiff_r*signnum as ddiff_r,ddiff_m*signnum as ddiff_m,ddiff_s*signnum as ddiff_s,ddiff_t*signnum as ddiff_t,ddiff_w*signnum as ddiff_w,ddiff_x*signnum as ddiff_x,ddiff_y*signnum as ddiff_y,ddiff_c*signnum as ddiff_c,sub_adjustamt*signnum as ddiff,noupdatecalfields";
        allDataSet = allDataSet.select(selectFields);
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        String groupFields = diffallocDims + ",costelement,costsubelement";
        GroupbyDataSet groupAllDataSet = allDataSet.groupBy(groupFields.split(","));
        groupAllDataSet.sum("ddiff_g");
        groupAllDataSet.sum("ddiff_h");
        groupAllDataSet.sum("ddiff_k");
        groupAllDataSet.sum("ddiff_p");
        groupAllDataSet.sum("ddiff_q");
        groupAllDataSet.sum("ddiff_r");
        groupAllDataSet.sum("ddiff_m");
        groupAllDataSet.sum("ddiff_s");
        groupAllDataSet.sum("ddiff_t");
        groupAllDataSet.sum("ddiff_w");
        groupAllDataSet.sum("ddiff_x");
        groupAllDataSet.sum("ddiff_y");
        groupAllDataSet.sum("ddiff_c");
        groupAllDataSet.sum("ddiff");
        return groupAllDataSet.finish();
    }

    public Input[] getOutputDiffData(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffallocDims.contains("material")) {
            diffallocDims = diffallocDims + ",material";
        }
        QFilter filter = new QFilter("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)entry.getStartDate());
        filter.and("bookdate", "<=", (Object)entry.getEndDate());
        filter.and("period", "=", (Object)entry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.queuetype", "=", (Object)"1");
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and("entryentity.material.id", "in", matIds);
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "!=", (Object)"G");
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffallocDims, "");
        String jsonSelectFields = dySelectFields + ",bizdate as bizdate,entryentity.invbillentryid as invbillentryid,entryentity.id as entryid,createtype as createtype,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g as ddiff_g,entryentity.subentryentity.ddiff_h as ddiff_h,entryentity.subentryentity.ddiff_k as ddiff_k,entryentity.subentryentity.ddiff_p as ddiff_p,entryentity.subentryentity.ddiff_q as ddiff_q,entryentity.subentryentity.ddiff_r as ddiff_r,entryentity.subentryentity.ddiff_m as ddiff_m,entryentity.subentryentity.ddiff_s as ddiff_s,entryentity.subentryentity.ddiff_t as ddiff_t,entryentity.subentryentity.ddiff_w as ddiff_w,entryentity.subentryentity.ddiff_x as ddiff_x,entryentity.subentryentity.ddiff_y as ddiff_y,entryentity.subentryentity.ddiff_c as ddiff_c,entryentity.subentryentity.sub_adjustamt as sub_adjustamt,entryentity.diff_g as diff_g,entryentity.diff_h as diff_h,entryentity.diff_k as diff_k,entryentity.diff_p as diff_p,entryentity.diff_q as diff_q,entryentity.diff_r as diff_r,entryentity.diff_m as diff_m,entryentity.diff_s as diff_s,entryentity.diff_t as diff_t,entryentity.diff_w as diff_w,entryentity.diff_x as diff_x,entryentity.diff_y as diff_y,entryentity.diff_c as diff_c,entryentity.adjustamt as adjustamt,entryentity.signnum as signnum,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet(ALGOKEY, "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        String selectFields = diffallocDims + ",bizdate,invbillentryid,entryid,createtype,costelement,costsubelement,ddiff_g*signnum as outddiff_g,ddiff_h*signnum as outddiff_h,ddiff_k*signnum as outddiff_k,ddiff_p*signnum as outddiff_p,ddiff_q*signnum as outddiff_q,ddiff_r*signnum as outddiff_r,ddiff_m*signnum as outddiff_m,ddiff_s*signnum as outddiff_s,ddiff_t*signnum as outddiff_t,ddiff_w*signnum as outddiff_w,ddiff_x*signnum as outddiff_x,ddiff_y*signnum as outddiff_y,ddiff_c*signnum as outddiff_c,sub_adjustamt*signnum as outddiff,diff_g*signnum as outdiff_g,diff_h*signnum as outdiff_h,diff_k*signnum as outdiff_k,diff_p*signnum as outdiff_p,diff_q*signnum as outdiff_q,diff_r*signnum as outdiff_r,diff_m*signnum as outdiff_m,diff_s*signnum as outdiff_s,diff_t*signnum as outdiff_t,diff_w*signnum as outdiff_w,diff_x*signnum as outdiff_x,diff_y*signnum as outdiff_y,diff_c*signnum as outdiff_c,adjustamt*signnum as outdiff,noupdatecalfields";
        allDataSet = allDataSet.select(selectFields);
        DataSet jsonData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_stdcostdiffbill", (String)"entryentity.id as entryid,entryentity.subentryentity_json as subentryentity", (QFilter[])filter.toArray(), null);
        allDataSet = allDataSet.leftJoin(jsonData).on("entryid", "entryid").select(allDataSet.getRowMeta().getFieldNames(), new String[]{"subentryentity"}).finish();
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        QFilter acctGrpRecordFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
        acctGrpRecordFilter.and("entryentity.material.id", "in", matIds);
        DataSet groupData = null;
        if (this.isBizGroup.booleanValue()) {
            groupData = this.getBizGroupDS();
            groupData = groupData.select("costrecordentryid as gcostrecordentryid");
        } else {
            groupData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"entryentity.costrecordentryid as gcostrecordentryid", (QFilter[])acctGrpRecordFilter.toArray(), null);
        }
        groupData = groupData.distinct();
        allDataSet = allDataSet.leftJoin(groupData).on("invbillentryid", "gcostrecordentryid").select(allDataSet.getRowMeta().getFieldNames(), new String[]{"gcostrecordentryid"}).finish();
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        inputList.add(new DataSetInput(allDataSet, allDataSet.getRowMeta()));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private Set<Long> getNOOverCalRgBills(Set<GroupBillInfo> outBillGroupInfos, Map<String, List<GroupBillInfo>> inBillGroupInfos) {
        HashSet<Long> result = new HashSet<Long>(16);
        result.add(0L);
        for (GroupBillInfo outGroupBillInfo : outBillGroupInfos) {
            List<GroupBillInfo> inGroupBillInfos = inBillGroupInfos.get(outGroupBillInfo.getGroupId());
            if (inGroupBillInfos == null) continue;
            boolean isOver = true;
            for (GroupBillInfo inGroupBillInfo : inGroupBillInfos) {
                if ((outGroupBillInfo.isEmpt() || outGroupBillInfo.getCalRangeId().compareTo(inGroupBillInfo.getCalRangeId()) == 0) && outGroupBillInfo.getCaldimensionVal().equals(inGroupBillInfo.getCaldimensionVal()) && (!"im_adjustbill".equals(outGroupBillInfo.getBillType()) && !"im_locationtransfer".equals(outGroupBillInfo.getBillType()) || outGroupBillInfo.getMatId().compareTo(inGroupBillInfo.getMatId()) == 0)) continue;
                isOver = false;
                break;
            }
            if (!isOver) continue;
            result.add(outGroupBillInfo.getEntryId());
        }
        return result;
    }

    private String getDivideBasisVal(Row row, String[] divideBasis) {
        StringBuilder divideBasisVal = new StringBuilder();
        String[] var7 = divideBasis;
        int var6 = divideBasis.length;
        for (int var5 = 0; var5 < var6; ++var5) {
            String field = var7[var5];
            divideBasisVal.append(row.get(field));
            divideBasisVal.append("+");
        }
        if (divideBasisVal.length() > 0) {
            divideBasisVal.deleteCharAt(divideBasisVal.length() - 1);
        }
        return divideBasisVal.toString();
    }

    private String getCaldimensionVal(Row row) {
        String caldimensions = row.getString("caldimension");
        if (caldimensions != null && caldimensions.length() >= 1) {
            String[] caldimensionsArray = caldimensions.split(",");
            StringBuilder caldimensionVal = new StringBuilder();
            String[] var8 = caldimensionsArray;
            int var7 = caldimensionsArray.length;
            for (int var6 = 0; var6 < var7; ++var6) {
                String field = var8[var6];
                caldimensionVal.append(row.get(field));
                caldimensionVal.append("+");
            }
            if (caldimensionVal.length() > 0) {
                caldimensionVal.deleteCharAt(caldimensionVal.length() - 1);
            }
            return caldimensionVal.toString();
        }
        return "";
    }

    private String getCostRecordBizField() {
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        return "id as costrecordid,bookdate as bizdate,auditdate,billno as costrecordbillno,entry.id as costrecordentryid,entry.seq as costrecordseq,billnumber as outbillno,bizbillid as outbillid,entry.id as outbillentryid,entry.seq as outbillseq,billtype as outbilltypeid,billtype.name as outbilltypename,bizentityobject.number as bizentityobject,costaccount as costaccountid,costaccount.calsystem as calsystemid,costaccount.calpolicy as calpolicyid,costaccount.costtype as costtypeid,costaccount.booktype as costaccounttypeid,entry.material as materialid,period as periodid,calorg,entry.owner as owner,storageorgunit,entry.warehouse as warehouse,entry.location as location,entry.project as project,entry.tracknumber as tracknumber,entry.configuredcode as configuredcode,entry.productline as productline,entry.noupdatecalfields as noupdatecalfields,entry.stocktype as stocktype,entry.assist as assist,entry.lot as lot,entry.mversion as mversion ,entry.calrange as calrangeid,entry.baseqty as baseqty,entry.standardcost as standardcost,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,adminorg,biztype,transtype,supplier,customer,entry.queuetype as queuetype,entry.signnum as signnum,entry.ecostcenter as ecostcenter" + exFieldHelper.getAllExFields("cal_costrecord_subentity");
    }

    private String getCostRecordNoRequestBizField() {
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        return "id as costrecordid,billno as costrecordbillno,entry.id as costrecordentryid,entry.seq as costrecordseq,billnumber as outbillno,bizbillid as outbillid,entry.id as outbillentryid,entry.seq as outbillseq,billtype as outbilltypeid,billtype.name as outbilltypename,bizentityobject.number as bizentityobject,costaccount as costaccountid,costaccount.calsystem as calsystemid,costaccount.calpolicy as calpolicyid,costaccount.costtype as costtypeid,costaccount.booktype as costaccounttypeid,entry.material as materialid,period as periodid,calorg,entry.owner as owner,storageorgunit,entry.warehouse as warehouse,entry.location as location,entry.assist as assist,entry.lot as lot,entry.mversion as mversion ,entry.calrange as calrangeid,entry.baseqty as baseqty,entry.standardcost as standardcost,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,adminorg,biztype,transtype,supplier,customer,entry.accounttype as accounttype,entry.ecostcenter as ecostcenter" + exFieldHelper.getAllExFields("cal_costrecord_subentity");
    }

    private void buildCostRecordRowMeta() {
        Field[] beginFields = new Field[]{new Field("costrecordid", (DataType)DataType.LongType), new Field("bizdate", (DataType)DataType.DateType), new Field("auditdate", (DataType)DataType.DateType), new Field("costrecordbillno", (DataType)DataType.StringType), new Field("costrecordentryid", (DataType)DataType.LongType), new Field("costrecordseq", (DataType)DataType.LongType), new Field("outbillno", (DataType)DataType.StringType), new Field("outbillid", (DataType)DataType.LongType), new Field("outbillentryid", (DataType)DataType.LongType), new Field("outbillseq", (DataType)DataType.LongType), new Field("outbilltypeid", (DataType)DataType.LongType), new Field("outbilltypename", (DataType)DataType.StringType), new Field("bizentityobject", (DataType)DataType.StringType), new Field("costaccountid", (DataType)DataType.LongType), new Field("calsystemid", (DataType)DataType.LongType), new Field("calpolicyid", (DataType)DataType.LongType), new Field("costtypeid", (DataType)DataType.LongType), new Field("costaccounttypeid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType)};
        Field[] dynamicFields = new Field[]{new Field("calorg", (DataType)DataType.LongType), new Field("owner", (DataType)DataType.LongType), new Field("storageorgunit", (DataType)DataType.LongType), new Field("warehouse", (DataType)DataType.LongType), new Field("location", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("productline", (DataType)DataType.LongType), new Field("noupdatecalfields", (DataType)DataType.StringType), new Field("stocktype", (DataType)DataType.LongType), new Field("assist", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("mversion", (DataType)DataType.LongType)};
        Field[] endFields = new Field[]{new Field("calrangeid", (DataType)DataType.LongType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("standardcost", (DataType)DataType.BigDecimalType), new Field("caldimensionid", (DataType)DataType.LongType), new Field("caldimension", (DataType)DataType.StringType), new Field("adminorg", (DataType)DataType.LongType), new Field("biztype", (DataType)DataType.LongType), new Field("transtype", (DataType)DataType.StringType), new Field("supplier", (DataType)DataType.LongType), new Field("customer", (DataType)DataType.LongType), new Field("queuetype", (DataType)DataType.StringType), new Field("signnum", (DataType)DataType.IntegerType), new Field("ecostcenter", (DataType)DataType.LongType)};
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        Field[] exFields = exFieldHelper.getAllExSimpleFields("cal_costrecord_subentity");
        String exFieldStrs = exFieldHelper.getExFieldNoCalSet("cal_costrecord_subentity");
        String[] exFieldArray = exFieldStrs.split(",");
        ArrayList<Field> exNewFields = new ArrayList<Field>(16);
        String[] var13 = exFieldArray;
        int var12 = exFieldArray.length;
        for (int var11 = 0; var11 < var12; ++var11) {
            String exField = var13[var11];
            Field[] var17 = exFields;
            int var16 = exFields.length;
            for (int var15 = 0; var15 < var16; ++var15) {
                Field field = var17[var15];
                if (!exField.equals(field.getName())) continue;
                exNewFields.add(new Field(exField, field.getDataType()));
            }
        }
        Field[] exNewField = exNewFields.toArray(new Field[0]);
        Field[] bizgropuFields = new Field[]{new Field("bizgrouprecordid", (DataType)DataType.StringType)};
        this.costRecordDataMeta = new RowMeta(this.concat(this.concat(this.concat(this.concat(beginFields, dynamicFields), endFields), exNewField), bizgropuFields));
        this.printLog("costRecordDataMeta:", this.costRecordDataMeta);
    }

    private void buildBalanceRowMeta() {
        Field[] beginFields = new Field[]{new Field("costaccountid", (DataType)DataType.LongType), new Field("calsystemid", (DataType)DataType.LongType), new Field("calpolicyid", (DataType)DataType.LongType), new Field("costtypeid", (DataType)DataType.LongType), new Field("costaccounttypeid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType)};
        Field[] dynamicFields = new Field[]{new Field("calorg", (DataType)DataType.LongType), new Field("owner", (DataType)DataType.LongType), new Field("storageorgunit", (DataType)DataType.LongType), new Field("warehouse", (DataType)DataType.LongType), new Field("location", (DataType)DataType.LongType), new Field("assist", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)};
        Field[] endFields = new Field[]{new Field("calrangeid", (DataType)DataType.LongType), new Field("beginqty", (DataType)DataType.BigDecimalType), new Field("beginamt", (DataType)DataType.BigDecimalType), new Field("periodinqty", (DataType)DataType.BigDecimalType), new Field("periodinstandardcost", (DataType)DataType.BigDecimalType), new Field("periodendqty", (DataType)DataType.BigDecimalType)};
        this.balanceDataMeta = new RowMeta(this.concat(this.concat(beginFields, dynamicFields), endFields));
        this.printLog("balanceDataMeta:", this.balanceDataMeta);
    }

    private void buildCostAdjRowMeta() {
        Field[] beginFields = new Field[]{new Field("difftype", (DataType)DataType.StringType), new Field("costaccount", (DataType)DataType.LongType), new Field("calsystemid", (DataType)DataType.LongType), new Field("calpolicyid", (DataType)DataType.LongType), new Field("amtprecision", (DataType)DataType.IntegerType), new Field("costtypeid", (DataType)DataType.LongType), new Field("costaccounttypeid", (DataType)DataType.LongType), new Field("dividebasis", (DataType)DataType.StringType), new Field("material", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType), new Field("enddate", (DataType)DataType.DateType)};
        Field[] dynamicFields = new Field[]{new Field("calorg", (DataType)DataType.LongType), new Field("owner", (DataType)DataType.LongType), new Field("storageorgunit", (DataType)DataType.LongType), new Field("warehouse", (DataType)DataType.LongType), new Field("location", (DataType)DataType.LongType), new Field("assist", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)};
        Field[] endFields = new Field[]{new Field("storageorgunitname", (DataType)DataType.StringType), new Field("warehousename", (DataType)DataType.StringType), new Field("locationname", (DataType)DataType.StringType), new Field("calorgname", (DataType)DataType.StringType), new Field("ownername", (DataType)DataType.StringType), new Field("calrangeid", (DataType)DataType.LongType), new Field("caldimensionid", (DataType)DataType.LongType), new Field("caldimension", (DataType)DataType.StringType), new Field("accounttype", (DataType)DataType.StringType), new Field("currencyid", (DataType)DataType.LongType), new Field("baseunitid", (DataType)DataType.LongType), new Field("precision", (DataType)DataType.IntegerType), new Field("invtypeid", (DataType)DataType.LongType), new Field("invstatusid", (DataType)DataType.LongType), new Field("ownertypeid", (DataType)DataType.StringType), new Field("elementid", (DataType)DataType.LongType), new Field("subelementid", (DataType)DataType.LongType), new Field("sourDiffId", (DataType)DataType.LongType), new Field("diffamt", (DataType)DataType.BigDecimalType), new Field("begindiffamt", (DataType)DataType.BigDecimalType), new Field("allocedAmt", (DataType)DataType.BigDecimalType), new Field("diffRate", (DataType)DataType.BigDecimalType), new Field("dividebasisval", (DataType)DataType.StringType), new Field("caldimensionval", (DataType)DataType.StringType), new Field("newcalrangeid", (DataType)DataType.LongType)};
        this.costAdjDataMeta = new RowMeta(this.concat(this.concat(beginFields, dynamicFields), endFields));
        this.printLog("costAdjDataMeta:", this.costAdjDataMeta);
    }

    private void buildStdCostBalaRowMeta() {
        Field[] fields = new Field[]{new Field("difftype", (DataType)DataType.StringType), new Field("costaccountid", (DataType)DataType.LongType), new Field("calsystemid", (DataType)DataType.LongType), new Field("calpolicyid", (DataType)DataType.LongType), new Field("costaccounttypeid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType), new Field("calorg", (DataType)DataType.LongType), new Field("owner", (DataType)DataType.LongType), new Field("storageorgunit", (DataType)DataType.LongType), new Field("warehouse", (DataType)DataType.LongType), new Field("location", (DataType)DataType.LongType), new Field("assist", (DataType)DataType.StringType), new Field("lot", (DataType)DataType.StringType), new Field("ownertypeid", (DataType)DataType.StringType), new Field("sourDiffId", (DataType)DataType.LongType), new Field("elementid", (DataType)DataType.LongType), new Field("subelementid", (DataType)DataType.LongType), new Field("begindiffamt", (DataType)DataType.BigDecimalType)};
        this.stdCostBalaDataMeta = new RowMeta(fields);
        this.printLog("stdCostBalaDataMeta:", this.stdCostBalaDataMeta);
    }

    private QFilter getMatFilter(String matField, DiffAllocParamter allocParam, DiffAllocParamterEntry paramEntry) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (paramEntry.getMatIdSet() != null && paramEntry.getMatIdSet().size() > 0) {
            String matConditionType = allocParam.getMatConditionType();
            filter.and(matField, "B".equals(matConditionType) ? "not in" : "in", paramEntry.getMatIdSet());
        }
        return filter;
    }

    private <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void printLog(String logDesc, RowMeta rowMeta) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String f : rowMeta.getFieldNames()) {
            sb.append(",").append(f);
        }
        logger.info(logDesc + sb);
    }

    @Deprecated
    public Set<Object> getAllMats() {
        HashSet<Object> mats = new HashSet<Object>();
        mats.add(1L);
        for (Map.Entry<String, DiffAllocParamterEntry> entry : this.allocParam.getEntityEntry().entrySet()) {
            DiffAllocParamterEntry paramEntry = entry.getValue();
            if (paramEntry.getMatIdSet() == null || paramEntry.getMatIdSet().size() <= 0) continue;
            mats.addAll(paramEntry.getMatIdSet());
        }
        return mats;
    }

    public Set<Long> getGenCrossMonthGroupBill() {
        Object row6;
        HashMap<Long, Set> historyBillInfoMap = new HashMap<Long, Set>(16);
        HashMap<Long, Set> adjInvBillMap = new HashMap<Long, Set>(16);
        HashSet<Long> currCrossEntryIDs = new HashSet<Long>();
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        HashSet<Long> srcBizBillIds = new HashSet<Long>(16);
        DataSet currPerdGrpData = null;
        DataSet grpDatas = null;
        if (this.isBizGroup.booleanValue()) {
            grpDatas = this.getBizGroupDS();
            grpDatas = grpDatas.select("groupid as bizgrouprecordid,calentryid as inbillid,costrecordentryid as billentryid,type,bizbillid,material as materialid,period as periodid");
        } else {
            QFilter currPerdGrpFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            currPerdGrpFilter.and("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
            currPerdGrpFilter.and("costaccounttype.id", "=", (Object)this.allocParamEntry.getCostAccountTypeId());
            currPerdGrpFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.allocParamEntry));
            currPerdGrpFilter.and("entryentity.type", "=", (Object)"1");
            grpDatas = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])currPerdGrpFilter.toArray(), null);
            HashSet groupRecrodIds = new HashSet(100);
            for (Row row2 : grpDatas) {
                groupRecrodIds.add(row2.getLong("id"));
            }
            QFilter qfilter = new QFilter("id", "in", (Object)groupRecrodIds);
            grpDatas = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(bizgrouprecordid) bizgrouprecordid,entryentity.calentryid as inbillid ,entryentity.costrecordentryid as billentryid,entryentity.type as type,entryentity.bizbillid as bizbillid,entryentity.material as materialid,entryentity.period.id as periodid", (QFilter[])qfilter.toArray(), null);
            grpDatas.getRowMeta().getField("bizgrouprecordid").setDataType((DataType)DataType.StringType);
        }
        DataSet[] grpDataArray = grpDatas.splitByFilter(new String[]{"type='1' and periodid = " + this.allocParamEntry.getPeriodId().toString(), "type='0' and periodid < " + this.allocParamEntry.getPeriodId().toString()}, false);
        currPerdGrpData = grpDataArray[0];
        if (AcctGroupModelHelper.isNewGroupModel()) {
            for (Iterator row3 : grpDataArray[1]) {
                srcBizBillIds.add(row3.getLong("bizbillid"));
            }
        } else {
            HashSet<Long> bizGroupIds = new HashSet<Long>(16);
            for (Row row2 : grpDataArray[1]) {
                bizGroupIds.add(Long.valueOf(row2.getString("bizgrouprecordid")));
            }
            QFilter bizGroupFilter = new QFilter("id", "in", bizGroupIds);
            DataSet bizGroupDatas = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_groupbillrecord", (String)"entryentity.bizbillid as bizbillid", (QFilter[])bizGroupFilter.toArray(), null);
            for (Row row4 : bizGroupDatas) {
                srcBizBillIds.add(row4.getLong("bizbillid"));
            }
        }
        if (srcBizBillIds.isEmpty()) {
            return currCrossEntryIDs;
        }
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        Long costAccountId = this.allocParamEntry.getCostAccountId();
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        String[] allocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims()).split(",");
        String selectFileds = "id as costrecordid,bookdate as bizdate,auditdate as auditdate,billno,entry.id as costrecordentryid,entry.seq as costrecordseq,billnumber as outbillno,bizbillid as outbillid,entry.id as outbillentryid,entry.seq as outbillseq,billtype ,bizentityobject.number as bizentityobject,costaccount,0 as cstype,billtype as invbilltype,costaccount.calsystem as calsystemid,costaccount.calpolicy as calpolicyid,costaccount.costtype as costtypeid,costaccount.booktype as costaccounttypeid,entry.material.id as materialid,entry.material.id as material,period as periodid,calorg,entry.owner as owner,storageorgunit,entry.warehouse as warehouse,entry.location as location,entry.project as project,entry.tracknumber as tracknumber,entry.configuredcode as configuredcode,entry.productline as productline,entry.ecostcenter as ecostcenter,entry.noupdatecalfields as noupdatecalfields,entry.stocktype as stocktype,entry.assist as assist,entry.lot as lot,entry.mversion as mversion ,entry.calrange as calrangeid,entry.baseqty as baseqty,entry.standardcost as standardcost,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,adminorg,biztype as invbiztype,transtype,supplier,customer,entry.queuetype as queuetype,entry.signnum as signnum " + exFieldHelper.getAllExFields("cal_costrecord_subentity") + ",calbilltype,entry.accounttype as accounttype,entry.ownertype as ownertype,entry.invstatus as invstatus,entry.invtype as invtype" + DiffAllocHelper.getDiffAllocDimsAlias("cal_costrecord_subentity", allocDims, "");
        DataSet costRecordBillData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)selectFileds, (QFilter[])filter.toArray(), (String)null);
        costRecordBillData = costRecordBillData.filter((FilterFunction)new FilterDataSetFunction(costRecordBillData.getRowMeta(), this.allocParam, this.allocParamEntry));
        JoinDataSet outBillJoin = currPerdGrpData.leftJoin(costRecordBillData).on("billentryid", "costrecordentryid");
        currPerdGrpData = outBillJoin.select(new String[]{"bizgrouprecordid"}, new String[]{"billno", "costrecordid", "costrecordentryid", "calrangeid", "storageorgunit", "warehouse", "materialid", "billtype", "cstype", "supplier", "customer", "invbilltype", "invtype", "transtype", "invbiztype", "invstatus", "baseqty", "calbilltype", "queuetype", "signnum"}).finish().filter("materialid is not null");
        HashSet<Long> bizgrouprecordids = new HashSet<Long>(16);
        HashSet<String> bizgrouprecordidStr = new HashSet<String>(16);
        for (Row row5 : currPerdGrpData.copy()) {
            if (!this.isBizGroup.booleanValue()) {
                bizgrouprecordids.add(row5.getLong("bizgrouprecordid"));
                continue;
            }
            bizgrouprecordidStr.add(row5.getString("bizgrouprecordid"));
        }
        DataSet historyPerdGrpData = null;
        if (this.isBizGroup.booleanValue()) {
            historyPerdGrpData = this.getBizGroupDS();
            historyPerdGrpData = historyPerdGrpData.where("type = '0' and period < " + this.allocParamEntry.getPeriodId() + " and groupid in ('" + StringUtils.join(bizgrouprecordidStr, (String)"','") + "')");
            historyPerdGrpData = historyPerdGrpData.select("groupid as bizgrouprecordid,calentryid as inbillid,costrecordentryid as billentryid,type");
        } else {
            QFilter historyPerdGrpFilter = new QFilter("entryentity.period.id", "<", (Object)this.allocParamEntry.getPeriodId());
            historyPerdGrpFilter.and("bizgrouprecordid", "in", bizgrouprecordids);
            historyPerdGrpFilter.and("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
            historyPerdGrpFilter.and("costaccounttype.id", "=", (Object)this.allocParamEntry.getCostAccountTypeId());
            historyPerdGrpFilter.and("entryentity.type", "=", (Object)"0");
            historyPerdGrpData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(bizgrouprecordid) bizgrouprecordid,entryentity.calentryid as inbillid ,entryentity.costrecordentryid as billentryid,entryentity.type as type", (QFilter[])historyPerdGrpFilter.toArray(), null);
        }
        JoinDataSet crossMonthGrpData = currPerdGrpData.leftJoin(historyPerdGrpData).on("bizgrouprecordid", "bizgrouprecordid");
        DataSet crossMonthData = crossMonthGrpData.select(new String[]{"bizgrouprecordid as srcBbizgrouprecordid", "billno as srcbillno", "costrecordid as srccostrecordid", "costrecordentryid as srcBillentryid", "calrangeid", "storageorgunit", "warehouse", "materialid", "billtype", "cstype", "supplier", "customer", "invbilltype", "invtype", "transtype", "invbiztype", "invstatus", "baseqty", "calbilltype", "queuetype", "signnum"}, new String[]{"bizgrouprecordid as decBbizgrouprecordid", "billentryid as decBillentryid"}).finish().filter("decBillentryid is not null");
        HashMap<Long, Set> groupRecordEntryIdMap = new HashMap<Long, Set>(16);
        for (Object row6 : crossMonthData) {
            String infos = row6.getLong("calrangeid") + "@" + row6.getLong("storageorgunit") + "@" + row6.getLong("materialid") + "@" + row6.getString("srcbillno") + "@" + row6.getLong("srccostrecordid") + "@" + row6.getLong("srcBillentryid") + "@" + row6.getLong("warehouse") + "@" + row6.getString("billtype") + "@" + row6.getString("cstype") + "@" + row6.getString("supplier") + "@" + row6.getString("invbilltype") + "@" + row6.getString("invtype") + "@" + row6.getString("transtype") + "@" + row6.getString("invbiztype") + "@" + row6.getString("invstatus") + "@" + row6.getString("customer") + "@" + row6.getBigDecimal("baseqty") + "@" + row6.getString("calbilltype") + "@" + row6.getString("queuetype") + "@" + row6.getInteger("signnum");
            historyBillInfoMap.computeIfAbsent(row6.getLong("decBillentryid"), r -> new HashSet()).add(infos);
            currCrossEntryIDs.add(row6.getLong("srcBillentryid"));
            groupRecordEntryIdMap.computeIfAbsent(row6.getLong("decBillentryid"), r -> new HashSet()).add(row6.getLong("srcBillentryid"));
        }
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_stdcostdiff", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccount", FilterType.eq, (Object)costAccountId), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.allocParamEntry.getStartDate()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.allocParamEntry.getEndDate())});
        row6 = null;
        try {
            ctx.set();
            QFilter existAjdFilter = new QFilter("entryentity.invbillentryid", "in", currCrossEntryIDs);
            existAjdFilter.and("billsrctype", "=", (Object)"D");
            DataSet existInAdjBillData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"id,remark,entryentity.invbillentryid as invbillentryid,ischargeoffed,ischargeoff", (QFilter[])existAjdFilter.toArray(), null);
            String remark = ResManager.loadKDString((String)"\u8de8\u671f", (String)"CostAdjustBillHelper_3", (String)"fi-calx-algox", (Object[])new Object[0]);
            Iterator iterator = existInAdjBillData.iterator();
            while (iterator.hasNext()) {
                Row row7 = (Row)iterator.next();
                if (!row7.getString("remark").contains(remark)) continue;
                currCrossEntryIDs.remove(row7.getLong("invbillentryid"));
            }
        }
        catch (Throwable existAjdFilter) {
            row6 = existAjdFilter;
            throw existAjdFilter;
        }
        finally {
            if (ctx != null) {
                if (row6 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable existAjdFilter) {
                        ((Throwable)row6).addSuppressed(existAjdFilter);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        QFilter ajdFilter = new QFilter("entryentity.invbillentryid", "in", historyBillInfoMap.keySet());
        ajdFilter.and("billsrctype", "=", (Object)"D");
        DataSet adjbillData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"id,entryentity.invbillentryid as invbillentryid", (QFilter[])ajdFilter.toArray(), null);
        ArrayList<Object> adjPks = new ArrayList<Object>(16);
        for (Row row8 : adjbillData) {
            adjPks.add(row8.get("id"));
            adjInvBillMap.computeIfAbsent(row8.getLong("id"), r -> new HashSet()).add(row8.getLong("invbillentryid"));
        }
        QFilter costRecordFilter = new QFilter("entry.id", "in", historyBillInfoMap.keySet());
        costRecordFilter.and("bizbillid", "in", srcBizBillIds);
        DataSet historyCostRecordData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"entry.id as entryid,entry.baseqty as baseqty", (QFilter[])costRecordFilter.toArray(), null);
        HashMap<Long, BigDecimal> recordAndQtyMap = new HashMap<Long, BigDecimal>();
        for (Row row9 : historyCostRecordData) {
            recordAndQtyMap.put(row9.getLong("entryid"), row9.getBigDecimal("baseqty"));
        }
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        DynamicObject[] adjbills = BusinessDataServiceHelper.load((Object[])adjPks.toArray(), (DynamicObjectType)costAdjustEntityType);
        if (currCrossEntryIDs.size() == 0) {
            return currCrossEntryIDs;
        }
        ArrayList<DynamicObject> newAdjbills = new ArrayList<DynamicObject>(adjbills.length);
        CloneUtils cloneUitls = new CloneUtils(false, true);
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        String outRemark = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210\u2014\u8de8\u671f\u6210\u7ec4\u51fa\u5e93", (String)"CostAdjustBillHelper_4", (String)"fi-calx-algox", (Object[])new Object[0]);
        String inRemark = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210\u2014\u8de8\u671f\u6210\u7ec4\u5165\u5e93", (String)"CostAdjustBillHelper_5", (String)"fi-calx-algox", (Object[])new Object[0]);
        for (DynamicObject adjBill : adjbills) {
            Set costRecordIds = (Set)adjInvBillMap.get(adjBill.getLong("id"));
            for (Object costRecordId : costRecordIds) {
                Set costRecordInfoSet = (Set)historyBillInfoMap.get(costRecordId);
                if (costRecordInfoSet.isEmpty()) continue;
                for (String costRecordInfoStr : costRecordInfoSet) {
                    DiffAllocHelper.writeLog(logger, ResManager.loadKDString((String)"\u8de8\u671f\u6210\u7ec4\u51fa\u5e93/\u5165\u5e93\u5bf9\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6570\u636e\u96c6==>{}", (String)"DiffAllocDataFactory_2", (String)"fi-calx-algox", (Object[])new Object[0]), costRecordInfoStr);
                    int amtprecision = adjBill.getInt("currency.amtprecision");
                    DynamicObject newAdjBill = (DynamicObject)cloneUitls.clone((IDataEntityType)costAdjustEntityType, (Object)adjBill);
                    long ID = DB.genGlobalLongId();
                    newAdjBill.set("id", (Object)ID);
                    newAdjBill.set("billno", (Object)("ZBTZ" + ID));
                    newAdjBill.set("period_id", (Object)this.allocParamEntry.getPeriodId());
                    newAdjBill.set("bizdate", (Object)this.allocParamEntry.getEndDate());
                    newAdjBill.set("bookdate", (Object)this.allocParamEntry.getEndDate());
                    newAdjBill.set("remark", (Object)("A".equals(adjBill.getString("biztype")) ? outRemark : inRemark));
                    newAdjBill.set("isvoucher", (Object)"0");
                    newAdjBill.set("vouchernum", (Object)" ");
                    newAdjBill.set("billstatus", (Object)"B");
                    DynamicObjectCollection entrys = newAdjBill.getDynamicObjectCollection("entryentity");
                    if (entrys == null || entrys.isEmpty()) continue;
                    ArrayList<Integer> removeIdexs = new ArrayList<Integer>(16);
                    int indexEntry = 0;
                    for (DynamicObject billEntry : entrys) {
                        String[] costRecordInfos = costRecordInfoStr.split("@");
                        Set invBillEntryIds = (Set)groupRecordEntryIdMap.get(billEntry.getLong("invbillentryid"));
                        if (invBillEntryIds != null && invBillEntryIds.contains(Long.parseLong(costRecordInfos[5]))) {
                            if (!currCrossEntryIDs.contains(Long.valueOf(costRecordInfos[5]))) {
                                removeIdexs.add(indexEntry++);
                                continue;
                            }
                            newAdjBill.set("biztype", (Object)("OUT".equals(costRecordInfos[17]) ? "B" : "A"));
                            newAdjBill.set("billtype_id", (Object)costRecordInfos[7]);
                            newAdjBill.set("cstype", (Object)("A".equals(newAdjBill.getString("biztype")) ? "bd_supplier" : "bd_customer"));
                            newAdjBill.set("custsupplier_id", (Object)("A".equals(newAdjBill.getString("biztype")) ? costRecordInfos[9] : costRecordInfos[15]));
                            BigDecimal historyCostRecordQty = (BigDecimal)recordAndQtyMap.get(billEntry.getLong("invbillentryid"));
                            if (historyCostRecordQty == null || BigDecimal.ZERO.compareTo(historyCostRecordQty) == 0) continue;
                            billEntry.set("invbillid", (Object)costRecordInfos[4]);
                            billEntry.set("invbillentryid", (Object)costRecordInfos[5]);
                            billEntry.set("invbillnum", (Object)costRecordInfos[3]);
                            billEntry.set("calrange_id", (Object)costRecordInfos[0]);
                            billEntry.set("storageorgunit_id", (Object)costRecordInfos[1]);
                            billEntry.set("material_id", (Object)costRecordInfos[2]);
                            billEntry.set("warehouse_id", (Object)costRecordInfos[6]);
                            billEntry.set("invbilltype_id", (Object)costRecordInfos[10]);
                            billEntry.set("invtype_id", (Object)costRecordInfos[11]);
                            billEntry.set("transtype", (Object)costRecordInfos[12]);
                            billEntry.set("invbiztype_id", (Object)costRecordInfos[13]);
                            billEntry.set("invstatus_id", (Object)costRecordInfos[14]);
                            billEntry.set("srcbillid", adjBill.get("id"));
                            billEntry.set("srcbillnum", adjBill.get("billno"));
                            billEntry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
                            billEntry.set("queuetype", (Object)costRecordInfos[18]);
                            billEntry.set("signnum", (Object)Integer.valueOf(costRecordInfos[19]));
                            DynamicObjectCollection entrysDetails = billEntry.getDynamicObjectCollection("subentryentity");
                            BigDecimal entryAdjAmt = BigDecimal.ZERO;
                            BigDecimal diff_g = BigDecimal.ZERO;
                            BigDecimal diff_h = BigDecimal.ZERO;
                            BigDecimal diff_k = BigDecimal.ZERO;
                            BigDecimal diff_p = BigDecimal.ZERO;
                            BigDecimal diff_q = BigDecimal.ZERO;
                            BigDecimal diff_r = BigDecimal.ZERO;
                            BigDecimal diff_m = BigDecimal.ZERO;
                            BigDecimal diff_s = BigDecimal.ZERO;
                            BigDecimal diff_t = BigDecimal.ZERO;
                            BigDecimal diff_c = BigDecimal.ZERO;
                            BigDecimal diff_w = BigDecimal.ZERO;
                            BigDecimal diff_x = BigDecimal.ZERO;
                            BigDecimal diff_y = BigDecimal.ZERO;
                            for (DynamicObject entrysDetail : entrysDetails) {
                                BigDecimal oldSubAmt = entrysDetail.getBigDecimal("sub_adjustamt");
                                BigDecimal oldDiff_g = entrysDetail.getBigDecimal("ddiff_g");
                                BigDecimal oldDiff_h = entrysDetail.getBigDecimal("ddiff_h");
                                BigDecimal oldDiff_k = entrysDetail.getBigDecimal("ddiff_k");
                                BigDecimal oldDiff_p = entrysDetail.getBigDecimal("ddiff_p");
                                BigDecimal oldDiff_q = entrysDetail.getBigDecimal("ddiff_q");
                                BigDecimal oldDiff_r = entrysDetail.getBigDecimal("ddiff_r");
                                BigDecimal oldDiff_m = entrysDetail.getBigDecimal("ddiff_m");
                                BigDecimal oldDiff_s = entrysDetail.getBigDecimal("ddiff_s");
                                BigDecimal oldDiff_t = entrysDetail.getBigDecimal("ddiff_t");
                                BigDecimal oldDiff_c = entrysDetail.getBigDecimal("ddiff_c");
                                BigDecimal oldDiff_w = entrysDetail.getBigDecimal("ddiff_w");
                                BigDecimal oldDiff_x = entrysDetail.getBigDecimal("ddiff_x");
                                BigDecimal oldDiff_y = entrysDetail.getBigDecimal("ddiff_y");
                                BigDecimal currAdjAmt = BigDecimal.ZERO;
                                BigDecimal currDdiff_g = oldDiff_g.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_g);
                                BigDecimal currDdiff_h = oldDiff_h.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_h);
                                BigDecimal currDdiff_k = oldDiff_k.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_k);
                                BigDecimal currDdiff_p = oldDiff_p.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_p);
                                BigDecimal currDdiff_q = oldDiff_q.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_q);
                                BigDecimal currDdiff_r = oldDiff_r.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_r);
                                BigDecimal currDdiff_m = oldDiff_m.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_m);
                                BigDecimal currDdiff_s = oldDiff_s.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_s);
                                BigDecimal currDdiff_t = oldDiff_t.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_t);
                                BigDecimal currDdiff_c = oldDiff_c.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_c);
                                BigDecimal currDdiff_w = oldDiff_w.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_w);
                                BigDecimal currDdiff_x = oldDiff_x.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_x);
                                BigDecimal currDdiff_y = oldDiff_y.divide(historyCostRecordQty, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(costRecordInfos[16])).setScale(amtprecision, RoundingMode.HALF_UP);
                                currAdjAmt = currAdjAmt.add(currDdiff_y);
                                entrysDetail.set("sub_adjustamt", (Object)currAdjAmt);
                                entrysDetail.set("ddiff_g", (Object)currDdiff_g);
                                entrysDetail.set("ddiff_h", (Object)currDdiff_h);
                                entrysDetail.set("ddiff_k", (Object)currDdiff_k);
                                entrysDetail.set("ddiff_p", (Object)currDdiff_p);
                                entrysDetail.set("ddiff_q", (Object)currDdiff_q);
                                entrysDetail.set("ddiff_r", (Object)currDdiff_r);
                                entrysDetail.set("ddiff_m", (Object)currDdiff_m);
                                entrysDetail.set("ddiff_s", (Object)currDdiff_s);
                                entrysDetail.set("ddiff_t", (Object)currDdiff_t);
                                entrysDetail.set("ddiff_c", (Object)currDdiff_c);
                                entrysDetail.set("ddiff_w", (Object)currDdiff_w);
                                entrysDetail.set("ddiff_x", (Object)currDdiff_x);
                                entrysDetail.set("ddiff_y", (Object)currDdiff_y);
                                entryAdjAmt = entryAdjAmt.add(currAdjAmt);
                                diff_g = diff_g.add(currDdiff_g);
                                diff_h = diff_h.add(currDdiff_h);
                                diff_k = diff_k.add(currDdiff_k);
                                diff_p = diff_p.add(currDdiff_p);
                                diff_q = diff_q.add(currDdiff_q);
                                diff_r = diff_r.add(currDdiff_r);
                                diff_m = diff_m.add(currDdiff_m);
                                diff_s = diff_s.add(currDdiff_s);
                                diff_t = diff_t.add(currDdiff_t);
                                diff_c = diff_c.add(currDdiff_c);
                                diff_w = diff_w.add(currDdiff_w);
                                diff_x = diff_x.add(currDdiff_x);
                                diff_y = diff_y.add(currDdiff_y);
                            }
                            BigDecimal oldAmt = billEntry.getBigDecimal("adjustamt");
                            if (oldAmt != null && historyCostRecordQty != null && historyCostRecordQty.compareTo(BigDecimal.ZERO) != 0) {
                                billEntry.set("adjustamt", (Object)entryAdjAmt);
                                billEntry.set("diff_g", (Object)diff_g);
                                billEntry.set("diff_h", (Object)diff_h);
                                billEntry.set("diff_k", (Object)diff_k);
                                billEntry.set("diff_p", (Object)diff_p);
                                billEntry.set("diff_q", (Object)diff_q);
                                billEntry.set("diff_r", (Object)diff_r);
                                billEntry.set("diff_m", (Object)diff_m);
                                billEntry.set("diff_s", (Object)diff_s);
                                billEntry.set("diff_t", (Object)diff_t);
                                billEntry.set("diff_c", (Object)diff_c);
                                billEntry.set("diff_w", (Object)diff_w);
                                billEntry.set("diff_x", (Object)diff_x);
                                billEntry.set("diff_y", (Object)diff_y);
                            }
                        } else {
                            removeIdexs.add(indexEntry);
                        }
                        ++indexEntry;
                    }
                    if (!removeIdexs.isEmpty()) {
                        for (int i = removeIdexs.size() - 1; i >= 0; --i) {
                            entrys.remove(((Integer)removeIdexs.get(i)).intValue());
                        }
                    }
                    newAdjBill.set("creator", (Object)userId);
                    newAdjBill.set("createtime", (Object)date);
                    newAdjBill.set("modifier", (Object)userId);
                    newAdjBill.set("modifytime", (Object)date);
                    newAdjBill.set("auditor", (Object)userId);
                    newAdjBill.set("auditdate", (Object)date);
                    if (newAdjBill.getDynamicObjectCollection("entryentity").isEmpty()) continue;
                    newAdjbills.add(newAdjBill);
                }
            }
        }
        Object[] billIds = SaveServiceHelper.save((DynamicObject[])newAdjbills.toArray(new DynamicObject[0]));
        this.updateBal(billIds);
        HashSet<Long> targCostRecordEntryIds = new HashSet<Long>(16);
        DataSet currTargGrpData = null;
        HashMap<Long, String> outBillBizGroupIdMap = new HashMap<Long, String>(16);
        if (this.isBizGroup.booleanValue()) {
            DataSet currGrpData = this.getBizGroupDS();
            currGrpData = currGrpData.select("groupid as bizgrouprecordid,calentryid as inbillid ,costrecordentryid as billentryid,type");
            if (currCrossEntryIDs.isEmpty()) {
                currGrpData = currGrpData.where("1<>1");
            } else {
                HashSet<String> currCrossEntryIDStr = new HashSet<String>(16);
                for (Long currCrossEntryID : currCrossEntryIDs) {
                    currCrossEntryIDStr.add(currCrossEntryID.toString());
                }
                currGrpData = currGrpData.where("type = '0' and billentryid in(" + String.join((CharSequence)",", currCrossEntryIDStr) + ")");
            }
            HashSet<String> bizGroupIds = new HashSet<String>(16);
            for (Object row10 : currGrpData) {
                bizGroupIds.add("'" + row10.getString("bizgrouprecordid") + "'");
                outBillBizGroupIdMap.put(row10.getLong("billentryid"), row10.getString("bizgrouprecordid"));
            }
            currTargGrpData = this.getBizGroupDS();
            currTargGrpData = currTargGrpData.select("groupid as bizgrouprecordid,calentryid as inbillid,costrecordentryid as billentryid,type,period");
            currTargGrpData = bizGroupIds.isEmpty() ? currTargGrpData.where("1<>1") : currTargGrpData.where("type = '1' and bizgrouprecordid in(" + String.join((CharSequence)",", bizGroupIds) + ") and period = " + this.allocParamEntry.getPeriodId());
            for (Object row10 : currTargGrpData.copy()) {
                targCostRecordEntryIds.add(row10.getLong("billentryid"));
            }
        } else {
            QFilter currGrpFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            currGrpFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
            currGrpFilter.and("entryentity.costrecordentryid", "in", currCrossEntryIDs);
            currGrpFilter.and("entryentity.type", "=", (Object)"0");
            DataSet currGrpData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"bizgrouprecordid,entryentity.calentryid as inbillid ,entryentity.costrecordentryid as billentryid,entryentity.type as type", (QFilter[])currGrpFilter.toArray(), null);
            HashSet<Long> bizGroupIds = new HashSet<Long>(16);
            for (Object row11 : currGrpData) {
                bizGroupIds.add(row11.getLong("bizgrouprecordid"));
                outBillBizGroupIdMap.put(row11.getLong("billentryid"), row11.getString("bizgrouprecordid"));
            }
            QFilter currTargGrpFilter = new QFilter("bizgrouprecordid", "in", bizGroupIds);
            currTargGrpFilter.and("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            currTargGrpFilter.and("entryentity.type", "=", (Object)"1");
            currTargGrpData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(bizgrouprecordid) as bizgrouprecordid,entryentity.calentryid as inbillid ,entryentity.costrecordentryid as billentryid,entryentity.type as type", (QFilter[])currTargGrpFilter.toArray(), null);
            for (Object row12 : currTargGrpData.copy()) {
                targCostRecordEntryIds.add(row12.getLong("billentryid"));
            }
        }
        QFilter rcdFilter = new QFilter("entry.id", "in", targCostRecordEntryIds);
        DataSet currCostRecordBillData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"billno,id as costrecordid,entry.queuetype as queuetype,entry.id as costrecordentryid,entry.calrange as calrangeid,storageorgunit,billtype,0 as cstype,supplier,customer,calbilltype,entry.warehouse as warehouse,entry.material as materialid,entry.baseqty as baseqty,billtype as invbilltype,entry.invtype as invtype,transtype as transtype,biztype as invbiztype,entry.invstatus as invstatus,ischargeoff,entry.signnum as signnum", (QFilter[])rcdFilter.toArray(), (String)null);
        JoinDataSet currCostRecordBillJoinData = currCostRecordBillData.leftJoin(currTargGrpData).on("costrecordentryid", "billentryid");
        DataSet currCostRecordBill = currCostRecordBillJoinData.select(new String[]{"billno", "costrecordid", "costrecordentryid", "calrangeid", "materialid", "storageorgunit", "warehouse", "billtype", "cstype", "supplier", "customer", "invbilltype", "invtype", "transtype", "invbiztype", "invstatus", "calbilltype", "queuetype", "ischargeoff", "signnum"}, new String[]{"bizgrouprecordid"}).finish().filter("bizgrouprecordid is not null");
        HashMap<String, String> currCostRecordInfoMap = new HashMap<String, String>();
        for (Row row13 : currCostRecordBill) {
            String infos = row13.getLong("calrangeid") + "@" + row13.getLong("storageorgunit") + "@" + row13.getLong("materialid") + "@" + row13.getString("billno") + "@" + row13.getLong("costrecordid") + "@" + row13.getLong("costrecordentryid") + "@" + row13.getLong("warehouse") + "@" + row13.getString("billtype") + "@" + row13.getString("cstype") + "@" + row13.getString("supplier") + "@" + row13.getString("invbilltype") + "@" + row13.getString("invtype") + "@" + row13.getString("transtype") + "@" + row13.getString("invbiztype") + "@" + row13.getString("invstatus") + "@" + row13.getString("customer") + "@" + row13.getString("calbilltype") + "@" + row13.getString("queuetype") + "@" + row13.getString("ischargeoff") + "@" + row13.getInteger("signnum");
            currCostRecordInfoMap.put(row13.getString("bizgrouprecordid"), infos);
        }
        ArrayList<DynamicObject> newCurrAdjbills = new ArrayList<DynamicObject>(newAdjbills.size());
        block30: for (DynamicObject newAdjbill : newAdjbills) {
            DynamicObject newCurrAdjBill = (DynamicObject)cloneUitls.clone((IDataEntityType)costAdjustEntityType, (Object)newAdjbill);
            long ID = DB.genGlobalLongId();
            newCurrAdjBill.set("id", (Object)ID);
            newCurrAdjBill.set("billno", (Object)("ZBTZ" + ID));
            newCurrAdjBill.set("period_id", (Object)this.allocParamEntry.getPeriodId());
            newCurrAdjBill.set("bizdate", (Object)this.allocParamEntry.getEndDate());
            newCurrAdjBill.set("bookdate", (Object)this.allocParamEntry.getEndDate());
            newCurrAdjBill.set("creator", (Object)userId);
            newCurrAdjBill.set("createtime", (Object)date);
            newCurrAdjBill.set("modifier", (Object)userId);
            newCurrAdjBill.set("modifytime", (Object)date);
            newCurrAdjBill.set("auditor", (Object)userId);
            newCurrAdjBill.set("auditdate", (Object)date);
            newCurrAdjBill.set("isvoucher", (Object)"0");
            newCurrAdjBill.set("vouchernum", (Object)" ");
            newCurrAdjBill.set("billstatus", (Object)"B");
            DynamicObjectCollection entrys = newCurrAdjBill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection srcEntrys = newAdjbill.getDynamicObjectCollection("entryentity");
            int entryIndex = 0;
            for (DynamicObject billEntry : entrys) {
                DynamicObject srcEntry = (DynamicObject)srcEntrys.get(entryIndex++);
                String bizGroupId = (String)outBillBizGroupIdMap.get(billEntry.getLong("invbillentryid"));
                String currCostRecordInfoStr = (String)currCostRecordInfoMap.get(bizGroupId);
                if (currCostRecordInfoStr == null) continue block30;
                String[] currCostRecordInfos = currCostRecordInfoStr.split("@");
                newCurrAdjBill.set("biztype", (Object)("IN".equals(currCostRecordInfos[16]) ? "A" : "B"));
                newCurrAdjBill.set("remark", (Object)("IN".equals(currCostRecordInfos[16]) ? inRemark : outRemark));
                newCurrAdjBill.set("billtype_id", (Object)currCostRecordInfos[7]);
                newCurrAdjBill.set("cstype", (Object)("A".equals(newCurrAdjBill.getString("biztype")) ? "bd_supplier" : "bd_customer"));
                newCurrAdjBill.set("custsupplier_id", (Object)("A".equals(newCurrAdjBill.getString("biztype")) ? currCostRecordInfos[9] : currCostRecordInfos[15]));
                billEntry.set("invbillid", (Object)currCostRecordInfos[4]);
                billEntry.set("invbillentryid", (Object)currCostRecordInfos[5]);
                billEntry.set("invbillnum", (Object)currCostRecordInfos[3]);
                billEntry.set("calrange_id", (Object)currCostRecordInfos[0]);
                billEntry.set("storageorgunit_id", (Object)currCostRecordInfos[1]);
                billEntry.set("material_id", (Object)currCostRecordInfos[2]);
                billEntry.set("warehouse_id", (Object)currCostRecordInfos[6]);
                billEntry.set("invbilltype_id", (Object)currCostRecordInfos[10]);
                billEntry.set("invtype_id", (Object)currCostRecordInfos[11]);
                billEntry.set("transtype", (Object)currCostRecordInfos[12]);
                billEntry.set("invbiztype_id", (Object)currCostRecordInfos[13]);
                billEntry.set("invstatus_id", (Object)currCostRecordInfos[14]);
                billEntry.set("queuetype", (Object)currCostRecordInfos[17]);
                billEntry.set("signnum", (Object)Integer.valueOf(currCostRecordInfos[19]));
                billEntry.set("srcbillentryid", srcEntry.get("id"));
                billEntry.set("srcbillid", newAdjbill.get("id"));
                billEntry.set("srcbillnum", newAdjbill.get("billno"));
                String isChargeOff = currCostRecordInfos[18];
                if ("true".equals(isChargeOff)) {
                    this.reverseAmount(billEntry);
                }
                if (newCurrAdjbills.contains(newCurrAdjBill)) continue;
                currCrossEntryIDs.add(Long.parseLong(currCostRecordInfos[5]));
                newCurrAdjbills.add(newCurrAdjBill);
            }
        }
        billIds = SaveServiceHelper.save((DynamicObject[])newCurrAdjbills.toArray(new DynamicObject[0]));
        this.updateBal(billIds);
        return currCrossEntryIDs;
    }

    public String getSubElementIds() {
        DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory.getSubElementIds", (String)"cad_subelement", (String)"id", null, null);
        StringBuilder subelementIds = new StringBuilder();
        for (Row row : data) {
            subelementIds.append(row.getString("id")).append(",");
        }
        return subelementIds.substring(1, subelementIds.length() - 1);
    }

    public Input[] getFixDiffOutBillEntryData() {
        ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
        RowMeta dataMeta = ORM.create().createRowMeta("cal_stdcostdiffbill", "entryentity.invbillentryid as fixDiffCostRecordEntryId");
        DataSet allGroupData = null;
        Algo algo = Algo.create((String)ALGOKEY);
        RowMeta groupDdataMeta = ORM.create().createRowMeta("cal_account_grouprecord", "id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period");
        groupDdataMeta.getField("groupid").setDataType((DataType)DataType.StringType);
        if (this.isBizGroup.booleanValue()) {
            allGroupData = this.getBizGroupDS();
            allGroupData = allGroupData.select("groupid,costrecordentryid,type,period");
        } else {
            QFilter acctGrpRecordFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
            acctGrpRecordFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.allocParamEntry));
            acctGrpRecordFilter.and("entryentity.type", "=", (Object)"1");
            DataSet groupData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])acctGrpRecordFilter.toArray(), null);
            HashSet<Long> groupIds = new HashSet<Long>(10);
            HashSet<DataSet> groupDatas = new HashSet<DataSet>(16);
            for (Row row : groupData) {
                groupIds.add(row.getLong("id"));
                if (groupIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter filter = new QFilter("id", "in", groupIds);
                filter.and("entryentity.period", "<=", (Object)this.allocParamEntry.getPeriodId());
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
                groupIds = new HashSet(10);
            }
            if (groupIds.size() > 0) {
                QFilter filter = new QFilter("id", "in", groupIds);
                filter.and("entryentity.period", "<=", (Object)this.allocParamEntry.getPeriodId());
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
            }
            DataSet emptyGroupData = algo.createDataSet(new ArrayList(), groupDdataMeta);
            if (!groupDatas.isEmpty()) {
                allGroupData = emptyGroupData.union(groupDatas.toArray(new DataSet[0]));
            } else {
                DataSet emptySet = algo.createDataSet(new ArrayList(), dataMeta);
                inputList.add(new DataSetInput(emptySet, dataMeta));
                return inputList.toArray(new Input[inputList.size()]);
            }
        }
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        DataSet costRecordData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"bizentityobject,entry.id as costrecordentryid", (QFilter[])filter.toArray(), null);
        allGroupData = allGroupData.leftJoin(costRecordData).on("costrecordentryid", "costrecordentryid").select(allGroupData.getRowMeta().getFieldNames(), new String[]{"bizentityobject"}).finish();
        DataSet noDiffAllocEntryIds = allGroupData.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunction)new FilterNoAllocEntryIdsFunction());
        DataSet adjbillData = noDiffAllocEntryIds.select("costrecordentryid as fixDiffCostRecordEntryId");
        inputList.add(new DataSetInput(adjbillData.copy(), dataMeta));
        HashSet<Long> fixEntryIds = new HashSet<Long>();
        for (Row row : adjbillData) {
            fixEntryIds.add(row.getLong("fixDiffCostRecordEntryId"));
        }
        DataSet allGrpData = null;
        if (this.isBizGroup.booleanValue()) {
            HashSet<String> fixEntryIdStr = new HashSet<String>(16);
            for (Long fixEntryId : fixEntryIds) {
                fixEntryIdStr.add(fixEntryId.toString());
            }
            DataSet ds = this.getBizGroupDS();
            ds = fixEntryIdStr.isEmpty() ? ds.where("1<>1") : ds.where("type = '0' and costrecordentryid in (" + String.join((CharSequence)",", fixEntryIdStr) + ")");
            ds = ds.select("groupid");
            HashSet<String> groupids = new HashSet<String>(16);
            for (Object row : ds) {
                groupids.add("'" + row.getString("groupid") + "'");
            }
            ds = this.getBizGroupDS();
            allGrpData = groupids.isEmpty() ? ds.where("1<>1") : ds.where("groupid in (" + String.join((CharSequence)",", groupids) + ")");
        } else {
            QFilter grpRecordFilter = new QFilter("entryentity.period.id", "=", (Object)this.allocParamEntry.getPeriodId());
            grpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId()));
            grpRecordFilter.and("entryentity.costrecordentryid", "in", fixEntryIds);
            grpRecordFilter.and("entryentity.type", "=", (Object)"0");
            DataSet grpData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"id", (QFilter[])grpRecordFilter.toArray(), null);
            HashSet<Long> grpIds = new HashSet<Long>(10);
            HashSet<DataSet> grpDatas = new HashSet<DataSet>(16);
            for (Row row : grpData) {
                grpIds.add(row.getLong("id"));
                if (grpIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter filter1 = new QFilter("id", "in", grpIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter1.toArray(), null);
                grpDatas.add(data);
                grpIds = new HashSet(10);
            }
            if (grpIds.size() > 0) {
                QFilter filter1 = new QFilter("id", "in", grpIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter1.toArray(), null);
                grpDatas.add(data);
            }
            if (grpDatas.isEmpty()) {
                return inputList.toArray(new Input[inputList.size()]);
            }
            DataSet emptyGroupData1 = algo.createDataSet(new ArrayList(), groupDdataMeta);
            allGrpData = emptyGroupData1.union(grpDatas.toArray(new DataSet[0]));
        }
        QFilter billFilter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        billFilter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        billFilter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        billFilter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            billFilter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        billFilter.and("calbilltype", "=", (Object)"OUT");
        billFilter.and("billstatus", "=", (Object)"C");
        billFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        billFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        billFilter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        billFilter.and("entry.accounttype", "=", (Object)"D");
        DataSet outCostRecordData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"bizentityobject,entry.id as costrecordentryid", (QFilter[])filter.toArray(), null);
        allGrpData = allGrpData.leftJoin(outCostRecordData).on("costrecordentryid", "costrecordentryid").select(allGrpData.getRowMeta().getFieldNames(), new String[]{"bizentityobject"}).finish();
        DataSet targOutBillEntrys = allGrpData.filter("bizentityobject is null");
        DataSet adjbillData1 = targOutBillEntrys.select("costrecordentryid as fixDiffCostRecordEntryId");
        inputList.add(new DataSetInput(adjbillData1, dataMeta));
        DataSet emptySet = algo.createDataSet(new ArrayList(), dataMeta);
        inputList.add(new DataSetInput(emptySet, dataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private long getRandomValue() {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        return (current - zero) / 1000L;
    }

    private void checkIsHashMatTrans() {
        QFilter filter = new QFilter("period.id", "=", (Object)this.allocParamEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.allocParamEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.allocParamEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.allocParamEntry.getCostAccountId());
        if (this.allocParamEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.allocParamEntry.getCalRangeId());
        }
        filter.and("entry.queuetype", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.allocParamEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.id", "not in", this.allocParam.getCrossRecordEntryIds());
        QFilter billTypeFilter = new QFilter("bizentityobject", "in", billTypes);
        DataSet outBillData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"id", (QFilter[])new QFilter[]{filter, billTypeFilter}, null);
        if (!outBillData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u644a\u8303\u56f4\u5185\u5b58\u5728\u7ec4\u88c5\u5355\u3001\u62c6\u5378\u5355\u3001\u5f62\u6001\u8f6c\u6362\u5355\u3001\u59d4\u5916\u9886\u6599\u5355\u6216\u59d4\u5916\u9000\u6599\u5355\uff0c\u8bf7\u5728\u201c\u6807\u51c6\u6210\u672c\u6838\u7b97\u201d\u6a21\u5757\u6267\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocDataFactory_0", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
    }

    private String getCostRecordBizFieldByOrmInput(DiffAllocParamterEntry entry) {
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        Date enddate = new Date();
        if (entry != null) {
            enddate = entry.getEndDate();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String[] allocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims()).split(",");
        return "id as costrecordid,bookdate as bizdate,auditdate as auditdate,billno as costrecordbillno,entry.id as costrecordentryid,entry.seq as costrecordseq,billnumber as outbillno,bizbillid as outbillid,entry.id as outbillentryid,entry.seq as outbillseq,billtype as outbilltypeid,billtype.name as outbilltypename,bizentityobject.number as bizentityobject,costaccount,costaccount.calsystem as calsystemid,costaccount.calpolicy as calpolicyid,costaccount.costtype as costtypeid,costaccount.booktype as costaccounttypeid,entry.material as material,period as periodid,calorg,entry.owner as owner,storageorgunit,entry.warehouse as warehouse,entry.location as location,entry.project as project,entry.tracknumber as tracknumber,entry.configuredcode as configuredcode,entry.productline as productline,entry.ecostcenter as ecostcenter,entry.noupdatecalfields as noupdatecalfields,entry.stocktype as stocktype,entry.assist as assist,entry.lot as lot,entry.mversion as mversion ,entry.calrange as calrangeid,entry.baseqty as baseqty,entry.standardcost as standardcost,entry.caldimension as caldimensionid,entry.caldimension.caldimension as caldimension,adminorg,biztype,transtype,supplier,customer,entry.queuetype as queuetype,entry.signnum as signnum " + exFieldHelper.getAllExFields("cal_costrecord_subentity") + ",calbilltype,entry.accounttype as accounttype,entry.ownertype as ownertype,entry.invstatus as invstatus,entry.invtype as invtypeid,entry.baseunit as baseunitid,localcurrency as currencyid,entry.subentrycostelement.costelement as elementid,entry.subentrycostelement.costsubelement as subelementid,to_date('" + sdf.format(enddate) + "') as enddate ,'' as costdomain,0 as diffType_G,0 as diffType_H,0 as diffType_K,0 as diffType_M,0 as diffType_P,0 as diffType_Q,0 as diffType_R,0 as diffType_S,0 as diffType_T,0 as diffType_C,0 as diffType_W,0 as diffType_X,0 as diffType_Y,'0' as adjtype,' ' as adjsutbillno,'0' as adjsutbillid,' ' as stdcostdiffbillno,'0' as stdcostdiffbillid" + DiffAllocHelper.getDiffAllocDimsAlias("cal_costrecord_subentity", allocDims, "");
    }

    private String getGroupCostRecordBizField(DiffAllocParamterEntry entry) {
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        Date enddate = new Date();
        if (entry != null) {
            enddate = entry.getEndDate();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] allocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims()).split(",");
        return "id as gcostrecordid,bookdate as gbizdate,auditdate as gauditdate,billno as gcostrecordbillno,entry.id as gcostrecordentryid,entry.seq as gcostrecordseq,billnumber as goutbillno,bizbillid as goutbillid,entry.id as goutbillentryid,entry.seq as goutbillseq,billtype as goutbilltypeid,billtype.name as goutbilltypename,bizentityobject.number as gbizentityobject,costaccount as gcostaccount,costaccount.calsystem as gcalsystemid,costaccount.calpolicy as gcalpolicyid,costaccount.costtype as gcosttypeid,costaccount.booktype as gcostaccounttypeid,entry.material as gmaterial,period as gperiodid,calorg as gcalorg,entry.owner as gowner,storageorgunit as gstorageorgunit,entry.warehouse as gwarehouse,entry.location as glocation,entry.project as gproject,entry.tracknumber as gtracknumber,entry.configuredcode as gconfiguredcode,entry.productline as gproductline,entry.ecostcenter as gecostcenter,entry.noupdatecalfields as gnoupdatecalfields,entry.stocktype as gstocktype,entry.assist as gassist,entry.lot as glot,entry.mversion as gmversion ,entry.calrange as gcalrangeid,entry.baseqty as gbaseqty,entry.standardcost as gstandardcost,entry.caldimension as gcaldimensionid,entry.caldimension.caldimension as gcaldimension,adminorg as gadminorg,biztype as gbiztype,transtype as gtranstype,supplier as gsupplier,customer as gcustomer,entry.queuetype as gqueuetype,entry.signnum as gsignnum " + exFieldHelper.getAllExFields("cal_costrecord_subentity", "g") + ",calbilltype as gcalbilltype,entry.accounttype as gaccounttype,entry.ownertype as gownertype,entry.invstatus as ginvstatus,entry.invtype as ginvtypeid,entry.baseunit as gbaseunitid,localcurrency as gcurrencyid,entry.subentrycostelement.costelement as gelementid,entry.subentrycostelement.costsubelement as gsubelementid,to_date('" + sdf.format(enddate) + "') as genddate ,'' as gcostdomain,0 as gdiffType_G,0 as gdiffType_H,0 as gdiffType_K,0 as gdiffType_M,0 as gdiffType_P,0 as gdiffType_Q,0 as gdiffType_R,0 as gdiffType_S,0 as gdiffType_T,0 as gdiffType_C,0 as gdiffType_W,0 as gdiffType_X,0 as gdiffType_Y, '0' as gadjtype,' ' as gadjsutbillno,'0' as gadjsutbillid,' ' as gstdcostdiffbillno,'0' as gstdcostdiffbillid" + DiffAllocHelper.getDiffAllocDimsAlias("cal_costrecord_subentity", allocDims, "g") + ",0L as gcalRecordEntryid, '0' as giscompleted, 0 as goccupiedqty";
    }

    private void buildBizRowMeta() {
        this.bizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getCostRecordBizFieldByOrmInput(null));
        this.bizDataMeta.getField("elementid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("subelementid").setDataType((DataType)DataType.LongType);
        this.bizDataMeta.getField("costdomain").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("diffType_G").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_H").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_K").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_M").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_P").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_Q").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_R").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_S").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_T").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_C").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_W").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_X").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("diffType_Y").setDataType((DataType)DataType.BigDecimalType);
        this.bizDataMeta.getField("enddate").setDataType((DataType)DataType.DateType);
        this.bizDataMeta.getField("adjtype").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("adjsutbillno").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("adjsutbillid").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("stdcostdiffbillno").setDataType((DataType)DataType.StringType);
        this.bizDataMeta.getField("stdcostdiffbillid").setDataType((DataType)DataType.StringType);
    }

    private void buildBizGroupRowMeta() {
        this.gbizDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", this.getGroupCostRecordBizField(null));
        this.gbizDataMeta.getField("gelementid").setDataType((DataType)DataType.LongType);
        this.gbizDataMeta.getField("gsubelementid").setDataType((DataType)DataType.LongType);
        this.gbizDataMeta.getField("gcostdomain").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gdiffType_G").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_H").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_K").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_M").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_P").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_Q").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_R").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_S").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_T").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_C").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_W").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_X").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("gdiffType_Y").setDataType((DataType)DataType.BigDecimalType);
        this.gbizDataMeta.getField("genddate").setDataType((DataType)DataType.DateType);
        this.gbizDataMeta.getField("gadjtype").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gadjsutbillno").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gadjsutbillid").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gstdcostdiffbillno").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gstdcostdiffbillid").setDataType((DataType)DataType.StringType);
        this.gbizDataMeta.getField("gcalRecordEntryid").setDataType((DataType)DataType.LongType);
        this.gbizDataMeta.getField("giscompleted").setDataType((DataType)DataType.BooleanType);
        this.gbizDataMeta.getField("goccupiedqty").setDataType((DataType)DataType.BigDecimalType);
    }

    private void buildGroupDataRowMeta() {
        this.groupDataMeta = ORM.create().createRowMeta("cal_account_grouprecord", "bizgrouprecordid,entryentity.costrecordentryid as calRecordEntryid,iscompleted,entryentity.occupiedqty as occupiedqty,entryentity.type as type,entryentity.weight as weight,0.0 as totalweight");
        this.groupDataMeta.getField("totalweight").setDataType((DataType)DataType.BigDecimalType);
        this.groupDataMeta.getField("bizgrouprecordid").setDataType((DataType)DataType.StringType);
    }

    private void updateBal(Object[] bills) {
        if (!this.allocParam.isNewBalance() || bills == null || bills.length < 1) {
            return;
        }
        Object[] billIds = new Object[bills.length];
        for (int index = 0; index < bills.length; ++index) {
            billIds[index] = ((DynamicObject)bills[index]).getPkValue();
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("isResetQueueType", "false");
        OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])billIds, (OperateOption)option);
    }

    private void reverseAmount(DynamicObject dynamicObject) {
        dynamicObject.set("adjustamt", (Object)dynamicObject.getBigDecimal("adjustamt").negate());
        dynamicObject.set("diff_g", (Object)dynamicObject.getBigDecimal("diff_g").negate());
        dynamicObject.set("diff_h", (Object)dynamicObject.getBigDecimal("diff_h").negate());
        dynamicObject.set("diff_k", (Object)dynamicObject.getBigDecimal("diff_k").negate());
        dynamicObject.set("diff_p", (Object)dynamicObject.getBigDecimal("diff_p").negate());
        dynamicObject.set("diff_q", (Object)dynamicObject.getBigDecimal("diff_q").negate());
        dynamicObject.set("diff_r", (Object)dynamicObject.getBigDecimal("diff_r").negate());
        dynamicObject.set("diff_m", (Object)dynamicObject.getBigDecimal("diff_m").negate());
        dynamicObject.set("diff_s", (Object)dynamicObject.getBigDecimal("diff_s").negate());
        dynamicObject.set("diff_t", (Object)dynamicObject.getBigDecimal("diff_t").negate());
        dynamicObject.set("diff_c", (Object)dynamicObject.getBigDecimal("diff_c").negate());
        DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subDynamicObj : subEntryEntity) {
            subDynamicObj.set("sub_adjustamt", (Object)subDynamicObj.getBigDecimal("sub_adjustamt").negate());
            subDynamicObj.set("ddiff_g", (Object)subDynamicObj.getBigDecimal("ddiff_g").negate());
            subDynamicObj.set("ddiff_h", (Object)subDynamicObj.getBigDecimal("ddiff_h").negate());
            subDynamicObj.set("ddiff_k", (Object)subDynamicObj.getBigDecimal("ddiff_k").negate());
            subDynamicObj.set("ddiff_p", (Object)subDynamicObj.getBigDecimal("ddiff_p").negate());
            subDynamicObj.set("ddiff_q", (Object)subDynamicObj.getBigDecimal("ddiff_q").negate());
            subDynamicObj.set("ddiff_r", (Object)subDynamicObj.getBigDecimal("ddiff_r").negate());
            subDynamicObj.set("ddiff_m", (Object)subDynamicObj.getBigDecimal("ddiff_m").negate());
            subDynamicObj.set("ddiff_s", (Object)subDynamicObj.getBigDecimal("ddiff_s").negate());
            subDynamicObj.set("ddiff_t", (Object)subDynamicObj.getBigDecimal("ddiff_t").negate());
            subDynamicObj.set("ddiff_c", (Object)subDynamicObj.getBigDecimal("ddiff_c").negate());
        }
    }

    private String getAllDiffFieldByNewBalance(DiffAllocParamterEntry entry) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String amtFields = "costdiff_bal as begindiffamt,diff_g_bal as ddiff_g,diff_h_bal as ddiff_h,diff_k_bal as ddiff_k,diff_m_bal as ddiff_m,diff_p_bal as ddiff_p,diff_q_bal as ddiff_q,diff_r_bal as ddiff_r,diff_s_bal as ddiff_s,diff_t_bal as ddiff_t,diff_c_bal as ddiff_c,diff_w_bal as ddiff_w,diff_x_bal as ddiff_x,diff_y_bal as ddiff_y,costdiff_bal as ddiff";
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffallocDims, "");
        return "id,material.id as materialid," + dySelectStr + ",costelement as costelement,costsubelement as costsubelement," + amtFields;
    }

    public Map<String, String> buildStdHeadData(DiffAllocParamterEntry entry, Set<Long> matIds) {
        HashMap<String, String> dataMap = new HashMap<String, String>(1000);
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        QFilter filter = new QFilter("period", "<=", (Object)entry.getPeriod());
        filter.and("endperiod", ">", (Object)entry.getPeriod());
        filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and("material", "in", matIds);
        filter.and("costsubelement", "=", (Object)773175233367685120L);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",calorg as org,costaccount as account,currency,storageorgunit as storageorg,baseunit,invtype,invstatus,owner,calrange,caldimension,period,warehouse as store,location as position,stocktype";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
        DataSet result = dataSet.groupBy(diffAllocDims.split(",")).max("org").max("account").max("currency").max("storageorg").max("material").max("baseunit").max("invtype").max("invstatus").max("owner").max("calrange").max("caldimension").max("period").max("store").max("position").max("stocktype").finish();
        for (Row row : result) {
            StringBuilder key = new StringBuilder();
            for (String field : diffAllocDims.split(",")) {
                key.append(row.getString(field)).append("@");
            }
            String mapKey = key.substring(0, key.toString().length() - 1);
            String value = row.getString("org") + "@" + row.getString("account") + "@" + row.getString("currency") + "@" + row.getString("storageorg") + "@" + row.getString("material") + "@" + row.getString("baseunit") + "@" + row.getString("invtype") + "@" + row.getString("invstatus") + "@" + row.getString("owner") + "@" + row.getString("calrange") + "@" + row.getString("caldimension") + "@" + row.getString("period") + "@" + row.getString("store") + "@" + row.getString("position") + "@" + row.getString("stocktype");
            dataMap.put(mapKey, value);
        }
        return dataMap;
    }

    public Date getEndDateByAccount(DiffAllocParamterEntry paramEntry) {
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        filter.and("entry.isenabled", "=", (Object)true);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.enddate enddate", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return new Date();
        }
        return dynamicObject.getDate("enddate");
    }

    public void buildStdBillDetails(DataSet dataSet, DiffAllocParamterEntry entry, Map<Long, Map<String, BigDecimal>> entryDiffMap, Map<String, Map<String, BigDecimal>> subEntryDiffMap, List<Long> materials) {
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        QFilter filter = new QFilter("period", "<=", (Object)entry.getPeriod());
        filter.and("endperiod", ">", (Object)entry.getPeriod());
        filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and("material", "in", materials);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",costsubelement,diff_g_bal diff_g,diff_h_bal diff_h,diff_k_bal diff_k,diff_p_bal diff_p,diff_q_bal diff_q,diff_r_bal diff_r,diff_m_bal diff_m,diff_s_bal diff_s,diff_t_bal diff_t,diff_c_bal diff_c,diff_x_bal diff_x,diff_w_bal diff_w,diff_y_bal diff_y";
        DataSet diffDetails = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_standcost_bal", (String)selectStr, (QFilter[])filter.toArray(), null);
        JoinDataSet joinDataSet = diffDetails.join(dataSet);
        for (String field : diffAllocDims.split(",")) {
            joinDataSet.on(field, field);
        }
        DataSet stdDiffDetails = joinDataSet.select(diffDetails.getRowMeta().getFieldNames(), new String[]{"id"}).finish();
        diffAllocDims = diffAllocDims + ",id";
        DataSet entryDiffDs = stdDiffDetails.copy().groupBy(diffAllocDims.split(",")).sum("diff_g").sum("diff_h").sum("diff_k").sum("diff_p").sum("diff_q").sum("diff_r").sum("diff_m").sum("diff_s").sum("diff_t").sum("diff_c").sum("diff_x").sum("diff_w").sum("diff_y").finish();
        for (Row row : entryDiffDs) {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
            for (String field : entryDiffField) {
                BigDecimal diff = row.getBigDecimal(field) == null ? BigDecimal.ZERO : row.getBigDecimal(field);
                map.put(field, diff);
            }
            entryDiffMap.put(row.getLong("id"), map);
        }
        diffAllocDims = diffAllocDims + ",costsubelement";
        DataSet subEntryDs = stdDiffDetails.groupBy(diffAllocDims.split(",")).sum("diff_g").sum("diff_h").sum("diff_k").sum("diff_p").sum("diff_q").sum("diff_r").sum("diff_m").sum("diff_s").sum("diff_t").sum("diff_c").sum("diff_x").sum("diff_w").sum("diff_y").finish();
        for (Row row : subEntryDs) {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
            for (String field : entryDiffField) {
                BigDecimal diff = row.getBigDecimal(field) == null ? BigDecimal.ZERO : row.getBigDecimal(field);
                map.put("d" + field, diff);
            }
            subEntryDiffMap.put(row.getString("id") + "@" + row.getString("costsubelement"), map);
        }
    }

    public DataSet getBalStandCost(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        DataSet result = null;
        List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(entry.getCostAccountId(), entry.getPeriodId(), "<");
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(periodBatchSize);
        Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",costelement as costelement,costsubelement as costsubelement,standardcost_bal as periodstandardcost";
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)entry.getPeriod());
            filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
            filter.and("accounttype", "=", (Object)"D");
            filter.and("material", "in", matIds);
            if (balCompress.booleanValue()) {
                qFilterList.add(filter);
                continue;
            }
            if (result == null) {
                result = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), null);
                continue;
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), null);
            result = result.union(dataSet);
        }
        if (balCompress.booleanValue()) {
            String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, true, null, qFilterList});
            DataSet dataSet = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"getBalStandCost"), true);
            dataSet = dataSet.select(selectStr);
            return dataSet;
        }
        return result;
    }

    public DataSet getCostRecordStdCost(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        QFilter filter = new QFilter("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)entry.getStartDate());
        filter.and("bookdate", "<=", (Object)entry.getEndDate());
        filter.and("period", "=", (Object)entry.getPeriodId());
        filter.and("isinitbill", "=", (Object)false);
        filter.and("issplitcreate", "=", (Object)false);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entry.material", "in", matIds);
        filter.and("entry.accounttype", "=", (Object)"D");
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffAllocDims, "");
        dySelectStr = dySelectStr + ",entry.queuetype queuetype,entry.subentrycostelement.costelement costelement,entry.subentrycostelement.costsubelement costsubelement,entry.subentrycostelement.sub_standardcost*entry.signnum as sub_standardcost,entry.noupdatecalfields noupdatecalfields";
        DataSet stdCostBalanceData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)dySelectStr, (QFilter[])filter.toArray(), null);
        stdCostBalanceData = stdCostBalanceData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(stdCostBalanceData.getRowMeta()));
        String groupDims = diffAllocDims + ",costelement,costsubelement";
        DataSet inDataSet = stdCostBalanceData.filter("queuetype = '0'");
        inDataSet = inDataSet.addField("0.00", "outstandardcost").select(groupDims + ",sub_standardcost as instandardcost,outstandardcost");
        DataSet outDataSet = stdCostBalanceData.filter("queuetype = '1'");
        outDataSet = outDataSet.addField("0.00", "instandardcost").select(groupDims + ",instandardcost,sub_standardcost as outstandardcost");
        DataSet unionDs = inDataSet.union(outDataSet);
        unionDs = unionDs.groupBy(groupDims.split(",")).sum("instandardcost").sum("outstandardcost").finish();
        unionDs = unionDs.select(groupDims + ",instandardcost-outstandardcost as standardcost");
        return unionDs;
    }

    public DataSet getStandDiff(DiffAllocParamterEntry entry, Set<Long> matIds) {
        String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        if (!diffAllocDims.contains("material")) {
            diffAllocDims = diffAllocDims + ",material";
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)entry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)entry.getStartDate());
        filter.and("bookdate", "<=", (Object)entry.getEndDate());
        filter.and("period", "=", (Object)entry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "=", (Object)"C1");
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and("entryentity.material.id", "in", matIds);
        filter.and("entryentity.queuetype", "=", (Object)"0");
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "");
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt*entryentity.signnum as sub_adjustamt,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet(ALGOKEY, "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        String[] fieldNames = allDataSet.getRowMeta().getFieldNames();
        StringJoiner joiner = new StringJoiner(",");
        for (String fieldName : fieldNames) {
            if (fieldName.equalsIgnoreCase("NOUPDATECALFIELDS")) continue;
            joiner.add(fieldName.toLowerCase());
        }
        String selectSql = joiner + ",noupdatecalfields";
        allDataSet = allDataSet.select(selectSql);
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        diffAllocDims = diffAllocDims + ",costelement,costsubelement";
        return allDataSet.groupBy(diffAllocDims.split(",")).sum("sub_adjustamt").finish();
    }
}

