/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocService;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.util.CommonUtils;
import kd.fi.calx.algox.util.JsonUtils;

public class DiffAllocNewTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DiffAllocNewTask.class);

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        String batchInfo = (String)paramMap.get("batchInfo");
        logger.info("task's-currBatch:" + batchInfo + ":DiffAllocNewTask-ALL begin");
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ISDO_DIFFALLOC_BY_TASK).booleanValue()) {
            return;
        }
        MessageInfo msgInfo = new MessageInfo();
        ArrayList<Long> userList = new ArrayList<Long>();
        userList.add(ctx.getCurrUserId());
        msgInfo.setUserIds(userList);
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a", (String)"DiffAllocTask_1", (String)"fi-calx-algox", (Object[])new Object[0]));
        try {
            Long paramId = JsonUtils.jsonToObj(paramMap.get("paramid").toString(), Long.class);
            DynamicObject[] params = BusinessDataServiceHelper.load((String)"cal_taskparam", (String)"param_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paramId)});
            DiffAllocParamter param = (DiffAllocParamter)SerializationUtils.fromJsonString((String)params[0].getString("param_tag"), DiffAllocParamter.class);
            DiffAllocParamter newParam = param.copy(Boolean.TRUE);
            newParam.setBatchInfo(batchInfo);
            DiffAllocService service = new DiffAllocService();
            service.alloc(newParam);
            String msg = String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u6210\u529f,%1$s\u6279", (String)"DiffAllocService_4", (String)"fi-calx-algox", (Object[])new Object[0]), batchInfo);
            msgInfo.setContent(msg);
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)("update t_cal_taskparam set fstatus = 'B' where fid = " + paramId));
        }
        catch (Throwable e) {
            msgInfo.setContent(CommonUtils.getLogMessage(e));
            logger.error("\u5dee\u5f02\u5206\u644a\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", e);
            throw new KDBizException(e, new ErrorCode("", ""), new Object[0]);
        }
        finally {
            MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
            logger.info("task's-currBatch:" + batchInfo + ":DiffAllocNewTask-ALL end");
        }
    }
}

