/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

public class DiffAllocParamterEntry
implements Serializable {
    private static final long serialVersionUID = 7467278066392608469L;
    private Long costAccountId = 0L;
    private Long costAccountTypeId = 0L;
    private String costAccountName;
    private Long calOrgId = 0L;
    private Long calSystemId = 0L;
    private Long calPolicyId = 0L;
    private Long periodId = 0L;
    private int period = 0;
    private Long calRangeId = 0L;
    private Date startDate;
    private Date endDate;
    private Set<Object> matIdSet = new HashSet<Object>(16);
    private List<Map<String, Object>> allocDimValsList = new ArrayList<Map<String, Object>>(16);
    private Set<Long> sortMatIdSet = new HashSet<Long>(16);
    private Set<String> allocDimKeyCols = new HashSet<String>(16);
    private Set<Object> initMatIdSet = new HashSet<Object>(16);
    private Set<String> negativeAllocDimKeyCols = new HashSet<String>(16);

    public Set<Object> getInitMatIdSet() {
        return this.initMatIdSet;
    }

    public void setInitMatIdSet(Set<Object> initMatIdSet) {
        this.initMatIdSet = initMatIdSet;
    }

    public DiffAllocParamterEntry() {
    }

    public Set<String> getNegativeAllocDimKeyCols() {
        return this.negativeAllocDimKeyCols;
    }

    public void setNegativeAllocDimKeyCols(Set<String> negativeAllocDimKeyCols) {
        this.negativeAllocDimKeyCols = negativeAllocDimKeyCols;
    }

    public DiffAllocParamterEntry(String key, Set<Object> matIdSet, Set<String> allocDimKeyCols, List<Map<String, Object>> allocDimValsList) {
        String[] keys = key.split("@");
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)keys[0], (String)"cal_bd_costaccount", (String)"name,calorg,calsystem,calpolicy,booktype");
        this.costAccountId = costAccount.getLong("id");
        this.costAccountTypeId = costAccount.getDynamicObject("booktype").getLong("id");
        this.costAccountName = costAccount.getString("name");
        this.calOrgId = costAccount.getDynamicObject("calorg").getLong("id");
        this.calSystemId = costAccount.getDynamicObject("calsystem").getLong("id");
        this.calPolicyId = costAccount.getDynamicObject("calpolicy").getLong("id");
        this.calRangeId = Long.valueOf(keys[1]);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(this.costAccountId);
        if (currentPeriod == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u53c2\u4e0e\u51fa\u5e93\u6838\u7b97\u3002", (String)"CalCulateOutParamEntry_3", (String)"fi-calx-algox", (Object[])new Object[0]), costAccount.getString("name"));
            throw new KDBizException(msg);
        }
        this.periodId = currentPeriod.getLong("id");
        this.startDate = currentPeriod.getDate("begindate");
        this.endDate = currentPeriod.getDate("enddate");
        this.period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
        this.matIdSet = matIdSet;
        this.allocDimKeyCols = allocDimKeyCols;
        this.allocDimValsList = allocDimValsList;
    }

    public String getCostAccountName() {
        return this.costAccountName;
    }

    public void setCostAccountName(String costAccountName) {
        this.costAccountName = costAccountName;
    }

    public Long getCostAccountId() {
        return this.costAccountId;
    }

    public void setCostAccountId(Long costAccountId) {
        this.costAccountId = costAccountId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getCalRangeId() {
        return this.calRangeId;
    }

    public void setCalRangeId(Long calRangeId) {
        this.calRangeId = calRangeId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Set<Object> getMatIdSet() {
        return this.matIdSet;
    }

    public Set<String> getAllocDimKeyCols() {
        return this.allocDimKeyCols;
    }

    public void setAllocDimKeyCols(Set<String> allocDimKeyCols) {
        this.allocDimKeyCols = allocDimKeyCols;
    }

    public List<Map<String, Object>> getAllocDimValsList() {
        return this.allocDimValsList;
    }

    public void setAllocDimValsList(List<Map<String, Object>> allocDimValsList) {
        this.allocDimValsList = allocDimValsList;
    }

    public void addMatIds(Set<Object> matIdSet, Set<String> allocDimKeyCols, List<Map<String, Object>> allocDimValsList) {
        if (matIdSet == null) {
            return;
        }
        this.matIdSet.addAll(matIdSet);
        this.allocDimKeyCols.addAll(allocDimKeyCols);
        this.allocDimValsList.addAll(allocDimValsList);
    }

    public void addCircleMatIds(List<Set<Long>> circleMatIdsList) {
        if (circleMatIdsList == null || circleMatIdsList.isEmpty()) {
            return;
        }
    }

    public Long getCalOrgId() {
        return this.calOrgId;
    }

    public void setCalOrgId(Long calOrgId) {
        this.calOrgId = calOrgId;
    }

    public Long getCalSystemId() {
        return this.calSystemId;
    }

    public void setCalSystemId(Long calSystemId) {
        this.calSystemId = calSystemId;
    }

    public Long getCalPolicyId() {
        return this.calPolicyId;
    }

    public void setCalPolicyId(Long calPolicyId) {
        this.calPolicyId = calPolicyId;
    }

    public void setMatIdSet(Set<Object> matIdSet) {
        this.matIdSet = matIdSet;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public Set<Long> getSortMatIdSet() {
        return this.sortMatIdSet;
    }

    public void setSortMatIdSet(Set<Long> sortMatIdSet) {
        this.sortMatIdSet = sortMatIdSet;
    }

    public Long getCostAccountTypeId() {
        return this.costAccountTypeId;
    }

    public void setCostAccountTypeId(Long costAccountTypeId) {
        this.costAccountTypeId = costAccountTypeId;
    }

    public DiffAllocParamterEntry copy(Boolean isDeepCopy) {
        DiffAllocParamterEntry paramEntry = new DiffAllocParamterEntry();
        paramEntry.setCalOrgId(this.calOrgId);
        paramEntry.setCalPolicyId(this.calPolicyId);
        paramEntry.setCalRangeId(this.calRangeId);
        paramEntry.setCalSystemId(this.calSystemId);
        paramEntry.setCostAccountId(this.costAccountId);
        paramEntry.setCostAccountTypeId(this.costAccountTypeId);
        paramEntry.setEndDate(this.endDate);
        paramEntry.setPeriodId(this.periodId);
        paramEntry.setStartDate(this.startDate);
        paramEntry.setPeriod(this.period);
        if (this.sortMatIdSet.size() > 0) {
            for (Long l : this.sortMatIdSet) {
                paramEntry.getSortMatIdSet().add(l);
            }
        }
        if (this.matIdSet != null && this.matIdSet.size() > 0) {
            for (Object object : this.matIdSet) {
                paramEntry.getMatIdSet().add(object);
            }
        }
        for (String string : this.allocDimKeyCols) {
            paramEntry.getAllocDimKeyCols().add(string);
        }
        if (isDeepCopy.booleanValue()) {
            for (Map map : this.allocDimValsList) {
                HashMap currAllocDimVals = new HashMap(16);
                for (Map.Entry val : map.entrySet()) {
                    currAllocDimVals.put(val.getKey(), val.getValue());
                }
                paramEntry.allocDimValsList.add(currAllocDimVals);
            }
        }
        return paramEntry;
    }
}

