/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.io.IOException;
import java.util.HashMap;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocServiceNew;
import kd.fi.calx.algox.diff.helper.AllocRecordHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class DiffAllocService {
    private static final Log logger = LogFactory.getLog(DiffAllocService.class);
    private static final String DLOCK_KEY = "calx_diffalloc#";
    private static final String CBFIELDS = "calorg,owner,storageorgunit,warehouse,location,assist,lot,";

    public void allocByJob(DiffAllocParamter param) {
        DiffAllocHelper.checkBalModel();
        HashMap<String, String> jobParams = new HashMap<String, String>();
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException var5) {
            AllocRecordHelper.updateAllocRecord(param, "C");
            throw new KDBizException(var5.getMessage());
        }
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a \u64cd\u4f5c\u4eba: %1$s", (String)"DiffAllocService_2", (String)"fi-calx-algox", (Object[])new Object[0]), RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TENGYFUC2TA");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.calx.algox.diff.DiffAllocTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        JobClient.dispatch((JobInfo)job);
    }

    public void alloc(DiffAllocParamter param) {
        DiffAllocHelper.checkBalModel();
        if (param.isOnlyAdjustDiff()) {
            DiffAllocServiceNew service = new DiffAllocServiceNew();
            service.dealAdjustDiff(param);
            return;
        }
        if ("B".equals(CalDbParamServiceHelper.getString(CalDbParamConstant.DIFFALLOC_MODEL, null))) {
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocModel:B");
            DiffAllocServiceNew service = new DiffAllocServiceNew();
            service.alloc(param);
            return;
        }
    }
}

