/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.LinearEquationsDataFactory;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalLogHelper;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public class DiffRateCalcService
implements Serializable {
    private static final Log logger = LogFactory.getLog(DiffRateCalcService.class);
    private static String[] diffTypes = new String[]{"G", "H", "K", "M", "P", "Q", "R", "S", "T", "C", "X", "W", "Y"};
    private LinearEquationsDataFactory linearEqDataFactory;
    private Set<Long> crossMonthRecordEntryIds;
    private Map<String, BigDecimal> periodOutputQtyMap;
    private Map<String, BigDecimal> periodFixedOutputQtyMap;
    private Map<String, Map<String, BigDecimal>> transInQtyWithDmMap;
    private Map<String, BigDecimal> periodIntputQtyMap;
    private Map<String, BigDecimal> crossPeriodOutputDiffMap;
    private Map<String, BigDecimal> periodInputDiffMap;
    private Map<String, BigDecimal> periodBeginDiffMap;

    public DiffRateCalcService(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, Set<Long> entryIds) {
        this.crossMonthRecordEntryIds = entryIds;
        this.linearEqDataFactory = new LinearEquationsDataFactory(param, paramEntry);
        Boolean startMultiThread = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.START_MULTI_THREAD);
        if (startMultiThread == null) {
            startMultiThread = false;
        }
        if (startMultiThread.booleanValue()) {
            this.buildCalcParamByThread(param, this.linearEqDataFactory);
        } else {
            Long startTime = System.currentTimeMillis();
            Boolean splitQuery = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.QUERY_HEAD_ENTRY_SPILT);
            this.periodOutputQtyMap = splitQuery != false ? this.linearEqDataFactory.getCurrOutputQtyByBillNew() : this.linearEqDataFactory.getCurrOutputQtyByBill(this.crossMonthRecordEntryIds);
            Long endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCurrOutputQtyByBill_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.periodFixedOutputQtyMap = this.linearEqDataFactory.getPeriodFixedOutputQty(this.crossMonthRecordEntryIds);
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCurrOutputQtyByBill_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.transInQtyWithDmMap = this.linearEqDataFactory.getCalcDmTransInQty(this.crossMonthRecordEntryIds);
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCalcDmTransInQty_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.periodIntputQtyMap = splitQuery != false ? this.linearEqDataFactory.getInputQtyByBillNew() : this.linearEqDataFactory.getInputQtyByBill();
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getInputQtyByBill_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.crossPeriodOutputDiffMap = this.linearEqDataFactory.getCrossMonthOutDiffData(this.crossMonthRecordEntryIds);
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCrossMonthOutDiffData_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.periodInputDiffMap = this.linearEqDataFactory.getPeriodInDiffDataByBill();
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getPeriodInDiffDataByBill_time:" + (endTime - startTime) + "ms");
            startTime = System.currentTimeMillis();
            this.periodBeginDiffMap = this.linearEqDataFactory.getPeriodBeginDiffData();
            endTime = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getPeriodBeginDiffData_time:" + (endTime - startTime) + "ms");
        }
    }

    private void buildCalcParamByThread(DiffAllocParamter param, final LinearEquationsDataFactory linearEqDataFactory) {
        logger.info("buildCalcParamByThread start");
        final CountDownLatch latch = new CountDownLatch(7);
        Long startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.periodOutputQtyMap = linearEqDataFactory.getCurrOutputQtyByBill(DiffRateCalcService.this.crossMonthRecordEntryIds);
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 1 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        Long endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCurrOutputQtyByBill_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.periodFixedOutputQtyMap = linearEqDataFactory.getPeriodFixedOutputQty(DiffRateCalcService.this.crossMonthRecordEntryIds);
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 2 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCurrOutputQtyByBill_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.transInQtyWithDmMap = linearEqDataFactory.getCalcDmTransInQty(DiffRateCalcService.this.crossMonthRecordEntryIds);
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 3 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCalcDmTransInQty_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.periodIntputQtyMap = linearEqDataFactory.getInputQtyByBill();
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 4 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getInputQtyByBill_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.crossPeriodOutputDiffMap = linearEqDataFactory.getCrossMonthOutDiffData(DiffRateCalcService.this.crossMonthRecordEntryIds);
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 5 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getCrossMonthOutDiffData_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.periodInputDiffMap = linearEqDataFactory.getPeriodInDiffDataByBill();
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 6 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getPeriodInDiffDataByBill_time:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DiffRateCalcService.this.periodBeginDiffMap = linearEqDataFactory.getPeriodBeginDiffData();
                }
                catch (Exception e) {
                    logger.error("CountDownLatch -> countDown 6 error ", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error("DiffRateCalcService->latch.await() error ", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":linearEqDataFactory.getPeriodBeginDiffData_time:" + (endTime - startTime) + "ms");
    }

    public Map<String, BigDecimal> calcRate(final DiffAllocParamter param) {
        final HashMap<String, BigDecimal> diffRateMap = new HashMap<String, BigDecimal>();
        Boolean startMultiThread = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.START_MULTI_THREAD);
        if (startMultiThread == null) {
            startMultiThread = false;
        }
        final Map<String, List<String>> balanceDmDataMap = this.linearEqDataFactory.getBalanceDmData();
        if (startMultiThread.booleanValue()) {
            final CountDownLatch latch = new CountDownLatch(diffTypes.length);
            for (final String diffType : diffTypes) {
                ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (Map.Entry balanceDmData : balanceDmDataMap.entrySet()) {
                                diffRateMap.putAll(DiffRateCalcService.this.resolve(param, diffType, (String)balanceDmData.getKey(), (List)balanceDmData.getValue()));
                            }
                        }
                        catch (Exception e) {
                            logger.error("CountDownLatch -> countDown 1 error ", (Throwable)e);
                            throw new KDBizException(e.getMessage());
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("calcRate->latch.await() error ", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else {
            for (String diffType : diffTypes) {
                for (Map.Entry<String, List<String>> balanceDmData : balanceDmDataMap.entrySet()) {
                    diffRateMap.putAll(this.resolve(param, diffType, balanceDmData.getKey(), balanceDmData.getValue()));
                }
            }
        }
        return diffRateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BigDecimal> resolve(DiffAllocParamter param, String diffType, String balanceDmDataKey, List<String> balanceDmDataValue) {
        Long logTag = System.currentTimeMillis();
        DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_resolve_\u65b9\u7a0b\u7ec4\u5212\u5206\u7ef4\u5ea6\uff1a%2$s", (String)"DiffRateCalcService_0", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, balanceDmDataKey));
        HashMap<String, BigDecimal> resolveRsMap = new HashMap<String, BigDecimal>();
        Long startTime = System.currentTimeMillis();
        Set<String> noOutputDims = this.getNoOutputDims(diffType, balanceDmDataKey, balanceDmDataValue);
        Long endTime = System.currentTimeMillis();
        endTime = System.currentTimeMillis();
        BigDecimal[] constantMatrix = this.setConstantMatrix(diffType, balanceDmDataKey, balanceDmDataValue, logTag);
        endTime = System.currentTimeMillis();
        endTime = System.currentTimeMillis();
        BigDecimal[][] variableMatrix = this.setVariableMatrix(diffType, balanceDmDataKey, balanceDmDataValue, logTag);
        endTime = System.currentTimeMillis();
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(param.getAllocDims(), param.getEquationSetDims());
        StringBuilder currEquDims = new StringBuilder();
        String[] dims = diffallocDims.split(",");
        for (String dim : dims) {
            currEquDims.append(dim).append("#");
        }
        currEquDims.append("elementid#");
        currEquDims.append("subelementid");
        currEquDims.append("\r\n");
        for (String value : balanceDmDataValue) {
            currEquDims.append(value).append("\r\n");
        }
        BigDecimal[] resolveResult = null;
        try {
            resolveResult = this.linearEqDataFactory.resolveNew(variableMatrix, constantMatrix);
        }
        catch (Exception e) {
            if (!e.toString().contains(LocalizedFormats.AT_LEAST_ONE_ROW.getSourceString()) && !e.toString().contains(LocalizedFormats.AT_LEAST_ONE_COLUMN.getSourceString())) {
                logger.info("\u7269\u6599\u89e3\u65b9\u7a0b\u51fa\u9519\uff0c\u76f8\u5173\u4fe1\u606f\uff1a" + balanceDmDataKey);
                logger.error("\u7269\u6599\u89e3\u65b9\u7a0b\u51fa\u9519\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
                CalLogHelper.alwaysPrintLog(ResManager.loadKDString((String)"\u65b9\u7a0b\u7ec4\u65e0\u89e3\u3002", (String)"DiffRateCalcService_17", (String)"fi-calx-algox", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u7ef4\u5ea6\u7ec4\u5408\uff1a%1$s\uff0c\u89e3\u65b9\u7a0b\u51fa\u9519:%2$s", (String)"DiffRateCalcService_18", (String)"fi-calx-algox", (Object[])new Object[0]), currEquDims, e.toString()));
            }
        }
        finally {
            if (this.linearEqDataFactory != null) {
                this.linearEqDataFactory.close();
            }
        }
        int index = 0;
        for (String value : balanceDmDataValue) {
            String valueStr = this.getDomainStr(value);
            if (noOutputDims.contains(value)) continue;
            String key = diffType + "@" + valueStr;
            if (resolveResult != null && index < resolveResult.length && resolveResult[index] != null && BigDecimal.ZERO.compareTo(resolveResult[index]) != 0) {
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s\u5dee\u5f02\u7387\uff1a%2$s", (String)"DiffRateCalcService_1", (String)"fi-calx-algox", (Object[])new Object[0]), key, resolveResult[index]));
                resolveRsMap.put(key, resolveResult[index]);
            }
            ++index;
        }
        return resolveRsMap;
    }

    private Set<String> getNoOutputDims(String diffType, String balanceDmDataKey, List<String> balanceDmDataValue) {
        HashSet<String> noOutPutDims = new HashSet<String>(16);
        for (String value : balanceDmDataValue) {
            StringBuilder qtyKey = new StringBuilder();
            String[] values = value.split("@");
            for (int i = 0; i < values.length - 2; ++i) {
                qtyKey.append(values[i]).append("@");
            }
            BigDecimal periodOutputQty = this.periodOutputQtyMap.get(qtyKey.substring(0, qtyKey.length() - 1));
            if (periodOutputQty != null) continue;
            noOutPutDims.add(value);
        }
        return noOutPutDims;
    }

    private BigDecimal[] setConstantMatrix(String diffType, String balanceDmDataKey, List<String> balanceDmDataValue, Long logTag) {
        int matrixCount = balanceDmDataValue.size();
        BigDecimal[] constantMatrix = new BigDecimal[matrixCount];
        ArrayList<Integer> noOutPutIndex = new ArrayList<Integer>(16);
        int index = 0;
        for (String value : balanceDmDataValue) {
            String diffKey = diffType + "@" + value;
            StringBuilder qtyKey = new StringBuilder();
            String[] values = value.split("@");
            for (int i = 0; i < values.length - 2; ++i) {
                qtyKey.append(values[i]).append("@");
            }
            String qtyKeyStr = qtyKey.substring(0, qtyKey.length() - 1);
            BigDecimal crossPeriodOutDiff = this.crossPeriodOutputDiffMap.get(diffKey);
            BigDecimal periodInputDiff = this.periodInputDiffMap.get(diffKey);
            BigDecimal periodBeginDiff = this.periodBeginDiffMap.get(diffKey);
            BigDecimal periodOutputQty = this.periodOutputQtyMap.get(qtyKeyStr);
            BigDecimal periodIntputQty = this.periodIntputQtyMap.get(qtyKeyStr);
            if (crossPeriodOutDiff == null) {
                crossPeriodOutDiff = BigDecimal.ZERO;
            }
            if (periodInputDiff == null) {
                periodInputDiff = BigDecimal.ZERO;
            }
            if (periodBeginDiff == null) {
                periodBeginDiff = BigDecimal.ZERO;
            }
            if (periodOutputQty == null) {
                noOutPutIndex.add(index++);
                continue;
            }
            if (periodIntputQty == null) {
                periodIntputQty = BigDecimal.ZERO;
            }
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u8de8\u671f\u8f6c\u51fa\u5dee\u5f02%2$s:%3$s", (String)"DiffRateCalcService_2", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffKey, crossPeriodOutDiff.toString()));
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u6536\u5165\u5dee\u5f02\uff08\u542b\u8de8\u671f\uff09%2$s:%3$s", (String)"DiffRateCalcService_3", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffKey, periodInputDiff.toString()));
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u671f\u521d\u5dee\u5f02%2$s:%3$s", (String)"DiffRateCalcService_4", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffKey, periodBeginDiff.toString()));
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u672c\u671f\u53d1\u51fa\u603b\u6570\u91cf%2$s:%3$s", (String)"DiffRateCalcService_5", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffKey, periodOutputQty.toString()));
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u672c\u671f\u6536\u5165\u603b\u6570\u91cf%2$s:%3$s", (String)"DiffRateCalcService_6", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffKey, periodIntputQty.toString()));
            BigDecimal crossPeriodRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(periodOutputQty) != 0) {
                crossPeriodRate = crossPeriodOutDiff.multiply(periodIntputQty);
            }
            BigDecimal periodInputRate = BigDecimal.ZERO;
            BigDecimal periodBeginRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(periodIntputQty) != 0) {
                periodInputRate = periodInputDiff.multiply(periodOutputQty);
                periodBeginRate = periodBeginDiff.multiply(periodOutputQty);
            }
            constantMatrix[index++] = crossPeriodRate.subtract(periodInputRate).subtract(periodBeginRate);
        }
        int finalDmCount = matrixCount - noOutPutIndex.size();
        BigDecimal[] finalConstantMatrix = new BigDecimal[finalDmCount];
        int finalindex = 0;
        if (!noOutPutIndex.isEmpty()) {
            for (int i = 0; i < matrixCount; ++i) {
                if (noOutPutIndex.contains(i)) continue;
                finalConstantMatrix[finalindex++] = constantMatrix[i];
            }
            constantMatrix = finalConstantMatrix;
        }
        StringBuilder constantMatrixStr = new StringBuilder();
        for (BigDecimal value : constantMatrix) {
            constantMatrixStr.append(value).append("\n");
        }
        DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setConstantMatrix_\u5e38\u91cf\u7cfb\u6570\uff1a%2$s@%3$s:%4$s", (String)"DiffRateCalcService_16", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffType, balanceDmDataKey, constantMatrixStr));
        return constantMatrix;
    }

    private BigDecimal[][] setVariableMatrix(String diffType, String balanceDmDataKey, List<String> balanceDmDataValue, Long logTag) {
        int matrixCount = balanceDmDataValue.size();
        BigDecimal[][] variableMatrix = new BigDecimal[matrixCount][matrixCount];
        ArrayList<Integer> noOutPutIndex = new ArrayList<Integer>(16);
        for (int index = 0; index < balanceDmDataValue.size(); ++index) {
            int secdIndex = 0;
            String firsDmKey = balanceDmDataValue.get(index);
            StringBuilder firsDmKeySb = new StringBuilder();
            String[] firsDmKeys = firsDmKey.split("@");
            for (int i = 0; i < firsDmKeys.length - 2; ++i) {
                firsDmKeySb.append(firsDmKeys[i]);
                firsDmKeySb.append("@");
            }
            String firsDmKeyStr = firsDmKeySb.substring(0, firsDmKeySb.length() - 1);
            Map<String, BigDecimal> transInDataMap = this.transInQtyWithDmMap.get("IN#" + firsDmKeyStr);
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_transInDataMap\u662f\u5426\u4e3a\u7a7a\uff1a%2$s", (String)"DiffRateCalcService_7", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, transInDataMap == null));
            Map<String, BigDecimal> transOutDataMap = this.transInQtyWithDmMap.get("OUT#" + firsDmKeyStr);
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_transOutDataMap\u662f\u5426\u4e3a\u7a7a\uff1a%2$s", (String)"DiffRateCalcService_8", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, transOutDataMap == null));
            BigDecimal inputQty = this.periodIntputQtyMap.get(firsDmKeyStr);
            DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u6536\u5165\u603b\u6570\u91cf%2$s:%3$s", (String)"DiffRateCalcService_9", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, inputQty));
            BigDecimal periodOutputQty = this.periodOutputQtyMap.get(firsDmKeyStr);
            DiffAllocHelper.writeLog(logger, ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u53d1\u51fa\u603b\u6570\u91cf%2$s:%3$s", (String)"DiffRateCalcService_10", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, periodOutputQty);
            if (inputQty == null) {
                inputQty = BigDecimal.ZERO;
            }
            if (periodOutputQty == null) {
                noOutPutIndex.add(index);
                continue;
            }
            for (String value : balanceDmDataValue) {
                String secDmKeyStr = "";
                String[] secDmKeys = value.split("@");
                StringBuilder secDmKeySb = new StringBuilder();
                for (int i = 0; i < secDmKeys.length - 2; ++i) {
                    secDmKeySb.append(secDmKeys[i]);
                    secDmKeySb.append("@");
                }
                secDmKeyStr = secDmKeySb.substring(0, secDmKeySb.length() - 1);
                BigDecimal transQty = BigDecimal.ZERO;
                if (transInDataMap != null && transInDataMap.containsKey(secDmKeyStr)) {
                    transQty = transInDataMap.get(secDmKeyStr);
                }
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u4e92\u8f6c\u6570\u91cf%2$s->%3$s:%4$s", (String)"DiffRateCalcService_11", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, secDmKeyStr, transQty));
                BigDecimal periodOutputQtyNoCross = BigDecimal.ZERO;
                BigDecimal transOutQty = BigDecimal.ZERO;
                if (secDmKeyStr.equals(firsDmKeyStr) && this.periodOutputQtyMap.get(secDmKeyStr) != null) {
                    BigDecimal fixedOutQty = this.periodFixedOutputQtyMap.get(secDmKeyStr);
                    DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u56fa\u5b9a\u51fa\u6570\u91cf%2$s->%3$s:%4$s", (String)"DiffRateCalcService_12", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, secDmKeyStr, fixedOutQty));
                    periodOutputQtyNoCross = this.periodOutputQtyMap.get(secDmKeyStr).subtract(fixedOutQty == null ? BigDecimal.ZERO : fixedOutQty);
                }
                if (transOutDataMap != null && transOutDataMap.get(secDmKeyStr) != null) {
                    transOutQty = transOutDataMap.get(secDmKeyStr) == null ? BigDecimal.ZERO : transOutDataMap.get(secDmKeyStr);
                    DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u7b2c\u4e8c\u7ef4\u5ea6\u8f6c\u51fa\u51fa\u6570\u91cf%2$s->%3$s:%4$s", (String)"DiffRateCalcService_13", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, secDmKeyStr, transOutQty));
                }
                DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$s_DiffRateCalcService_setVariableMatrix_\u672c\u671f\u53d1\u51fa\uff08\u4e0d\u542b\u8de8\u671f\uff09%2$s->%3$s:%4$s", (String)"DiffRateCalcService_14", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, firsDmKeyStr, secDmKeyStr, periodOutputQtyNoCross));
                BigDecimal inDiffRate = BigDecimal.ZERO;
                if (inputQty != null && BigDecimal.ZERO.compareTo(inputQty) != 0) {
                    inDiffRate = transQty.multiply(periodOutputQty);
                }
                BigDecimal outDiffRate = BigDecimal.ZERO;
                BigDecimal transOutRate = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(periodOutputQty) != 0) {
                    outDiffRate = periodOutputQtyNoCross.multiply(inputQty);
                    transOutRate = transOutQty.multiply(inputQty);
                }
                variableMatrix[index][secdIndex++] = inDiffRate.subtract(outDiffRate).subtract(transOutRate);
            }
        }
        int finalDmCount = matrixCount - noOutPutIndex.size();
        BigDecimal[][] tempVariableMatrix = new BigDecimal[finalDmCount][matrixCount];
        BigDecimal[][] finalVariableMatrix = new BigDecimal[finalDmCount][finalDmCount];
        int tempindex = 0;
        if (!noOutPutIndex.isEmpty()) {
            int i;
            for (i = 0; i < matrixCount; ++i) {
                if (noOutPutIndex.contains(i)) continue;
                tempVariableMatrix[tempindex++] = variableMatrix[i];
            }
            for (i = 0; i < finalDmCount; ++i) {
                tempindex = 0;
                for (int j = 0; j < matrixCount; ++j) {
                    if (noOutPutIndex.contains(j)) continue;
                    finalVariableMatrix[i][tempindex++] = tempVariableMatrix[i][j];
                }
            }
            variableMatrix = finalVariableMatrix;
        }
        StringBuilder variableMatrixStr = new StringBuilder();
        BigDecimal[][] bigDecimalArray = variableMatrix;
        int n = bigDecimalArray.length;
        for (int i = 0; i < n; ++i) {
            BigDecimal[] values;
            for (BigDecimal value : values = bigDecimalArray[i]) {
                variableMatrixStr.append(value).append(",");
            }
            variableMatrixStr.append("\n");
        }
        DiffAllocHelper.writeLog(logger, String.format(ResManager.loadKDString((String)"%1$sDiffRateCalcService_\u53d8\u91cf\u7cfb\u6570\uff1a%2$s@%3$s:%4$s", (String)"DiffRateCalcService_15", (String)"fi-calx-algox", (Object[])new Object[0]), logTag, diffType, balanceDmDataKey, variableMatrixStr));
        return variableMatrix;
    }

    private String getDomainStr(String value) {
        return DiffRateCalcService.getSHA256Base64Str(value);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    public Map<String, BigDecimal> getPeriodOutputQtyMap() {
        return this.periodOutputQtyMap;
    }

    public Map<String, BigDecimal> getPeriodFixedOutputQtyMap() {
        return this.periodFixedOutputQtyMap;
    }

    public Map<String, Map<String, BigDecimal>> getTransInQtyWithDmMap() {
        return this.transInQtyWithDmMap;
    }

    public Map<String, BigDecimal> getPeriodIntputQtyMap() {
        return this.periodIntputQtyMap;
    }

    public Map<String, BigDecimal> getPeriodInputDiffMap() {
        return this.periodInputDiffMap;
    }

    public Map<String, BigDecimal> getPeriodBeginDiffMap() {
        return this.periodBeginDiffMap;
    }

    public Map<String, BigDecimal> getCrossPeriodOutputDiffMap() {
        return this.crossPeriodOutputDiffMap;
    }
}

