/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.function.DealAlgoNoUpdateCalFields;
import kd.fi.calx.algox.diff.function.DealTransInQtyFunction;
import kd.fi.calx.algox.diff.function.FilterDataSetFunctionNew;
import kd.fi.calx.algox.diff.function.FilterNoAllocEntryIdsFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.BizGroupRecordHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalLogHelper;
import kd.fi.calx.algox.helper.JsonEntryServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class LinearEquationsDataFactory
implements Serializable {
    private static final String SPLIT_TAG = "@";
    private DiffAllocParamter allocParam;
    private DiffAllocParamterEntry paramEntry;
    private IDataEntityProperty property;
    private static String[] diffTypes = new String[]{"G", "H", "K", "M", "P", "Q", "R", "S", "T", "C"};
    private Boolean isBizGroup = AcctGroupModelHelper.isBizGroupModel();
    private BizGroupRecordHelper bizGroupRecordHelper = null;
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };

    public LinearEquationsDataFactory(DiffAllocParamter param, DiffAllocParamterEntry paramEntry) {
        this.allocParam = param;
        this.paramEntry = paramEntry;
    }

    public void close() {
        if (this.bizGroupRecordHelper != null) {
            this.bizGroupRecordHelper.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Map<String, BigDecimal>> getCalcDmTransInQty(Set<Long> crossEntryIds) {
        HashMap<String, Map<String, BigDecimal>> transQtyDatas = new HashMap<String, Map<String, BigDecimal>>(1000);
        try (AlgoContext context = Algo.newContext();){
            DataSet transOutToIn2Data = this.getTransOutToIn_1And2(crossEntryIds);
            HashSet<String> transinBillNos = new HashSet<String>(16);
            for (Row row : transOutToIn2Data.copy()) {
                if (row.getString("inbillno") == null) continue;
                transinBillNos.add(row.getString("inbillno"));
            }
            String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
            QFilter filter = new QFilter("period.id", "=", (Object)this.paramEntry.getPeriodId());
            Long costAccountId = this.paramEntry.getCostAccountId();
            filter.and("costaccount.id", "=", (Object)costAccountId);
            filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            if (this.paramEntry.getCalRangeId() != 0L) {
                filter.and("entry.calrange", "=", (Object)this.paramEntry.getCalRangeId());
            }
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
            filter.and("entry.accounttype", "=", (Object)"D");
            filter.and("entry.id", "not in", crossEntryIds);
            filter.and("billno", "not in", transinBillNos);
            String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
            DataSet billData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)("calbilltype,bizentityobject,billno,entry.id as costrecordentryid," + dySelectFields + ",entry.baseqty as baseqty,entry.noupdatecalfields as noupdatecalfields"), (QFilter[])filter.toArray(), (String)null);
            billData = billData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(billData.getRowMeta()));
            billData = billData.filter((FilterFunction)new FilterDataSetFunctionNew(billData.getRowMeta(), this.allocParam, this.paramEntry, ""));
            DataSet srcGrpData = null;
            HashSet<Long> acctGroupIds = new HashSet<Long>(100);
            if (this.isBizGroup.booleanValue()) {
                srcGrpData = this.getBizGroupDS();
                srcGrpData = srcGrpData.where("period = " + this.paramEntry.getPeriodId() + " and costaccount = " + this.paramEntry.getCostAccountId() + " and type = '0' and material in (" + StringUtils.join(this.paramEntry.getMatIdSet(), (String)",") + ")");
                srcGrpData = srcGrpData.select("groupid as bizgrouprecordid,costrecordentryid as billentryid");
            } else {
                QFilter srcGrpFilter = new QFilter("entryentity.period.id", "=", (Object)this.paramEntry.getPeriodId());
                srcGrpFilter.and("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
                srcGrpFilter.and("costaccounttype.id", "=", (Object)this.paramEntry.getCostAccountTypeId());
                srcGrpFilter.and("entryentity.type", "=", (Object)"0");
                srcGrpFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
                srcGrpData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"bizgrouprecordid,entryentity.costrecordentryid as billentryid", (QFilter[])srcGrpFilter.toArray(), null);
                for (String[] row : srcGrpData.copy()) {
                    acctGroupIds.add(row.getLong("bizgrouprecordid"));
                }
            }
            JoinDataSet outBillJoin = srcGrpData.leftJoin(billData).on("billentryid", "costrecordentryid");
            StringBuilder outDySelectFields = new StringBuilder();
            outDySelectFields.append("calbilltype as outcalbilltype,");
            outDySelectFields.append("bizentityobject as outbizentityobject,");
            outDySelectFields.append("billno as outbillno,");
            for (String field : diffallocDims.split(",")) {
                outDySelectFields.append(field).append(" as out").append(field).append(",");
            }
            outDySelectFields.append("costrecordentryid as outbillentryid,");
            outDySelectFields.append("baseqty as outbaseqty");
            String outSelectStr = outDySelectFields.toString();
            DataSet outBillData = outBillJoin.select(new String[]{"bizgrouprecordid"}, outSelectStr.split(",")).finish().filter("outmaterial is not null");
            DataSet targGrpData = null;
            if (this.isBizGroup.booleanValue()) {
                targGrpData = this.getBizGroupDS();
                targGrpData = targGrpData.where("period = " + this.paramEntry.getPeriodId() + " and costaccount = " + this.paramEntry.getCostAccountId() + " and type = '1' ");
                targGrpData = targGrpData.select("groupid as bizgrouprecordid,costrecordentryid as billentryid");
            } else {
                QFilter targGrpFilter = new QFilter("entryentity.period.id", "=", (Object)this.paramEntry.getPeriodId());
                targGrpFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId()));
                targGrpFilter.and("costaccounttype.id", "=", (Object)this.paramEntry.getCostAccountTypeId());
                targGrpFilter.and("entryentity.type", "=", (Object)"1");
                targGrpFilter.and("bizgrouprecordid", "in", acctGroupIds);
                targGrpData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"bizgrouprecordid,entryentity.costrecordentryid as billentryid", (QFilter[])targGrpFilter.toArray(), null);
            }
            HashSet<Long> targBillEntryIds = new HashSet<Long>(100);
            for (Row row : targGrpData.copy()) {
                targBillEntryIds.add(row.getLong("billentryid"));
            }
            QFilter targBillFilter = new QFilter("period.id", "=", (Object)this.paramEntry.getPeriodId());
            targBillFilter.and("costaccount.id", "=", (Object)costAccountId);
            targBillFilter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            targBillFilter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            if (this.paramEntry.getCalRangeId() != 0L) {
                targBillFilter.and("entry.calrange", "=", (Object)this.paramEntry.getCalRangeId());
            }
            targBillFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
            targBillFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            targBillFilter.and("entry.accounttype", "=", (Object)"D");
            targBillFilter.and("entry.id", "in", targBillEntryIds);
            targBillFilter.and("billno", "not in", transinBillNos);
            DataSet targBillData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)("calbilltype,bizentityobject,billno,entry.id as costrecordentryid," + dySelectFields + ",entry.baseqty as baseqty,entry.noupdatecalfields as noupdatecalfields"), (QFilter[])targBillFilter.toArray(), (String)null);
            targBillData = targBillData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(targBillData.getRowMeta()));
            JoinDataSet inBillJoin = targGrpData.leftJoin(targBillData).on("billentryid", "costrecordentryid");
            StringBuilder inDySelectFields = new StringBuilder();
            inDySelectFields.append("calbilltype as incalbilltype,");
            inDySelectFields.append("bizentityobject as inbizentityobject,");
            inDySelectFields.append("billno as inbillno,");
            for (String field : diffallocDims.split(",")) {
                inDySelectFields.append(field).append(" as in").append(field).append(",");
            }
            inDySelectFields.append("baseqty as inbaseqty");
            inDySelectFields.append(",costrecordentryid as inbillentryid");
            String inSelectStr = inDySelectFields.toString();
            DataSet inBillData = inBillJoin.select(new String[]{"bizgrouprecordid"}, inSelectStr.split(",")).finish().filter("inmaterial is not null");
            JoinDataSet groupBillJoin = outBillData.leftJoin(inBillData).on("bizgrouprecordid", "bizgrouprecordid");
            StringBuilder outDySelects = new StringBuilder();
            outDySelects.append("outcalbilltype,outbizentityobject,outbillno,");
            for (String field : diffallocDims.split(",")) {
                outDySelects.append("out").append(field).append(",");
            }
            outDySelects.append(" outbillentryid,");
            outDySelects.append(" outbaseqty,");
            outDySelects.append(" bizgrouprecordid");
            String outDySelectStr = outDySelects.toString();
            StringBuilder inDySelects = new StringBuilder();
            inDySelects.append("incalbilltype,inbizentityobject,inbillno,");
            for (String field : diffallocDims.split(",")) {
                inDySelects.append("in").append(field).append(",");
            }
            inDySelects.append("inbaseqty");
            inDySelects.append(",inbillentryid");
            String inDySelectStr = inDySelects.toString();
            DataSet groupBillData = groupBillJoin.select(outDySelectStr.split(","), inDySelectStr.split(",")).finish().filter("inmaterial is not null");
            CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->before-DealTransInQtyFunction:", groupBillData);
            groupBillData = groupBillData.distinct();
            groupBillData = groupBillData.groupBy(new String[]{"bizgrouprecordid"}).reduceGroup((ReduceGroupFunction)new DealTransInQtyFunction(transOutToIn2Data.getRowMeta()));
            CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->after-DealTransInQtyFunction:", groupBillData);
            CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->AB:", transOutToIn2Data);
            groupBillData = groupBillData.select(transOutToIn2Data.getRowMeta().getFieldNames()).union(transOutToIn2Data);
            if (this.allocParam.isCircle().booleanValue() || this.allocParam.isRework().booleanValue()) {
                Boolean isGetDataFromCoSys = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ISGETDATA_FROM_COSYS);
                if (isGetDataFromCoSys.booleanValue()) {
                    CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->Rework_from_cacheid:", this.allocParam.getNestMatUseQtyDsCache());
                    if (this.allocParam.getNestMatUseQtyDsCache() != null && !this.allocParam.getNestMatUseQtyDsCache().isEmpty()) {
                        DataSet estMatUseQtyDsCacheDS = Algo.getCacheDataSet((String)this.allocParam.getNestMatUseQtyDsCache()).toDataSet(Algo.create((String)LinearEquationsDataFactory.class.getName()), false);
                        CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->Rework_from_cache:", estMatUseQtyDsCacheDS);
                        estMatUseQtyDsCacheDS = estMatUseQtyDsCacheDS.select(this.getAliasFiledFromCache(estMatUseQtyDsCacheDS.getRowMeta()));
                        estMatUseQtyDsCacheDS = estMatUseQtyDsCacheDS.select(groupBillData.getRowMeta().getFieldNames());
                        groupBillData = groupBillData.union(estMatUseQtyDsCacheDS);
                    }
                } else {
                    DataSet reworkData = this.getReworkDataNew(this.paramEntry, crossEntryIds, diffallocDims);
                    CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->AC:", reworkData);
                    groupBillData = groupBillData.union(reworkData);
                }
            }
            CalLogHelper.printLog("LinearEquationsDataFactory.getCalcDmTransInQty->AA:", groupBillData);
            for (Row row : groupBillData) {
                Map<String, BigDecimal> transQtyData;
                String string;
                void var38_56;
                if ("OUT".equals(row.getString("incalbilltype")) && !"im_transinbill".equals(row.getString("inbizentityobject"))) continue;
                StringBuilder inDyFields = new StringBuilder();
                for (String string2 : diffallocDims.split(",")) {
                    inDyFields.append("in").append(string2).append(",");
                }
                StringBuilder inBillKey = new StringBuilder();
                if ("OUT".equals(row.getString("incalbilltype"))) {
                    inBillKey.append("OUT#");
                } else {
                    inBillKey.append("IN#");
                }
                String[] stringArray = inDyFields.substring(0, inDyFields.length() - 1).split(",");
                int n = stringArray.length;
                boolean bl = false;
                while (var38_56 < n) {
                    String string3 = stringArray[var38_56];
                    inBillKey.append(row.getString(string3)).append(SPLIT_TAG);
                    ++var38_56;
                }
                String inBillKeyStr = inBillKey.length() > 0 ? inBillKey.substring(0, inBillKey.length() - 1) : inBillKey.toString();
                StringBuilder outDyFields = new StringBuilder();
                for (String field4 : diffallocDims.split(",")) {
                    outDyFields.append("out").append(field4).append(",");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String field5 : outDyFields.substring(0, outDyFields.length() - 1).split(",")) {
                    stringBuilder.append(row.getString(field5)).append(SPLIT_TAG);
                }
                String string4 = string = stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : stringBuilder.toString();
                if (transQtyDatas.containsKey(inBillKeyStr)) {
                    transQtyData = (Map)transQtyDatas.get(inBillKeyStr);
                    if (transQtyData.containsKey(string)) {
                        BigDecimal baseQty;
                        BigDecimal currQty = (BigDecimal)transQtyData.get(string);
                        if (currQty == null) {
                            currQty = BigDecimal.ZERO;
                        }
                        if ((baseQty = row.getBigDecimal("baseqty")) == null) {
                            baseQty = BigDecimal.ZERO;
                        }
                        transQtyData.put(string, currQty.add(baseQty));
                        continue;
                    }
                    transQtyData.put(string, row.getBigDecimal("baseqty"));
                    continue;
                }
                transQtyData = new HashMap();
                transQtyData.put(string, row.getBigDecimal("baseqty"));
                transQtyDatas.put(inBillKeyStr, transQtyData);
            }
        }
        return transQtyDatas;
    }

    protected DataSet getBizGroupDS() {
        if (this.bizGroupRecordHelper == null) {
            String selectFields = "groupid,costfields,costcolumn,iscompleted,type,costrecordentryid,weight,occupiedqty,groupno,periodenddate,costaccount,bookdate,period,bizbillid,isbeforeperiod,material";
            this.bizGroupRecordHelper = new BizGroupRecordHelper(this.paramEntry, selectFields);
        }
        DataSet groupBillRecordDS = this.bizGroupRecordHelper.getGroupBillRecordDS();
        return groupBillRecordDS;
    }

    private Map<String, Map<String, BigDecimal>> initTransQtyData() {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        HashMap<String, Map<String, BigDecimal>> transQtyDatas = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
        DataSet data = null;
        for (Map.Entry<String, DiffAllocParamterEntry> entry : entrys.entrySet()) {
            QFilter filter = new QFilter("period", "<=", (Object)entry.getValue().getPeriod());
            filter.and("endperiod", ">", (Object)entry.getValue().getPeriod());
            filter.and("costaccount.id", "=", (Object)entry.getValue().getCostAccountId());
            filter.and("accounttype", "=", (Object)"D");
            filter.and(this.getMatFilter("material.id", this.allocParam, entry.getValue()));
            DataSet queryData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)CalBalanceModelHelper.getBalanceEntityName(false), (String)diffallocDims, (QFilter[])filter.toArray(), (String)null);
            if (data == null) {
                data = queryData;
                continue;
            }
            data = data.union(queryData);
        }
        if (data == null || data.isEmpty()) {
            return transQtyDatas;
        }
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        data = groupDataSet.finish();
        for (Row row : data.copy()) {
            StringBuilder inBillKey = new StringBuilder();
            inBillKey.append("IN#");
            for (String dim : diffallocDims.split(",")) {
                inBillKey.append(row.getString(dim)).append(SPLIT_TAG);
            }
            String inBillKeyStr = inBillKey.length() > 0 ? inBillKey.substring(0, inBillKey.length() - 1) : inBillKey.toString();
            for (Row row1 : data.copy()) {
                Map<String, BigDecimal> transQtyData;
                String outBillKeyStr;
                if (!row.getString("material").equals(row1.getString("material"))) continue;
                StringBuilder outBillKey = new StringBuilder();
                for (String dim : diffallocDims.split(",")) {
                    outBillKey.append(row1.getString(dim)).append(SPLIT_TAG);
                }
                String string = outBillKeyStr = outBillKey.length() > 0 ? outBillKey.substring(0, outBillKey.length() - 1) : outBillKey.toString();
                if (transQtyDatas.containsKey(inBillKeyStr)) {
                    transQtyData = (Map)transQtyDatas.get(inBillKeyStr);
                    if (transQtyData.containsKey(outBillKeyStr)) continue;
                    transQtyData.put(outBillKeyStr, BigDecimal.ZERO);
                    continue;
                }
                transQtyData = new HashMap();
                transQtyData.put(outBillKeyStr, BigDecimal.ZERO);
                transQtyDatas.put(inBillKeyStr, transQtyData);
            }
        }
        return transQtyDatas;
    }

    public Map<String, BigDecimal> getPeriodBeginDiffData() {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        HashMap<String, BigDecimal> periodBeginDataMap = new HashMap<String, BigDecimal>();
        Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
        DataSet allDataSet = null;
        if (this.allocParam.isNewBalance()) {
            allDataSet = this.getBizDiffDataByNewBalance(this.paramEntry);
        } else {
            allDataSet = this.getBizDiffData(this.paramEntry, false);
            allDataSet = allDataSet.union(this.getBizDiffData(this.paramEntry, true));
        }
        String groupFields = diffallocDims + ",costelement,costsubelement";
        GroupbyDataSet groupAllDataSet = allDataSet.groupBy(groupFields.split(","));
        groupAllDataSet.sum("begindiffamt");
        groupAllDataSet.sum("diff_g");
        groupAllDataSet.sum("diff_h");
        groupAllDataSet.sum("diff_k");
        groupAllDataSet.sum("diff_m");
        groupAllDataSet.sum("diff_p");
        groupAllDataSet.sum("diff_q");
        groupAllDataSet.sum("diff_r");
        groupAllDataSet.sum("diff_s");
        groupAllDataSet.sum("diff_t");
        groupAllDataSet.sum("diff_c");
        groupAllDataSet.sum("diff_w");
        groupAllDataSet.sum("diff_x");
        groupAllDataSet.sum("diff_y");
        allDataSet = groupAllDataSet.finish();
        CalLogHelper.printLog("LinearEquationsDataFactory.getPeriodBeginDiffData->allDataSet:", allDataSet);
        for (Row row : allDataSet) {
            for (String diffType : diffTypes) {
                String key = this.getDataKey(diffType, row);
                if (row.getBigDecimal("diff_" + diffType.toLowerCase()) == null || BigDecimal.ZERO.compareTo(row.getBigDecimal("diff_" + diffType.toLowerCase())) == 0) continue;
                BigDecimal currDiff = (BigDecimal)periodBeginDataMap.get(key);
                if (currDiff == null) {
                    periodBeginDataMap.put(this.getDataKey(diffType, row), row.getBigDecimal("diff_" + diffType.toLowerCase()));
                    continue;
                }
                currDiff = currDiff.add(row.getBigDecimal("diff_" + diffType.toLowerCase()));
                periodBeginDataMap.put(key, currDiff);
            }
        }
        return periodBeginDataMap;
    }

    public Map<String, BigDecimal> getPeriodInDiffDataByBill() {
        HashMap<String, BigDecimal> periodBeginDataMap = new HashMap<String, BigDecimal>();
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        filter.and("period", "=", (Object)this.paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and(new QFilter("entryentity.queuetype", "=", (Object)"0"));
        filter.and("entryentity.accounttype", "=", (Object)"D");
        filter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
        filter.and("isupdatecost", "=", (Object)true);
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffallocDims, "");
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g as ddiff_g,entryentity.subentryentity.ddiff_h as ddiff_h,entryentity.subentryentity.ddiff_k as ddiff_k,entryentity.subentryentity.ddiff_p as ddiff_p,entryentity.subentryentity.ddiff_q as ddiff_q,entryentity.subentryentity.ddiff_r as ddiff_r,entryentity.subentryentity.ddiff_m as ddiff_m,entryentity.subentryentity.ddiff_s as ddiff_s,entryentity.subentryentity.ddiff_t as ddiff_t,entryentity.subentryentity.ddiff_w as ddiff_w,entryentity.subentryentity.ddiff_x as ddiff_x,entryentity.subentryentity.ddiff_y as ddiff_y,entryentity.subentryentity.ddiff_c as ddiff_c,entryentity.signnum as signnum,entryentity.noupdatecalfields as noupdatecalfields";
        DataSet allDataSet = JsonEntryServiceHelper.queryJsonSubEntryDataSet("kd.fi.calx.algox.diff.DiffAllocDataFactory", "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", filter.toArray(), null);
        String selectFields = diffallocDims + ",costelement,costsubelement,ddiff_g*signnum as ddiff_g,ddiff_h*signnum as ddiff_h,ddiff_k*signnum as ddiff_k,ddiff_p*signnum as ddiff_p,ddiff_q*signnum as ddiff_q,ddiff_r*signnum as ddiff_r,ddiff_m*signnum as ddiff_m,ddiff_s*signnum as ddiff_s,ddiff_t*signnum as ddiff_t,ddiff_w*signnum as ddiff_w,ddiff_x*signnum as ddiff_x,ddiff_y*signnum as ddiff_y,ddiff_c*signnum as ddiff_c,noupdatecalfields";
        allDataSet = allDataSet.select(selectFields);
        Boolean isGetDataFromCoSys = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ISGETDATA_FROM_COSYS);
        if ((this.allocParam.isCircle().booleanValue() || this.allocParam.isRework().booleanValue()) && isGetDataFromCoSys.booleanValue()) {
            CalLogHelper.printLog("LinearEquationsDataFactory.getPeriodInDiffDataByBill->Rework_from_cacheid:", this.allocParam.getNestPreDiffDsCache());
            if (this.allocParam.getNestPreDiffDsCache() != null && !this.allocParam.getNestPreDiffDsCache().isEmpty()) {
                DataSet nestPreDiffDsCacheDS = Algo.getCacheDataSet((String)this.allocParam.getNestPreDiffDsCache()).toDataSet(Algo.create((String)LinearEquationsDataFactory.class.getName()), false);
                CalLogHelper.printLog("LinearEquationsDataFactory.getPeriodInDiffDataByBill->DiffBegin_from_cache:", nestPreDiffDsCacheDS);
                nestPreDiffDsCacheDS = nestPreDiffDsCacheDS.select(this.getAliasFiledFromCache2(nestPreDiffDsCacheDS.getRowMeta()));
                nestPreDiffDsCacheDS = nestPreDiffDsCacheDS.select(allDataSet.getRowMeta().getFieldNames());
                allDataSet = allDataSet.union(nestPreDiffDsCacheDS);
            }
        }
        allDataSet = allDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(allDataSet.getRowMeta()));
        allDataSet = allDataSet.filter((FilterFunction)new FilterDataSetFunctionNew(allDataSet.getRowMeta(), this.allocParam, this.paramEntry, ""));
        CalLogHelper.printLog("LinearEquationsDataFactory.getPeriodInDiffDataByBill->allDataSet:", allDataSet);
        String groupFields = diffallocDims + ",costelement,costsubelement";
        GroupbyDataSet groupAllDataSet = allDataSet.groupBy(groupFields.split(","));
        groupAllDataSet.sum("ddiff_g");
        groupAllDataSet.sum("ddiff_h");
        groupAllDataSet.sum("ddiff_k");
        groupAllDataSet.sum("ddiff_p");
        groupAllDataSet.sum("ddiff_q");
        groupAllDataSet.sum("ddiff_r");
        groupAllDataSet.sum("ddiff_m");
        groupAllDataSet.sum("ddiff_s");
        groupAllDataSet.sum("ddiff_t");
        groupAllDataSet.sum("ddiff_w");
        groupAllDataSet.sum("ddiff_x");
        groupAllDataSet.sum("ddiff_y");
        groupAllDataSet.sum("ddiff_c");
        allDataSet = groupAllDataSet.finish();
        for (Row row : allDataSet) {
            for (String diffType : diffTypes) {
                periodBeginDataMap.put(this.getDataKey(diffType, row), row.getBigDecimal("ddiff_" + diffType));
            }
        }
        return periodBeginDataMap;
    }

    public Map<String, BigDecimal> getCrossMonthOutDiffData(Set<Long> crossEntryIds) {
        HashMap<String, BigDecimal> crossMonthOutDiffMap = new HashMap<String, BigDecimal>();
        DataSet adjbillEmptyData = null;
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffallocDims, "");
        String jsonSelectFields = dySelectFields + ",entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.ddiff_g as ddiff_g,entryentity.subentryentity.ddiff_h as ddiff_h,entryentity.subentryentity.ddiff_k as ddiff_k,entryentity.subentryentity.ddiff_p as ddiff_p,entryentity.subentryentity.ddiff_q as ddiff_q,entryentity.subentryentity.ddiff_r as ddiff_r,entryentity.subentryentity.ddiff_m as ddiff_m,entryentity.subentryentity.ddiff_s as ddiff_s,entryentity.subentryentity.ddiff_t as ddiff_t,entryentity.subentryentity.ddiff_w as ddiff_w,entryentity.subentryentity.ddiff_x as ddiff_x,entryentity.subentryentity.ddiff_y as ddiff_y,entryentity.subentryentity.ddiff_c as ddiff_c,entryentity.signnum as signnum,entryentity.noupdatecalfields as noupdatecalfields";
        String selectFields = diffallocDims + ",costelement,costsubelement,ddiff_g*signnum as ddiff_g,ddiff_h*signnum as ddiff_h,ddiff_k*signnum as ddiff_k,ddiff_p*signnum as ddiff_p,ddiff_q*signnum as ddiff_q,ddiff_r*signnum as ddiff_r,ddiff_m*signnum as ddiff_m,ddiff_s*signnum as ddiff_s,ddiff_t*signnum as ddiff_t,ddiff_w*signnum as ddiff_w,ddiff_x*signnum as ddiff_x,ddiff_y*signnum as ddiff_y,ddiff_c*signnum as ddiff_c,noupdatecalfields";
        HashSet<DataSet> stdCostDiffBillDatas = new HashSet<DataSet>(16);
        Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
        QFilter ajdFilter = new QFilter("period", "=", (Object)this.paramEntry.getPeriodId());
        ajdFilter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        ajdFilter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        ajdFilter.and("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        ajdFilter.and("billstatus", "=", (Object)"C");
        ajdFilter.and(new QFilter("entryentity.queuetype", "=", (Object)"1"));
        ajdFilter.and("entryentity.accounttype", "=", (Object)"D");
        ajdFilter.and("isupdatecost", "=", (Object)true);
        ajdFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
        DataSet adjbillData = JsonEntryServiceHelper.queryJsonSubEntryDataSet("kd.fi.calx.algox.diff.DiffAllocDataFactory", "cal_stdcostdiffbill", jsonSelectFields, "entryentity.subentryentity", ajdFilter.toArray(), null);
        CalLogHelper.printLog("LinearEquationsDataFactory.getCrossMonthOutDiffData->getCrossMonthOutDiffData:", adjbillData);
        adjbillData = adjbillData.select(selectFields);
        stdCostDiffBillDatas.add(adjbillData);
        Algo algo = Algo.create((String)this.getClass().getName());
        selectFields = dySelectFields + ",0L as costelement,0L as costsubelement,0 as ddiff_g,0 as ddiff_h,0 as ddiff_k,0 as ddiff_p,0 as ddiff_q,0 as ddiff_r,0 as ddiff_m,0 as ddiff_s,0 as ddiff_t,0 as ddiff_w,0 as ddiff_x,0 as ddiff_y,0 as ddiff_c,entryentity.noupdatecalfields as noupdatecalfields";
        RowMeta bizDataMeta = ORM.create().createRowMeta("cal_stdcostdiffbill", selectFields);
        bizDataMeta.getField("costelement").setDataType((DataType)DataType.LongType);
        bizDataMeta.getField("costsubelement").setDataType((DataType)DataType.LongType);
        bizDataMeta.getField("ddiff_g").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_h").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_k").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_p").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_q").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_r").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_m").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_s").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_t").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_w").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_x").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_y").setDataType((DataType)DataType.BigDecimalType);
        bizDataMeta.getField("ddiff_c").setDataType((DataType)DataType.BigDecimalType);
        adjbillEmptyData = algo.createDataSet(new ArrayList(), bizDataMeta);
        if (!stdCostDiffBillDatas.isEmpty()) {
            adjbillData = adjbillEmptyData.union(stdCostDiffBillDatas.toArray(new DataSet[0]));
        }
        if (adjbillData == null) {
            return crossMonthOutDiffMap;
        }
        adjbillData = adjbillData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(adjbillData.getRowMeta()));
        adjbillData = adjbillData.filter((FilterFunction)new FilterDataSetFunctionNew(adjbillData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        for (Row row : adjbillData) {
            for (String diffType : diffTypes) {
                if (crossMonthOutDiffMap.containsKey(this.getDataKey(diffType, row))) {
                    BigDecimal currDiff = (BigDecimal)crossMonthOutDiffMap.get(this.getDataKey(diffType, row));
                    crossMonthOutDiffMap.put(this.getDataKey(diffType, row), currDiff.add(row.getBigDecimal("ddiff_" + diffType)));
                    continue;
                }
                crossMonthOutDiffMap.put(this.getDataKey(diffType, row), row.getBigDecimal("ddiff_" + diffType));
            }
        }
        return crossMonthOutDiffMap;
    }

    public Map<String, BigDecimal> getInputQtyByBill() {
        HashMap<String, BigDecimal> periodInputQtyMap = new HashMap<String, BigDecimal>();
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        filter.and("period", "<", (Object)this.paramEntry.getPeriod());
        filter.and("endperiod", ">=", (Object)this.paramEntry.getPeriod());
        filter.and("accounttype", "=", (Object)"D");
        filter.and(this.getMatFilter("material.id", this.allocParam, this.paramEntry));
        DataSet periodBeginData = null;
        if (CalBalanceModelHelper.isNewBalance()) {
            periodBeginData = this.getBalQty(filter, this.paramEntry.getPeriodId(), this.paramEntry.getPeriod());
            periodBeginData = periodBeginData.select(diffallocDims + ",periodbeginqty,0 as periodinqty");
        } else {
            periodBeginData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)CalBalanceModelHelper.getBalanceEntityName(false), (String)this.getBalanceBizField(this.paramEntry.getPeriodId(), this.paramEntry.getPeriod()), (QFilter[])filter.toArray(), (String)null);
            periodBeginData = periodBeginData.select(diffallocDims + ",periodbeginqty,0 as periodinqty");
        }
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->periodBeginData:", periodBeginData);
        QFilter billFilter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        billFilter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        billFilter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        billFilter.and("period", "=", (Object)this.paramEntry.getPeriodId());
        billFilter.and("billstatus", "=", (Object)"C");
        billFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
        billFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        billFilter.and(new QFilter("entry.queuetype", "=", (Object)"0"));
        billFilter.and("entry.accounttype", "=", (Object)"D");
        billFilter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", selectDMFileds, "");
        String selectFileds = dySelectFieldsStr + ",0 as periodbeginqty,entry.baseqty*entry.signnum as periodinqty,entry.noupdatecalfields as noupdatecalfields";
        DataSet billData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)selectFileds, (QFilter[])billFilter.toArray(), (String)null);
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->billData:", billData);
        billData = billData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(billData.getRowMeta()));
        billData = billData.filter((FilterFunction)new FilterDataSetFunctionNew(billData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        DataSet data = periodBeginData.union(billData);
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        groupDataSet.sum("periodinqty");
        groupDataSet.sum("periodbeginqty");
        String selectStr = diffallocDims + ",periodinqty,periodbeginqty";
        data = groupDataSet.finish().select(selectStr.split(",")).filter(" periodinqty != 0 or periodbeginqty != 0");
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->data:", data);
        for (Row row : data) {
            StringBuilder key = new StringBuilder();
            for (String field : diffallocDims.split(",")) {
                key.append(row.getString(field)).append(SPLIT_TAG);
            }
            String keyStr = key.length() > 0 ? key.substring(0, key.length() - 1) : key.toString();
            periodInputQtyMap.put(keyStr, row.getBigDecimal("periodinqty").add(row.getBigDecimal("periodbeginqty")));
        }
        return periodInputQtyMap;
    }

    public Map<String, BigDecimal> getInputQtyByBillNew() {
        HashMap<String, BigDecimal> periodInputQtyMap = new HashMap<String, BigDecimal>();
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        filter.and("period", "<", (Object)this.paramEntry.getPeriod());
        filter.and("endperiod", ">=", (Object)this.paramEntry.getPeriod());
        filter.and("accounttype", "=", (Object)"D");
        filter.and(this.getMatFilter("material.id", this.allocParam, this.paramEntry));
        DataSet periodBeginData = null;
        periodBeginData = CalBalanceModelHelper.isNewBalance() ? this.getBalQty(filter, this.paramEntry.getPeriodId(), this.paramEntry.getPeriod()) : QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)CalBalanceModelHelper.getBalanceEntityName(false), (String)this.getBalanceBizField(this.paramEntry.getPeriodId(), this.paramEntry.getPeriod()), (QFilter[])filter.toArray(), (String)null);
        periodBeginData = periodBeginData.select(diffallocDims + ",periodbeginqty,0 as periodinqty");
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->periodBeginData:", periodBeginData);
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", selectDMFileds, "");
        Map<String, String> headEntryMap = this.getHeadEntryMap(dySelectFieldsStr, Sets.newHashSet(), Sets.newHashSet((Object[])new String[]{"fbaseqty", "fsignnum", "fnoupdatecalfields"}), "0 as periodbeginqty,fbaseqty*fsignnum as periodinqty,fnoupdatecalfields as noupdatecalfields");
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("SELECT ", new Object[0]).append(headEntryMap.get("entry"), new Object[0]);
        balSql.append(" FROM ", new Object[0]).append("T_CAL_CALCOSTRECORDENTRY", new Object[0]);
        balSql.append(" WHERE FACCOUNTTYPE='D' AND FQUEUETYPE = '0'", new Object[0]);
        if (this.paramEntry.getMatIdSet() != null && !this.paramEntry.getMatIdSet().isEmpty()) {
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn("FMATERIALID", this.paramEntry.getMatIdSet().toArray());
        }
        DataSet entryDataSet = null;
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.paramEntry.getCostAccountId()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.paramEntry.getStartDate()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.paramEntry.getEndDate())});
        Object object = null;
        try {
            ctx.set();
            entryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balSql);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        if (entryDataSet == null) {
            return periodInputQtyMap;
        }
        ArrayList<Long> fids = new ArrayList<Long>(500);
        for (Object row : entryDataSet.copy()) {
            fids.add(row.getLong("fid"));
        }
        fids.add(0L);
        DataSet headDataSet = null;
        for (List ids : Lists.partition(fids, (int)500000)) {
            QFilter billFilter = new QFilter("costaccount", "=", (Object)this.paramEntry.getCostAccountId());
            billFilter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            billFilter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            billFilter.and("period", "=", (Object)this.paramEntry.getPeriodId());
            billFilter.and("billstatus", "=", (Object)"C");
            billFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
            billFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            billFilter.and("id", "in", (Object)ids);
            DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)headEntryMap.get("head"), (QFilter[])billFilter.toArray(), (String)null);
            if (headDataSet == null) {
                headDataSet = data;
                continue;
            }
            headDataSet = headDataSet.union(data);
        }
        if (headDataSet == null) {
            return periodInputQtyMap;
        }
        DataSet billData = headDataSet.join(entryDataSet).on("id", "fid").select(headEntryMap.get("head").split(","), headEntryMap.get("selEntry").split(",")).finish();
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->billData:", billData);
        billData = billData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(billData.getRowMeta()));
        billData = billData.filter((FilterFunction)new FilterDataSetFunctionNew(billData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        billData = billData.select(periodBeginData.getRowMeta().getFieldNames());
        DataSet data = periodBeginData.union(billData);
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        groupDataSet.sum("periodinqty");
        groupDataSet.sum("periodbeginqty");
        String selectStr = diffallocDims + ",periodinqty,periodbeginqty";
        data = groupDataSet.finish().select(selectStr.split(",")).filter(" periodinqty != 0 or periodbeginqty != 0");
        CalLogHelper.printLog("LinearEquationsDataFactory.getInputQtyByBill->data:", data);
        for (Row row : data) {
            StringBuilder key = new StringBuilder();
            for (String field : diffallocDims.split(",")) {
                key.append(row.getString(field)).append(SPLIT_TAG);
            }
            String keyStr = key.length() > 0 ? key.substring(0, key.length() - 1) : key.toString();
            periodInputQtyMap.put(keyStr, row.getBigDecimal("periodinqty").add(row.getBigDecimal("periodbeginqty")));
        }
        return periodInputQtyMap;
    }

    public Map<String, BigDecimal> getCurrOutputQtyByBill(Set<Long> crossEntryIds) {
        HashMap<String, BigDecimal> periodOutputQtyMap = new HashMap<String, BigDecimal>();
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        filter.and("period", "=", (Object)this.paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(new QFilter("entry.queuetype", "=", (Object)"1"));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
        String selectFileds = dySelectFieldsStr + ",entry.baseqty*entry.signnum as periodissueqty,entry.noupdatecalfields as noupdatecalfields";
        DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)selectFileds, (QFilter[])filter.toArray(), (String)null);
        data = data.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(data.getRowMeta()));
        data = data.filter((FilterFunction)new FilterDataSetFunctionNew(data.getRowMeta(), this.allocParam, this.paramEntry, ""));
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        groupDataSet.sum("periodissueqty");
        String groupStr = diffallocDims + ",periodissueqty";
        data = groupDataSet.finish().select(groupStr.split(",")).filter(" periodissueqty != 0");
        CalLogHelper.printLog("LinearEquationsDataFactory.getCurrOutputQtyByBill->AA:", data);
        for (Row row : data) {
            StringBuilder key = new StringBuilder();
            for (String field : diffallocDims.split(",")) {
                key.append(row.getString(field)).append(SPLIT_TAG);
            }
            String keyStr = key.length() > 0 ? key.substring(0, key.length() - 1) : key.toString();
            periodOutputQtyMap.put(keyStr, row.getBigDecimal("periodissueqty"));
        }
        return periodOutputQtyMap;
    }

    public Map<String, BigDecimal> getCurrOutputQtyByBillNew() {
        HashMap<String, BigDecimal> periodOutputQtyMap = new HashMap<String, BigDecimal>(200);
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
        Map<String, String> headEntryMap = this.getHeadEntryMap(dySelectFieldsStr, Sets.newHashSet(), Sets.newHashSet((Object[])new String[]{"fbaseqty", "fsignnum", "fnoupdatecalfields"}), "fbaseqty*fsignnum as periodissueqty,fnoupdatecalfields as noupdatecalfields");
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("SELECT ", new Object[0]).append(headEntryMap.get("entry"), new Object[0]);
        balSql.append(" FROM ", new Object[0]).append("T_CAL_CALCOSTRECORDENTRY", new Object[0]);
        balSql.append(" WHERE FQUEUETYPE='1' AND FACCOUNTTYPE='D'", new Object[0]);
        if (this.paramEntry.getMatIdSet() != null && !this.paramEntry.getMatIdSet().isEmpty()) {
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn("FMATERIALID", this.paramEntry.getMatIdSet().toArray());
        }
        DataSet entryDataSet = null;
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.paramEntry.getCostAccountId()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.paramEntry.getStartDate()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.paramEntry.getEndDate())});
        Object object = null;
        try {
            ctx.set();
            entryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balSql);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        if (entryDataSet == null || entryDataSet.isEmpty()) {
            return periodOutputQtyMap;
        }
        ArrayList<Long> fids = new ArrayList<Long>(500);
        for (Object row : entryDataSet.copy()) {
            fids.add(row.getLong("fid"));
        }
        fids.add(0L);
        DataSet headDataSet = null;
        for (List ids : Lists.partition(fids, (int)500000)) {
            QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
            filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            filter.and("period", "=", (Object)this.paramEntry.getPeriodId());
            filter.and("billstatus", "=", (Object)"C");
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("id", "in", (Object)ids);
            DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)headEntryMap.get("head"), (QFilter[])filter.toArray(), (String)null);
            if (headDataSet == null) {
                headDataSet = data;
                continue;
            }
            headDataSet = headDataSet.union(data);
        }
        if (headDataSet == null) {
            return periodOutputQtyMap;
        }
        DataSet data = headDataSet.join(entryDataSet).on("id", "fid").select(headEntryMap.get("head").split(","), headEntryMap.get("selEntry").split(",")).finish();
        data = data.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(data.getRowMeta()));
        data = data.filter((FilterFunction)new FilterDataSetFunctionNew(data.getRowMeta(), this.allocParam, this.paramEntry, ""));
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        groupDataSet.sum("periodissueqty");
        String groupStr = diffallocDims + ",periodissueqty";
        data = groupDataSet.finish().select(groupStr.split(",")).filter(" periodissueqty != 0");
        CalLogHelper.printLog("LinearEquationsDataFactory.getCurrOutputQtyByBill->AA:", data);
        for (Row row : data) {
            StringBuilder key = new StringBuilder();
            for (String field : diffallocDims.split(",")) {
                key.append(row.getString(field)).append(SPLIT_TAG);
            }
            String keyStr = key.length() > 0 ? key.substring(0, key.length() - 1) : key.toString();
            periodOutputQtyMap.put(keyStr, row.getBigDecimal("periodissueqty"));
        }
        return periodOutputQtyMap;
    }

    public Map<String, BigDecimal> getPeriodFixedOutputQty(Set<Long> crossEntryIds) {
        HashMap<String, BigDecimal> periodFixedOutputQtyMap = new HashMap<String, BigDecimal>();
        QFilter filter = new QFilter("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        filter.and("period", "=", (Object)this.paramEntry.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(new QFilter("entry.queuetype", "=", (Object)"1"));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        DataSet transOutToIn2Data = this.getTransOutToIn_1And2(crossEntryIds);
        HashSet<String> transinBillNos = new HashSet<String>(16);
        for (Row row : transOutToIn2Data.copy()) {
            if (row.getString("inbillno") == null) continue;
            transinBillNos.add(row.getString("inbillno"));
        }
        DataSet inbillData = null;
        Boolean splitQuery = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.QUERY_HEAD_ENTRY_SPILT);
        inbillData = splitQuery != false ? this.getFixedDiffOfQtyDatasNew(this.paramEntry) : this.getFixedDiffOfQtyDatas(this.paramEntry);
        QFilter bizentityobjectFilter = new QFilter("bizentityobject.id", "=", (Object)"im_transinbill");
        bizentityobjectFilter.and("billno", "in", transinBillNos);
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
        String selectFileds = dySelectFieldsStr + ",entry.baseqty*entry.signnum as periodissueqty,entry.noupdatecalfields as noupdatecalfields";
        String selectIn_1Fileds = dySelectFieldsStr + ",entry.baseqty*entry.signnum as periodissueqty,entry.noupdatecalfields as noupdatecalfields";
        DataSet in_1data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)selectIn_1Fileds, (QFilter[])new QFilter[]{filter, bizentityobjectFilter}, (String)null);
        DataSet data = inbillData.union(in_1data);
        data = data.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(data.getRowMeta()));
        data = data.filter((FilterFunction)new FilterDataSetFunctionNew(data.getRowMeta(), this.allocParam, this.paramEntry, ""));
        GroupbyDataSet groupDataSet = data.groupBy(diffallocDims.split(","));
        groupDataSet.sum("periodissueqty");
        String groupStr = diffallocDims + ",periodissueqty";
        data = groupDataSet.finish().select(groupStr.split(",")).filter(" periodissueqty != 0");
        CalLogHelper.printLog("LinearEquationsDataFactory.getCurrOutputQtyByBill->AA:", data);
        for (Row row : data) {
            StringBuilder key = new StringBuilder();
            for (String field : diffallocDims.split(",")) {
                key.append(row.getString(field)).append(SPLIT_TAG);
            }
            String keyStr = key.length() > 0 ? key.substring(0, key.length() - 1) : key.toString();
            periodFixedOutputQtyMap.put(keyStr, row.getBigDecimal("periodissueqty"));
        }
        return periodFixedOutputQtyMap;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<String>> getBalanceDmData() {
        HashMap<String, List<String>> balanceDmDataMap = new HashMap<String, List<String>>();
        Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
        try (AlgoContext context = Algo.newContext();){
            String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
            for (Map.Entry<String, DiffAllocParamterEntry> entry : entrys.entrySet()) {
                QFilter filter = new QFilter("period", "=", (Object)entry.getValue().getPeriod());
                filter.and("costaccount.id", "=", (Object)entry.getValue().getCostAccountId());
                filter.and("accounttype", "=", (Object)"D");
                filter.and(this.getMatFilter("material.id", this.allocParam, entry.getValue()));
                String selectFields = diffallocDims + ",costelement as elementid,costsubelement as subelementid";
                DataSet data = null;
                Boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
                if (balCompress.booleanValue()) {
                    String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, null, Collections.singletonList(filter)});
                    data = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"getBalanceDmData"), true);
                    data = data.select(selectFields);
                } else {
                    data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_bal", (String)selectFields, (QFilter[])filter.toArray(), null);
                }
                HashSet<DataSet> balDatas = new HashSet<DataSet>(16);
                List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(entry.getValue().getCostAccountId(), entry.getValue().getPeriodId(), "<");
                int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
                for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
                    QFilter tempFilter = new QFilter("period", "in", (Object)periods);
                    tempFilter.and("endperiod", ">", (Object)entry.getValue().getPeriod());
                    tempFilter.and("costaccount.id", "=", (Object)entry.getValue().getCostAccountId());
                    tempFilter.and("accounttype", "=", (Object)"D");
                    tempFilter.and(this.getMatFilter("material.id", this.allocParam, entry.getValue()));
                    if (balCompress.booleanValue()) {
                        qFilterList.add(tempFilter);
                        continue;
                    }
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_bal", (String)selectFields, (QFilter[])tempFilter.toArray(), null);
                    balDatas.add(dataSet);
                }
                if (balCompress.booleanValue()) {
                    String cacheId = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalUncompressService", (String)"getBalancDataSetDetail", (Object[])new Object[]{false, false, null, qFilterList});
                    DataSet dataSet = Algo.getCacheDataSet((String)cacheId).toDataSet(Algo.create((String)"getBalanceDmData"), true);
                    dataSet = dataSet.select(selectFields);
                    balDatas.add(dataSet);
                }
                data = data.union(balDatas.toArray(new DataSet[0]));
                String groupStr = diffallocDims + ",elementid,subelementid";
                GroupbyDataSet groupDataSet = data.groupBy(groupStr.split(","));
                data = groupDataSet.finish().select(data.getRowMeta().getFieldNames());
                CalLogHelper.printLog("LinearEquationsDataFactory.getBalanceDmData->allData:", data);
                if (this.paramEntry.getAllocDimValsList() != null && !this.paramEntry.getAllocDimValsList().isEmpty()) {
                    DataSet filterData = this.getFilterData();
                    JoinDataSet joinData = data.join(filterData);
                    for (String string : this.allocParam.getCostSysAllocDims().split(",")) {
                        joinData.on(string, string);
                    }
                    data = joinData.select(data.getRowMeta().getFieldNames()).finish().groupBy(data.getRowMeta().getFieldNames()).finish();
                }
                CalLogHelper.printLog("LinearEquationsDataFactory.getBalanceDmData->filtedData:", data);
                for (Row row : data) {
                    void var23_30;
                    StringBuilder key = new StringBuilder();
                    String[] stringArray = this.allocParam.getEquationSetDims().split(",");
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var23_30 < n) {
                        String dimStr = stringArray[var23_30];
                        key.append(row.getString(dimStr)).append(SPLIT_TAG);
                        ++var23_30;
                    }
                    key.append(row.getString("elementid")).append(SPLIT_TAG);
                    key.append(row.getString("subelementid"));
                    String keyStr = key.toString();
                    StringBuilder value = new StringBuilder();
                    for (String field : diffallocDims.split(",")) {
                        value.append(row.getString(field)).append(SPLIT_TAG);
                    }
                    value.append(row.getString("elementid")).append(SPLIT_TAG);
                    value.append(row.getString("subelementid"));
                    if (balanceDmDataMap.containsKey(keyStr)) {
                        List list = (List)balanceDmDataMap.get(keyStr);
                        if (list.contains(value.toString())) continue;
                        list.add(value.toString());
                        continue;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(16);
                    arrayList.add(value.toString());
                    balanceDmDataMap.put(keyStr, arrayList);
                }
            }
        }
        return balanceDmDataMap;
    }

    private DataSet getFixedDiffOfQtyDatas(DiffAllocParamterEntry paramEntry) {
        DataSet allGroupData = null;
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", selectDMFileds, "");
        String selectFileds = dySelectFieldsStr + ",entry.baseqty*entry.signnum as periodissueqty,entry.noupdatecalfields as noupdatecalfields";
        RowMeta dataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", selectFileds);
        dataMeta.getField("periodissueqty").setDataType((DataType)DataType.BigDecimalType);
        Algo algo = Algo.create((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory");
        DataSet emptySet = algo.createDataSet(new ArrayList(), dataMeta);
        if (this.isBizGroup.booleanValue()) {
            allGroupData = this.getBizGroupDS();
            allGroupData = allGroupData.select("groupid,costrecordentryid,type,period");
        } else {
            Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
            QFilter acctGrpRecordFilter = new QFilter("entryentity.period", "=", (Object)this.paramEntry.getPeriodId());
            acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId()));
            acctGrpRecordFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
            acctGrpRecordFilter.and("entryentity.type", "=", (Object)"1");
            DataSet groupData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id", (QFilter[])acctGrpRecordFilter.toArray(), null);
            HashSet<Long> groupIds = new HashSet<Long>(10);
            HashSet<DataSet> groupDatas = new HashSet<DataSet>(16);
            for (Row row : groupData) {
                groupIds.add(row.getLong("id"));
                if (groupIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter filter = new QFilter("id", "in", groupIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
                groupIds = new HashSet(10);
            }
            if (groupIds.size() > 0) {
                QFilter filter = new QFilter("id", "in", groupIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
                groupIds = new HashSet(10);
            }
            RowMeta groupDdataMeta = ORM.create().createRowMeta("cal_account_grouprecord", "id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period");
            DataSet emptyGroupData = algo.createDataSet(new ArrayList(), groupDdataMeta);
            if (!groupDatas.isEmpty()) {
                allGroupData = emptyGroupData.union(groupDatas.toArray(new DataSet[0]));
            } else {
                return emptySet;
            }
        }
        if (!allGroupData.copy().isEmpty()) {
            allGroupData = allGroupData.filter("period<=" + this.paramEntry.getPeriodId());
        }
        QFilter filter = new QFilter("period.id", "=", (Object)this.paramEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)this.paramEntry.getCostAccountId());
        if (this.paramEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.paramEntry.getCalRangeId());
        }
        filter.and("calbilltype", "=", (Object)"IN");
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        DataSet costRecordData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)"bizentityobject,entry.id as costrecordentryid", (QFilter[])filter.toArray(), null);
        allGroupData = allGroupData.leftJoin(costRecordData).on("costrecordentryid", "costrecordentryid").select(allGroupData.getRowMeta().getFieldNames(), new String[]{"bizentityobject"}).finish();
        DataSet noDiffAllocEntryIds = allGroupData.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunction)new FilterNoAllocEntryIdsFunction());
        ArrayList<Long> costrecordEntryIds = new ArrayList<Long>(16);
        for (Row row : noDiffAllocEntryIds) {
            costrecordEntryIds.add(row.getLong("costrecordentryid"));
        }
        if (costrecordEntryIds.isEmpty()) {
            return emptySet;
        }
        HashSet costRecordDatas = new HashSet(16);
        QFilter billQFilter = new QFilter("costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        billQFilter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        billQFilter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        billQFilter.and("entry.queuetype", "=", (Object)"1");
        billQFilter.and(this.getMatFilter("entry.material.id", this.allocParam, paramEntry));
        int BATCH_SIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE);
        Lists.partition(costrecordEntryIds, (int)BATCH_SIZE).forEach(list -> {
            QFilter entryFilter = new QFilter("entry.id", "in", list);
            DataSet costrecordData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory.getFixedDiffOfQtyDatas()", (String)"cal_costrecord_subentity", (String)selectFileds, (QFilter[])new QFilter[]{billQFilter, entryFilter}, (String)null);
            costRecordDatas.add(costrecordData);
        });
        if (!costRecordDatas.isEmpty()) {
            return emptySet.union(costRecordDatas.toArray(new DataSet[0]));
        }
        return emptySet;
    }

    private String getDataKey(Row row) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        StringBuilder key = new StringBuilder();
        key.append(row.getString("difftype"));
        key.append(SPLIT_TAG);
        for (String field : diffallocDims.split(",")) {
            key.append(row.getString(field)).append(SPLIT_TAG);
        }
        key.append(row.getString("elementid"));
        key.append(SPLIT_TAG);
        key.append(row.getString("subelementid"));
        return key.toString();
    }

    private String getDataKey(String diffType, Row row) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        StringBuilder key = new StringBuilder();
        key.append(diffType);
        key.append(SPLIT_TAG);
        for (String field : diffallocDims.split(",")) {
            key.append(row.getString(field)).append(SPLIT_TAG);
        }
        key.append(row.getString("costelement"));
        key.append(SPLIT_TAG);
        key.append(row.getString("costsubelement"));
        return key.toString();
    }

    private DataSet getBizDiffData(DiffAllocParamterEntry entry, boolean isPrePeriod) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("period", isPrePeriod ? "<" : "=", (Object)entry.getPeriod());
        filter.and("endperiod", ">", (Object)entry.getPeriod());
        filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
        filter.and(this.getMatFilter("material.id", this.allocParam, entry));
        DataSet stdCostBalanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_purpricediff", (String)this.getAllDiffField(entry), (QFilter[])filter.toArray(), (String)null);
        HashSet<Long> balanceIds = new HashSet<Long>();
        for (Row row : stdCostBalanceData.copy()) {
            balanceIds.add(row.getLong("id"));
        }
        QFilter dtFilter = new QFilter("balid", "in", balanceIds);
        DataSet stdCostBalaDtData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_purpricediff_detail", (String)this.getAllDiffDtField(isPrePeriod), (QFilter[])dtFilter.toArray(), (String)null);
        JoinDataSet joinAllDataSet = stdCostBalanceData.join(stdCostBalaDtData, JoinType.LEFT).on("id", "balid");
        StringBuilder selectfields = new StringBuilder();
        selectfields.append("difftype, ");
        selectfields.append(diffallocDims);
        DataSet allDataSet = joinAllDataSet.select(selectfields.toString().split(","), "elementid,subelementid,diffamt,begindiffamt".split(",")).finish();
        return allDataSet.where("diffamt != 0 or begindiffamt != 0");
    }

    private DataSet getBizDiffDataByNewBalance(DiffAllocParamterEntry entry) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        DataSet stdCostBalanceData = null;
        List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(entry.getCostAccountId(), this.paramEntry.getPeriodId(), "<");
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)entry.getPeriod());
            filter.and("costaccount.id", "=", (Object)entry.getCostAccountId());
            filter.and(this.getMatFilter("material.id", this.allocParam, entry));
            if (stdCostBalanceData == null) {
                stdCostBalanceData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_standcost_bal", (String)this.getAllDiffFieldByNewBalance(this.paramEntry), (QFilter[])filter.toArray(), (String)null);
                continue;
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_standcost_bal", (String)this.getAllDiffFieldByNewBalance(this.paramEntry), (QFilter[])filter.toArray(), (String)null);
            stdCostBalanceData = stdCostBalanceData.union(dataSet);
        }
        if (stdCostBalanceData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u671f\u521d\u6570\u636e", (String)"DiffAllocDataFactory_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        stdCostBalanceData = stdCostBalanceData.filter((FilterFunction)new FilterDataSetFunctionNew(stdCostBalanceData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        StringBuilder selectfields = new StringBuilder();
        selectfields.append(diffallocDims);
        selectfields.append(",costelement,costsubelement,begindiffamt,diff_g,diff_h,diff_k,diff_m,diff_p");
        selectfields.append(",diff_q,diff_r,diff_s,diff_t,diff_c,diff_w,diff_x,diff_y");
        DataSet allDataSet = stdCostBalanceData.select(selectfields.toString());
        return allDataSet.where("diff_g != 0 or diff_h != 0 or diff_k != 0 or diff_m != 0 or diff_p != 0 or diff_q != 0 or diff_r != 0 or diff_s != 0 or diff_t != 0 or diff_c != 0 or diff_w != 0 or diff_x != 0 or diff_y != 0");
    }

    private String getAllDiffField(DiffAllocParamterEntry entry) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffallocDims, "");
        return "id,createtype as difftype," + dySelectStr;
    }

    private String getAllDiffFieldByNewBalance(DiffAllocParamterEntry entry) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String amtFields = "costdiff_bal as begindiffamt,diff_g_bal as diff_g,diff_h_bal as diff_h,diff_k_bal as diff_k,diff_m_bal as diff_m,diff_p_bal as diff_p,diff_q_bal as diff_q,diff_r_bal as diff_r,diff_s_bal as diff_s,diff_t_bal as diff_t,diff_c_bal as diff_c,diff_w_bal as diff_w,diff_x_bal as diff_x,diff_y_bal as diff_y";
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffallocDims, "");
        return "id,material.id as materialid," + dySelectStr + ",costelement as costelement,costsubelement as costsubelement," + amtFields;
    }

    private String getAllDiffDtField(boolean isPrePeriod) {
        String amtFields = isPrePeriod ? "0 as diffamt,periodendcostdiff as begindiffamt" : "periodincostdiff as diffamt,periodbegincostdiff as begindiffamt";
        return "id as sourDiffId,balid,costelement as elementid,costsubelement as subelementid," + amtFields;
    }

    private QFilter getMatFilter(String matField, DiffAllocParamter allocParam, DiffAllocParamterEntry paramEntry) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (paramEntry.getMatIdSet() != null && !paramEntry.getMatIdSet().isEmpty()) {
            filter.and(matField, "in", paramEntry.getMatIdSet());
        }
        return filter;
    }

    public BigDecimal[] resolve(BigDecimal[][] coef, BigDecimal[] b) {
        int n = coef.length;
        int[] shift = new int[n];
        for (int i = 0; i < n; ++i) {
            shift[i] = i;
        }
        for (int rows = 0; rows < n; ++rows) {
            int i;
            BigDecimal rightLowMax = BigDecimal.ZERO;
            int pickedRow = 0;
            int pickedColumn = 0;
            for (i = rows; i < n; ++i) {
                for (int j = rows; j < n; ++j) {
                    if (rightLowMax.compareTo(coef[i][j].abs()) >= 0) continue;
                    rightLowMax = coef[i][j].abs();
                    pickedRow = i;
                    pickedColumn = j;
                }
            }
            if (pickedColumn != rows) {
                for (i = 0; i < n; ++i) {
                    LinearEquationsDataFactory.swap(coef, i, rows, i, pickedColumn);
                }
                LinearEquationsDataFactory.swap(shift, rows, pickedColumn);
            }
            if (pickedRow != rows) {
                for (int j = rows; j < n; ++j) {
                    LinearEquationsDataFactory.swap(coef, rows, j, pickedRow, j);
                }
                LinearEquationsDataFactory.swap(b, rows, pickedRow);
            }
            for (int subrows = 0; subrows < n; ++subrows) {
                if (subrows == rows) continue;
                if (BigDecimal.ZERO.compareTo(coef[rows][rows]) == 0) {
                    String errorStr = ResManager.loadKDString((String)"\u4e3b\u5143\u7cfb\u6570\u4e3a\u96f6\uff0c\u65b9\u7a0b\u7ec4\u65e0\u89e3\u3002", (String)"DiffAllocService_9", (String)"fi-calx-algox", (Object[])new Object[0]);
                    throw new KDBizException(new ErrorCode(String.valueOf(rows), errorStr), new Object[0]);
                }
                BigDecimal m = coef[subrows][rows].divide(coef[rows][rows], 10, 4);
                for (int rowsRight = rows; rowsRight < n; ++rowsRight) {
                    coef[subrows][rowsRight] = coef[subrows][rowsRight].subtract(coef[rows][rowsRight].multiply(m)).setScale(10, 4);
                }
                b[subrows] = b[subrows].subtract(b[rows].multiply(m));
            }
        }
        BigDecimal[] x = new BigDecimal[n];
        for (int rows = 0; rows <= n; ++rows) {
            for (int i = 0; i < n; ++i) {
                if (shift[i] != rows) continue;
                x[shift[i]] = BigDecimal.ZERO.compareTo(coef[i][i]) == 0 ? BigDecimal.ZERO : b[i].divide(coef[i][i], 10, 4);
            }
        }
        return x;
    }

    public BigDecimal[] resolveNew(BigDecimal[][] srcCoefficients, BigDecimal[] srcConstants) {
        BigDecimal[] result = new BigDecimal[srcConstants.length];
        double[][] coef = new double[srcConstants.length][srcConstants.length];
        double[] con = new double[srcConstants.length];
        for (int i = 0; i < srcConstants.length; ++i) {
            con[i] = srcConstants[i].doubleValue();
            for (int j = 0; j < srcConstants.length; ++j) {
                coef[i][j] = srcCoefficients[i][j].doubleValue();
            }
        }
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(coef, false);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)coefficients).getSolver();
        ArrayRealVector constants = new ArrayRealVector(con, false);
        RealVector solution = solver.solve((RealVector)constants);
        for (int i = 0; i < srcConstants.length; ++i) {
            result[i] = BigDecimal.valueOf(solution.getEntry(i)).setScale(10, RoundingMode.HALF_UP);
        }
        return result;
    }

    public static void swap(BigDecimal[] a, int x, int y) {
        BigDecimal tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    public static void swap(int[] a, int x, int y) {
        int tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    public static void swap(BigDecimal[][] a, int x1, int y1, int x2, int y2) {
        BigDecimal tmp = a[x1][y1];
        a[x1][y1] = a[x2][y2];
        a[x2][y2] = tmp;
    }

    private String getBalanceBizField(Long periodId, Integer period) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return this.allocParam.getAllocDims() + ",costaccount,material, baseqty_bal end as periodbeginqty, 0 end as periodinqty, 0 end as periodissueqty, 0 end as periodinstandardcost, 0 end as periodissuesstandardcost";
        }
        return this.allocParam.getAllocDims() + ",costaccount,material, periodendqty end as periodbeginqty, 0 end as periodinqty, 0 end as periodissueqty, 0 end as periodinstandardcost, 0 end as periodissuesstandardcost";
    }

    public static void main(String[] args) {
        LinearEquationsDataFactory test = new LinearEquationsDataFactory(null, null);
        int count = 100;
        BigDecimal[] costmatrix = new BigDecimal[count];
        BigDecimal[][] varmatrix = new BigDecimal[count][count];
        for (int i = 0; i < count; ++i) {
            costmatrix[i] = BigDecimal.valueOf(1L);
        }
        for (int j = 0; j < count; ++j) {
            for (int d = 0; d < count; ++d) {
                varmatrix[j][d] = j == d ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        Long startTime = System.currentTimeMillis();
        System.out.println("resolve_start");
        BigDecimal[] result = test.resolve(varmatrix, costmatrix);
        Long endTime = System.currentTimeMillis();
        Long time = endTime - startTime;
        System.out.println("resolve_time" + time);
        test.close();
    }

    private DataSet getBalQty(QFilter filter, Long periodId, Integer period) {
        QFilter qfilter = new QFilter("costsubelement.id", "=", (Object)773175233367685120L);
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String selectQTYFileds = ",case when period = " + period + " then baseqty else baseqty_bal end as periodbeginqty,case when period = " + period + " then baseqty_in else 0 end as periodinqty,case when period = " + period + " then baseqty_out else 0 end as periodissueqty,case when period = " + period + " then standardcost_in else 0 end as periodinstandardcost,case when period = " + period + " then standardcost_out else 0 end as periodissuesstandardcost";
        DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)CalBalanceModelHelper.getBalanceEntityName(true), (String)(selectDMFileds + selectQTYFileds), (QFilter[])new QFilter[]{filter, qfilter}, null);
        data = data.filter((FilterFunction)new FilterDataSetFunctionNew(data.getRowMeta(), this.allocParam, this.paramEntry, ""));
        String groupDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        GroupbyDataSet groupDataSet = data.groupBy(groupDMFileds.split(","));
        groupDataSet.sum("periodbeginqty");
        groupDataSet.sum("periodinqty");
        groupDataSet.sum("periodissueqty");
        groupDataSet.sum("periodinstandardcost");
        groupDataSet.sum("periodissuesstandardcost");
        data = groupDataSet.finish();
        return data;
    }

    private DataSet getReworkDataNew(DiffAllocParamterEntry paramEntry, Set<Long> crossEntryIds, String diffallocDims) {
        QFilter filter = new QFilter("period.id", "=", (Object)paramEntry.getPeriodId());
        Long costAccountId = paramEntry.getCostAccountId();
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        if (paramEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)paramEntry.getCalRangeId());
        }
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, paramEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.id", "not in", crossEntryIds);
        QFilter billTypeQFilter = new QFilter("bizentityobject", "in", (Object)new String[]{"im_mdc_mftmanuinbill", "im_mdc_omcmplinbill", "im_mdc_mftreturnbill", "im_productinbill"});
        String inDySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "in");
        String inSelectStr = "'IN' as incalbilltype,bizentityobject as inbizentityobject,' ' as inbillno," + inDySelectFields + ",entry.mainbillentryid as mainbillentryid,entry.noupdatecalfields as noupdatecalfields";
        DataSet reworkInBillData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)inSelectStr, (QFilter[])new QFilter[]{filter, billTypeQFilter}, null);
        reworkInBillData = reworkInBillData.groupBy(new String[]{"inmaterial"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(reworkInBillData.getRowMeta(), "in"));
        reworkInBillData = reworkInBillData.filter((FilterFunction)new FilterDataSetFunctionNew(reworkInBillData.getRowMeta(), this.allocParam, this.paramEntry, "in"));
        reworkInBillData = reworkInBillData.groupBy(reworkInBillData.getRowMeta().getFieldNames()).finish();
        QFilter outBillTypeQFilter = new QFilter("bizentityobject", "in", (Object)new String[]{"im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_materialreqoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill", "im_mdc_mftfeedorder", "im_mdc_omoutbill"});
        outBillTypeQFilter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        if (CalDbParamServiceHelper.getBoolean(CalDbParamConstant.ISONLYGETREWORK).booleanValue()) {
            outBillTypeQFilter.and("entry.isrework", "=", (Object)"1");
        }
        String outDySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "out");
        String outSelectStr = "'OUT' as outcalbilltype,bizentityobject as outbizentityobject,billno as outbillno," + outDySelectFields + ",entry.mainbillentryid as mainbillentryid,entry.baseqty as baseqty,entry.noupdatecalfields as noupdatecalfields";
        DataSet reworkOutBillData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)outSelectStr, (QFilter[])new QFilter[]{filter, outBillTypeQFilter}, null);
        reworkOutBillData = reworkOutBillData.groupBy(new String[]{"outmaterial"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(reworkOutBillData.getRowMeta(), "out"));
        reworkOutBillData = reworkOutBillData.filter((FilterFunction)new FilterDataSetFunctionNew(reworkOutBillData.getRowMeta(), this.allocParam, this.paramEntry, "out"));
        JoinDataSet inBillJoin = reworkOutBillData.leftJoin(reworkInBillData).on("mainbillentryid", "mainbillentryid");
        StringBuilder outDySelects = new StringBuilder();
        outDySelects.append("outcalbilltype,outbizentityobject,outbillno,");
        for (String field : diffallocDims.split(",")) {
            outDySelects.append("out").append(field).append(",");
        }
        String outDySelectStr = outDySelects.toString();
        StringBuilder inDySelects = new StringBuilder();
        inDySelects.append("incalbilltype,inbizentityobject,inbillno,");
        for (String field : diffallocDims.split(",")) {
            inDySelects.append("in").append(field).append(",");
        }
        inDySelects.append("baseqty");
        String inDySelectStr = inDySelects.toString();
        DataSet groupBillData = inBillJoin.select(outDySelectStr.split(","), inDySelectStr.split(",")).finish().filter("inmaterial is not null");
        return groupBillData;
    }

    private DataSet getFilterData() {
        String allDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getEquationSetDims(), this.allocParam.getAllocDims());
        String[] dims = allDims.split(",");
        ArrayList<String> dimsKeys = new ArrayList<String>(16);
        for (String dim : dims) {
            if (!CAlSYS_DIFFALLOC_DIMS.contains(dim)) continue;
            dimsKeys.add(dim);
        }
        RowMeta rowMeta = ORM.create().createRowMeta("cal_bal", String.join((CharSequence)",", dimsKeys));
        DataSetBuilder fitlerDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map<String, Object> values : this.paramEntry.getAllocDimValsList()) {
            Object[] vals = new Object[rowMeta.getFieldCount()];
            int index = 0;
            for (String field : rowMeta.getFieldNames()) {
                vals[index++] = "costaccount".equals(field) ? this.paramEntry.getCostAccountId() : ("calorg".equals(field) ? this.paramEntry.getCalOrgId() : values.get(field));
            }
            fitlerDataSetBuilder.append(vals);
        }
        return fitlerDataSetBuilder.build();
    }

    private DataSet getTransOutToIn(Set<Long> crossEntryIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        QFilter filter = new QFilter("period.id", "=", (Object)this.paramEntry.getPeriodId());
        Long costAccountId = this.paramEntry.getCostAccountId();
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
        if (this.paramEntry.getCalRangeId() != 0L) {
            filter.and("entry.calrange", "=", (Object)this.paramEntry.getCalRangeId());
        }
        filter.and("bizentityobject", "in", (Object)new String[]{"im_transoutbill", "im_transinbill"});
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and(this.getMatFilter("entry.material.id", this.allocParam, this.paramEntry));
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.id", "not in", crossEntryIds);
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
        DataSet transBillData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)("calbilltype,billno,entry.id as costrecordentryid," + dySelectFields + ",entry.baseqty as baseqty,entry.noupdatecalfields as noupdatecalfields,bizentityobject"), (QFilter[])filter.toArray(), (String)null);
        transBillData = transBillData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(transBillData.getRowMeta()));
        transBillData = transBillData.filter((FilterFunction)new FilterDataSetFunctionNew(transBillData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        QFilter grpFilter = new QFilter("entryentity.period.id", "=", (Object)this.paramEntry.getPeriodId());
        grpFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId()));
        grpFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
        grpFilter.and("costaccounttype.id", "=", (Object)this.paramEntry.getCostAccountTypeId());
        DataSet grpData = null;
        if (this.isBizGroup.booleanValue()) {
            grpData = this.getBizGroupDS();
            grpData = grpData.select("groupid as bizgrouprecordid,costrecordentryid as billentryid,type");
        } else {
            grpData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"bizgrouprecordid,entryentity.costrecordentryid as billentryid,entryentity.type as type", (QFilter[])grpFilter.toArray(), null);
        }
        transBillData = grpData.leftJoin(transBillData).on("billentryid", "costrecordentryid").select(new String[]{"bizgrouprecordid", "type"}, transBillData.getRowMeta().getFieldNames()).finish().filter("costrecordentryid is not null");
        DataSet[] transOutBillDatas = transBillData.splitByFilter(new String[]{"type ='0' and bizentityobject = 'im_transoutbill' and calbilltype = 'OUT'", "type ='1' and bizentityobject = 'im_transoutbill' and calbilltype = 'IN'", "type ='0' and bizentityobject = 'im_transoutbill' and calbilltype = 'IN'", "type ='1' and bizentityobject = 'im_transinbill' and calbilltype = 'OUT'", "type ='0' and bizentityobject = 'im_transinbill' and calbilltype = 'OUT'", "type ='1' and bizentityobject = 'im_transinbill' and calbilltype = 'IN'"}, true);
        String outBill_1SeltFeilds = "calbilltype as out_1calbilltype,billno as out_1billno,costrecordentryid as out_1costrecordentryid," + this.getDySelectFields(diffallocDims, " as out_1") + ",baseqty as out_1baseqty,bizentityobject as out_1bizentityobject,bizgrouprecordid as out_1bizgrouprecordid";
        DataSet transOutBill_1Data = transOutBillDatas[0].select(outBill_1SeltFeilds);
        String outBill_2SeltFeilds = "calbilltype as out_2calbilltype,billno as out_2billno,costrecordentryid as out_2costrecordentryid," + this.getDySelectFields(diffallocDims, " as out_2") + ",baseqty as out_2baseqty,bizentityobject as out_2bizentityobject,bizgrouprecordid as out_2bizgrouprecordid";
        DataSet transOutBill_2Data = transOutBillDatas[1].select(outBill_2SeltFeilds);
        DataSet transOutBillData = transOutBill_1Data.leftJoin(transOutBill_2Data).on("out_1bizgrouprecordid", "out_2bizgrouprecordid").select(transOutBill_1Data.getRowMeta().getFieldNames(), transOutBill_2Data.getRowMeta().getFieldNames()).finish();
        DataSet transOut_2AndInBillData = transOutBillDatas[2].select("costrecordentryid as out_2costrecordentryid,bizgrouprecordid");
        DataSet transOutAndIn_1BillData = transOutBillDatas[3].select("costrecordentryid as in_1costrecordentryid,bizgrouprecordid");
        DataSet transOutAndInBillData = transOut_2AndInBillData.leftJoin(transOutAndIn_1BillData).on("bizgrouprecordid", "bizgrouprecordid").select(new String[]{"out_2costrecordentryid"}, new String[]{"in_1costrecordentryid"}).finish();
        String inBill_1SeltFeilds = "calbilltype as in_1calbilltype,billno as in_1billno,costrecordentryid as in_1costrecordentryid," + this.getDySelectFields(diffallocDims, " as in_1") + ",baseqty as in_1baseqty,bizentityobject as in_1bizentityobject,bizgrouprecordid as in_1bizgrouprecordid";
        DataSet transInBill_1Data = transOutBillDatas[4].select(inBill_1SeltFeilds);
        String inBill_2SeltFeilds = "calbilltype as in_2calbilltype,billno as in_2billno,costrecordentryid as in_2costrecordentryid," + this.getDySelectFields(diffallocDims, " as in_2") + ",baseqty as in_2baseqty,bizentityobject as in_2bizentityobject,bizgrouprecordid as in_2bizgrouprecordid";
        DataSet transInBill_2Data = transOutBillDatas[5].select(inBill_2SeltFeilds);
        DataSet transInBillData = transInBill_1Data.leftJoin(transInBill_2Data).on("in_1bizgrouprecordid", "in_2bizgrouprecordid").select(transInBill_1Data.getRowMeta().getFieldNames(), transInBill_2Data.getRowMeta().getFieldNames()).finish();
        DataSet transAllBillData = transOutBillData.leftJoin(transOutAndInBillData).on("out_2costrecordentryid", "out_2costrecordentryid").select(transOutBillData.getRowMeta().getFieldNames(), new String[]{"in_1costrecordentryid"}).finish();
        transAllBillData = transAllBillData.leftJoin(transInBillData).on("in_1costrecordentryid", "in_1costrecordentryid").select(this.removeFieldFromArray(transAllBillData.getRowMeta().getFieldNames(), "in_1costrecordentryid"), transInBillData.getRowMeta().getFieldNames()).finish();
        return transAllBillData;
    }

    private DataSet getTransOutToInNew(Set<Long> crossEntryIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", diffallocDims, "");
        Map<String, String> headEntryMap = this.getHeadEntryMap(dySelectFields, Sets.newHashSet((Object[])new String[]{"billno", "calbilltype", "bizentityobject"}), Sets.newHashSet((Object[])new String[]{"fentryid", "fbaseqty", "fnoupdatecalfields"}), "fentryid as costrecordentryid,fbaseqty as baseqty,fnoupdatecalfields as noupdatecalfields");
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("SELECT ", new Object[0]).append(headEntryMap.get("entry"), new Object[0]);
        balSql.append(" FROM ", new Object[0]).append("T_CAL_CALCOSTRECORDENTRY", new Object[0]);
        balSql.append(" WHERE FACCOUNTTYPE='D'", new Object[0]);
        if (this.paramEntry.getMatIdSet() != null && !this.paramEntry.getMatIdSet().isEmpty()) {
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn("FMATERIALID", this.paramEntry.getMatIdSet().toArray());
        }
        if (this.paramEntry.getCalRangeId() != 0L) {
            balSql.append(" AND FCALRANGEID = " + this.paramEntry.getCalRangeId(), new Object[0]);
        }
        if (crossEntryIds != null && !crossEntryIds.isEmpty()) {
            balSql.append(" AND FENTRYID NOT IN" + this.getIdParam(crossEntryIds), new Object[0]);
        }
        DataSet entryDataSet = null;
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.paramEntry.getCostAccountId()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.paramEntry.getStartDate()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)this.paramEntry.getEndDate())});
        Object object = null;
        try {
            ctx.set();
            entryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balSql);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        ArrayList<Long> fids = new ArrayList<Long>(500);
        for (Object row : entryDataSet.copy()) {
            fids.add(row.getLong("fid"));
        }
        fids.add(0L);
        DataSet headDataSet = null;
        for (List ids : Lists.partition(fids, (int)500000)) {
            QFilter filter = new QFilter("costaccount", "=", (Object)this.paramEntry.getCostAccountId());
            filter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            filter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            filter.and("period", "=", (Object)this.paramEntry.getPeriodId());
            filter.and("billstatus", "=", (Object)"C");
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("bizentityobject", "in", (Object)new String[]{"im_transoutbill", "im_transinbill"});
            filter.and("id", "in", (Object)ids);
            DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)headEntryMap.get("head"), (QFilter[])filter.toArray(), (String)null);
            if (headDataSet == null) {
                headDataSet = data;
                continue;
            }
            headDataSet = headDataSet.union(data);
        }
        if (headDataSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u5934\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u5207\u6362\u67e5\u8be2\u6a21\u5f0f", (String)"LinearEquationsDataFactory_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DataSet transBillData = headDataSet.join(entryDataSet).on("id", "fid").select(headEntryMap.get("head").split(","), headEntryMap.get("selEntry").split(",")).finish();
        transBillData = transBillData.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(transBillData.getRowMeta()));
        transBillData = transBillData.filter((FilterFunction)new FilterDataSetFunctionNew(transBillData.getRowMeta(), this.allocParam, this.paramEntry, ""));
        QFilter grpFilter = new QFilter("entryentity.period.id", "=", (Object)this.paramEntry.getPeriodId());
        grpFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId()));
        grpFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
        grpFilter.and("costaccounttype.id", "=", (Object)this.paramEntry.getCostAccountTypeId());
        DataSet grpData = null;
        if (this.isBizGroup.booleanValue()) {
            grpData = this.getBizGroupDS();
            grpData = grpData.select("groupid as bizgrouprecordid,costrecordentryid as billentryid,type");
        } else {
            grpData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"bizgrouprecordid,entryentity.costrecordentryid as billentryid,entryentity.type as type", (QFilter[])grpFilter.toArray(), null);
        }
        transBillData = grpData.leftJoin(transBillData).on("billentryid", "costrecordentryid").select(new String[]{"bizgrouprecordid", "type"}, transBillData.getRowMeta().getFieldNames()).finish().filter("costrecordentryid is not null");
        DataSet[] transOutBillDatas = transBillData.splitByFilter(new String[]{"type ='0' and bizentityobject = 'im_transoutbill' and calbilltype = 'OUT'", "type ='1' and bizentityobject = 'im_transoutbill' and calbilltype = 'IN'", "type ='0' and bizentityobject = 'im_transoutbill' and calbilltype = 'IN'", "type ='1' and bizentityobject = 'im_transinbill' and calbilltype = 'OUT'", "type ='0' and bizentityobject = 'im_transinbill' and calbilltype = 'OUT'", "type ='1' and bizentityobject = 'im_transinbill' and calbilltype = 'IN'"}, true);
        String outBill_1SeltFeilds = "calbilltype as out_1calbilltype,billno as out_1billno,costrecordentryid as out_1costrecordentryid," + this.getDySelectFields(diffallocDims, " as out_1") + ",baseqty as out_1baseqty,bizentityobject as out_1bizentityobject,bizgrouprecordid as out_1bizgrouprecordid";
        DataSet transOutBill_1Data = transOutBillDatas[0].select(outBill_1SeltFeilds);
        String outBill_2SeltFeilds = "calbilltype as out_2calbilltype,billno as out_2billno,costrecordentryid as out_2costrecordentryid," + this.getDySelectFields(diffallocDims, " as out_2") + ",baseqty as out_2baseqty,bizentityobject as out_2bizentityobject,bizgrouprecordid as out_2bizgrouprecordid";
        DataSet transOutBill_2Data = transOutBillDatas[1].select(outBill_2SeltFeilds);
        DataSet transOutBillData = transOutBill_1Data.leftJoin(transOutBill_2Data).on("out_1bizgrouprecordid", "out_2bizgrouprecordid").select(transOutBill_1Data.getRowMeta().getFieldNames(), transOutBill_2Data.getRowMeta().getFieldNames()).finish();
        DataSet transOut_2AndInBillData = transOutBillDatas[2].select("costrecordentryid as out_2costrecordentryid,bizgrouprecordid");
        DataSet transOutAndIn_1BillData = transOutBillDatas[3].select("costrecordentryid as in_1costrecordentryid,bizgrouprecordid");
        DataSet transOutAndInBillData = transOut_2AndInBillData.leftJoin(transOutAndIn_1BillData).on("bizgrouprecordid", "bizgrouprecordid").select(new String[]{"out_2costrecordentryid"}, new String[]{"in_1costrecordentryid"}).finish();
        String inBill_1SeltFeilds = "calbilltype as in_1calbilltype,billno as in_1billno,costrecordentryid as in_1costrecordentryid," + this.getDySelectFields(diffallocDims, " as in_1") + ",baseqty as in_1baseqty,bizentityobject as in_1bizentityobject,bizgrouprecordid as in_1bizgrouprecordid";
        DataSet transInBill_1Data = transOutBillDatas[4].select(inBill_1SeltFeilds);
        String inBill_2SeltFeilds = "calbilltype as in_2calbilltype,billno as in_2billno,costrecordentryid as in_2costrecordentryid," + this.getDySelectFields(diffallocDims, " as in_2") + ",baseqty as in_2baseqty,bizentityobject as in_2bizentityobject,bizgrouprecordid as in_2bizgrouprecordid";
        DataSet transInBill_2Data = transOutBillDatas[5].select(inBill_2SeltFeilds);
        DataSet transInBillData = transInBill_1Data.leftJoin(transInBill_2Data).on("in_1bizgrouprecordid", "in_2bizgrouprecordid").select(transInBill_1Data.getRowMeta().getFieldNames(), transInBill_2Data.getRowMeta().getFieldNames()).finish();
        DataSet transAllBillData = transOutBillData.leftJoin(transOutAndInBillData).on("out_2costrecordentryid", "out_2costrecordentryid").select(transOutBillData.getRowMeta().getFieldNames(), new String[]{"in_1costrecordentryid"}).finish();
        transAllBillData = transAllBillData.leftJoin(transInBillData).on("in_1costrecordentryid", "in_1costrecordentryid").select(this.removeFieldFromArray(transAllBillData.getRowMeta().getFieldNames(), "in_1costrecordentryid"), transInBillData.getRowMeta().getFieldNames()).finish();
        return transAllBillData;
    }

    public DataSet getTransOutToIn_1And2(Set<Long> crossEntryIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        Boolean splitQuery = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.QUERY_HEAD_ENTRY_SPILT);
        DataSet transAllBillData = null;
        transAllBillData = splitQuery != false ? this.getTransOutToInNew(crossEntryIds) : this.getTransOutToIn(crossEntryIds);
        StringBuilder outDySelects = new StringBuilder();
        outDySelects.append("out_1calbilltype as  outcalbilltype,out_1bizentityobject as  outbizentityobject,out_1billno as outbillno,");
        for (String field : diffallocDims.split(",")) {
            outDySelects.append("out_1").append(field).append(" as out").append(field).append(",");
        }
        String outDySelectStr = outDySelects.toString();
        StringBuilder in_1DySelects = new StringBuilder();
        in_1DySelects.append("in_1calbilltype as  incalbilltype,in_1bizentityobject as  inbizentityobject,in_1billno as inbillno,");
        for (String field : diffallocDims.split(",")) {
            in_1DySelects.append("in_1").append(field).append(" as in").append(field).append(",");
        }
        in_1DySelects.append("in_1baseqty as baseqty");
        DataSet transOut_1ToIn_1BillData = transAllBillData.copy().select(outDySelectStr + in_1DySelects);
        StringBuilder in_2DySelects = new StringBuilder();
        in_2DySelects.append("in_2calbilltype as  incalbilltype,in_2bizentityobject as  inbizentityobject,in_2billno as inbillno,");
        for (String field : diffallocDims.split(",")) {
            in_2DySelects.append("in_2").append(field).append(" as in").append(field).append(",");
        }
        in_2DySelects.append("in_1baseqty as baseqty");
        DataSet transOut_1ToIn_2BillData = transAllBillData.copy().select(outDySelectStr + in_2DySelects);
        return transOut_1ToIn_1BillData.union(transOut_1ToIn_2BillData);
    }

    public DataSet getTransOutToIn_1(Set<Long> crossEntryIds) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        DataSet transAllBillData = this.getTransOutToIn(crossEntryIds);
        StringBuilder outDySelects = new StringBuilder();
        outDySelects.append("out_1calbilltype as  outcalbilltype,out_1bizentityobject as  outbizentityobject,");
        for (String field : diffallocDims.split(",")) {
            outDySelects.append("out_1").append(field).append(" as out").append(field).append(",");
        }
        outDySelects.append("out_1costrecordentryid,");
        String outDySelectStr = outDySelects.toString();
        DataSet transOut_1ToIn_1BillData = transAllBillData.copy().select(outDySelectStr + "in_1costrecordentryid");
        return transOut_1ToIn_1BillData;
    }

    private String getDySelectFields(String diffallocDims, String aliasname) {
        StringBuilder sb = new StringBuilder();
        for (String field : diffallocDims.split(",")) {
            sb.append(",");
            sb.append(field);
            sb.append(aliasname);
            sb.append(field);
        }
        return sb.substring(1);
    }

    private String[] removeFieldFromArray(String[] fileds, String removeField) {
        String fieldsStr = String.join((CharSequence)",", fileds);
        fieldsStr = fieldsStr.replace(removeField, "");
        return fieldsStr.split(",");
    }

    private String[] getAliasFiledFromCache(RowMeta srcRowMeta) {
        Object[] fields = new String[srcRowMeta.getFieldCount() + 10];
        int index = 0;
        fields[index++] = "'OUT' as outcalbilltype";
        fields[index++] = "' ' as outbizentityobject";
        fields[index++] = "' ' as outbillno";
        fields[index++] = this.paramEntry.getCalOrgId() + "L  as outcalorg";
        fields[index++] = this.paramEntry.getCostAccountId() + "L  as outcostaccount";
        fields[index++] = "'IN' as incalbilltype";
        fields[index++] = "' ' as inbizentityobject";
        fields[index++] = "' ' as inbillno";
        fields[index++] = this.paramEntry.getCalOrgId() + "L as incalorg";
        fields[index++] = this.paramEntry.getCostAccountId() + "L  as incostaccount";
        for (String field : srcRowMeta.getFieldNames()) {
            fields[index++] = field;
        }
        CalLogHelper.printLog("LinearEquationsDataFactory.getAliasFiledFromCache->srcRowMeta:", Arrays.toString(fields));
        return fields;
    }

    private String[] getAliasFiledFromCache2(RowMeta srcRowMeta) {
        Object[] fields = new String[srcRowMeta.getFieldCount() + 3];
        int index = 0;
        fields[index++] = this.paramEntry.getCalOrgId() + "L  as calorg";
        fields[index++] = this.paramEntry.getCostAccountId() + "L  as costaccount";
        fields[index++] = " ' ' as noupdatecalfields";
        for (String field : srcRowMeta.getFieldNames()) {
            fields[index++] = field;
        }
        CalLogHelper.printLog("LinearEquationsDataFactory.getAliasFiledFromCache2->srcRowMeta:", Arrays.toString(fields));
        return fields;
    }

    private Map<String, String> getHeadEntryMap(String selectFields, Set<String> headAddField, Set<String> entryAddField, String entryTransForSql) {
        StringJoiner headSelectField = new StringJoiner(",");
        headSelectField.add("id");
        StringJoiner entrySelectField = new StringJoiner(",");
        entrySelectField.add("fid");
        StringJoiner selEntrySelectField = new StringJoiner(",");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String field : selectFields.split(",")) {
            if (field.contains("entry")) {
                String proField = field.split("as ")[1];
                IDataEntityProperty property = entityType.findProperty(proField);
                if (property == null) continue;
                entrySelectField.add(property.getAlias());
                selEntrySelectField.add(property.getAlias() + " as " + proField);
                continue;
            }
            headSelectField.add(field.split("as ")[1]);
        }
        for (String headField : headAddField) {
            headSelectField.add(headField);
        }
        map.put("head", headSelectField.toString());
        for (String entryField : entryAddField) {
            entrySelectField.add(entryField);
        }
        map.put("entry", entrySelectField.toString());
        selEntrySelectField.add(entryTransForSql);
        map.put("selEntry", selEntrySelectField.toString());
        return map;
    }

    private String getIdParam(Set<Long> crossEntryIds) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (Long crossEntryId : crossEntryIds) {
            stringJoiner.add(crossEntryId.toString());
        }
        return stringJoiner.toString();
    }

    private DataSet getFixedDiffOfQtyDatasNew(DiffAllocParamterEntry paramEntry) {
        Object groupIds;
        DataSet allGroupData = null;
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        String dySelectFieldsStr = ExFieldHelper.getSelectFieldsStr("cal_costrecord_subentity", selectDMFileds, "");
        String selectFileds = dySelectFieldsStr + ",entry.baseqty*entry.signnum as periodissueqty,entry.noupdatecalfields as noupdatecalfields";
        RowMeta dataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", selectFileds);
        dataMeta.getField("periodissueqty").setDataType((DataType)DataType.BigDecimalType);
        Algo algo = Algo.create((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory");
        DataSet emptySet = algo.createDataSet(new ArrayList(), dataMeta);
        if (this.isBizGroup.booleanValue()) {
            allGroupData = this.getBizGroupDS();
            allGroupData = allGroupData.select("groupid,costrecordentryid,type,period");
        } else {
            Map<String, DiffAllocParamterEntry> entrys = this.allocParam.getEntityEntry();
            QFilter acctGrpRecordFilter = new QFilter("entryentity.period", "=", (Object)this.paramEntry.getPeriodId());
            acctGrpRecordFilter.and(new QFilter("entryentity.costaccount.id", "=", (Object)this.paramEntry.getCostAccountId()));
            acctGrpRecordFilter.and(this.getMatFilter("entryentity.material.id", this.allocParam, this.paramEntry));
            acctGrpRecordFilter.and("entryentity.type", "=", (Object)"1");
            DataSet groupData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id", (QFilter[])acctGrpRecordFilter.toArray(), null);
            groupIds = new HashSet<Long>(10);
            HashSet<DataSet> groupDatas = new HashSet<DataSet>(16);
            for (Row row : groupData) {
                groupIds.add(row.getLong("id"));
                if (groupIds.size() <= CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE)) continue;
                QFilter filter = new QFilter("id", "in", groupIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
                groupIds = new HashSet(10);
            }
            if (groupIds.size() > 0) {
                QFilter filter = new QFilter("id", "in", groupIds);
                DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_account_grouprecord", (String)"id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period", (QFilter[])filter.toArray(), null);
                groupDatas.add(data);
                groupIds = new HashSet(10);
            }
            RowMeta groupDdataMeta = ORM.create().createRowMeta("cal_account_grouprecord", "id as groupid,entryentity.costrecordentryid as costrecordentryid,entryentity.type as type,entryentity.period as period");
            DataSet emptyGroupData = algo.createDataSet(new ArrayList(), groupDdataMeta);
            if (!groupDatas.isEmpty()) {
                allGroupData = emptyGroupData.union(groupDatas.toArray(new DataSet[0]));
            } else {
                return emptySet;
            }
        }
        if (!allGroupData.copy().isEmpty()) {
            allGroupData = allGroupData.filter("period<=" + this.paramEntry.getPeriodId());
        }
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("SELECT FID,FENTRYID FROM T_CAL_CALCOSTRECORDENTRY", new Object[0]);
        balSql.append(" WHERE FACCOUNTTYPE = 'D'", new Object[0]);
        if (paramEntry.getMatIdSet() != null && !paramEntry.getMatIdSet().isEmpty()) {
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn("FMATERIALID", paramEntry.getMatIdSet().toArray());
        }
        if (this.paramEntry.getCalRangeId() != 0L) {
            balSql.append(" AND FCALRANGEID = " + paramEntry.getCalRangeId(), new Object[0]);
        }
        DataSet entryDataSet = null;
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.eq, (Object)this.paramEntry.getCostAccountId()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)this.paramEntry.getStartDate()), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)paramEntry.getEndDate())});
        groupIds = null;
        try {
            ctx.set();
            entryDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("cal"), (SqlBuilder)balSql);
        }
        catch (Throwable groupDatas) {
            groupIds = groupDatas;
            throw groupDatas;
        }
        finally {
            if (ctx != null) {
                if (groupIds != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable groupDatas) {
                        ((Throwable)groupIds).addSuppressed(groupDatas);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        ArrayList<Long> fids = new ArrayList<Long>(500);
        fids.add(0L);
        for (Object row : entryDataSet.copy()) {
            fids.add(row.getLong("fid"));
        }
        Iterator headDataSet = null;
        for (List ids : Lists.partition(fids, (int)500000)) {
            QFilter headFilter = new QFilter("costaccount", "=", (Object)this.paramEntry.getCostAccountId());
            headFilter.and("bookdate", ">=", (Object)this.paramEntry.getStartDate());
            headFilter.and("bookdate", "<=", (Object)this.paramEntry.getEndDate());
            headFilter.and("period", "=", (Object)this.paramEntry.getPeriodId());
            headFilter.and("billstatus", "=", (Object)"C");
            headFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
            headFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            headFilter.and("calbilltype", "=", (Object)"IN");
            headFilter.and("id", "in", (Object)ids);
            Iterator data = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory", (String)"cal_costrecord_subentity", (String)"id,bizentityobject", (QFilter[])headFilter.toArray(), (String)null);
            if (headDataSet == null) {
                headDataSet = data;
                continue;
            }
            headDataSet = headDataSet.union((DataSet)data);
        }
        if (headDataSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u5934\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u5207\u6362\u67e5\u8be2\u6a21\u5f0f", (String)"LinearEquationsDataFactory_1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DataSet costRecordData = headDataSet.join(entryDataSet).on("id", "fid").select(headDataSet.getRowMeta().getFieldNames(), new String[]{"FENTRYID as costrecordentryid"}).finish();
        allGroupData = allGroupData.leftJoin(costRecordData).on("costrecordentryid", "costrecordentryid").select(allGroupData.getRowMeta().getFieldNames(), new String[]{"bizentityobject"}).finish();
        DataSet noDiffAllocEntryIds = allGroupData.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunction)new FilterNoAllocEntryIdsFunction());
        ArrayList<Long> costrecordEntryIds = new ArrayList<Long>(16);
        for (Row row : noDiffAllocEntryIds) {
            costrecordEntryIds.add(row.getLong("costrecordentryid"));
        }
        if (costrecordEntryIds.isEmpty()) {
            return emptySet;
        }
        HashSet costRecordDatas = new HashSet(16);
        QFilter billQFilter = new QFilter("costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        billQFilter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        billQFilter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        billQFilter.and("entry.queuetype", "=", (Object)"1");
        billQFilter.and(this.getMatFilter("entry.material.id", this.allocParam, paramEntry));
        int BATCH_SIZE = CalDbParamServiceHelper.getInteger(CalDbParamConstant.QUERY_IN_SPRITSIZE);
        Lists.partition(costrecordEntryIds, (int)BATCH_SIZE).forEach(list -> {
            QFilter entryFilter = new QFilter("entry.id", "in", list);
            DataSet costrecordData = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.DiffAllocDataFactory.getFixedDiffOfQtyDatas()", (String)"cal_costrecord_subentity", (String)selectFileds, (QFilter[])new QFilter[]{billQFilter, entryFilter}, (String)null);
            costRecordDatas.add(costrecordData);
        });
        if (!costRecordDatas.isEmpty()) {
            return emptySet.union(costRecordDatas.toArray(new DataSet[0]));
        }
        return emptySet;
    }
}

