/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class PartitionTaskService {
    private static final Log logger = LogFactory.getLog(PartitionTaskService.class);
    private static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };

    public Set<String> execute(Map<String, Object> paramMap) throws KDException {
        HashSet<String> taskIds = new HashSet<String>(16);
        taskIds.add("12321412");
        Set partialDms = (Set)paramMap.get("partialDm");
        if (partialDms == null || partialDms.isEmpty()) {
            return taskIds;
        }
        String taskName = (String)paramMap.get("taskName");
        List<Set<Object>> batchList = this.spritBatch(paramMap);
        boolean isSynchronous = (Boolean)paramMap.get("isSynchronous");
        int batchIndex = 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        taskFilter.and("status", "=", (Object)"BEGIN");
        taskFilter.and("runtime", ">=", (Object)calendar.getTime());
        Object fixedParam = paramMap.get("fixedParam");
        DiffAllocParamter diffAllocParamter = (DiffAllocParamter)fixedParam;
        String allDims = DiffAllocHelper.mergDiffAllocDims(diffAllocParamter.getEquationSetDims(), diffAllocParamter.getAllocDims());
        String[] dims = allDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (Set<Object> currBatchDm : batchList) {
            StringBuilder matids = new StringBuilder();
            for (Object matid : currBatchDm) {
                matids.append(matid).append(",");
            }
            String taskid = this.sendTask(diffAllocParamter.getReportId(), paramMap, currBatchDm, batchList.size(), batchIndex++, dimsKeys);
            taskIds.add(taskid);
            logger.info("this-taskid: " + taskid + ",currBatch:" + batchIndex + "/" + batchList.size() + ", total task currBatchDm:" + matids);
        }
        logger.info("this-task-is: " + taskName + " total task size:" + taskIds.size() + ",taskID:" + taskIds);
        if (!isSynchronous) {
            return taskIds;
        }
        Boolean stayConnected = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.STAY_CONNECTED);
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            if (runningTasks.size() == batchList.size()) {
                QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                failTtaskFilter.and("status", "=", (Object)"FAILED");
                failTtaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                if (failTasks != null && failTasks.size() > 0) {
                    throw new KDBizException(taskName + "task\uff0cPartitionTaskService.execute failed\u3002");
                }
                return taskIds;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.info("PartitionTaskService execute", (Object)e);
            }
            if (!stayConnected.booleanValue()) continue;
            QFilter filter = new QFilter("id", "=", (Object)0L);
            QueryServiceHelper.queryOne((String)"cal_dbparam", (String)"id", (QFilter[])new QFilter[]{filter});
        }
    }

    private String sendTask(Long reportId, Map<String, Object> paramMap, Set<Object> currBatchDms, int totalBatch, int currbatch, List<String> dimsKeys) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        Object fixedParam = paramMap.get("fixedParam");
        Object newFixedParam = this.dealAllocDimValsList(currBatchDms, fixedParam, currbatch, totalBatch, dimsKeys);
        DynamicObject taskParam = BusinessDataServiceHelper.newDynamicObject((String)"cal_taskparam");
        taskParam.set("param_tag", (Object)SerializationUtils.toJsonString((Object)newFixedParam));
        taskParam.set("functionnum", (Object)"diffalloc");
        taskParam.set("param", (Object)("currbatch:" + currbatch + "/" + totalBatch));
        long paramId = DBServiceHelper.genLongIds((String)"cal_taskparam", (int)1)[0];
        taskParam.set("id", (Object)paramId);
        taskParam.set("taskgroupno", (Object)reportId);
        taskParam.set("status", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskParam});
        jobParams.put("paramid", paramId);
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        String appId = (String)paramMap.get("appId");
        String taskClass = (String)paramMap.get("taskClass");
        String taskName = (String)paramMap.get("taskName");
        String taskdefineid = (String)paramMap.get("taskdefineid");
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u3010%1$s\u3011\uff0c\u7b2c\u3010%2$s\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:%3$s", (String)"PartitionTask_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, taskName + ",TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId(taskdefineid);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId(appId);
        job.setTaskClassname(taskClass);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setRunByLang(Lang.get());
        return JobClient.dispatch((JobInfo)job);
    }

    private List<Set<Object>> spritBatch(Map<String, Object> paramMap) {
        int batch_size;
        Set partialDms = (Set)paramMap.get("partialDm");
        DiffAllocParamter diffAllocParamter = (DiffAllocParamter)paramMap.get("fixedParam");
        int n = batch_size = paramMap.get("batchSize") == null ? 20 : (Integer)paramMap.get("batchSize");
        if (diffAllocParamter.isCircle().booleanValue() || diffAllocParamter.isRework().booleanValue()) {
            paramMap.put("batchSize", batch_size *= 30);
            if (partialDms.size() > batch_size) {
                logger.info("diffAllocParamter.isCircle.spritbatch.size:" + batch_size + ",partialDms.size():" + partialDms.size());
            }
        }
        if (batch_size > partialDms.size() && !diffAllocParamter.isCircle().booleanValue() && !diffAllocParamter.isRework().booleanValue()) {
            batch_size = 10;
            paramMap.put("batchSize", 10);
        }
        ArrayList<Set<Object>> batchList = new ArrayList<Set<Object>>(16);
        HashSet currBatchDms = null;
        for (Object partialDm : partialDms) {
            if (currBatchDms == null || currBatchDms.size() >= batch_size) {
                currBatchDms = new HashSet(16);
                batchList.add(currBatchDms);
            }
            currBatchDms.add(partialDm);
        }
        return batchList;
    }

    private Object dealAllocDimValsList(Set<Object> currBatchDms, Object fixedParam, int currbatch, int totalBatch, List<String> dimsKeys) {
        if (fixedParam == null || !(fixedParam instanceof DiffAllocParamter)) {
            return fixedParam;
        }
        DiffAllocParamter newFixedParam = ((DiffAllocParamter)fixedParam).copy(Boolean.FALSE);
        newFixedParam.setBatchInfo(currbatch + "/" + totalBatch);
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(((DiffAllocParamter)fixedParam).getAllocDims(), ((DiffAllocParamter)fixedParam).getEquationSetDims());
        Map<String, DiffAllocParamterEntry> entrysMap = ((DiffAllocParamter)fixedParam).getEntityEntry();
        HashSet<Object> matIds = new HashSet<Object>(100);
        for (Map.Entry<String, DiffAllocParamterEntry> entry : entrysMap.entrySet()) {
            DiffAllocParamterEntry diffAllocParamterEntry;
            Map<String, DiffAllocParamterEntry> entityEntry;
            Object costDomainStr;
            StringBuilder dimKey;
            HashSet<String> existedAllDims = new HashSet<String>();
            HashSet<String> allocDimKeyCols = new HashSet<String>();
            ArrayList<Map<String, Object>> allocDimValsList = new ArrayList<Map<String, Object>>(16);
            if (CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFF_ALLOC_DIMS_ISMAT, entry.getValue().getCalOrgId().toString()).booleanValue()) {
                for (Map<String, Object> allocDimsInfoMap : entry.getValue().getAllocDimValsList()) {
                    if (!currBatchDms.contains(allocDimsInfoMap.get("material"))) continue;
                    dimKey = new StringBuilder();
                    for (String dim : diffallocDims.split(",")) {
                        dimKey.append(allocDimsInfoMap.get(dim)).append("@");
                    }
                    if (existedAllDims.contains(dimKey.toString())) continue;
                    existedAllDims.add(dimKey.toString());
                    allocDimValsList.add(allocDimsInfoMap);
                    costDomainStr = new StringBuilder();
                    for (String field : dimsKeys) {
                        if ("calorg".equals(field)) {
                            ((StringBuilder)costDomainStr).append(entry.getValue().getCalOrgId());
                            continue;
                        }
                        if ("costaccount".equals(field)) {
                            ((StringBuilder)costDomainStr).append(entry.getValue().getCostAccountId());
                            continue;
                        }
                        if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
                        ((StringBuilder)costDomainStr).append(allocDimsInfoMap.get(field));
                    }
                    String keyCol = CommonUtils.getSHA256Base64Str(((StringBuilder)costDomainStr).toString());
                    allocDimKeyCols.add(keyCol);
                }
                entityEntry = newFixedParam.getEntityEntry();
                diffAllocParamterEntry = entityEntry.get(entry.getKey());
                diffAllocParamterEntry.setAllocDimValsList(allocDimValsList);
                diffAllocParamterEntry.setAllocDimKeyCols(allocDimKeyCols);
                diffAllocParamterEntry.setMatIdSet(currBatchDms);
                continue;
            }
            for (Map<String, Object> allocDimsInfoMap : entry.getValue().getAllocDimValsList()) {
                dimKey = new StringBuilder();
                for (String dim : diffallocDims.split(",")) {
                    dimKey.append(allocDimsInfoMap.get(dim)).append("@");
                }
                if (existedAllDims.contains(dimKey.toString())) continue;
                existedAllDims.add(dimKey.toString());
                costDomainStr = new StringBuilder();
                for (String field : dimsKeys) {
                    if ("calorg".equals(field)) {
                        ((StringBuilder)costDomainStr).append(entry.getValue().getCalOrgId());
                        continue;
                    }
                    if ("costaccount".equals(field)) {
                        ((StringBuilder)costDomainStr).append(entry.getValue().getCostAccountId());
                        continue;
                    }
                    if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
                    ((StringBuilder)costDomainStr).append(allocDimsInfoMap.get(field));
                }
                String keyCol = CommonUtils.getSHA256Base64Str(((StringBuilder)costDomainStr).toString());
                if (!currBatchDms.contains(keyCol)) continue;
                allocDimKeyCols.add(keyCol);
                allocDimValsList.add(allocDimsInfoMap);
                matIds.add(allocDimsInfoMap.get("material"));
            }
            entityEntry = newFixedParam.getEntityEntry();
            diffAllocParamterEntry = entityEntry.get(entry.getKey());
            diffAllocParamterEntry.setAllocDimValsList(allocDimValsList);
            diffAllocParamterEntry.setAllocDimKeyCols(allocDimKeyCols);
            diffAllocParamterEntry.setMatIdSet(matIds);
        }
        return newFixedParam;
    }
}

