/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.formplugin;

import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;

public class AllocRecordListPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("detail".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            if (row == null || row.getPrimaryKeyValue() == null) {
                return;
            }
            String pk = row.getPrimaryKeyValue().toString();
            DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"calx_diffallocrc");
            if ("B".equals(record.getString("status"))) {
                this.openAllocRpt(pk, record);
            } else {
                this.openRecordEdit(pk, record);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
    }

    private void openRecordEdit(String pk, DynamicObject record) {
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("calx_diffallocrc");
        lsp.setCustomParam("pkId", (Object)Long.valueOf(pk));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openAllocRpt(String pk, DynamicObject record) {
        List<Long> hasPermOrgIds = this.getAllPermOrgs();
        DiffAllocParamter allocParam = (DiffAllocParamter)SerializationUtils.fromJsonString((String)record.getString("param_tag"), DiffAllocParamter.class);
        boolean isHasPerm = false;
        for (Map.Entry<String, DiffAllocParamterEntry> entry : allocParam.getEntityEntry().entrySet()) {
            if (!hasPermOrgIds.contains(entry.getValue().getCalOrgId())) continue;
            isHasPerm = true;
        }
        if (!isHasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u8be5\u5206\u644a\u8bb0\u5f55\u5bf9\u5e94\u7ec4\u7ec7\u4e0b\u201c\u5dee\u5f02\u5206\u644a\u62a5\u544a\u201d\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AllocRecordListPlugin_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"calx_diffallocrpt", (boolean)true, (int)1, (boolean)false);
        lsp.setCustomParam("param", (Object)record.getString("param_tag"));
        lsp.setCustomParam("isFromRrd", (Object)"true");
        ListFilterParameter filterParam = new ListFilterParameter();
        filterParam.getQFilters().add(new QFilter("allocrecordid", "=", (Object)Long.valueOf(pk)));
        lsp.setListFilterParameter(filterParam);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Long> getAllPermOrgs() {
        String appInnerId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appInnerId = AppMetadataCache.getAppInfo((String)"calx").getId()), (String)"calx_diffallocrpt", (String)"47150e89000000ac");
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return PermissionServiceHelper.getUserOrgs((long)userId);
    }
}

