/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.formplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.DiffAllocService;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.ParamsHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.helper.PermissionHelper;

public class DiffAllocWizardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(DiffAllocService.class);

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String opKey = event.getOperateKey();
        try {
            if ("alloc".equals(opKey)) {
                DiffAllocParamter param = this.buildDiffAllocParam();
                this.checkCostEstimateBill(param);
                this.checkStdBillVoucher(param);
                this.genAllocRecord(param);
                DiffAllocService service = new DiffAllocService();
                if (param.isRunJob()) {
                    service.allocByJob(param);
                    OperationResult result = event.getOperationResult();
                    result.setMessage(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u5df2\u8fdb\u5165\u540e\u53f0\u8fd0\u7b97\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u5206\u644a\u7ed3\u679c\u3002", (String)"DiffAllocWizardPlugin_1", (String)"fi-calx-algox", (Object[])new Object[0]));
                } else {
                    service.alloc(param);
                }
            }
        }
        catch (KDBizException e) {
            logger.error("\u5dee\u5f02\u5206\u644a\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u644a\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAllocWizardPlugin_11", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
    }

    private DiffAllocParamter buildDiffAllocParam() {
        IDataModel model = this.getModel();
        DiffAllocParamter param = new DiffAllocParamter();
        param.setStartTime(new Date());
        param.setAlloctor(Long.valueOf(RequestContext.get().getUserId()));
        param.setAllocModel((String)model.getValue("allocmodel"));
        param.setCarryRule((String)model.getValue("carryrule"));
        param.setWriterpt(model.getDataEntity().getBoolean("iswriterpt"));
        param.setWriteErrRpt((Boolean)model.getValue("iswriteerrrpt"));
        param.setRunJob((Boolean)model.getValue("runjob"));
        param.setBatchInfo(String.valueOf(System.currentTimeMillis()));
        int size = model.getEntryRowCount("entryentity");
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u6709\u6548\u6838\u7b97\u4fe1\u606f\u5206\u5f55\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocWizardPlugin_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
        ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
        for (int i = 0; i < size; ++i) {
            DynamicObject costRange;
            DynamicObject costAccount = (DynamicObject)model.getValue("costaccount", i);
            if (costAccount == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocWizardPlugin_16", (String)"fi-calx-algox", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg);
            }
            Object diffAllocDims = ParamsHelper.getAppParam(costAccount.getLong("calorg.id"), "diffalloccols");
            if (diffAllocDims != null && !diffAllocDims.toString().isEmpty()) {
                param.setAllocDims(diffAllocDims.toString());
            }
            String costRangeId = (costRange = (DynamicObject)model.getValue("calrange", i)) == null ? "0" : costRange.getString("id");
            DynamicObject periodObj = (DynamicObject)model.getValue("period", i);
            if (periodObj == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6210\u672c\u8d26\u7c3f\u5c1a\u672a\u8fdb\u884c\u671f\u95f4\u521d\u59cb\u5316\u3002", (String)"DiffAllocWizardPlugin_17", (String)"fi-calx-algox", (Object[])new Object[0]), i + 1);
                throw new KDBizException(msg);
            }
            param.addEntry(costAccount.getLong("id") + "@" + costRangeId, this.getMaterialSet(i), new HashSet<String>(), new ArrayList<Map<String, Object>>(1));
            Long calpolicyId = costAccount.getLong("calpolicy.id");
            DynamicObject currencyDyc = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency.amtprecision", (QFilter[])new QFilter("id", "=", (Object)calpolicyId).toArray());
            param.setPrecision(currencyDyc.getInt("currency.amtprecision"));
            costAccountIds.add(costAccount.getLong("id"));
        }
        Map<Long, String> DiffAllocStrategys = DiffAllocHelper.getDiffAllocStrategy(costAccountIds);
        this.checkDiffAllocStrategy(DiffAllocStrategys);
        return param;
    }

    private Set<Object> getMaterialSet(int rowIndex) {
        HashSet<Long> materialSet;
        block9: {
            DynamicObjectCollection materialFromCol;
            block10: {
                DynamicObject materialTo;
                block8: {
                    DynamicObjectCollection materialGroupCol = (DynamicObjectCollection)this.getModel().getValue("matgroup", rowIndex);
                    materialFromCol = (DynamicObjectCollection)this.getModel().getValue("matfrom", rowIndex);
                    materialTo = (DynamicObject)this.getModel().getValue("matto", rowIndex);
                    materialSet = null;
                    if (materialGroupCol == null || materialGroupCol.isEmpty()) break block8;
                    QFilter groupFilter = null;
                    for (DynamicObject materialGroup : materialGroupCol) {
                        String longNumber = materialGroup.getDynamicObject("fbasedataid").getString("longnumber");
                        if (groupFilter == null) {
                            groupFilter = new QFilter("group.longnumber", "like", (Object)((String)longNumber + "%"));
                            continue;
                        }
                        groupFilter.or("group.longnumber", "like", (Object)((String)longNumber + "%"));
                    }
                    QFilter[] qFilters = groupFilter == null ? null : groupFilter.toArray();
                    DynamicObjectCollection materialCol = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])qFilters);
                    materialSet = new HashSet();
                    for (DynamicObject material : materialCol) {
                        materialSet.add(material.getLong("material.id"));
                    }
                    if (materialSet == null || materialSet.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u5206\u7c7b\u4e0b\u6ca1\u6709\u7269\u6599\u3002", (String)"DiffAllocWizardPlugin_6", (String)"fi-calx-algox", (Object[])new Object[0]));
                    }
                    break block9;
                }
                if (materialTo == null) break block10;
                if (materialFromCol == null || materialFromCol.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4ece\u3002", (String)"DiffAllocWizardPlugin_7", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
                String fromMaterialNo = ((DynamicObject)materialFromCol.get(0)).getDynamicObject("fbasedataid").getString("number");
                String toMaterialNo = materialTo.getString("number");
                QFilter materialFilter = new QFilter("number", ">=", (Object)fromMaterialNo);
                materialFilter.and(new QFilter("number", "<=", (Object)toMaterialNo));
                Set pkIds = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])materialFilter.toArray()).keySet();
                if (pkIds.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u4ece-\u7269\u6599\u81f3\u4e0b\u6ca1\u6709\u7269\u6599\u3002", (String)"DiffAllocWizardPlugin_8", (String)"fi-calx-algox", (Object[])new Object[0]));
                }
                materialSet = new HashSet(pkIds.size());
                for (Object pkId : pkIds) {
                    materialSet.add(Long.valueOf(pkId.toString()));
                }
                break block9;
            }
            if (materialFromCol == null || materialFromCol.isEmpty()) break block9;
            materialSet = new HashSet<Long>();
            for (DynamicObject material : materialFromCol) {
                materialSet.add(material.getLong("fbasedataid_id"));
            }
        }
        return materialSet;
    }

    public void registerListener(EventObject e) {
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialfrom = (BasedataEdit)this.getControl("matfrom");
        materialfrom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialto = (BasedataEdit)this.getControl("matto");
        materialto.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("matgroup");
        materialgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String opKey = e.getProperty().getName();
        if (opKey.equals("costaccount")) {
            ChangeData[] est = e.getChangeSet();
            int rowIndex = est[0].getRowIndex();
            DynamicObject costaccountInfo = this.getModel().getEntryRowEntity("entryentity", rowIndex).getDynamicObject("costaccount");
            this.getModel().beginInit();
            if (costaccountInfo == null) {
                this.getModel().setValue("period", null, rowIndex);
                this.getModel().setValue("calorg", null, rowIndex);
            } else {
                DynamicObject currentInfo = PeriodHelper.getCurrentPeriod(costaccountInfo.getLong("id"));
                if (currentInfo == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u6267\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocWizardPlugin_18", (String)"fi-calx-algox", (Object[])new Object[0]), costaccountInfo.getString("name"));
                    throw new KDBizException(msg);
                }
                this.getModel().setValue("period", (Object)currentInfo.getLong("id"), rowIndex);
                this.getModel().setValue("calorg", (Object)costaccountInfo.getDynamicObject("calorg"), rowIndex);
            }
            this.getModel().setValue("calrange", null, rowIndex);
            this.getView().updateView("calorg", rowIndex);
            this.getView().updateView("calrange", rowIndex);
            this.getView().updateView("period", rowIndex);
            this.getView().updateView("startdate", rowIndex);
            this.getView().updateView("enddate", rowIndex);
            this.getModel().endInit();
        } else if (opKey.equals("iswriterpt")) {
            boolean cbxwriterpt = this.getModel().getDataEntity().getBoolean("iswriterpt");
            this.getModel().beginInit();
            if (cbxwriterpt) {
                this.getModel().getDataEntity().set("iswriteerrrpt", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.TRUE, new String[]{"iswriteerrrpt"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"iswriteerrrpt"});
            } else {
                this.getModel().getDataEntity().set("iswriteerrrpt", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"iswriteerrrpt"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"iswriteerrrpt"});
            }
            this.getModel().endInit();
            this.getView().updateView("iswriteerrrpt");
        } else if (opKey.equals("matfrom")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet != null && changeSet.length > 0) {
                this.materialFromChange(changeSet[0].getRowIndex());
            }
        } else if (opKey.equals("matgroup")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().beginInit();
            this.getModel().setValue("matfrom", null, rowIndex);
            this.getModel().setValue("matto", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("matfrom", rowIndex);
            this.getView().updateView("matto", rowIndex);
        } else if (opKey.equals("matto")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().beginInit();
            this.getModel().setValue("matgroup", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("matgroup", rowIndex);
        }
    }

    private void materialFromChange(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        DynamicObjectCollection materialFrom = entry.getDynamicObjectCollection("matfrom");
        int size = materialFrom.size();
        this.getModel().beginInit();
        this.getModel().setValue("matgroup", null, rowIndex);
        if (size > 1) {
            this.getModel().setValue("matto", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"matto"});
        } else {
            if (materialFrom.size() == 1) {
                this.getModel().setValue("matto", ((DynamicObject)materialFrom.get(0)).getDynamicObject("fbasedataid").getPkValue());
            } else {
                this.getModel().setValue("matto", null);
            }
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"matto"});
        }
        this.getModel().endInit();
        this.getView().updateView("matto", rowIndex);
        this.getView().updateView("matgroup", rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        int rowIndex = event.getRow();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("calrange".equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount", rowIndex);
            if (costAccount == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"DiffAllocWizardPlugin_12", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter("costaccount.id", "=", costAccount.getPkValue());
            qf.and(new QFilter("status", "=", (Object)"C"));
            qf.and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qf);
        } else if ("costaccount".equals(sourceID)) {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List<Long> list = PermissionHelper.getUserPermOrgs(userId, "calx_diffallocwizard", "0EMT+DL/XQ19");
            QFilter q = new QFilter("entry.costaccount.enable", "=", (Object)"1");
            q.and("entry.isenabled", "=", (Object)true);
            if (list != null) {
                q.and(new QFilter("org", "in", list));
            }
            DynamicObjectCollection sysEntitys = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])q.toArray());
            HashSet<Long> endInitCostAccountIds = new HashSet<Long>(16);
            for (DynamicObject info : sysEntitys) {
                endInitCostAccountIds.add(info.getLong("entry.costaccount"));
            }
            QFilter qf = new QFilter("id", "=", (Object)-1L);
            if (!endInitCostAccountIds.isEmpty()) {
                qf = new QFilter("id", "in", endInitCostAccountIds);
            }
            showParameter.getListFilterParameter().setFilter(qf);
        } else if ("matfrom".equals(sourceID) || "matto".equals(sourceID)) {
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter();
        }
    }

    private void genAllocRecord(DiffAllocParamter param) {
        DynamicObject allocRecord = BusinessDataServiceHelper.newDynamicObject((String)"calx_diffallocrc");
        allocRecord.set("user", (Object)RequestContext.get().getUserId());
        allocRecord.set("starttime", (Object)new Date());
        allocRecord.set("status", (Object)"A");
        allocRecord.set("billstatus", (Object)"A");
        allocRecord.set("allocmodel", (Object)param.getAllocModel());
        allocRecord.set("param_tag", (Object)SerializationUtils.toJsonString((Object)param));
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocRecord});
        param.setAllocRecordId(((DynamicObject)result[0]).getLong("id"));
    }

    private void checkDiffAllocStrategy(Map<Long, String> DiffAllocStrategys) {
        IDataModel model = this.getModel();
        int size = model.getEntryRowCount("entryentity");
        StringBuilder error = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            DynamicObject costAccount = (DynamicObject)model.getValue("costaccount", i);
            if (!"ITEMIZED_REDUCT".equals(DiffAllocStrategys.get(costAccount.getLong("id")))) continue;
            error.append(costAccount.getString("name")).append(",");
        }
    }

    private void checkCostEstimateBill(DiffAllocParamter param) {
        if (param == null || param.getEntityEntry() == null || param.getEntityEntry().isEmpty()) {
            return;
        }
        HashSet<Long> calOrgs = new HashSet<Long>(param.getEntityEntry().size());
        Date periodStart = null;
        Date periodEnd = null;
        for (Map.Entry<String, DiffAllocParamterEntry> entry : param.getEntityEntry().entrySet()) {
            calOrgs.add(entry.getValue().getCalOrgId());
            if (periodStart == null || periodStart.compareTo(entry.getValue().getStartDate()) > 0) {
                periodStart = entry.getValue().getStartDate();
            }
            if (periodEnd != null && periodEnd.compareTo(entry.getValue().getEndDate()) >= 0) continue;
            periodEnd = entry.getValue().getEndDate();
        }
        QFilter filter = new QFilter("calorg", "in", calOrgs);
        filter.and(new QFilter("estimatedate", ">=", periodStart));
        filter.and(new QFilter("estimatedate", "<=", periodEnd));
        filter.and(new QFilter("billstatus", "=", (Object)"A"));
        DynamicObject[] costEstimateBills = BusinessDataServiceHelper.load((String)"cal_costestimatebill", (String)"billno", (QFilter[])filter.toArray());
        if (costEstimateBills == null || costEstimateBills.length < 1) {
            return;
        }
        StringBuilder billnos = new StringBuilder();
        for (DynamicObject bill : costEstimateBills) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s", (String)"DiffAllocWizardPlugin_14", (String)"fi-calx-algox", (Object[])new Object[0]), bill.getString("billno"));
            billnos.append(msg);
        }
        if (billnos.length() > 1) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u5f53\u671f\u8d39\u7528\u6682\u4f30\u5355\uff0c\u8fdb\u884c\u8d39\u7528\u6682\u4f30\u6216\u8005\u4e0a\u67e5\u6682\u4f30\u5e94\u4ed8\u5355\u505a\u53cd\u5ba1\u6838\u64cd\u4f5c\uff1a%1$s", (String)"DiffAllocWizardPlugin_15", (String)"fi-calx-algox", (Object[])new Object[0]), billnos.substring(1));
            throw new KDBizException(msg);
        }
    }

    private void checkStdBillVoucher(DiffAllocParamter param) {
        boolean isGroup = CalDbParamServiceHelper.getString("isgroupdiffbill", null).equals("true");
        if (param == null || param.getEntityEntry() == null || param.getEntityEntry().isEmpty()) {
            return;
        }
        StringJoiner stringJoiner = new StringJoiner("\uff1b");
        for (Map.Entry<String, DiffAllocParamterEntry> entryEntry : param.getEntityEntry().entrySet()) {
            StringBuilder errorMsg = new StringBuilder();
            DiffAllocParamterEntry entry = entryEntry.getValue();
            QFilter filter = new QFilter("calorg", "=", (Object)entry.getCalOrgId());
            filter.and("costaccount", "=", (Object)entry.getCostAccountId());
            filter.and("period", "=", (Object)entry.getPeriodId());
            filter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z", "G"}));
            filter.and("isvoucher", "=", (Object)true);
            QFilter grpFilter = new QFilter("calorg", "=", (Object)entry.getCalOrgId());
            grpFilter.and("costaccount", "=", (Object)entry.getCostAccountId());
            grpFilter.and("period", "=", (Object)entry.getPeriodId());
            grpFilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z", "G"}));
            grpFilter.and("isvoucher", "=", (Object)true);
            if (entry.getMatIdSet() != null && !entry.getMatIdSet().isEmpty()) {
                filter.and("entryentity.material", "in", entry.getMatIdSet());
                if (isGroup) {
                    grpFilter.and("material", "in", entry.getMatIdSet());
                } else {
                    grpFilter.and("entryentity.material", "in", entry.getMatIdSet());
                }
            }
            boolean adjustVoucherExist = QueryServiceHelper.exists((String)"cal_costadjustbill", (QFilter[])new QFilter[]{filter});
            boolean stdVoucherExist = QueryServiceHelper.exists((String)"cal_costdiffgroupbill", (QFilter[])new QFilter[]{grpFilter});
            if (!stdVoucherExist && !adjustVoucherExist) continue;
            DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entry.getCostAccountId())});
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u5bf9\u5e94\u7684", (String)"DiffAllocWizardPlugin_20", (String)"fi-calx-algox", (Object[])new Object[0]), costAccountDy.getString("number") + " /" + entry.getCostAccountName());
            errorMsg.append(msg);
            if (stdVoucherExist) {
                errorMsg.append(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"DiffAllocWizardPlugin_22", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            if (adjustVoucherExist) {
                if (stdVoucherExist) {
                    errorMsg.append("\u3001");
                }
                errorMsg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"DiffAllocWizardPlugin_23", (String)"fi-calx-algox", (Object[])new Object[0]));
            }
            errorMsg.append(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5220\u9664\u76f8\u5173\u51ed\u8bc1\u540e\u518d\u6267\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocWizardPlugin_24", (String)"fi-calx-algox", (Object[])new Object[0]));
            stringJoiner.add(errorMsg.toString());
        }
        if (stringJoiner.toString().length() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)stringJoiner.toString(), (String)"DiffAllocWizardPlugin_25", (String)"fi-calx-algox", (Object[])new Object[0]));
        }
    }
}

