/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;

public class DealAlgoNoUpdateCalFields
extends ReduceGroupFunction {
    private RowMeta rowMeta;
    private String prefix = "";

    public DealAlgoNoUpdateCalFields(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public DealAlgoNoUpdateCalFields(RowMeta rowMeta, String prefix) {
        this.rowMeta = rowMeta;
        this.prefix = prefix;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        while (iterator.hasNext()) {
            Row row = iterator.next();
            RowX rowX = this.getRowx(row);
            String noUpdateCalFields = row.getString("noupdatecalfields");
            JSONObject jsonObject = JSON.parseObject((String)noUpdateCalFields);
            if (jsonObject != null) {
                JSONArray noupdateFields = jsonObject.getJSONArray("setnull");
                for (Object noupdateField : noupdateFields) {
                    if (noupdateField == null) continue;
                    String field = noupdateField.toString();
                    if (this.rowMeta.getFieldIndex(this.prefix + field, Boolean.FALSE.booleanValue()) < 0) continue;
                    rowX.set(this.rowMeta.getFieldIndex(this.prefix + field), this.getDefaultVal(row, this.prefix + field));
                }
            }
            dataList.add(rowX.values());
        }
        return dataList.iterator();
    }

    public RowMeta getResultRowMeta() {
        if (this.rowMeta.getFieldIndex("noupdatecalfields", Boolean.FALSE.booleanValue()) >= 0) {
            Field[] fields = new Field[this.rowMeta.getFieldCount() - 1];
            int index = 0;
            for (Field field : this.rowMeta.getFields()) {
                if ("noupdatecalfields".equals(field.getName())) continue;
                fields[index++] = field;
            }
            return new RowMeta(fields);
        }
        return this.rowMeta;
    }

    private RowX getRowx(Row row) {
        Field[] fields = this.getResultRowMeta().getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = row.get(fields[i].getName());
        }
        return new RowX(values);
    }

    private Object getDefaultVal(Row row, String fieldAlias) {
        int index = this.rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

