/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.function.DealBaseFunction;

public class DealAllocOutTailDiffFunction
extends DealBaseFunction {
    private static final long serialVersionUID = -2646572368922884533L;

    public DealAllocOutTailDiffFunction(RowMeta rowMeta, DiffAllocParamter allocParam, Map<String, BigDecimal> rateMap) {
        super(rowMeta, allocParam, rateMap);
    }

    @Override
    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        Iterator<RowX> it = arg1.iterator();
        BigDecimal totalOutQty = BigDecimal.ZERO;
        HashMap<String, BigDecimal> totalDiffAmts = new HashMap<String, BigDecimal>(10);
        Map<Object, Object> domainRateMap = new HashMap(10);
        Boolean isFirstRow = Boolean.FALSE;
        RowX adjRow = null;
        while (it.hasNext()) {
            String difftype;
            int n;
            int n2;
            String[] stringArray;
            RowX row = it.next();
            totalOutQty = totalOutQty.add((BigDecimal)this.getRowValue(Boolean.FALSE, row, "baseqty"));
            if (!isFirstRow.booleanValue()) {
                stringArray = "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    difftype = stringArray[n];
                    totalDiffAmts.put(difftype, (BigDecimal)this.getRowValue(Boolean.FALSE, row, "diffType_" + difftype));
                }
                domainRateMap = this.getDomainOutDiff(row);
                isFirstRow = Boolean.TRUE;
            } else {
                stringArray = "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    difftype = stringArray[n];
                    BigDecimal currDiff = (BigDecimal)totalDiffAmts.get(difftype);
                    totalDiffAmts.put(difftype, currDiff.add((BigDecimal)this.getRowValue(Boolean.FALSE, row, "diffType_" + difftype)));
                }
            }
            if (adjRow == null) {
                adjRow = this.copyRowX(row);
                adjRow.set(this.rowMeta.getFieldIndex("adjtype"), (Object)"2");
                continue;
            }
            collector.collect(row);
        }
        if (adjRow == null) {
            return;
        }
        for (String difftype : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
            BigDecimal totalDiffAmt;
            BigDecimal diffAmt = (BigDecimal)totalDiffAmts.get(difftype);
            BigDecimal diffRate = (BigDecimal)domainRateMap.get(difftype);
            if (diffRate == null || (totalDiffAmt = diffRate.multiply(totalOutQty).setScale(2, RoundingMode.HALF_UP)).compareTo(diffAmt) == 0) continue;
            BigDecimal diff = totalDiffAmt.subtract(diffAmt);
            BigDecimal curDiff = adjRow.getBigDecimal(this.rowMeta.getFieldIndex("diffType_" + difftype));
            adjRow.set(this.rowMeta.getFieldIndex("diffType_" + difftype), (Object)diff.add(curDiff));
        }
        collector.collect(adjRow);
    }

    private Map<String, BigDecimal> getDomainOutDiff(RowX row) {
        HashMap<String, BigDecimal> domainRateMap = new HashMap<String, BigDecimal>(10);
        String outCostDomainStr = this.getRowValue(Boolean.FALSE, row, "costDomain").toString();
        StringBuilder equationSetDimsVal = new StringBuilder();
        for (String dim : this.allocParam.getEquationSetDims().split(",")) {
            equationSetDimsVal.append(this.getRowValue(Boolean.FALSE, row, dim).toString()).append("@");
        }
        String equationSetDimsValStr = equationSetDimsVal.toString();
        for (String difftype : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
            StringBuilder outDiffRateSb = new StringBuilder();
            outDiffRateSb.append(difftype);
            outDiffRateSb.append("@");
            outDiffRateSb.append(outCostDomainStr);
            outDiffRateSb.append("@");
            outDiffRateSb.append(equationSetDimsValStr);
            outDiffRateSb.append(this.getRowValue(Boolean.FALSE, row, "elementid"));
            outDiffRateSb.append("@");
            outDiffRateSb.append(this.getRowValue(Boolean.FALSE, row, "subelementid"));
            BigDecimal outDiffRate = (BigDecimal)this.rateMap.get(outDiffRateSb.toString());
            domainRateMap.put(difftype, outDiffRate);
        }
        return domainRateMap;
    }
}

