/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.function.DealBaseFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class DealCostDomainByOthBillFunction
extends DealBaseFunction {
    public DealCostDomainByOthBillFunction(RowMeta rowMeta, DiffAllocParamter allocParam, Map<String, BigDecimal> rateMap, RowMeta resultRowMeta) {
        super(rowMeta, allocParam, rateMap, resultRowMeta);
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        for (RowX row : arg1) {
            if ((Long)this.getRowValue(row, "in_1costrecordentryid") == 0L) {
                collector.collect(this.copyRowX(row));
                continue;
            }
            row.set(this.resultRowMeta.getFieldIndex("costDomain"), (Object)this.getDomainStr(row, ""));
            collector.collect(this.copyRowX(row));
        }
    }

    @Override
    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    @Override
    protected RowX copyRowX(RowX row) {
        Object[] rowValues = new Object[this.resultRowMeta.getFieldCount()];
        int index = 0;
        for (String field : this.resultRowMeta.getFieldNames()) {
            rowValues[index++] = row.get(this.resultRowMeta.getFieldIndex(field));
        }
        return new RowX(rowValues);
    }

    private String getDomainStr(RowX row, String preStr) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        StringBuilder costDomainStr = new StringBuilder();
        for (String field : diffallocDims.split(",")) {
            String newField = "out" + field;
            costDomainStr.append(this.getRowValue(row, newField)).append("@");
        }
        costDomainStr.append(this.getRowValue(row, preStr + "elementid")).append("@");
        costDomainStr.append(this.getRowValue(row, preStr + "subelementid"));
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }
}

