/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.function.DealBaseFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class DealCostDomainFunction
extends DealBaseFunction {
    private static final long serialVersionUID = -7662066085678547490L;
    private static final Log logger = LogFactory.getLog(DealCostDomainFunction.class);

    public DealCostDomainFunction(RowMeta rowMeta, DiffAllocParamter allocParam, Map<String, BigDecimal> rateMap) {
        super(rowMeta, allocParam, rateMap);
    }

    @Override
    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        Iterator<RowX> it = arg1.iterator();
        Boolean isAllZero = Boolean.TRUE;
        HashSet<RowX> allRows = new HashSet<RowX>(20);
        while (it.hasNext()) {
            RowX row = it.next();
            if (this.getRowValue(row, "costrecordentryid").equals(this.getRowValue(row, "gcostrecordentryid"))) continue;
            String costDomainStr = this.getRowValue(row, "costDomain").toString();
            String outBillCostDomain = StringUtils.isEmpty((String)costDomainStr) ? this.getDomainStr(row, "") : costDomainStr;
            String groupBillCostDomain = this.getDomainStr(row, "g");
            row.set(this.rowMeta.getFieldIndex("costDomain"), (Object)outBillCostDomain);
            row.set(this.rowMeta.getFieldIndex("gcostDomain"), (Object)groupBillCostDomain);
            for (String difftype : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
                String outCostDomainStr = this.getRowValue(row, "costDomain").toString();
                StringBuilder equationSetDimsVal = new StringBuilder();
                for (String dim : this.allocParam.getEquationSetDims().split(",")) {
                    equationSetDimsVal.append(this.getRowValue(row, dim).toString()).append("@");
                }
                BigDecimal outDiffRate = (BigDecimal)this.rateMap.get(difftype + "@" + outCostDomainStr);
                outDiffRate = outDiffRate == null ? BigDecimal.ZERO : outDiffRate;
                BigDecimal baseQty = (BigDecimal)this.getRowValue(row, "baseqty");
                BigDecimal diff = baseQty.multiply(outDiffRate).setScale(2, 4);
                if (BigDecimal.ZERO.compareTo(diff) != 0) {
                    isAllZero = Boolean.FALSE;
                }
                row.set(this.rowMeta.getFieldIndex("diffType_" + difftype), (Object)diff);
                if ("0".equals((String)this.getRowValue(Boolean.FALSE, row, "bizgrouprecordid"))) continue;
                String outMaterialId = this.getRowValue(row, "material").toString();
                String gmaterialid = this.getRowValue(row, "gmaterial").toString();
                BigDecimal gbaseQty = (BigDecimal)this.getRowValue(row, "gbaseQty");
                BigDecimal weight = (BigDecimal)this.getRowValue(row, "weight");
                BigDecimal totalWeight = (BigDecimal)this.getRowValue(row, "totalweight");
                if (BigDecimal.ZERO.compareTo(totalWeight) == 0) {
                    logger.error("totalWeight_is_zero");
                    totalWeight = BigDecimal.ONE;
                }
                BigDecimal gdiff = gbaseQty.multiply(outDiffRate).setScale(2, 4);
                if (!"0".equals(outMaterialId) && !gmaterialid.equals(outMaterialId)) {
                    baseQty = baseQty.multiply(weight).divide(totalWeight, 10, RoundingMode.HALF_UP);
                    gdiff = baseQty.multiply(outDiffRate).setScale(2, 4);
                }
                if (BigDecimal.ZERO.compareTo(gdiff) != 0) {
                    isAllZero = Boolean.FALSE;
                }
                row.set(this.rowMeta.getFieldIndex("gdiffType_" + difftype), (Object)gdiff);
            }
            allRows.add(row);
        }
        if (!isAllZero.booleanValue()) {
            for (RowX allRow : allRows) {
                collector.collect(allRow);
            }
        }
    }

    private String getDomainStr(RowX row, String preStr) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        StringBuilder costDomainStr = new StringBuilder();
        String noUpdateCalFields = row.getString(this.rowMeta.getFieldIndex(preStr + "noupdatecalfields"));
        JSONObject jsonObject = JSON.parseObject((String)noUpdateCalFields);
        JSONArray noupdateFields = null;
        if (jsonObject != null) {
            noupdateFields = jsonObject.getJSONArray("setnull");
        }
        for (String field : diffallocDims.split(",")) {
            if (noupdateFields != null && noupdateFields.contains((Object)field)) {
                costDomainStr.append(this.getDefaultVal(row, preStr + field)).append("@");
                continue;
            }
            costDomainStr.append(this.getRowValue(row, preStr + field)).append("@");
        }
        costDomainStr.append(this.getRowValue(row, preStr + "elementid")).append("@");
        costDomainStr.append(this.getRowValue(row, preStr + "subelementid"));
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }
}

