/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.model.DealGenDiffParamService;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class DealGenDiffAllocRptFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 7900162346554482209L;
    protected RowMeta rowMeta;
    protected Map<String, BigDecimal> rateMap;
    protected DiffAllocParamter allocParam;
    protected DealGenDiffParamService rateService;
    protected static final String diffTypes = "G,H,K,P,Q,R,M,S,T,C,X,W,Y";
    private HashSet<String> calSysDefaultDims = Sets.newHashSet((Object[])new String[]{"configuredcode", "assist", "tracknumber", "project", "lot", "costaccount", "material", "calorg"});
    private static final Set<String> noDisPlayDims = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("calorg");
            this.add("material");
            this.add("costaccount");
            this.add("assist");
        }
    };

    public DealGenDiffAllocRptFunction(RowMeta rowMeta, DiffAllocParamter allocParam, Map<String, BigDecimal> rateMap, DealGenDiffParamService rateService) {
        this.rowMeta = rowMeta;
        this.rateMap = rateMap;
        this.allocParam = allocParam;
        this.rateService = rateService;
    }

    public RowMeta getResultRowMeta() {
        Field[] resultFields = new Field[]{new Field("stdcostdiffbillids", (DataType)DataType.StringType), new Field("costadjustbillids", (DataType)DataType.StringType), new Field("materialid", (DataType)DataType.LongType)};
        return new RowMeta(resultFields);
    }

    public void reduce(Iterable<RowX> arg1, Collector collector) {
        Iterator<RowX> it = arg1.iterator();
        Object[] header = null;
        LinkedHashMap<String, Object[]> entrys = new LinkedHashMap<String, Object[]>(16);
        HashMap<String, Object[]> details = new HashMap<String, Object[]>(16);
        HashMap<String, Integer> entrySeqMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> detailSeqMap = new HashMap<String, Integer>(16);
        HashMap<String, BigDecimal> balaAmtMap = new HashMap<String, BigDecimal>(16);
        Boolean isFirstRow = Boolean.TRUE;
        Long headerId = DBServiceHelper.genLongIds((String)"t_cal_diffallocrpt", (int)1)[0];
        int startSeq = 0;
        while (it.hasNext()) {
            RowX row = it.next();
            if (isFirstRow.booleanValue()) {
                header = this.getHeaderValues(headerId, row);
            }
            startSeq = this.getEntrys(startSeq, headerId, row, entrySeqMap, balaAmtMap, detailSeqMap, entrys, details);
            String adjustBillIds = (String)this.getRowValue(row, "adjsutbillid");
            String stdcostDiffBillIds = (String)this.getRowValue(row, "stdcostdiffbillid");
            if (" ".equals(adjustBillIds)) continue;
            Long materialId = (Long)this.getRowValue(row, "material");
            collector.collect(new RowX(new Object[]{stdcostDiffBillIds, adjustBillIds, materialId}));
        }
        for (Map.Entry entry : entrys.entrySet()) {
            BigDecimal balAmt;
            BigDecimal effectValue;
            String balAmtKey;
            if ("IN".equals(((Object[])entry.getValue())[9])) {
                balAmtKey = ((Object[])entry.getValue())[3] + "@" + ((Object[])entry.getValue())[6];
                effectValue = new BigDecimal(((Object[])entry.getValue())[7].toString().replace("(", "").replace(")", ""));
                balAmt = balaAmtMap.get(balAmtKey) == null ? BigDecimal.ZERO : (BigDecimal)balaAmtMap.get(balAmtKey);
                ((Object[])entry.getValue())[9] = this.toBigDecimalString(balAmt.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "+" + this.toBigDecimalString(effectValue.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "=" + this.toBigDecimalString(effectValue.add(balAmt).setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
                balaAmtMap.put(balAmtKey, effectValue.add(balAmt));
                continue;
            }
            if (!"OUT".equals(((Object[])entry.getValue())[9])) continue;
            balAmtKey = ((Object[])entry.getValue())[3] + "@" + ((Object[])entry.getValue())[6];
            effectValue = new BigDecimal(((Object[])entry.getValue())[8].toString().replace("(", "").replace(")", ""));
            balAmt = balaAmtMap.get(balAmtKey) == null ? BigDecimal.ZERO : (BigDecimal)balaAmtMap.get(balAmtKey);
            ((Object[])entry.getValue())[9] = this.toBigDecimalString(balAmt.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "-" + this.toBigDecimalString(effectValue.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "=" + this.toBigDecimalString(balAmt.subtract(effectValue).setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
            balaAmtMap.put(balAmtKey, balAmt.subtract(effectValue));
        }
        this.saveToDB(header, entrys, details);
    }

    private Object[] getHeaderValues(Long headerId, RowX row) {
        Object[] header = new Object[16];
        header[0] = headerId;
        header[1] = this.getRowValue(row, "calorg");
        header[2] = this.getRowValue(row, "costaccount");
        header[3] = this.getRowValue(row, "periodid");
        header[4] = this.getRowValue(row, "material");
        header[5] = this.getAllocDim();
        header[6] = this.getAllocDimVal(row);
        header[7] = "D";
        header[8] = this.allocParam.getAllocModel();
        header[9] = this.allocParam.getCarryRule();
        header[10] = RequestContext.get().getCurrUserId();
        header[11] = TimeServiceHelper.now();
        header[12] = this.allocParam.getAllocRecordId();
        header[13] = TimeServiceHelper.now();
        String selectDMFileds = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        header[14] = selectDMFileds.contains("assist") ? this.getRowValue(row, "assist") : Long.valueOf(0L);
        String[] dims = selectDMFileds.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        StringBuilder costDomainStr = new StringBuilder();
        for (String dimsKey : dimsKeys) {
            if (!this.calSysDefaultDims.contains(dimsKey)) continue;
            costDomainStr.append(this.getRowValue(row, dimsKey));
        }
        String keyCol = CommonUtils.getSHA256Base64Str(costDomainStr.toString());
        header[15] = keyCol;
        return header;
    }

    private int getEntrys(int startSeq, Long headerId, RowX row, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Map<String, Integer> detailSeqMap, Map<String, Object[]> entrys, Map<String, Object[]> details) {
        for (String difftype : diffTypes.split(",")) {
            String rptEntryGroupKey = difftype + "#" + this.getRowValue(row, "subelementid");
            if (!entrySeqMap.containsKey(rptEntryGroupKey)) {
                startSeq = this.dealEntyFixedData(difftype, startSeq, entrySeqMap, balaAmtMap, headerId, row, entrys);
            }
            if (entrySeqMap.get(difftype + "#" + this.getRowValue(row, "subelementid")) == -1) continue;
            String entrykey = difftype + "#" + this.getRowValue(row, "outbilltypeid") + "#" + this.getRowValue(row, "subelementid");
            String calbilltype = this.getRowValue(row, "calbilltype").toString();
            BigDecimal currDiff = (BigDecimal)this.getRowValue(row, "diffType_" + difftype);
            if (entrys.containsKey(entrykey)) {
                BigDecimal diff;
                Object[] entry = entrys.get(entrykey);
                if ("IN".equals(calbilltype)) {
                    if (!"OUT".equals(entry[9].toString())) {
                        String entrydiffsStr = (String)entry[7];
                        if (entrydiffsStr.contains("(") || entrydiffsStr.contains(")")) {
                            entrydiffsStr = entrydiffsStr.replace("(", "");
                            entrydiffsStr = entrydiffsStr.replace(")", "");
                        }
                        diff = currDiff.add(new BigDecimal(entrydiffsStr));
                        entry[7] = this.toBigDecimalString(diff.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
                        entry[9] = "IN";
                    }
                } else {
                    String entrydiffsStr;
                    if ("IN".equals(entry[9].toString())) {
                        entry[7] = "0";
                    }
                    if ((entrydiffsStr = (String)entry[8]).contains("(") || entrydiffsStr.contains(")")) {
                        entrydiffsStr = entrydiffsStr.replace("(", "");
                        entrydiffsStr = entrydiffsStr.replace(")", "");
                    }
                    diff = currDiff.add(new BigDecimal(entrydiffsStr));
                    entry[8] = this.toBigDecimalString(diff.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
                    entry[9] = "OUT";
                }
                this.getDetails(difftype, (Long)entry[1], detailSeqMap, row, details);
                continue;
            }
            String typeName = this.getRowValue(row, "outbilltypename").toString();
            int currSeq = entrySeqMap.get(rptEntryGroupKey);
            Object[] entry = this.getPublicEntryData(difftype, currSeq, 1, typeName, entrySeqMap, headerId, row);
            entrySeqMap.put(rptEntryGroupKey, currSeq + 1);
            if ("IN".equals(calbilltype)) {
                entry[7] = this.toBigDecimalString(currDiff.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
                entry[9] = "IN";
            } else {
                entry[8] = this.toBigDecimalString(currDiff.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
                entry[9] = "OUT";
            }
            if (currDiff == null || BigDecimal.ZERO.compareTo(currDiff) == 0) continue;
            entrys.put(entrykey, entry);
            this.getDetails(difftype, (Long)entry[1], detailSeqMap, row, details);
        }
        return startSeq;
    }

    private int dealEntyFixedData(String difftype, int startSeq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row, Map<String, Object[]> entrys) {
        Object[] diffRateEntry;
        Object[] allocOutQtyEntry;
        Object[] totalOutQtyEntry;
        Object[] inQtyEntry;
        int seq = startSeq;
        int addseq = 1;
        Object[] initDiffEntry = this.getInitDiffData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row);
        Object[] fixedInDiffEntry = this.getFixedInDiffData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row);
        Object[] transInDiffEntry = this.getTransInDiffData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row);
        String key = difftype + "@" + row.getString(this.rowMeta.getFieldIndex("subelementid"));
        Object[] fixedOutDiffEntry = this.getFixedOutDiffData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row);
        BigDecimal preBala = balaAmtMap.get(key);
        if (preBala == null || preBala.compareTo(BigDecimal.ZERO) == 0) {
            entrySeqMap.put(difftype + "#" + this.getRowValue(row, "subelementid"), -1);
            return seq;
        }
        if (initDiffEntry != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#initDiffEntry", initDiffEntry);
        }
        if (fixedInDiffEntry != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#fixedInDiffEntry", fixedInDiffEntry);
        }
        if (transInDiffEntry != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#transInDiffEntry", transInDiffEntry);
        }
        if ((inQtyEntry = this.getInQtyData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row)) != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#inQtyEntry", inQtyEntry);
        }
        if (fixedOutDiffEntry != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#fixedOutDiffEntry", fixedOutDiffEntry);
        }
        if ((totalOutQtyEntry = this.getTotalOutQtyData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row)) != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#totalOutQtyEntry", totalOutQtyEntry);
        }
        if ((allocOutQtyEntry = this.getAllocOutQtyData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row)) != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#allocOutQtyEntry", allocOutQtyEntry);
        }
        if ((diffRateEntry = this.getDiffRateData(difftype, startSeq, addseq++, entrySeqMap, balaAmtMap, headerId, row)) != null) {
            entrys.put(difftype + "#" + this.getRowValue(row, "subelementid") + "#diffRateEntry", diffRateEntry);
        }
        int currSeq = startSeq + addseq - 1;
        entrySeqMap.put(difftype + "#" + this.getRowValue(row, "subelementid"), currSeq);
        return seq + 100;
    }

    private Object[] getInitDiffData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u671f\u521d\u5dee\u5f02", (String)"DealGenDiffAllocRptFunction_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        BigDecimal qty = this.rateService.getPeriodBeginDiffMap().get(this.getDiffKeyNoMD5(difftype, row));
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        this.dealBalance(difftype, row, "+", qty, balaAmtMap, entry);
        return entry;
    }

    private Object[] getFixedInDiffData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u56fa\u5b9a\u6536\u5165\u5dee\u5f02", (String)"DealGenDiffAllocRptFunction_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        BigDecimal qty = this.rateService.getPeriodInputDiffMap().get(this.getDiffKeyNoMD5(difftype, row));
        if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
            return null;
        }
        entry[7] = this.toBigDecimalString(qty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        this.dealBalance(difftype, row, "+", qty, balaAmtMap, entry);
        return entry;
    }

    private Object[] getTransInDiffData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u8f6c\u5165\u5dee\u5f02", (String)"DealGenDiffAllocRptFunction_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        Map<String, BigDecimal> transQtyMap = this.rateService.getTransInQtyWithDmMap().get("IN#" + this.getQtyKey(row));
        BigDecimal totalTransQty = BigDecimal.ZERO;
        if (transQtyMap != null && !transQtyMap.isEmpty()) {
            for (Map.Entry<String, BigDecimal> transQtyVals : transQtyMap.entrySet()) {
                BigDecimal curQty = transQtyVals.getValue() == null ? BigDecimal.ZERO : transQtyVals.getValue();
                String outCostDomainStr = this.getRowValue(row, "costDomain").toString();
                BigDecimal outRate = this.rateMap.get(difftype + "@" + outCostDomainStr) == null ? BigDecimal.ZERO : this.rateMap.get(difftype + "@" + outCostDomainStr);
                totalTransQty = totalTransQty.add(curQty.multiply(outRate).setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
            }
        }
        if (BigDecimal.ZERO.compareTo(totalTransQty) == 0) {
            return null;
        }
        entry[7] = this.toBigDecimalString(totalTransQty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        this.dealBalance(difftype, row, "+", totalTransQty, balaAmtMap, entry);
        return entry;
    }

    private Object[] getDiffRateData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u8f6c\u51fa\u5dee\u5f02\u7387", (String)"DealGenDiffAllocRptFunction_3", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        String outCostDomainStr = this.getRowValue(row, "costDomain").toString();
        StringBuilder equationSetDimsVal = new StringBuilder();
        for (String dim : this.allocParam.getEquationSetDims().split(",")) {
            equationSetDimsVal.append(this.getRowValue(row, dim).toString()).append("@");
        }
        BigDecimal outDiffRate = this.rateMap.get(difftype + "@" + outCostDomainStr);
        if (outDiffRate == null || BigDecimal.ZERO.compareTo(outDiffRate) == 0) {
            return null;
        }
        entry[7] = this.toBigDecimalString(outDiffRate);
        return entry;
    }

    private Object[] getInQtyData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u6536\u5165\u603b\u6570\u91cf\uff08\u542b\u671f\u521d\uff09", (String)"DealGenDiffAllocRptFunction_4", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        BigDecimal qty = this.rateService.getPeriodIntputQtyMap().get(this.getQtyKey(row));
        if (qty == null) {
            return null;
        }
        entry[7] = this.toBigDecimalString(qty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        return entry;
    }

    private Object[] getFixedOutDiffData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u56fa\u5b9a\u8f6c\u51fa\u5dee\u5f02", (String)"DealGenDiffAllocRptFunction_5", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        BigDecimal qty = this.rateService.getCrossPeriodOutputDiffMap().get(this.getDiffKeyNoMD5(difftype, row));
        if (qty == null) {
            return null;
        }
        entry[8] = this.toBigDecimalString(qty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        this.dealBalance(difftype, row, "-", qty, balaAmtMap, entry);
        return entry;
    }

    private Object[] getTotalOutQtyData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u8f6c\u51fa\u603b\u6570\u91cf", (String)"DealGenDiffAllocRptFunction_6", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        BigDecimal qty = this.rateService.getPeriodOutputQtyMap().get(this.getQtyKey(row));
        if (qty == null) {
            return null;
        }
        entry[8] = this.toBigDecimalString(qty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        return entry;
    }

    private Object[] getAllocOutQtyData(String difftype, int startSeq, int addseq, Map<String, Integer> entrySeqMap, Map<String, BigDecimal> balaAmtMap, Long headerId, RowX row) {
        String typeName = ResManager.loadKDString((String)"\u672c\u671f\u5e94\u5206\u644a\u5dee\u5f02\u7684\u8f6c\u51fa\u6570\u91cf", (String)"DealGenDiffAllocRptFunction_7", (String)"fi-calx-algox", (Object[])new Object[0]);
        Object[] entry = this.getPublicEntryData(difftype, startSeq, addseq, typeName, entrySeqMap, headerId, row);
        String qtyKey = this.getQtyKey(row);
        BigDecimal qty = this.rateService.getPeriodOutputQtyMap().get(qtyKey);
        if (qty == null) {
            return null;
        }
        BigDecimal fixedOutQty = this.rateService.getPeriodFixedOutputQtyMap().get(qtyKey);
        qty = qty.subtract(fixedOutQty == null ? BigDecimal.ZERO : fixedOutQty);
        entry[8] = this.toBigDecimalString(qty.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        return entry;
    }

    private Object[] getPublicEntryData(String difftype, int startSeq, int addseq, String typeName, Map<String, Integer> entrySeqMap, Long headerId, RowX row) {
        Object[] entry = new Object[]{headerId, DBServiceHelper.genLongIds((String)"t_cal_diffallocrptentry", (int)1)[0], startSeq + addseq, difftype, typeName, this.getRowValue(row, "elementid"), this.getRowValue(row, "subelementid"), "0", "0", " "};
        return entry;
    }

    private void getDetails(String difftype, Long entryId, Map<String, Integer> detailSeqMap, RowX row, Map<String, Object[]> details) {
        String rptEntryGroupKey = difftype + "#" + this.getRowValue(row, "outbilltypeid") + "#" + this.getRowValue(row, "subelementid");
        String detailKey = difftype + "#" + this.getRowValue(row, "outbillentryid") + this.getRowValue(row, "subelementid");
        Object[] detail = new Object[5];
        detail[0] = DBServiceHelper.genLongIds((String)"t_cal_diffallocrptentrydt", (int)1)[0];
        detail[1] = entryId;
        int detailSeq = detailSeqMap.get(rptEntryGroupKey) == null ? 1 : detailSeqMap.get(rptEntryGroupKey) + 1;
        detail[2] = detailSeq++;
        detailSeqMap.put(rptEntryGroupKey, detailSeq);
        BigDecimal baseQty = (BigDecimal)this.getRowValue(row, "baseqty");
        BigDecimal rate = this.rateMap.get(this.getDiffKey(difftype, row));
        BigDecimal diffAmt = (BigDecimal)this.getRowValue(row, "diffType_" + difftype);
        String outStr = rate + "*" + baseQty + "=" + diffAmt;
        String billNo = (String)this.getRowValue(row, "costrecordbillno");
        String descr = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u5206\u644a\u5dee\u5f02\uff1a%2$s", (String)"UnDiffAllocWizardCostAdjustHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]);
        detail[3] = String.format(descr, billNo, outStr);
        detail[4] = this.getRowValue(row, "stdcostdiffbillno");
        details.put(detailKey, detail);
    }

    private String getDiffKey(String diffType, RowX row) {
        String outCostDomainStr = this.getRowValue(row, "costDomain").toString();
        String diffKey = diffType + "@" + outCostDomainStr;
        return diffKey;
    }

    private String getDiffKeyNoMD5(String diffType, RowX row) {
        StringBuilder costDomainStr = new StringBuilder();
        for (String feild : this.allocParam.getAllocDims().split(",")) {
            costDomainStr.append(this.getRowValue(row, feild)).append("@");
        }
        StringBuilder equationSetDimsVal = new StringBuilder();
        for (String dim : this.allocParam.getEquationSetDims().split(",")) {
            equationSetDimsVal.append(this.getRowValue(row, dim).toString()).append("@");
        }
        String diffKey = diffType + "@" + costDomainStr + equationSetDimsVal + this.getRowValue(row, "elementid") + "@" + this.getRowValue(row, "subelementid");
        return diffKey;
    }

    private String getQtyKey(RowX row) {
        StringBuilder equationSetDimsVal = new StringBuilder();
        for (String feild : this.allocParam.getAllocDims().split(",")) {
            equationSetDimsVal.append(this.getRowValue(row, feild)).append("@");
        }
        for (String dim : this.allocParam.getEquationSetDims().split(",")) {
            equationSetDimsVal.append(this.getRowValue(row, dim).toString()).append("@");
        }
        return equationSetDimsVal.substring(0, equationSetDimsVal.length() - 1);
    }

    private void saveToDB(Object[] header, Map<String, Object[]> entrys, Map<String, Object[]> details) {
        if (header == null || entrys == null || entrys.isEmpty()) {
            return;
        }
        int batch_size = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        StringBuilder headInsertSql = new StringBuilder();
        headInsertSql.append("insert into t_cal_diffallocrpt(");
        headInsertSql.append("FID,FCALORGID,FCOSTACCOUNTID,FPERIODID,FMATERIALID,");
        headInsertSql.append("FDIFFALLOCCOLS,FDIFFALLOCCOLSVAL,FACCOUNTTYPE,FALLOCMODEL,");
        headInsertSql.append("FCARRYRULE,FCREATORID,FALLOCTIME,fallocrecordid,fcreatetime,fassist,fdimskeycol)");
        headInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuilder entryInsertSql = new StringBuilder();
        entryInsertSql.append("insert into t_cal_diffallocrptentry(");
        entryInsertSql.append("FID,FENTRYID,FSEQ,FCREATETYPE,FBILLTYPESTR,");
        entryInsertSql.append("FELEMENTID,FSUBELEMENTID,FINSTR,FOUTSTR,FBALANCESTR)");
        entryInsertSql.append("values(?,?,?,?,?,?,?,?,?,?)");
        StringBuilder detailInsertSql = new StringBuilder();
        detailInsertSql.append("insert into t_cal_diffallocrptentrydt(");
        detailInsertSql.append("fdetailid,fentryid,fseq,fdtoutstr,fcostadjbillno)");
        detailInsertSql.append("values(?,?,?,?,?)");
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        params.add(header);
        DB.executeBatch((DBRoute)route, (String)headInsertSql.toString(), params);
        Lists.partition((List)Lists.newArrayList(entrys.values()), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)entryInsertSql.toString(), (List)list);
            }
        });
        Lists.partition((List)Lists.newArrayList(details.values()), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)detailInsertSql.toString(), (List)list);
            }
        });
    }

    private void dealBalance(String difftype, RowX row, String direction, BigDecimal effectValue, Map<String, BigDecimal> balaAmtMap, Object[] entry) {
        BigDecimal currBala;
        if (effectValue == null) {
            return;
        }
        String key = difftype + "@" + row.getString(this.rowMeta.getFieldIndex("subelementid"));
        BigDecimal preBala = balaAmtMap.get(key);
        if (preBala == null) {
            preBala = BigDecimal.ZERO;
        }
        if ("+".equals(direction)) {
            currBala = effectValue.add(preBala);
            entry[9] = this.toBigDecimalString(preBala.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "+" + this.toBigDecimalString(effectValue.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "=" + this.toBigDecimalString(currBala.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        } else {
            currBala = preBala.subtract(effectValue);
            entry[9] = this.toBigDecimalString(preBala.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "-" + this.toBigDecimalString(effectValue.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP)) + "=" + this.toBigDecimalString(currBala.setScale(this.allocParam.getPrecision(), RoundingMode.HALF_UP));
        }
        balaAmtMap.put(key, currBala);
    }

    protected String toBigDecimalString(BigDecimal bigdecimal) {
        String bgStr = bigdecimal.toPlainString();
        if (bigdecimal.signum() < 0) {
            bgStr = "(" + bgStr + ")";
        }
        return bgStr;
    }

    private String getAllocDimVal(RowX row) {
        StringBuilder dimVals = new StringBuilder();
        String[] allocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims()).split(",");
        String noUpdateCalFields = row.getString(this.rowMeta.getFieldIndex("noupdatecalfields"));
        JSONObject jsonObject = JSON.parseObject((String)noUpdateCalFields);
        JSONArray noupdateFields = null;
        if (jsonObject != null) {
            noupdateFields = jsonObject.getJSONArray("setnull");
        }
        for (String field : allocDims) {
            if (noDisPlayDims.contains(field)) continue;
            Object currVal = this.getRowValue(row, field + "name");
            if (noupdateFields != null && noupdateFields.contains((Object)field)) {
                currVal = null;
            }
            if (currVal == null || currVal.toString().trim().isEmpty()) continue;
            dimVals.append(currVal);
            dimVals.append("_");
        }
        if (dimVals.length() > 1) {
            return dimVals.substring(0, dimVals.length() - 1);
        }
        return " ";
    }

    private String getAllocDim() {
        String allocDimsStr = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_bal");
        StringBuilder allocDims = new StringBuilder();
        for (String allocDim : allocDimsStr.split(",")) {
            if (noDisPlayDims.contains(allocDim)) continue;
            DynamicProperty property = entityType.getProperty(allocDim);
            allocDims.append(property.getDisplayName()).append("+");
        }
        return allocDims.length() == 0 ? " " : allocDims.substring(0, allocDims.length() - 1);
    }

    protected Object getRowValue(RowX row, String field) {
        return this.getRowValue(Boolean.FALSE, row, field);
    }

    protected Object getRowValue(Boolean isGroup, RowX row, String field) {
        String fieldAlias = isGroup != false ? "g" + field : field;
        int index = this.rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

