/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.EntityExInfo;
import kd.fi.calx.algox.diff.function.DealBaseFunction;
import kd.fi.calx.algox.diff.model.CostAdjustBillModel;
import kd.fi.calx.algox.diff.model.StdCostDiffBillModel;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class DealGenDiffBillFunction
extends DealBaseFunction {
    private static final long serialVersionUID = 6337267609760591733L;
    private static final String[] indexStrs = new String[]{"id", "seq", "sub_material", "costelement", "costsubelement", "sub_currency", "sub_adjustamt", "ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y", "sub_material_id", "costelement_id", "costsubelement_id", "sub_currency_id"};
    private List<EntityExInfo> entityExInfos = new ArrayList<EntityExInfo>(16);

    public DealGenDiffBillFunction(RowMeta rowMeta, String subelementIds) {
        super(rowMeta, null, null);
    }

    @Override
    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        Iterator<RowX> it = arg1.iterator();
        HashMap<String, CostAdjustBillModel> costAdjustBills = new HashMap<String, CostAdjustBillModel>(16);
        HashMap<String, List<StdCostDiffBillModel>> stdCostDiffBills = new HashMap<String, List<StdCostDiffBillModel>>(16);
        HashSet<String> dealedEntrys = new HashSet<String>(16);
        while (it.hasNext()) {
            RowX row = it.next();
            this.genStdCostDiffBill(dealedEntrys, row, stdCostDiffBills, collector);
            String accountType = this.getRowValue(row, "gaccounttype").toString();
            if ("D".equals(accountType) || accountType.trim().isEmpty()) continue;
            this.genActaulAdjustBill(row, costAdjustBills, collector);
        }
        this.saveCostAdjustBillToDB(costAdjustBills);
        this.saveStdCostDiffBillToDB(stdCostDiffBills);
    }

    private void genStdCostDiffBill(Set<String> dealedEntrys, RowX row, Map<String, List<StdCostDiffBillModel>> stdCostDiffBills, Collector collector) {
        String key = this.getRowValue(row, "costDomain").toString() + "@" + this.getRowValue(row, "costrecordentryid").toString();
        if (dealedEntrys.add(key)) {
            this.dealStdCostBillHeader(row, stdCostDiffBills, Boolean.FALSE);
            this.dealStdCostBillEntry(row, stdCostDiffBills, Boolean.FALSE);
            this.dealStdCostBillDetail(row, stdCostDiffBills, Boolean.FALSE);
            dealedEntrys.add(key);
        }
        if ((Long)this.getRowValue(Boolean.FALSE, row, "gcostrecordentryid") != 0L) {
            this.dealStdCostBillHeader(row, stdCostDiffBills, Boolean.TRUE);
            this.dealStdCostBillEntry(row, stdCostDiffBills, Boolean.TRUE);
            this.dealStdCostBillDetail(row, stdCostDiffBills, Boolean.TRUE);
        }
        collector.collect(row);
    }

    private void genActaulAdjustBill(RowX row, Map<String, CostAdjustBillModel> costAdjustBills, Collector collector) {
        for (String difftype : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
            if ((Long)this.getRowValue(Boolean.FALSE, row, "gcostrecordentryid") == 0L) continue;
            this.dealCostAdjustBillHeader(row, costAdjustBills, difftype, Boolean.TRUE);
            this.dealCostAdjustBillEntry(row, costAdjustBills, difftype, Boolean.TRUE);
            this.dealCostAdjustBillDetail(row, costAdjustBills, difftype, Boolean.TRUE);
        }
        collector.collect(row);
    }

    private void dealStdCostBillHeader(RowX row, Map<String, List<StdCostDiffBillModel>> costAdjustBills, Boolean isGroup) {
        String headerKey = this.getStdCostDiffBillHeadKey(row, isGroup);
        List<StdCostDiffBillModel> costAdjustBillModels = costAdjustBills.get(headerKey);
        if (costAdjustBillModels == null) {
            costAdjustBillModels = new ArrayList<StdCostDiffBillModel>(16);
            costAdjustBillModels.add(new StdCostDiffBillModel());
            costAdjustBills.put(headerKey, costAdjustBillModels);
        } else if (costAdjustBillModels.get(costAdjustBillModels.size() - 1).getEntrys().size() > 1000) {
            costAdjustBillModels.add(new StdCostDiffBillModel());
        } else {
            return;
        }
        Boolean isAdj = !"1".equals(this.getRowValue(isGroup, row, "costrecordid").toString());
        Object[] head = new Object[22];
        costAdjustBillModels.get(costAdjustBillModels.size() - 1).setHeaders(head);
        Object[] head_l = new Object[4];
        costAdjustBillModels.get(costAdjustBillModels.size() - 1).setHeaders_l(head_l);
        long costAdjustId = DBServiceHelper.genLongIds((String)"cal_stdcostdiffbill", (int)1)[0];
        head[0] = costAdjustId;
        String adjustIds = this.getRowValue(row, "stdcostdiffbillid").toString() + "," + costAdjustId;
        row.set(this.rowMeta.getFieldIndex("stdcostdiffbillid"), (Object)adjustIds);
        head_l[0] = costAdjustId;
        head_l[1] = DBServiceHelper.genStringIds((String)"t_cal_costadjustbill_l", (int)1)[0];
        head[1] = this.getRowValue(isGroup, row, "periodid");
        head[2] = this.getRowValue(isGroup, row, "calorg");
        head[3] = this.getRowValue(isGroup, row, "costaccount");
        head[4] = "C";
        head[5] = "D";
        head[6] = isGroup != false ? "A" : "B";
        head[7] = this.getRowValue(isGroup, row, "enddate");
        head[8] = this.getRowValue(isGroup, row, "enddate");
        head[9] = this.getRowValue(isGroup, row, "outbilltypeid");
        head[10] = isGroup != false ? "bd_supplier" : "bd_customer";
        head[11] = "W";
        head[12] = this.getRowValue(isGroup, row, "currencyid");
        head[13] = this.getRowValue(isGroup, row, "adminorg");
        head[14] = "IN".equals(this.getRowValue(isGroup, row, "calbilltype")) ? this.getRowValue(isGroup, row, "supplier") : this.getRowValue(isGroup, row, "customer");
        head_l[2] = ResManager.getLanguage();
        String ajdRemark = isAdj != false ? "" : ResManager.loadKDString((String)"_\u5c3e\u5dee\u8c03\u6574", (String)"DealGenDiffBillFunction_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        head_l[3] = String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210%1$s", (String)"UnDiffAllocWizardCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]), ajdRemark);
        head[15] = "CBTZ" + costAdjustId;
        Long userId = RequestContext.get().getCurrUserId();
        Date date = TimeServiceHelper.now();
        head[16] = userId;
        head[17] = date;
        head[18] = userId;
        head[19] = date;
        head[20] = userId;
        head[21] = date;
    }

    private void dealStdCostBillEntry(RowX row, Map<String, List<StdCostDiffBillModel>> costAdjustBills, Boolean isGroup) {
        String headerKey = this.getStdCostDiffBillHeadKey(row, isGroup);
        List<StdCostDiffBillModel> StdCostDiffBillModels = costAdjustBills.get(headerKey);
        StdCostDiffBillModel costAdjustBillModel = StdCostDiffBillModels.get(StdCostDiffBillModels.size() - 1);
        String entryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid");
        Object[] entry = costAdjustBillModel.getEntrys().get(entryKey);
        if ("2".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && !isGroup.booleanValue() || "1".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && isGroup.booleanValue()) {
            return;
        }
        if (entry != null) {
            int index = 1;
            BigDecimal totalDiff = BigDecimal.ZERO;
            for (String diffType : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
                BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + diffType);
                BigDecimal oldAdjAmt = (BigDecimal)entry[22 + index];
                currAdjAmt = currAdjAmt.add(oldAdjAmt);
                entry[22 + index++] = currAdjAmt;
                totalDiff = totalDiff.add(currAdjAmt);
            }
            entry[22] = totalDiff;
            return;
        }
        entry = new Object[57 + this.entityExInfos.size()];
        costAdjustBillModel.getEntrys().put(entryKey, entry);
        Boolean isAdj = Boolean.FALSE;
        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
        if (costAdjustBillModel == null) {
            return;
        }
        entry[0] = costAdjustBillModel.getHeaders()[0];
        entry[1] = costAdjustEntryId;
        entry[2] = costAdjustBillModel.getEntrySeq();
        entry[3] = this.getRowValue(isGroup, row, "storageorgunit");
        entry[4] = this.getRowValue(isGroup, row, "material");
        entry[5] = this.getRowValue(isGroup, row, "mversion");
        entry[6] = this.getRowValue(isGroup, row, "assist");
        entry[7] = this.getRowValue(isGroup, row, "lot");
        entry[8] = this.getRowValue(isGroup, row, "baseunitid");
        entry[9] = this.getRowValue(isGroup, row, "warehouse");
        entry[10] = this.getRowValue(isGroup, row, "location");
        entry[11] = this.getRowValue(isGroup, row, "invtypeid");
        entry[12] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "outbilltypeid");
        entry[13] = this.getRowValue(isGroup, row, "invstatus");
        entry[14] = this.getRowValue(isGroup, row, "ownertype");
        entry[15] = this.getRowValue(isGroup, row, "owner");
        entry[16] = this.getRowValue(isGroup, row, "project");
        entry[17] = this.getRowValue(isGroup, row, "tracknumber");
        entry[18] = this.getRowValue(isGroup, row, "configuredcode");
        entry[19] = this.getRowValue(isGroup, row, "calrangeid");
        entry[20] = this.getRowValue(isGroup, row, "caldimensionid");
        entry[21] = this.getRowValue(isGroup, row, "accounttype");
        int index = 1;
        BigDecimal totalDiff = BigDecimal.ZERO;
        for (String diffType : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
            BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + diffType);
            entry[22 + index++] = currAdjAmt;
            totalDiff = totalDiff.add(currAdjAmt);
        }
        entry[22] = totalDiff;
        entry[36] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "costrecordid");
        entry[37] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "costrecordentryid");
        entry[38] = isAdj != false ? " " : this.getRowValue(isGroup, row, "costrecordbillno");
        entry[39] = isAdj != false ? " " : "cal_costrecord_subentity";
        entry[40] = isAdj != false ? Integer.valueOf(0) : this.getRowValue(isGroup, row, "costrecordseq");
        entry[41] = isAdj != false ? null : this.getRowValue(isGroup, row, "enddate");
        Object object = entry[42] = isAdj != false ? null : this.getRowValue(isGroup, row, "auditdate");
        if (isGroup.booleanValue()) {
            String adjustbillids = this.getRowValue(isGroup, row, "stdcostdiffbillid").toString();
            entry[43] = isAdj != false ? 0L : Long.parseLong(adjustbillids.split(",")[0]);
            entry[44] = isAdj != false ? " " : this.getRowValue(isGroup, row, "adjsutbillno");
            entry[45] = 0L;
            String outBillKey = this.getStdCostDiffBillHeadKey(row, isGroup);
            List<StdCostDiffBillModel> costOutAdjustBillModels = costAdjustBills.get(outBillKey);
            String outBillEntryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(false, row, "costrecordentryid");
            int seq = 0;
            for (StdCostDiffBillModel costOutAdjustBillModel : costOutAdjustBillModels) {
                if (!costOutAdjustBillModel.getEntrys().containsKey(outBillEntryKey)) continue;
                seq = (Integer)costOutAdjustBillModel.getEntrys().get(outBillEntryKey)[2];
            }
            entry[46] = seq;
            entry[47] = isAdj != false ? " " : "cal_costadjust_subentity";
        } else {
            entry[43] = 0L;
            entry[44] = " ";
            entry[45] = 0L;
            entry[46] = 0;
            entry[47] = " ";
        }
        entry[48] = this.getRowValue(isGroup, row, "biztype");
        entry[49] = this.getRowValue(isGroup, row, "transtype");
        entry[50] = this.getRowValue(isGroup, row, "queuetype");
        entry[51] = this.getRowValue(isGroup, row, "signnum");
        entry[53] = this.getRowValue(isGroup, row, "ecostcenter");
        entry[54] = this.getRowValue(isGroup, row, "productline");
        entry[55] = this.getRowValue(isGroup, row, "noupdatecalfields");
        entry[56] = this.getRowValue(isGroup, row, "stocktype");
        for (int i = 0; i < this.entityExInfos.size(); ++i) {
            entry[57 + i] = this.getRowValue(isGroup, row, this.entityExInfos.get(i).getPropertyName());
        }
    }

    private void dealStdCostBillDetail(RowX row, Map<String, List<StdCostDiffBillModel>> costAdjustBills, Boolean isGroup) {
        if ("2".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && !isGroup.booleanValue() || "1".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && isGroup.booleanValue()) {
            return;
        }
        String headerKey = this.getStdCostDiffBillHeadKey(row, isGroup);
        List<StdCostDiffBillModel> stdCostDiffBillModels = costAdjustBills.get(headerKey);
        String entryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid");
        Object[] entry = null;
        Map<String, Object[]> details = null;
        StdCostDiffBillModel currStdCostDiffBillModel = null;
        for (StdCostDiffBillModel stdCostDiffBillModel : stdCostDiffBillModels) {
            if (!stdCostDiffBillModel.getEntrys().containsKey(entryKey)) continue;
            currStdCostDiffBillModel = stdCostDiffBillModel;
            entry = stdCostDiffBillModel.getEntrys().get(entryKey);
            details = stdCostDiffBillModel.getDetails();
        }
        if (stdCostDiffBillModels != null && stdCostDiffBillModels.get(0) != null) {
            String costAdjustNo = (String)stdCostDiffBillModels.get(0).getHeaders()[15];
            if (isGroup.booleanValue()) {
                row.set(this.getResultRowMeta().getFieldIndex("gadjsutbillno"), (Object)costAdjustNo);
            } else {
                row.set(this.getResultRowMeta().getFieldIndex("adjsutbillno"), (Object)costAdjustNo);
            }
        }
        String detailKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid").toString() + "@" + this.getRowValue(isGroup, row, "subelementid").toString();
        long detailId = DBServiceHelper.genLongIds((String)"t_cal_costadjust_detail", (int)1)[0];
        Object[] detail = new Object[24];
        if (entry == null) {
            return;
        }
        detail[0] = detailId;
        if (currStdCostDiffBillModel != null) {
            Map<String, Integer> detailSeqs = currStdCostDiffBillModel.getDetailSeqs();
            if (detailSeqs == null || currStdCostDiffBillModel.getDetailSeqs().get(entryKey) == null) {
                detail[1] = 1;
                currStdCostDiffBillModel.getDetailSeqs().put(entryKey, 1);
            } else {
                Integer currSeq = currStdCostDiffBillModel.getDetailSeqs().get(entryKey);
                detail[1] = currSeq + 1;
                currStdCostDiffBillModel.getDetailSeqs().put(entryKey, currSeq + 1);
            }
        } else {
            return;
        }
        detail[2] = this.getRowValue(isGroup, row, "material");
        detail[3] = this.getRowValue(isGroup, row, "elementid");
        detail[4] = this.getRowValue(isGroup, row, "subelementid");
        detail[5] = this.getRowValue(isGroup, row, "currencyid");
        int index = 1;
        BigDecimal totalDiff = BigDecimal.ZERO;
        for (String diffType : "G,H,K,P,Q,R,M,S,T,C,X,W,Y".split(",")) {
            BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + diffType);
            detail[6 + index++] = currAdjAmt;
            totalDiff = totalDiff.add(currAdjAmt);
        }
        detail[6] = totalDiff;
        detail[20] = this.getRowValue(isGroup, row, "material");
        detail[21] = this.getRowValue(isGroup, row, "elementid");
        detail[22] = this.getRowValue(isGroup, row, "subelementid");
        detail[23] = this.getRowValue(isGroup, row, "currencyid");
        entry[52] = this.dealJsonData(entry[52], detail);
    }

    private void dealCostAdjustBillHeader(RowX row, Map<String, CostAdjustBillModel> costAdjustBills, String difftype, Boolean isGroup) {
        BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + difftype);
        if (BigDecimal.ZERO.compareTo(currAdjAmt) == 0) {
            return;
        }
        String headerKey = this.getCostAdjustBillHeadKey(row, difftype, isGroup);
        CostAdjustBillModel costAdjustBillModel = costAdjustBills.get(headerKey);
        if (costAdjustBillModel != null) {
            return;
        }
        costAdjustBillModel = new CostAdjustBillModel();
        costAdjustBills.put(headerKey, costAdjustBillModel);
        Boolean isAdj = !"1".equals(this.getRowValue(isGroup, row, "costrecordid").toString());
        Object[] head = new Object[23];
        costAdjustBillModel.setHeaders(head);
        Object[] head_l = new Object[4];
        costAdjustBillModel.setHeaders_l(head_l);
        long costAdjustId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbill", (int)1)[0];
        head[0] = costAdjustId;
        String adjustIds = this.getRowValue(row, "adjsutbillid").toString() + "," + costAdjustId;
        row.set(this.rowMeta.getFieldIndex("adjsutbillid"), (Object)adjustIds);
        head_l[0] = costAdjustId;
        head_l[1] = DBServiceHelper.genStringIds((String)"t_cal_costadjustbill_l", (int)1)[0];
        head[1] = this.getRowValue(isGroup, row, "periodid");
        head[2] = this.getRowValue(isGroup, row, "calorg");
        head[3] = this.getRowValue(isGroup, row, "costaccount");
        head[4] = "B";
        head[5] = "D";
        head[6] = isGroup != false ? "A" : "B";
        head[7] = this.getRowValue(isGroup, row, "enddate");
        head[8] = this.getRowValue(isGroup, row, "enddate");
        head[9] = this.getRowValue(isGroup, row, "outbilltypeid");
        head[10] = isGroup != false ? "bd_supplier" : "bd_customer";
        head[11] = "B";
        head[12] = "W";
        head[13] = this.getRowValue(isGroup, row, "currencyid");
        head[14] = this.getRowValue(isGroup, row, "adminorg");
        head[15] = "OUT".equals(this.getRowValue(isGroup, row, "calbilltype")) ? this.getRowValue(isGroup, row, "supplier") : this.getRowValue(isGroup, row, "customer");
        head_l[2] = ResManager.getLanguage();
        String ajdRemark = isAdj != false ? "" : ResManager.loadKDString((String)"_\u5c3e\u5dee\u8c03\u6574", (String)"DealGenDiffBillFunction_0", (String)"fi-calx-algox", (Object[])new Object[0]);
        head_l[3] = String.format(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u81ea\u52a8\u751f\u6210%1$s", (String)"UnDiffAllocWizardCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]), ajdRemark);
        head[16] = "CBTZ" + costAdjustId;
        row.set(this.getResultRowMeta().getFieldIndex("adjsutbillno"), (Object)("CBTZ" + costAdjustId));
        Long userId = RequestContext.get().getCurrUserId();
        Date date = TimeServiceHelper.now();
        head[17] = userId;
        head[18] = date;
        head[19] = userId;
        head[20] = date;
        head[21] = userId;
        head[22] = date;
    }

    private void dealCostAdjustBillEntry(RowX row, Map<String, CostAdjustBillModel> costAdjustBills, String difftype, Boolean isGroup) {
        String headerKey = this.getCostAdjustBillHeadKey(row, difftype, isGroup);
        CostAdjustBillModel costAdjustBillModel = costAdjustBills.get(headerKey);
        if (costAdjustBillModel == null) {
            return;
        }
        String entryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid");
        Object[] entry = costAdjustBillModel.getEntrys().get(entryKey);
        if ("2".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && !isGroup.booleanValue() || "1".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && isGroup.booleanValue()) {
            return;
        }
        if (entry != null) {
            BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + difftype);
            BigDecimal oldAdjAmt = (BigDecimal)entry[22];
            entry[22] = currAdjAmt.add(oldAdjAmt);
            return;
        }
        entry = new Object[42 + this.entityExInfos.size()];
        costAdjustBillModel.getEntrys().put(entryKey, entry);
        Boolean isAdj = Boolean.FALSE;
        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
        if (costAdjustBillModel == null) {
            return;
        }
        entry[0] = costAdjustBillModel.getHeaders()[0];
        entry[1] = costAdjustEntryId;
        entry[2] = costAdjustBillModel.getEntrySeq();
        entry[3] = this.getRowValue(isGroup, row, "storageorgunit");
        entry[4] = this.getRowValue(isGroup, row, "material");
        entry[5] = this.getRowValue(isGroup, row, "mversion");
        entry[6] = this.getRowValue(isGroup, row, "assist");
        entry[7] = this.getRowValue(isGroup, row, "lot");
        entry[8] = this.getRowValue(isGroup, row, "baseunitid");
        entry[9] = this.getRowValue(isGroup, row, "warehouse");
        entry[10] = this.getRowValue(isGroup, row, "location");
        entry[11] = this.getRowValue(isGroup, row, "invtypeid");
        entry[12] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "outbilltypeid");
        entry[13] = this.getRowValue(isGroup, row, "invstatus");
        entry[14] = this.getRowValue(isGroup, row, "ownertype");
        entry[15] = this.getRowValue(isGroup, row, "owner");
        entry[16] = this.getRowValue(isGroup, row, "project");
        entry[17] = this.getRowValue(isGroup, row, "tracknumber");
        entry[18] = this.getRowValue(isGroup, row, "configuredcode");
        entry[19] = this.getRowValue(isGroup, row, "calrangeid");
        entry[20] = this.getRowValue(isGroup, row, "caldimensionid");
        entry[21] = this.getRowValue(isGroup, row, "accounttype");
        entry[22] = this.getRowValue(isGroup, row, "diffType_" + difftype);
        entry[23] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "costrecordid");
        entry[24] = isAdj != false ? Long.valueOf(0L) : this.getRowValue(isGroup, row, "costrecordentryid");
        entry[25] = isAdj != false ? " " : this.getRowValue(isGroup, row, "costrecordbillno");
        entry[26] = isAdj != false ? " " : "cal_costrecord_subentity";
        entry[27] = isAdj != false ? Integer.valueOf(0) : this.getRowValue(isGroup, row, "costrecordseq");
        entry[28] = isAdj != false ? null : this.getRowValue(isGroup, row, "enddate");
        Object object = entry[29] = isAdj != false ? null : this.getRowValue(isGroup, row, "auditdate");
        if (isGroup.booleanValue()) {
            String adjustbillids = this.getRowValue(isGroup, row, "adjsutbillid").toString();
            entry[30] = isAdj != false ? Long.valueOf(0L) : Long.valueOf(adjustbillids.split(",")[0]);
            entry[31] = isAdj != false ? " " : this.getRowValue(isGroup, row, "adjsutbillno");
            entry[32] = 0L;
            String outBillKey = this.getCostAdjustBillHeadKey(row, difftype, isGroup);
            CostAdjustBillModel costOutAdjustBillModel = costAdjustBills.get(outBillKey);
            String outBillEntryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(false, row, "costrecordentryid") + "@" + difftype;
            Map<String, Object[]> outBillEntrys = costOutAdjustBillModel.getEntrys();
            int seq = outBillEntrys.containsKey(outBillEntryKey) ? (Integer)outBillEntrys.get(outBillEntryKey)[2] : 0;
            entry[33] = seq;
            entry[34] = isAdj != false ? " " : "cal_costadjust_subentity";
        } else {
            entry[30] = 0L;
            entry[31] = " ";
            entry[32] = 0L;
            entry[33] = 0;
            entry[34] = " ";
        }
        entry[35] = this.getRowValue(isGroup, row, "biztype");
        entry[36] = this.getRowValue(isGroup, row, "transtype");
        entry[37] = this.getRowValue(isGroup, row, "queuetype");
        entry[38] = this.getRowValue(isGroup, row, "signnum");
        entry[39] = this.getRowValue(isGroup, row, "productline");
        entry[40] = this.getRowValue(isGroup, row, "ecostcenter");
        entry[41] = this.getRowValue(isGroup, row, "noupdatecalfields");
        entry[42] = this.getRowValue(isGroup, row, "stocktype");
        for (int i = 0; i < this.entityExInfos.size(); ++i) {
            entry[43 + i] = this.getRowValue(isGroup, row, this.entityExInfos.get(i).getPropertyName());
        }
    }

    private void dealCostAdjustBillDetail(RowX row, Map<String, CostAdjustBillModel> costAdjustBills, String difftype, Boolean isGroup) {
        if ("2".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && !isGroup.booleanValue() || "1".equals(this.getRowValue(isGroup, row, "costrecordid").toString()) && isGroup.booleanValue()) {
            return;
        }
        String headerKey = this.getCostAdjustBillHeadKey(row, difftype, isGroup);
        CostAdjustBillModel costAdjustBillModel = costAdjustBills.get(headerKey);
        if (costAdjustBillModel == null) {
            return;
        }
        String entryKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid");
        Object[] entry = costAdjustBillModel.getEntrys().get(entryKey);
        String detailKey = this.getRowValue(isGroup, row, "costrecordid").toString() + "@" + this.getRowValue(isGroup, row, "costrecordentryid").toString() + "@" + this.getRowValue(isGroup, row, "subelementid").toString();
        Map<String, Object[]> details = costAdjustBillModel.getDetails();
        long detailId = DBServiceHelper.genLongIds((String)"t_cal_costadjust_detail", (int)1)[0];
        Object[] detail = new Object[8];
        if (entry == null) {
            return;
        }
        detail[0] = entry[1];
        if (details.containsKey(detailKey)) {
            BigDecimal currAdjAmt = (BigDecimal)this.getRowValue(isGroup, row, "diffType_" + difftype);
            BigDecimal oldAdjAmt = (BigDecimal)details.get(detailKey)[7];
            details.get((Object)detailKey)[7] = currAdjAmt.add(oldAdjAmt);
            return;
        }
        detail[1] = detailId;
        if (costAdjustBillModel.getDetailSeqs().containsKey(entryKey)) {
            Integer currSeq = costAdjustBillModel.getDetailSeqs().get(entryKey);
            detail[2] = currSeq + 1;
            costAdjustBillModel.getDetailSeqs().put(entryKey, currSeq + 1);
        } else {
            detail[2] = 1;
            costAdjustBillModel.getDetailSeqs().put(entryKey, 1);
        }
        detail[3] = detail[4] = this.getRowValue(isGroup, row, "material");
        detail[4] = this.getRowValue(isGroup, row, "elementid");
        detail[5] = this.getRowValue(isGroup, row, "subelementid");
        detail[6] = this.getRowValue(isGroup, row, "currencyid");
        detail[7] = this.getRowValue(isGroup, row, "diffType_" + difftype);
        details.put(detailKey, detail);
    }

    private void saveCostAdjustBillToDB(Map<String, CostAdjustBillModel> costAdjustBills) {
        int index;
        int batch_size = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        StringBuilder headInsertSql = new StringBuilder();
        headInsertSql.append("insert into t_cal_costadjustbill(");
        headInsertSql.append("FID,fperiodid,forgid,fcostaccount,fbillstatus,");
        headInsertSql.append("fbillsrctype,fbiztype,fbizdate,fbookdate,fsrcbilltypeid,");
        headInsertSql.append("fcstypeid,fdifftype,fcreatetype,fcurrencyid,fadminorgid,");
        headInsertSql.append("fcustsupplierid,fbillno,fcreatorid,fcreatetime,fmodifierid,");
        headInsertSql.append("fmodifytime,fauditorid,fauditdate,fcalstatus)");
        headInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'A')");
        StringBuilder headInsertSql_l = new StringBuilder();
        headInsertSql_l.append("insert into t_cal_costadjustbill_l(");
        headInsertSql_l.append("FID,FPKID,FLOCALEID,FREMARK)");
        headInsertSql_l.append("values(?,?,?,?)");
        StringBuilder entryInsertSql = new StringBuilder();
        entryInsertSql.append("insert into t_cal_costadjustbillentry(");
        entryInsertSql.append("fid,fentryid,fseq,fstorageorgunitid,fmaterialid,");
        entryInsertSql.append("fmversionid,fauxpropertyid,flot,fbaseunitid,fwarehsouseid,");
        entryInsertSql.append("flocationid,finvtypeid,finvbilltype,finvstatusid,fownertype,");
        entryInsertSql.append("fownerid,fprojectid,ftracknumberid,fconfiguredcodeid,fcalrangeid,");
        entryInsertSql.append("fcaldimensionid,faccounttype,fadjustamt,finvbillid,finvbillentryid,");
        entryInsertSql.append("finvbillnum,finvbizentityobject,finventryseq,finvbizdate,finvauditdate,");
        entryInsertSql.append("fsrcbillid,fsrcbillnum,fsrcbillentryid,fsrcentryseq,fsrcbizentityobject,");
        entryInsertSql.append("finvbiztypeid,ftranstype,fqueuetype,fsignnum,fentrystatus,");
        entryInsertSql.append("fecalstatus,fproductline,fecostcenterid,fnoupdatecalfields,fstocktypeid");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",").append(this.entityExInfos.get(index).getDbField());
        }
        entryInsertSql.append(")");
        entryInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,'C','A',?,?,?,?");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",?");
        }
        entryInsertSql.append(")");
        StringBuilder detailInsertSql = new StringBuilder();
        detailInsertSql.append("insert into t_cal_costadjust_detail(");
        detailInsertSql.append("fEntryid,fdetailid,fseq,fmaterialid,fcostelementid,fcostsubelementid,fcurrencyid,fadjustamt)");
        detailInsertSql.append("values(?,?,?,?,?,?,?,?)");
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> heads = new ArrayList<Object[]>(16);
        ArrayList<Object[]> heads_l = new ArrayList<Object[]>(16);
        HashSet<Object[]> entrys = new HashSet<Object[]>(16);
        HashSet<Object[]> details = new HashSet<Object[]>(16);
        for (Map.Entry<String, CostAdjustBillModel> costAdjustBill : costAdjustBills.entrySet()) {
            heads.add(costAdjustBill.getValue().getHeaders());
            heads_l.add(costAdjustBill.getValue().getHeaders_l());
            entrys.addAll(costAdjustBill.getValue().getEntrys().values());
            details.addAll(costAdjustBill.getValue().getDetails().values());
        }
        Lists.partition(heads, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql.toString(), (List)list);
            }
        });
        Lists.partition(heads_l, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql_l.toString(), (List)list);
            }
        });
        Lists.partition((List)Lists.newArrayList(entrys), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)entryInsertSql.toString(), (List)list);
            }
        });
        Lists.partition((List)Lists.newArrayList(details), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)detailInsertSql.toString(), (List)list);
            }
        });
    }

    private void saveStdCostDiffBillToDB(Map<String, List<StdCostDiffBillModel>> stdCostDiffBills) {
        int index;
        int batch_size = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        StringBuilder headInsertSql = new StringBuilder();
        headInsertSql.append("insert into t_cal_stdcostdiff(");
        headInsertSql.append("FID,fperiodid,forgid,fcostaccount,fbillstatus,");
        headInsertSql.append("fbillsrctype,fbiztype,fbizdate,fbookdate,fsrcbilltypeid,");
        headInsertSql.append("fcstypeid,fcreatetype,fcurrencyid,fadminorgid,");
        headInsertSql.append("fcustsupplierid,fbillno,fcreatorid,fcreatetime,fmodifierid,");
        headInsertSql.append("fmodifytime,fauditorid,fauditdate,fcalstatus)");
        headInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'A')");
        StringBuilder headInsertSql_l = new StringBuilder();
        headInsertSql_l.append("insert into t_cal_stdcostdiff_l(");
        headInsertSql_l.append("FID,FPKID,FLOCALEID,FREMARK)");
        headInsertSql_l.append("values(?,?,?,?)");
        StringBuilder entryInsertSql = new StringBuilder();
        entryInsertSql.append("insert into t_cal_stdcostdiffentry(");
        entryInsertSql.append("fid,fentryid,fseq,fstorageorgunitid,fmaterialid,");
        entryInsertSql.append("fmversionid,fauxpropertyid,flot,fbaseunitid,fwarehsouseid,");
        entryInsertSql.append("flocationid,finvtypeid,finvbilltype,finvstatusid,fownertype,");
        entryInsertSql.append("fownerid,fprojectid,ftracknumberid,fconfiguredcodeid,fcalrangeid,");
        entryInsertSql.append("fcaldimensionid,faccounttype,fadjustamt,FDiff_G,FDiff_H,");
        entryInsertSql.append("FDiff_K,FDiff_P,FDiff_Q,FDiff_R,FDiff_M,");
        entryInsertSql.append("FDiff_S,FDiff_T,FDiff_C,FDiff_X,FDiff_W,");
        entryInsertSql.append("FDiff_Y,finvbillid,finvbillentryid,finvbillnum,finvbizentityobject,");
        entryInsertSql.append("finventryseq,finvbizdate,finvauditdate,fsrcbillid,fsrcbillnum,");
        entryInsertSql.append("fsrcbillentryid,fsrcentryseq,fsrcbizentityobject,finvbiztypeid,ftranstype,");
        entryInsertSql.append("fqueuetype,fsignnum,fsubentryentity,fentrystatus,fecalstatus,");
        entryInsertSql.append("fecostcenterid,fproductlineid,fnoupdatecalfields,fstocktypeid");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",").append(this.entityExInfos.get(index).getDbField());
        }
        entryInsertSql.append(")");
        entryInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,'C','A',?,?,?,?");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",?");
        }
        entryInsertSql.append(")");
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> heads = new ArrayList<Object[]>(16);
        ArrayList<Object[]> heads_l = new ArrayList<Object[]>(16);
        HashSet<Object[]> entrys = new HashSet<Object[]>(16);
        for (Map.Entry<String, List<StdCostDiffBillModel>> stdCostDiffBillModelsMap : stdCostDiffBills.entrySet()) {
            for (StdCostDiffBillModel stdCostDiffBillModel : stdCostDiffBillModelsMap.getValue()) {
                heads.add(stdCostDiffBillModel.getHeaders());
                heads_l.add(stdCostDiffBillModel.getHeaders_l());
                entrys.addAll(stdCostDiffBillModel.getEntrys().values());
            }
        }
        Lists.partition(heads, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql.toString(), (List)list);
            }
        });
        Lists.partition(heads_l, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql_l.toString(), (List)list);
            }
        });
        Lists.partition((List)Lists.newArrayList(entrys), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)entryInsertSql.toString(), (List)list);
            }
        });
    }

    private Object dealJsonData(Object val, Object[] detailVals) {
        if (val == null) {
            JSONObject valJson = new JSONObject();
            JSONArray datas = new JSONArray();
            datas.add((Object)detailVals);
            valJson.put("data", (Object)datas);
            valJson.put("index", JSON.toJSON((Object)indexStrs));
            val = valJson.toJSONString();
        } else {
            JSONObject vaJson = JSON.parseObject((String)val.toString());
            JSONArray data = vaJson.getJSONArray("data");
            data.add((Object)detailVals);
            val = vaJson.toString();
        }
        return val;
    }

    private String getStdCostDiffBillHeadKey(RowX row, Boolean isGroup) {
        StringBuilder headKey = new StringBuilder();
        headKey.append(this.getRowValue(isGroup, row, "costaccount").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "material").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "bizentityobject").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "customer").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "supplier").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "adminorg").toString()).append("@");
        headKey.append(isGroup);
        return headKey.toString();
    }

    private String getCostAdjustBillHeadKey(RowX row, String difftype, Boolean isGroup) {
        StringBuilder headKey = new StringBuilder();
        headKey.append(this.getRowValue(isGroup, row, "costaccount").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "material").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "bizentityobject").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "customer").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "supplier").toString()).append("@");
        headKey.append(this.getRowValue(isGroup, row, "adminorg").toString()).append("@");
        headKey.append(isGroup);
        return headKey.toString();
    }

    public void setEntityExInfos(List<EntityExInfo> entityExInfos) {
        this.entityExInfos = entityExInfos;
    }
}

