/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.function.DealBaseFunction;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;

public class DealInBillToRowFunction
extends DealBaseFunction {
    private static final long serialVersionUID = -8217462217838712816L;

    public DealInBillToRowFunction(RowMeta rowMeta, DiffAllocParamter allocParam, Map<String, BigDecimal> rateMap, RowMeta resultRowMeta) {
        super(rowMeta, allocParam, rateMap, resultRowMeta);
    }

    @Override
    public RowMeta getResultRowMeta() {
        if (this.allocParam.isWriterpt()) {
            return this.resultRowMeta;
        }
        Field[] resultFields = new Field[]{new Field("stdcostdiffbillids", (DataType)DataType.StringType), new Field("costadjustbillids", (DataType)DataType.StringType), new Field("materialid", (DataType)DataType.LongType)};
        return new RowMeta(resultFields);
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        for (RowX row : arg1) {
            RowX srcRow = this.getRowX(row, Boolean.FALSE);
            this.dealNoUpdateFields(srcRow);
            if (this.allocParam.isWriterpt()) {
                collector.collect(srcRow);
            } else {
                String adjustBillIds = (String)this.getRowValue(srcRow, "adjsutbillid");
                String stdcostdiffBillIds = (String)this.getRowValue(srcRow, "stdcostdiffbillid");
                if (!" ".equals(adjustBillIds)) {
                    Long materialId = (Long)this.getRowValue(srcRow, "material");
                    collector.collect(new RowX(new Object[]{stdcostdiffBillIds, adjustBillIds, materialId}));
                }
            }
            if ("0".equals((String)this.getRowValue(Boolean.FALSE, row, "bizgrouprecordid"))) continue;
            RowX tarRow = this.getRowX(row, Boolean.TRUE);
            this.dealNoUpdateFields(tarRow);
            if (this.allocParam.isWriterpt()) {
                collector.collect(tarRow);
                continue;
            }
            String adjustBillIds = (String)this.getRowValue(tarRow, "adjsutbillid");
            String stdcostdiffBillIds = (String)this.getRowValue(tarRow, "stdcostdiffbillid");
            if (" ".equals(adjustBillIds)) continue;
            Long materialId = (Long)this.getRowValue(tarRow, "material");
            collector.collect(new RowX(new Object[]{stdcostdiffBillIds, adjustBillIds, materialId}));
        }
    }

    private RowX getRowX(RowX row, Boolean isGroup) {
        Object[] values = new Object[this.resultRowMeta.getFieldCount()];
        int index = 0;
        for (String fieldName : this.resultRowMeta.getFieldNames()) {
            if (isGroup.booleanValue() && !"bizgrouprecordid".equals(fieldName)) {
                fieldName = "g" + fieldName;
            }
            values[index++] = row.get(this.rowMeta.getFieldIndex(fieldName));
        }
        return new RowX(values);
    }

    private void dealNoUpdateFields(RowX row) {
        String diffallocDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getAllocDims(), this.allocParam.getEquationSetDims());
        StringBuilder costDomainStr = new StringBuilder();
        String noUpdateCalFields = row.getString(this.rowMeta.getFieldIndex("noupdatecalfields"));
        JSONObject jsonObject = JSON.parseObject((String)noUpdateCalFields);
        JSONArray noupdateFields = null;
        if (jsonObject != null) {
            noupdateFields = jsonObject.getJSONArray("setnull");
        }
        for (String field : diffallocDims.split(",")) {
            if (noupdateFields == null || !noupdateFields.contains((Object)field)) continue;
            row.set(this.resultRowMeta.getFieldIndex(field), this.getDefaultVal(row, field));
        }
    }
}

