/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DealStandCostDiffFunction
extends GroupReduceFunction {
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("stdId", (DataType)DataType.LongType)});
    public RowMeta rowMeta;
    public Map<String, String> billHeadData;
    public String diffAllocDims;
    public Date endDate;
    public Long periodId;
    public Long billType;

    public DealStandCostDiffFunction(RowMeta rowMeta, Date endDate, Long periodId, Map<String, String> billHeadData, String diffAllocDims, Long billType) {
        this.rowMeta = rowMeta;
        this.endDate = endDate;
        this.billHeadData = billHeadData;
        this.diffAllocDims = diffAllocDims;
        this.periodId = periodId;
        this.billType = billType;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DynamicObject stdCostDiffBillObj = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        long[] ids = DBServiceHelper.genLongIds((String)"t_cal_stdcostdiff", (int)1);
        DynamicObjectCollection entryEntity = stdCostDiffBillObj.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryEntity.addNew();
        RowX rowX = null;
        entry.set("seq", (Object)1);
        BigDecimal adjustAmt = BigDecimal.ZERO;
        for (RowX row : rows) {
            if (rowX == null) {
                rowX = row;
            }
            String[] subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            DynamicObject subEntry = subEntryEntity.addNew();
            subEntry.set("costelement", (Object)row.getLong(this.rowMeta.getFieldIndex("costelement")));
            subEntry.set("costsubelement", (Object)row.getLong(this.rowMeta.getFieldIndex("costsubelement")));
            subEntry.set("costelement_id", (Object)row.getLong(this.rowMeta.getFieldIndex("costelement")));
            subEntry.set("costsubelement_id", (Object)row.getLong(this.rowMeta.getFieldIndex("costsubelement")));
            BigDecimal diff = this.getZeroValue(row, "periodstandardcost").add(this.getZeroValue(row, "standardcost")).subtract(this.getZeroValue(row, "sub_adjustamt"));
            subEntry.set("ddiff_t", (Object)diff);
            subEntry.set("sub_adjustamt", (Object)diff);
            adjustAmt = adjustAmt.add(diff);
        }
        if (adjustAmt.abs().compareTo(BigDecimal.ZERO) > 0 && rowX != null) {
            String userId = RequestContext.get().getUserId();
            StringBuilder key = new StringBuilder();
            for (String string : this.diffAllocDims.split(",")) {
                key.append(rowX.getString(this.rowMeta.getFieldIndex(string))).append("@");
            }
            String mapKey = key.substring(0, key.toString().length() - 1);
            String value = this.billHeadData.get(mapKey);
            if (value != null) {
                String[] values = value.split("@");
                stdCostDiffBillObj.set("id", (Object)ids[0]);
                stdCostDiffBillObj.set("billno", (Object)("CBTZ" + ids[0]));
                stdCostDiffBillObj.set("calorg", (Object)Long.valueOf(values[0]));
                stdCostDiffBillObj.set("costaccount", (Object)Long.valueOf(values[1]));
                stdCostDiffBillObj.set("currency", (Object)Long.valueOf(values[2]));
                stdCostDiffBillObj.set("period", (Object)this.periodId);
                stdCostDiffBillObj.set("auditor", (Object)userId);
                stdCostDiffBillObj.set("bookdate", (Object)this.endDate);
                stdCostDiffBillObj.set("bizdate", (Object)this.endDate);
                stdCostDiffBillObj.set("billstatus", (Object)"C");
                stdCostDiffBillObj.set("biztype", (Object)"B");
                stdCostDiffBillObj.set("createtype", (Object)"G");
                stdCostDiffBillObj.set("isupdatecost", (Object)true);
                stdCostDiffBillObj.set("srcsys", (Object)"A");
                stdCostDiffBillObj.set("creator", (Object)userId);
                stdCostDiffBillObj.set("createtime", (Object)new Date());
                stdCostDiffBillObj.set("auditdate", (Object)new Date());
                stdCostDiffBillObj.set("calstatus", (Object)"A");
                stdCostDiffBillObj.set("billtype", (Object)this.billType);
                stdCostDiffBillObj.set("remark", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7531\u6807\u51c6\u6210\u672c\u8c03\u5dee\u751f\u6210", (String)"DealStandCostDiffFunction_3", (String)"fi-calx-algox", (Object[])new Object[0]));
                entry.set("storageorgunit", (Object)Long.valueOf(values[3]));
                entry.set("material", (Object)Long.valueOf(values[4]));
                entry.set("baseunit", (Object)Long.valueOf(values[5]));
                entry.set("ecalstatus", (Object)"A");
                entry.set("adjustamt", (Object)adjustAmt);
                entry.set("diff_t", (Object)adjustAmt);
                entry.set("invtype", (Object)Long.valueOf(values[6]));
                entry.set("ownertype", (Object)"bos_org");
                entry.set("owner", (Object)Long.valueOf(values[8]));
                entry.set("invstatus", (Object)Long.valueOf(values[7]));
                entry.set("calrange", (Object)Long.valueOf(values[9]));
                entry.set("caldimension", (Object)Long.valueOf(values[10]));
                entry.set("accounttype", (Object)"D");
                entry.set("queuetype", (Object)"1");
                entry.set("signnum", (Object)"1");
                entry.set("entrystatus", (Object)"C");
                entry.set("warehouse", (Object)Long.valueOf(values[12]));
                entry.set("location", (Object)Long.valueOf(values[13]));
                entry.set("stocktype", (Object)Long.valueOf(values[14]));
                for (String field : this.diffAllocDims.split(",")) {
                    if (!entry.containsProperty(field)) continue;
                    if (field.equals("lot")) {
                        entry.set(field, (Object)rowX.getString(this.rowMeta.getFieldIndex(field)));
                        continue;
                    }
                    entry.set(field, (Object)rowX.getLong(this.rowMeta.getFieldIndex(field)));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stdCostDiffBillObj});
                RowX rowX2 = new RowX(1);
                rowX2.set(0, (Object)ids[0]);
                collector.collect(rowX2);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    private BigDecimal getZeroValue(RowX row, String field) {
        if (row.getBigDecimal(this.rowMeta.getFieldIndex(field)) == null) {
            return BigDecimal.ZERO;
        }
        return row.getBigDecimal(this.rowMeta.getFieldIndex(field));
    }
}

