/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class DealTransInQtyFunction
extends ReduceGroupFunction {
    protected RowMeta resultRowMeta;

    public DealTransInQtyFunction(RowMeta resultRowMeta) {
        this.resultRowMeta = resultRowMeta;
    }

    public Iterator<Object[]> reduce(Iterator<Row> iterator) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        BigDecimal inTotalQty = BigDecimal.ZERO;
        BigDecimal outQty = BigDecimal.ZERO;
        int rowCount = 0;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            Object[] values = new Object[this.resultRowMeta.getFieldCount()];
            int index = 0;
            for (String field : this.resultRowMeta.getFieldNames()) {
                values[index++] = "baseqty".equals(field) ? row.getBigDecimal("inbaseqty") : row.get(field);
            }
            inTotalQty = inTotalQty.add(row.getBigDecimal("inbaseqty").abs());
            outQty = row.getBigDecimal("outbaseqty");
            ++rowCount;
            dataList.add(values);
        }
        BigDecimal tempInTotalQty = BigDecimal.ZERO;
        int doRowCount = 0;
        for (Object[] values : dataList) {
            int outMatidIndex = this.resultRowMeta.getFieldIndex("outmaterial");
            int inMatidIndex = this.resultRowMeta.getFieldIndex("inmaterial");
            int qtyIndex = this.resultRowMeta.getFieldIndex("baseqty");
            ++doRowCount;
            if (rowCount == 1) {
                if (values[outMatidIndex] == values[inMatidIndex]) continue;
                values[qtyIndex] = outQty;
                continue;
            }
            if (rowCount <= 1) continue;
            BigDecimal inQty = (BigDecimal)values[qtyIndex];
            if (doRowCount == dataList.size()) {
                values[qtyIndex] = outQty.subtract(tempInTotalQty);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(inTotalQty) == 0) continue;
            BigDecimal currInQty = inQty.multiply(outQty).divide(inTotalQty, 10, RoundingMode.HALF_UP);
            values[qtyIndex] = currInQty;
            tempInTotalQty = tempInTotalQty.add(currInQty);
        }
        return dataList.iterator();
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }
}

