/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.helper.CalLogHelper;

public class DiffAllocDebugFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private String logDesc;

    public DiffAllocDebugFunction(RowMeta rowMeta, String logDesc) {
        this.rowMeta = rowMeta;
        this.logDesc = logDesc;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        StringBuilder logStr = this.initLogStr();
        Iterator<RowX> it = iterable.iterator();
        int index = 0;
        while (it.hasNext()) {
            RowX row = it.next();
            for (String field : this.rowMeta.getFieldNames()) {
                logStr.append(row.get(this.rowMeta.getFieldIndex(field))).append("#");
            }
            logStr.append("\r\n");
            if (++index >= 5000) {
                CalLogHelper.printLog(this.logDesc, logStr.toString());
                index = 0;
                logStr.setLength(0);
            }
            collector.collect(row);
        }
        if (index > 0) {
            CalLogHelper.printLog(this.logDesc, logStr.toString());
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private StringBuilder initLogStr() {
        StringBuilder logStr = new StringBuilder();
        for (String field : this.rowMeta.getFieldNames()) {
            logStr.append(field);
            logStr.append("#");
        }
        logStr.append("\r\n");
        return logStr;
    }
}

