/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.function.FilterQueueDataFunction;
import kd.fi.calx.algox.util.CommonUtils;

public class FilterByAllocDimValsFunctionNew
extends FilterQueueDataFunction {
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };
    private RowMeta rowMeta;
    private DiffAllocParamter allocParam;
    protected DiffAllocParamterEntry paramterEntry;

    public FilterByAllocDimValsFunctionNew(RowMeta srcMeta, DiffAllocParamter allocParam, DiffAllocParamterEntry paramterEntry) {
        super(srcMeta);
        this.allocParam = allocParam;
        this.paramterEntry = paramterEntry;
        this.rowMeta = srcMeta;
    }

    public boolean test(RowX rowX) {
        String allocDimValsKeyCol = this.getValuesKeyCol(rowX);
        if (this.paramterEntry.getAllocDimKeyCols() == null || this.paramterEntry.getAllocDimKeyCols().isEmpty()) {
            return Boolean.TRUE;
        }
        return this.paramterEntry.getAllocDimKeyCols().contains(allocDimValsKeyCol);
    }

    private String getValuesKeyCol(RowX rowX) {
        StringBuilder costDomainStr = new StringBuilder();
        String allDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getEquationSetDims(), this.allocParam.getAllocDims());
        String[] dims = allDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (String field : dimsKeys) {
            if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
            costDomainStr.append(this.getRowValue(false, rowX, field));
        }
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }

    protected Object getRowValue(Boolean isGroup, RowX row, String field) {
        String fieldAlias = isGroup != false ? "g" + field : field;
        int index = this.rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }

    private Object getDefaultVal(Boolean isGroup, RowX row, String fieldAlias) {
        fieldAlias = isGroup != false ? "g" + fieldAlias : fieldAlias;
        int index = this.rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

