/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class FilterDataSetFunctionNew
extends FilterFunction {
    private DiffAllocParamter allocParam;
    private DiffAllocParamterEntry paramterEntry;
    private RowMeta rowMeta;
    private String prefix = "";
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };

    public FilterDataSetFunctionNew(RowMeta rowMeta, DiffAllocParamter allocParam, DiffAllocParamterEntry paramterEntry, String prefix) {
        this.rowMeta = rowMeta;
        this.allocParam = allocParam;
        this.paramterEntry = paramterEntry;
        this.prefix = prefix;
    }

    public boolean test(Row row) {
        String allocDimValsKeyCol = this.getValuesKeyCol(row);
        if (this.paramterEntry.getAllocDimKeyCols() == null || this.paramterEntry.getAllocDimKeyCols().isEmpty()) {
            return Boolean.TRUE;
        }
        return this.paramterEntry.getAllocDimKeyCols().contains(allocDimValsKeyCol);
    }

    private String getValuesKeyCol(Row row) {
        StringBuilder costDomainStr = new StringBuilder();
        String allDims = DiffAllocHelper.mergDiffAllocDims(this.allocParam.getEquationSetDims(), this.allocParam.getAllocDims());
        String[] dims = allDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (String field : dimsKeys) {
            if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
            costDomainStr.append(this.getRowValue(row, this.prefix + field));
        }
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }

    protected Object getRowValue(Row row, String field) {
        int index = this.rowMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

