/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.util.CommonUtils;

public class NegativeUnitPriceCreateOutStdBill
extends ReduceGroupFunctionWithCollector {
    private static final Log logger = LogFactory.getLog(NegativeUnitPriceCreateOutStdBill.class);
    public static RowMeta targetRowMeta = new RowMeta(new Field[]{new Field("stdId", (DataType)DataType.LongType)});
    private static String[] entryDiffField = new String[]{"diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y"};
    String diffAllocDims;
    Set<String> keyCols;
    Map<String, String> stdHeadData;
    Date endDate;
    Long periodId;
    Long billType;
    int precision;

    public NegativeUnitPriceCreateOutStdBill(int precision, Map<String, String> stdHeadData, String diffAllocDims, Set<String> keyCols, Date endDate, Long periodId, Long billType) {
        this.precision = precision;
        this.stdHeadData = stdHeadData;
        this.diffAllocDims = diffAllocDims;
        this.keyCols = keyCols;
        this.endDate = endDate;
        this.periodId = periodId;
        this.billType = billType;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        DynamicObject stdCostDiffBillObj = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        long[] ids = DBServiceHelper.genLongIds((String)"t_cal_stdcostdiff", (int)1);
        DynamicObjectCollection entryEntity = stdCostDiffBillObj.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryEntity.addNew();
        entry.set("seq", (Object)1);
        BigDecimal totalDiff = BigDecimal.ZERO;
        Row row = null;
        String userId = RequestContext.get().getUserId();
        while (iterator.hasNext()) {
            BigDecimal subTotalDiff = BigDecimal.ZERO;
            String[] subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            DynamicObject subEntry = subEntryEntity.addNew();
            Row nextRow = iterator.next();
            if (row == null) {
                row = nextRow;
            }
            BigDecimal bigDecimal = this.getZeroValue(nextRow, "balqty");
            BigDecimal qty = this.getZeroValue(nextRow, "qty");
            BigDecimal outQty = this.getZeroValue(nextRow, "outqty");
            DiffAllocHelper.writeLog(logger, ResManager.loadKDString((String)"\u8fdb\u5165\u8d1f\u5355\u4ef7\u51fa\u5e93\u65b9\u5411\u8c03\u5dee\u5904\u7406,\u671f\u521d\u6570\u91cf==>{},\u672c\u671f\u6536\u5165\u6570\u91cf==>{},\u672c\u671f\u53d1\u51fa\u6570\u91cf==>{},\u5b50\u8981\u7d20==>{},\u7269\u6599==>{}", (String)"NegativeUnitPriceCreateOutStdBill_0", (String)"fi-calx-algox", (Object[])new Object[0]), bigDecimal, qty, outQty, nextRow.getLong("costsubelement"), nextRow.getLong("material"));
            for (String field : entryDiffField) {
                BigDecimal balDiff = this.getZeroValue(nextRow, field + "_bal");
                BigDecimal inDiff = this.getZeroValue(nextRow, "d" + field);
                BigDecimal outDiff = this.getZeroValue(nextRow, "out" + field);
                BigDecimal rate = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : inDiff.divide(qty, 10, RoundingMode.HALF_UP);
                BigDecimal adjustDiff = balDiff.add(inDiff).subtract(outDiff).subtract(rate.multiply(bigDecimal.add(qty).subtract(outQty)));
                adjustDiff = adjustDiff.setScale(this.precision, RoundingMode.HALF_UP);
                subEntry.set("costelement", (Object)nextRow.getLong("costelement"));
                subEntry.set("costsubelement", (Object)nextRow.getLong("costsubelement"));
                subEntry.set("costelement_id", (Object)nextRow.getLong("costelement"));
                subEntry.set("costsubelement_id", (Object)nextRow.getLong("costsubelement"));
                subEntry.set("d" + field, (Object)adjustDiff);
                totalDiff = totalDiff.add(adjustDiff);
                subTotalDiff = subTotalDiff.add(adjustDiff);
                entry.set(field, (Object)entry.getBigDecimal(field).add(adjustDiff));
            }
            subEntry.set("sub_adjustamt", (Object)subTotalDiff);
        }
        if (row != null && totalDiff.abs().compareTo(BigDecimal.ZERO) > 0) {
            StringBuilder key = new StringBuilder();
            for (String string : this.diffAllocDims.split(",")) {
                key.append(row.getString(string)).append("@");
            }
            String mapKey = key.substring(0, key.toString().length() - 1);
            String value = this.stdHeadData.get(mapKey);
            if (value != null) {
                String[] values = value.split("@");
                stdCostDiffBillObj.set("id", (Object)ids[0]);
                stdCostDiffBillObj.set("billno", (Object)("CBTZ" + ids[0]));
                stdCostDiffBillObj.set("calorg", (Object)Long.valueOf(values[0]));
                stdCostDiffBillObj.set("costaccount", (Object)Long.valueOf(values[1]));
                stdCostDiffBillObj.set("currency", (Object)Long.valueOf(values[2]));
                stdCostDiffBillObj.set("period", (Object)this.periodId);
                stdCostDiffBillObj.set("auditor", (Object)userId);
                stdCostDiffBillObj.set("bookdate", (Object)this.endDate);
                stdCostDiffBillObj.set("bizdate", (Object)this.endDate);
                stdCostDiffBillObj.set("billstatus", (Object)"C");
                stdCostDiffBillObj.set("biztype", (Object)"B");
                stdCostDiffBillObj.set("createtype", (Object)"W");
                stdCostDiffBillObj.set("isupdatecost", (Object)true);
                stdCostDiffBillObj.set("srcsys", (Object)"A");
                stdCostDiffBillObj.set("creator", (Object)userId);
                stdCostDiffBillObj.set("createtime", (Object)TimeServiceHelper.now());
                stdCostDiffBillObj.set("auditdate", (Object)TimeServiceHelper.now());
                stdCostDiffBillObj.set("calstatus", (Object)"A");
                stdCostDiffBillObj.set("billtype", (Object)this.billType);
                stdCostDiffBillObj.set("remark", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7531\u8d1f\u5355\u4ef7\u8c03\u6574\u751f\u6210\u3002", (String)"DealStdBillCreateFunction_2", (String)"fi-calx-algox", (Object[])new Object[0]));
                entry.set("storageorgunit", (Object)Long.valueOf(values[3]));
                entry.set("material", (Object)Long.valueOf(values[4]));
                entry.set("baseunit", (Object)Long.valueOf(values[5]));
                entry.set("ecalstatus", (Object)"A");
                entry.set("adjustamt", (Object)totalDiff);
                entry.set("invtype", (Object)Long.valueOf(values[6]));
                entry.set("ownertype", (Object)"bos_org");
                entry.set("owner", (Object)Long.valueOf(values[8]));
                entry.set("invstatus", (Object)Long.valueOf(values[7]));
                entry.set("calrange", (Object)Long.valueOf(values[9]));
                entry.set("caldimension", (Object)Long.valueOf(values[10]));
                entry.set("accounttype", (Object)"D");
                entry.set("queuetype", (Object)"1");
                entry.set("signnum", (Object)"1");
                entry.set("entrystatus", (Object)"C");
                entry.set("warehouse", (Object)Long.valueOf(values[12]));
                entry.set("location", (Object)Long.valueOf(values[13]));
                entry.set("stocktype", (Object)Long.valueOf(values[14]));
                for (String field : this.diffAllocDims.split(",")) {
                    if (!entry.containsProperty(field)) continue;
                    if (field.equals("lot")) {
                        entry.set(field, (Object)row.getString(field));
                        continue;
                    }
                    entry.set(field, (Object)row.getLong(field));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stdCostDiffBillObj});
                this.keyCols.add(this.getValuesKeyCol(row));
                RowX rowX = new RowX(1);
                rowX.set(0, (Object)ids[0]);
                collector.collect(rowX.values());
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return targetRowMeta;
    }

    private BigDecimal getZeroValue(Row row, String field) {
        if (row.getBigDecimal(field) == null) {
            return BigDecimal.ZERO;
        }
        return row.getBigDecimal(field);
    }

    private String getValuesKeyCol(Row row) {
        HashSet calSysDefaultDims = Sets.newHashSet((Object[])new String[]{"configuredcode", "assist", "tracknumber", "project", "lot", "costaccount", "material", "calorg"});
        StringBuilder costDomainStr = new StringBuilder();
        String[] dims = this.diffAllocDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (String field : dimsKeys) {
            if (!calSysDefaultDims.contains(field)) continue;
            costDomainStr.append(row.get(field));
        }
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }
}

