/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.function.DealBaseFunction;

public class UpdateTotalTailDiffFunction
extends DealBaseFunction {
    protected static Log log = LogFactory.getLog(UpdateTotalTailDiffFunction.class);
    private static final String UPDATE_STDDIFFENTRY = "update t_cal_stdcostdiffentry set fadjustamt=? , fdiff_g = ?, fdiff_h = ?, fdiff_k = ?, fdiff_m = ?, fdiff_p = ?, fdiff_q = ?, fdiff_r = ?, fdiff_s = ?, fdiff_t = ?, fdiff_c = ?, fdiff_w = ?, fdiff_x = ?, fdiff_y = ?, fsubentryentity = ? where fentryid = ?";
    private static final int BATCH_SIZE = 1000;

    public UpdateTotalTailDiffFunction(RowMeta rowMeta, DiffAllocParamter allocParam, RowMeta resultRowMeta) {
        super(rowMeta, allocParam, null, resultRowMeta);
    }

    @Override
    public RowMeta getResultRowMeta() {
        Field[] resultFields = new Field[]{new Field("stdcostdiffbillids", (DataType)DataType.StringType), new Field("costadjustbillids", (DataType)DataType.StringType), new Field("materialid", (DataType)DataType.LongType)};
        return new RowMeta(resultFields);
    }

    @Override
    public void reduce(Iterable<RowX> arg1, Collector collector) {
        Iterator<RowX> it = arg1.iterator();
        ArrayList<Object[]> updateParamslist = new ArrayList<Object[]>();
        HashSet<Long> costAccountIds = new HashSet<Long>();
        Date startDate = null;
        Date endDate = null;
        while (it.hasNext()) {
            RowX row = it.next();
            Long entryid = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            costAccountIds.add(row.getLong(this.rowMeta.getFieldIndex("costaccountid")));
            Date bookdate = row.getDate(this.rowMeta.getFieldIndex("bookdate"));
            if (startDate == null || startDate.after(bookdate)) {
                startDate = bookdate;
            }
            if (endDate == null || endDate.before(bookdate)) {
                endDate = bookdate;
            }
            Object[] recordUpdateparams = new Object[]{row.getBigDecimal(17), row.getBigDecimal(4), row.getBigDecimal(5), row.getBigDecimal(6), row.getBigDecimal(7), row.getBigDecimal(8), row.getBigDecimal(9), row.getBigDecimal(10), row.getBigDecimal(11), row.getBigDecimal(12), row.getBigDecimal(13), row.getBigDecimal(14), row.getBigDecimal(15), row.getBigDecimal(16), row.getString(18), entryid};
            updateParamslist.add(recordUpdateparams);
        }
        Date newStDate = startDate;
        Date newEdDate = endDate;
        DBRoute route = new DBRoute("cal");
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_stdcostdiff", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccount", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)newEdDate)});){
            ctx.set();
            Lists.partition(updateParamslist, (int)1000).forEach(list1 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_STDDIFFENTRY, (List)list1);
                    }
                    catch (Throwable e) {
                        log.error("UpdateTotalTailDiffFunction->recordUpdate_list Throwable erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################UpdateTotalTailDiffFunction\u2014>\u66f4\u65b0stdcosDiffEntry\u5206\u5f55\uff1a" + list1.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
                log.info("#################UpdateTotalTailDiffFunction\u2014>\u66f4\u65b0stdcosDiffEntry\u5206\u5f55\u5f53\u524d\u6279\u6b21\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
    }
}

