/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.helper.BatchExcuteHelper;

public class AllocRptHelper {
    private static final Log logger = LogFactory.getLog(AllocRptHelper.class);

    public static void genAllocRpt(Map<Long, Map<String, Object>> diffSrcInfos, Map<String, Map<String, Object>> diffBillResultInfos, Map<String, BigDecimal> diffAllocTotalAmt, Map<Long, BigDecimal> billTypeTotalQty, DiffAllocParamter allocParam) {
        HashMap<String, DynamicObject> allocRptMap = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> allocRptList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, Map<String, Object>> diffBillResultInfo : diffBillResultInfos.entrySet()) {
            Long sourDiffId = Long.valueOf(diffBillResultInfo.getValue().get("sourDiffId").toString());
            Map<String, Object> diffBillResultInfoVals = diffBillResultInfo.getValue();
            String storageId = diffBillResultInfoVals.get("storageorgunit").toString();
            String calrange = diffBillResultInfoVals.get("calrange").toString();
            String diffType = diffSrcInfos.get(sourDiffId).get("difftype").toString();
            String totalAmtKey = diffType + "@" + calrange + "@" + storageId + "@" + sourDiffId.toString();
            String rptKey = AllocRptHelper.getRptKey(diffSrcInfos.get(sourDiffId));
            if (allocRptMap.containsKey(rptKey)) {
                AllocRptHelper.updateRptInfo((DynamicObject)allocRptMap.get(rptKey), diffSrcInfos.get(sourDiffId), diffBillResultInfo.getValue(), diffAllocTotalAmt.get(totalAmtKey), allocParam);
                continue;
            }
            DynamicObject rptInfo = AllocRptHelper.newRptInfo(diffSrcInfos.get(sourDiffId), diffBillResultInfo.getValue(), allocRptMap, diffAllocTotalAmt.get(totalAmtKey), allocParam);
            allocRptMap.put(rptKey, rptInfo);
            allocRptList.add(rptInfo);
        }
        logger.info("--------------AllocRptHelper.genAllocRpt->save allocRptList size:" + allocRptList.size());
        BatchExcuteHelper.batchOperationexecuteOperate("save", "calx_diffallocrpt", allocRptList.toArray(new DynamicObject[0]), null, 500, 3);
    }

    private static String getRptKey(Map<String, Object> diffSrcInfo) {
        StringBuilder rptKey = new StringBuilder();
        rptKey.append(diffSrcInfo.get("costaccountid")).append("@");
        rptKey.append(diffSrcInfo.get("calorg")).append("@");
        rptKey.append(diffSrcInfo.get("calrangeid")).append("@");
        rptKey.append(diffSrcInfo.get("materialid")).append("@");
        rptKey.append(diffSrcInfo.get("lot")).append("@");
        rptKey.append(diffSrcInfo.get("assist")).append("@");
        rptKey.append(diffSrcInfo.get("storageorgunit")).append("@");
        rptKey.append(diffSrcInfo.get("warehouse")).append("@");
        rptKey.append(diffSrcInfo.get("location")).append("@");
        return rptKey.toString();
    }

    private static DynamicObject newRptInfo(Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo, Map<String, DynamicObject> allocRptMap, BigDecimal diffAllocTotalAmt, DiffAllocParamter allocParam) {
        DynamicObject allocRptBill = BusinessDataServiceHelper.newDynamicObject((String)"calx_diffallocrpt");
        allocRptBill.set("alloctime", (Object)allocParam.getStartTime());
        allocRptBill.set("creator", (Object)allocParam.getAlloctor());
        allocRptBill.set("costaccount", diffSrcInfo.get("costaccountid"));
        allocRptBill.set("calorg", diffSrcInfo.get("calorg"));
        allocRptBill.set("period", diffSrcInfo.get("periodid"));
        allocRptBill.set("calrange", diffSrcInfo.get("calrangeid"));
        allocRptBill.set("material", diffSrcInfo.get("materialid"));
        allocRptBill.set("lot", diffSrcInfo.get("lot"));
        allocRptBill.set("warehouse", diffSrcInfo.get("warehouse"));
        allocRptBill.set("location", diffSrcInfo.get("location"));
        allocRptBill.set("storageorgunit", diffSrcInfo.get("storageorgunit"));
        allocRptBill.set("dividebasisvalue", diffSrcInfo.get("dividebasisval"));
        allocRptBill.set("caldimension", diffSrcInfo.get("caldimensionid"));
        allocRptBill.set("caldimensionvalue", diffSrcInfo.get("caldimensionval"));
        allocRptBill.set("accounttype", diffSrcInfo.get("accounttype"));
        allocRptBill.set("allocmodel", diffSrcInfo.get("allocmodel"));
        allocRptBill.set("carryrule", diffSrcInfo.get("carryrule"));
        allocRptBill.set("billstatus", (Object)"A");
        allocRptBill.set("allocrecordid", (Object)allocParam.getAllocRecordId());
        AllocRptHelper.addDefualtEntry(allocRptBill, diffSrcInfo, diffBillResultInfo, diffAllocTotalAmt);
        AllocRptHelper.addAllocRptEntry(allocRptBill, diffSrcInfo, diffBillResultInfo, allocParam);
        return allocRptBill;
    }

    private static void addAllocRptEntry(DynamicObject allocRptBill, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo, DiffAllocParamter allocParam) {
        DynamicObjectCollection entrys = allocRptBill.getDynamicObjectCollection("entryentity");
        int seq = entrys.getRowCount() + AllocRptHelper.getRptEntrySeq(diffSrcInfo.get("difftype").toString(), diffSrcInfo.get("subelementid"));
        DynamicObject newEntry = entrys.addNew();
        newEntry.set("createtype", diffSrcInfo.get("difftype"));
        newEntry.set("seq", (Object)(++seq));
        newEntry.set("billtypestr", diffBillResultInfo.get("outbilltypename"));
        newEntry.set("billtypeid", diffBillResultInfo.get("outbilltypeid"));
        newEntry.set("subelement", diffSrcInfo.get("subelementid"));
        newEntry.set("element", diffSrcInfo.get("elementid"));
        newEntry.set("outamt", (Object)new BigDecimal(diffBillResultInfo.get("allocedAmt").toString()));
        newEntry.set("outbillqty", (Object)new BigDecimal(diffBillResultInfo.get(AllocRptHelper.getCarryField(allocParam)).toString()));
        String outStr = ResManager.loadKDString((String)"\u6210\u672c\uff1a%1$s = %2$s*%3$s", (String)"AllocRptHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]);
        newEntry.set("outstr", (Object)String.format(outStr, diffBillResultInfo.get("allocedAmt"), diffSrcInfo.get("diffRate"), diffBillResultInfo.get(AllocRptHelper.getCarryField(allocParam))));
        if ("A".equals(allocParam.getAllocModel())) {
            AllocRptHelper.addRptDetail(newEntry, diffSrcInfo, diffBillResultInfo);
        }
    }

    private static void addDefualtEntry(DynamicObject allocRptBill, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo, BigDecimal diffAllocTotalAmt) {
        DynamicObjectCollection entrys = allocRptBill.getDynamicObjectCollection("entryentity");
        int seq = entrys.getRowCount() + AllocRptHelper.getRptEntrySeq(diffSrcInfo.get("difftype").toString(), diffSrcInfo.get("subelementid"));
        DynamicObject diffRateEntry = entrys.addNew();
        diffRateEntry.set("createtype", diffSrcInfo.get("difftype"));
        int n = ++seq;
        diffRateEntry.set("seq", (Object)n);
        diffRateEntry.set("billtypestr", (Object)ResManager.loadKDString((String)"\u672c\u671f\u6210\u672c\u5dee\u5f02\u7387", (String)"AllocRptHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]));
        diffRateEntry.set("element", diffSrcInfo.get("elementid"));
        diffRateEntry.set("subelement", diffSrcInfo.get("subelementid"));
        diffRateEntry.set("outamt", (Object)BigDecimal.ZERO);
        diffRateEntry.set("outbillqty", (Object)BigDecimal.ZERO);
        diffRateEntry.set("outamt", (Object)0.0);
        diffRateEntry.set("outbillqty", (Object)0.0);
        String outStr = ResManager.loadKDString((String)"\u6210\u672c\u5dee\u5f02\u7387\uff1a%1$s", (String)"AllocRptHelper_3", (String)"fi-calx-algox", (Object[])new Object[0]);
        diffRateEntry.set("outstr", (Object)String.format(outStr, diffSrcInfo.get("diffRate")));
        DynamicObject prePeriodEntry = entrys.addNew();
        prePeriodEntry.set("createtype", diffSrcInfo.get("difftype"));
        int n2 = ++seq;
        prePeriodEntry.set("seq", (Object)n2);
        prePeriodEntry.set("billtypestr", (Object)ResManager.loadKDString((String)"\u671f\u521d\u5dee\u5f02", (String)"AllocRptHelper_4", (String)"fi-calx-algox", (Object[])new Object[0]));
        prePeriodEntry.set("element", diffSrcInfo.get("elementid"));
        prePeriodEntry.set("subelement", diffSrcInfo.get("subelementid"));
        String prePeriodInStr = ResManager.loadKDString((String)"\u6210\u672c\uff1a%1$s", (String)"AllocRptHelper_5", (String)"fi-calx-algox", (Object[])new Object[0]);
        prePeriodEntry.set("instr", (Object)String.format(prePeriodInStr, diffSrcInfo.get("begindiffamt")));
        prePeriodEntry.set("outamt", (Object)BigDecimal.ZERO);
        prePeriodEntry.set("outbillqty", (Object)BigDecimal.ZERO);
        DynamicObject currPeriodEntry = entrys.addNew();
        currPeriodEntry.set("createtype", diffSrcInfo.get("difftype"));
        int n3 = ++seq;
        ++seq;
        currPeriodEntry.set("seq", (Object)n3);
        currPeriodEntry.set("billtypestr", (Object)ResManager.loadKDString((String)"\u672c\u671f\u8f6c\u5165\u5dee\u5f02", (String)"AllocRptHelper_6", (String)"fi-calx-algox", (Object[])new Object[0]));
        currPeriodEntry.set("element", diffSrcInfo.get("elementid"));
        currPeriodEntry.set("subelement", diffSrcInfo.get("subelementid"));
        String currPeriodInStr = ResManager.loadKDString((String)"\u6210\u672c\uff1a%1$s", (String)"AllocRptHelper_7", (String)"fi-calx-algox", (Object[])new Object[0]);
        currPeriodEntry.set("instr", (Object)String.format(currPeriodInStr, diffSrcInfo.get("diffamt")));
        currPeriodEntry.set("outamt", (Object)BigDecimal.ZERO);
        currPeriodEntry.set("outbillqty", (Object)BigDecimal.ZERO);
        DynamicObject balanceEntry = entrys.addNew();
        balanceEntry.set("createtype", diffSrcInfo.get("difftype"));
        balanceEntry.set("seq", (Object)(seq + 99));
        balanceEntry.set("billtypestr", (Object)ResManager.loadKDString((String)"\u671f\u672b\u5dee\u5f02", (String)"AllocRptHelper_8", (String)"fi-calx-algox", (Object[])new Object[0]));
        balanceEntry.set("element", diffSrcInfo.get("elementid"));
        balanceEntry.set("subelement", diffSrcInfo.get("subelementid"));
        String balanceStr = ResManager.loadKDString((String)"\u6210\u672c\uff1a%1$s", (String)"AllocRptHelper_9", (String)"fi-calx-algox", (Object[])new Object[0]);
        balanceEntry.set("balancestr", (Object)String.format(balanceStr, ((BigDecimal)diffSrcInfo.get("totaldiffamt")).subtract(diffAllocTotalAmt == null ? BigDecimal.ZERO : diffAllocTotalAmt)));
        balanceEntry.set("outamt", (Object)BigDecimal.ZERO);
        balanceEntry.set("outbillqty", (Object)BigDecimal.ZERO);
    }

    private static void addRptDetail(DynamicObject adjBillEntry, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo) {
        DynamicObjectCollection detailEntrys = adjBillEntry.getDynamicObjectCollection("subentryentity");
        DynamicObject detailEntry = detailEntrys.addNew();
        String dtoutstr = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u5206\u644a\u5dee\u5f02\uff1a%2$s = %3$s*%4$s", (String)"AllocRptHelper_10", (String)"fi-calx-algox", (Object[])new Object[0]);
        detailEntry.set("dtoutstr", (Object)String.format(dtoutstr, diffBillResultInfo.get("outbillno"), diffBillResultInfo.get("allocedAmt"), diffSrcInfo.get("diffRate"), diffBillResultInfo.get("billqty")));
        detailEntry.set("costadjbillno", diffBillResultInfo.get("costadjbillno"));
        detailEntry.set("dtoutbillqty", (Object)BigDecimal.ZERO);
    }

    private static DynamicObject getExistRptEntry(DynamicObjectCollection entrys, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo) {
        if (entrys.isEmpty()) {
            return null;
        }
        String outBillTypeId = diffBillResultInfo.get("outbilltypeid").toString();
        String diffType = diffSrcInfo.get("difftype").toString();
        String subelementId = diffSrcInfo.get("subelementid").toString();
        for (DynamicObject entry : entrys) {
            if (!entry.getString("billtypeid").equals(outBillTypeId) || !entry.getString("createtype").equals(diffType) || !entry.getString("subelement").equals(subelementId)) continue;
            return entry;
        }
        return null;
    }

    private static DynamicObject getExistRptDefaultEntry(DynamicObjectCollection entrys, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo) {
        if (entrys.isEmpty()) {
            return null;
        }
        String diffType = diffSrcInfo.get("difftype").toString();
        String subelementid = diffSrcInfo.get("subelementid").toString();
        for (DynamicObject entry : entrys) {
            if (!ResManager.loadKDString((String)"\u671f\u521d\u5dee\u5f02", (String)"AllocRptHelper_11", (String)"fi-calx-algox", (Object[])new Object[0]).equals(entry.getString("billtypestr")) || !entry.getString("createtype").equals(diffType) || !entry.getString("subelement").equals(subelementid)) continue;
            return entry;
        }
        return null;
    }

    private static void updateRptInfo(DynamicObject allocRptInfo, Map<String, Object> diffSrcInfo, Map<String, Object> diffBillResultInfo, BigDecimal diffAllocTotalAmt, DiffAllocParamter allocParam) {
        DynamicObject currEntry;
        DynamicObjectCollection entrys = allocRptInfo.getDynamicObjectCollection("entryentity");
        DynamicObject defaultEntry = AllocRptHelper.getExistRptDefaultEntry(entrys, diffSrcInfo, diffBillResultInfo);
        if (defaultEntry == null) {
            AllocRptHelper.addDefualtEntry(allocRptInfo, diffSrcInfo, diffBillResultInfo, diffAllocTotalAmt);
        }
        if ((currEntry = AllocRptHelper.getExistRptEntry(entrys, diffSrcInfo, diffBillResultInfo)) == null) {
            AllocRptHelper.addAllocRptEntry(allocRptInfo, diffSrcInfo, diffBillResultInfo, allocParam);
        } else {
            BigDecimal outamt = currEntry.getBigDecimal("outamt");
            BigDecimal currAllocedAmt = (BigDecimal)diffBillResultInfo.get("allocedAmt");
            currEntry.set("outamt", (Object)outamt.add(currAllocedAmt));
            BigDecimal outBillQty = currEntry.getBigDecimal("outbillqty");
            BigDecimal currBillQty = (BigDecimal)diffBillResultInfo.get(AllocRptHelper.getCarryField(allocParam));
            currEntry.set("outbillqty", (Object)outBillQty.add(currBillQty));
            String outStr = ResManager.loadKDString((String)"\u6210\u672c\uff1a%1$s = %2$s*%3$s", (String)"AllocRptHelper_12", (String)"fi-calx-algox", (Object[])new Object[0]);
            currEntry.set("outstr", (Object)String.format(outStr, outamt.add(currAllocedAmt), diffSrcInfo.get("diffRate"), outBillQty.add(currBillQty)));
            AllocRptHelper.addRptDetail(currEntry, diffSrcInfo, diffBillResultInfo);
        }
    }

    public static String getCarryField(DiffAllocParamter param) {
        return "A".equals(param.getCarryRule()) ? "baseqty" : "standardcost";
    }

    private static int getRptEntrySeq(String createType, Object subelementid) {
        char[] createTypes = createType.toCharArray();
        int seq = 0;
        for (int index = 0; index < createTypes.length; ++index) {
            char createTypeChar = createTypes[index];
            seq += createTypeChar;
        }
        return seq * 100000 + Integer.parseInt(subelementid.toString().substring(13));
    }
}

