/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

public class BalCheckHelper {
    private static final Log logger = LogFactory.getLog(BalCheckHelper.class);

    public static void checkCalBalAndStdBalIsSame(DiffAllocParamter param, DiffAllocParamterEntry paramEntry) {
        Boolean balCheck = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CHECK_CALBAL_STABAL);
        if (balCheck.booleanValue()) {
            String diffAllocDims = DiffAllocHelper.mergDiffAllocDims(param.getAllocDims(), param.getEquationSetDims());
            List<Integer> historyPeriodNumbers = PeriodHelper.getHistoryPeriodNumbers(paramEntry.getCostAccountId(), paramEntry.getPeriodId(), "<");
            DataSet balDataSet = BalCheckHelper.getBalPeriodData(diffAllocDims, historyPeriodNumbers, paramEntry);
            DataSet stdBalDataSet = BalCheckHelper.getStdBalPeriodData(diffAllocDims, historyPeriodNumbers, paramEntry);
            if (balDataSet != null && stdBalDataSet != null) {
                DataSet dataSet = balDataSet.union(stdBalDataSet);
                dataSet = dataSet.groupBy(diffAllocDims.split(",")).sum("stddiffbal").sum("diffbal").finish();
                if (!(dataSet = dataSet.filter("stddiffbal<>diffbal")).isEmpty()) {
                    HashSet<Long> materials = new HashSet<Long>(16);
                    for (Row row : dataSet) {
                        if (materials.size() > 50) break;
                        materials.add(row.getLong("material"));
                    }
                    DataSet materialDs = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.helper.BalCheckHelper.checkCalBalAndStdBalIsSame", (String)"bd_material", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", materials)}, null);
                    StringJoiner stringJoiner = new StringJoiner(",", "", ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u7684\u671f\u521d\u6838\u7b97\u4f59\u989d\u4e0e\u5dee\u5f02\u4f59\u989d\u4e0d\u4e00\u81f4", (String)"BalCheckHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
                    for (Row row : materialDs) {
                        stringJoiner.add(row.getString("number"));
                    }
                    throw new KDBizException(stringJoiner.toString());
                }
            }
        }
    }

    private static DataSet getBalPeriodData(String diffAllocDims, List<Integer> historyPeriodNumbers, DiffAllocParamterEntry paramEntry) {
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",0.00 as stddiffbal,costdiff_bal as diffbal";
        DataSet dataSet = null;
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)paramEntry.getPeriod());
            filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
            filter.and("accounttype", "=", (Object)"D");
            if (paramEntry.getMatIdSet() != null && !paramEntry.getMatIdSet().isEmpty()) {
                filter.and("material", "in", paramEntry.getMatIdSet());
            }
            if (dataSet == null) {
                dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.helper.BalCheckHelper.getBalPeriodData", (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
                continue;
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.helper.BalCheckHelper.getBalPeriodData", (String)"cal_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
            dataSet = dataSet.union(result);
        }
        if (dataSet != null) {
            return dataSet.groupBy(diffAllocDims.split(",")).sum("stddiffbal").sum("diffbal").finish();
        }
        return null;
    }

    private static DataSet getStdBalPeriodData(String diffAllocDims, List<Integer> historyPeriodNumbers, DiffAllocParamterEntry paramEntry) {
        int periodBatchSize = CalDbParamServiceHelper.getInteger("period_batch_size");
        String dySelectStr = ExFieldHelper.getSelectFieldsStr("cal_standcost_bal", diffAllocDims, "");
        String selectStr = dySelectStr + ",costdiff_bal as stddiffbal,0.00 as diffbal";
        DataSet dataSet = null;
        for (List periods : Lists.partition(historyPeriodNumbers, (int)periodBatchSize)) {
            QFilter filter = new QFilter("period", "in", (Object)periods);
            filter.and("endperiod", ">=", (Object)paramEntry.getPeriod());
            filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
            if (paramEntry.getMatIdSet() != null && !paramEntry.getMatIdSet().isEmpty()) {
                filter.and("material", "in", paramEntry.getMatIdSet());
            }
            if (dataSet == null) {
                dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.helper.BalCheckHelper.getStdBalPeriodData", (String)"cal_standcost_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
                continue;
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"kd.fi.calx.algox.diff.helper.BalCheckHelper.getStdBalPeriodData", (String)"cal_standcost_bal", (String)selectStr, (QFilter[])filter.toArray(), (String)null);
            dataSet = dataSet.union(result);
        }
        if (dataSet != null) {
            return dataSet.groupBy(diffAllocDims.split(",")).sum("stddiffbal").sum("diffbal").finish();
        }
        return null;
    }
}

