/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.function.DealAlgoNoUpdateCalFields;
import kd.fi.calx.algox.diff.function.FilterDataSetFunctionNew;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.PeriodHelper;

public class DiffAllocDeleteHelper {
    public static void deleteStdBill(Long costAccountId, Long periodId, Set<Long> materials, Set<String> allocDimKeyCols, String equationSetDims, String diffAllocDims, Object startDate) {
        QFilter delFilter;
        Date[] periodStartAndEndTime = PeriodHelper.getPeriodStartAndEndTime(periodId);
        if (periodStartAndEndTime == null) {
            return;
        }
        String allDims = DiffAllocHelper.mergDiffAllocDims(equationSetDims, diffAllocDims);
        String dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_stdcostdiffbill", allDims, "");
        dySelectFields = dySelectFields + ",entryentity.noupdatecalfields noupdatecalfields,id,billstatus,'stdbill' as billytpe";
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bookdate", ">=", (Object)periodStartAndEndTime[0]);
        filter.and("bookdate", "<=", (Object)periodStartAndEndTime[1]);
        filter.and("entryentity.material", "in", materials);
        filter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "G", "Y", "Z"}));
        filter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        filter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        if (startDate != null) {
            filter.and("createtime", ">", startDate);
        }
        DataSet stdDataSet = QueryServiceHelper.queryDataSet((String)"DiffAllocDeleteHelper.deleteStdBill", (String)"cal_stdcostdiffbill", (String)dySelectFields, (QFilter[])new QFilter[]{filter}, null);
        dySelectFields = ExFieldHelper.getSelectFieldsStr("cal_costadjustbill", allDims, "");
        dySelectFields = dySelectFields + ",entryentity.noupdatecalfields noupdatecalfields,id,billstatus,'adjustbill' as billytpe";
        DataSet adjustDataSet = QueryServiceHelper.queryDataSet((String)"DiffAllocDeleteHelper.deleteStdBill", (String)"cal_costadjustbill", (String)dySelectFields, (QFilter[])new QFilter[]{filter}, null);
        DataSet dataSet = stdDataSet.union(adjustDataSet);
        dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()));
        DiffAllocParamter param = new DiffAllocParamter();
        param.setEquationSetDims(equationSetDims);
        param.setAllocDims(diffAllocDims);
        DiffAllocParamterEntry entry = new DiffAllocParamterEntry();
        entry.setAllocDimKeyCols(allocDimKeyCols);
        dataSet = dataSet.filter((FilterFunction)new FilterDataSetFunctionNew(dataSet.getRowMeta(), param, entry, ""));
        ArrayList<Long> stdAuditBillIds = new ArrayList<Long>(1000);
        ArrayList<Long> stdSubmitBillIds = new ArrayList<Long>(1000);
        ArrayList<Long> stdDeleteBillIds = new ArrayList<Long>(1000);
        ArrayList<Long> adjAuditBillIds = new ArrayList<Long>(1000);
        ArrayList<Long> adjSubmitBillIds = new ArrayList<Long>(1000);
        ArrayList<Long> adjDeleteBillIds = new ArrayList<Long>(1000);
        for (Row row : dataSet) {
            if ("stdbill".equals(row.getString("billytpe"))) {
                if ("C".equals(row.getString("billstatus"))) {
                    stdAuditBillIds.add(row.getLong("id"));
                    continue;
                }
                if ("B".equals(row.getString("billstatus"))) {
                    stdSubmitBillIds.add(row.getLong("id"));
                    continue;
                }
                stdDeleteBillIds.add(row.getLong("id"));
                continue;
            }
            if ("C".equals(row.getString("billstatus"))) {
                adjAuditBillIds.add(row.getLong("id"));
                continue;
            }
            if ("B".equals(row.getString("billstatus"))) {
                adjSubmitBillIds.add(row.getLong("id"));
                continue;
            }
            adjDeleteBillIds.add(row.getLong("id"));
        }
        DiffAllocDeleteHelper.operateBill("unaudit", "cal_stdcostdiffbill", stdAuditBillIds);
        stdDeleteBillIds.addAll(stdAuditBillIds);
        DiffAllocDeleteHelper.operateBill("unsubmit", "cal_stdcostdiffbill", adjSubmitBillIds);
        stdDeleteBillIds.addAll(stdSubmitBillIds);
        for (List list : Lists.partition(stdDeleteBillIds, (int)5000)) {
            delFilter = new QFilter("id", "in", (Object)list);
            DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])delFilter.toArray());
        }
        DiffAllocDeleteHelper.operateBill("unaudit", "cal_costadjustbill", adjAuditBillIds);
        adjDeleteBillIds.addAll(adjAuditBillIds);
        DiffAllocDeleteHelper.operateBill("unsubmit", "cal_costadjustbill", adjSubmitBillIds);
        adjDeleteBillIds.addAll(adjSubmitBillIds);
        for (List list : Lists.partition(adjDeleteBillIds, (int)5000)) {
            delFilter = new QFilter("id", "in", (Object)list);
            DeleteServiceHelper.delete((String)"cal_costadjustbill", (QFilter[])delFilter.toArray());
        }
    }

    private static void operateBill(String type, String entity, List<Long> ids) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        for (List list : Lists.partition(ids, (int)5000)) {
            OperationResult opeResult = OperationServiceHelper.executeOperate((String)type, (String)entity, (Object[])list.toArray(), (OperateOption)option);
            if (opeResult.isSuccess()) continue;
            ArrayList<String> errors = new ArrayList<String>(opeResult.getAllErrorOrValidateInfo().size());
            for (IOperateInfo operatorInfo : opeResult.getAllErrorOrValidateInfo()) {
                errors.add(operatorInfo.getMessage());
            }
            errors.add(opeResult.getMessage());
            throw new KDBizException(((Object)errors).toString());
        }
    }
}

