/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocDataFactory;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.DiffAllocResultInfo;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.util.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class DiffAllocHelper {
    private static final Log logger = LogFactory.getLog(DiffAllocHelper.class);
    private static final String ALGOKEY = "kd.fi.cal.opplugin.balance.StdCostDiffRecalOp";
    private static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };

    public static DiffAllocResultInfo deleteAllocResultByNewBal(DiffAllocParamter param, DiffAllocParamterEntry paramEntry) {
        DiffAllocResultInfo result = new DiffAllocResultInfo();
        Map<String, DiffAllocParamterEntry> entrys = param.getEntityEntry();
        DiffAllocDataFactory dataFactory = new DiffAllocDataFactory(param, paramEntry);
        if (paramEntry == null) {
            return result;
        }
        QFilter filter = new QFilter("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        if (paramEntry.getCalRangeId() > 0L) {
            filter.and("entryentity.calrange", "=", (Object)paramEntry.getCalRangeId());
        }
        if (!param.isAllocByCostSys()) {
            filter.and("billtype", "not in", (Object)new Long[]{920039909711047680L, 920040553033394176L});
        }
        filter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "G", "Y", "Z"}));
        filter.and("isvoucher", "=", (Object)Character.valueOf('0'));
        filter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        filter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        if (paramEntry.getMatIdSet() != null && paramEntry.getMatIdSet().size() > 0) {
            String matConditionType = param.getMatConditionType();
            filter.and("entryentity.material.id", "B".equals(matConditionType) ? "not in" : "in", paramEntry.getMatIdSet());
        }
        if ("false".equals(CalDbParamServiceHelper.getString(CalDbParamConstant.ISDO_DIFFALLOC_BY_OUTBILL, null))) {
            filter.and("biztype", "=", (Object)"A");
        }
        boolean isGroup = false;
        String isgroupdiffbill = CalDbParamServiceHelper.getString("isgroupdiffbill", null);
        if (isgroupdiffbill != null && "true".equals(isgroupdiffbill)) {
            isGroup = true;
        }
        String selectField = "id,billstatus";
        if (isGroup) {
            selectField = "id,billstatus,entryentity.groupdiffbillid as groupdiffbillid";
        }
        DataSet adjBillData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_stdcostdiffbill", (String)selectField, (QFilter[])new QFilter[]{filter}, null);
        Set<Long> hasVoucherDiffBill = DiffAllocHelper.getHasVoucherDiffBill(isGroup, adjBillData.copy());
        ArrayList<Long> noAuditBillIds = new ArrayList<Long>(1000);
        HashSet<Long> auditBillIds = new HashSet<Long>(1000);
        ArrayList<Long> submitBillIds = new ArrayList<Long>(1000);
        for (Row row : adjBillData) {
            if (hasVoucherDiffBill != null && !hasVoucherDiffBill.isEmpty() && hasVoucherDiffBill.contains(row.getLong("id"))) continue;
            if ("C".equals(row.getString("billstatus"))) {
                auditBillIds.add(row.getLong("id"));
                continue;
            }
            if ("B".equals(row.getString("billstatus"))) {
                submitBillIds.add(row.getLong("id"));
                continue;
            }
            noAuditBillIds.add(row.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        int batchSize = 5000;
        int totalBatch = auditBillIds.size() % batchSize == 0 ? auditBillIds.size() / batchSize : auditBillIds.size() / batchSize + 1;
        HashSet taskIds = new HashSet(16);
        Lists.partition(new ArrayList(auditBillIds), (int)batchSize).forEach(list -> {
            DynamicObject taskParam = BusinessDataServiceHelper.newDynamicObject((String)"cal_taskparam");
            taskParam.set("param_tag", (Object)SerializationUtils.toJsonString((Object)list));
            taskParam.set("functionnum", (Object)"diffalloc_unaudit");
            long paramId = DBServiceHelper.genLongIds((String)"cal_taskparam", (int)1)[0];
            taskParam.set("id", (Object)paramId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskParam});
            HashMap<String, Long> jobParams = new HashMap<String, Long>();
            jobParams.put("paramid", paramId);
            JobInfo job = new JobInfo();
            String OpName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5dee\u5f02\u5355\uff0c\u603b\u3010%1$s\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:%2$s", (String)"PartitionTask_2", (String)"fi-calx-algox", (Object[])new Object[0]);
            OpName = String.format(OpName, totalBatch, RequestContext.get().getUserName());
            job.setName(OpName);
            job.setJobType(JobType.BIZ);
            job.setParams(jobParams);
            job.setAppId("calx");
            job.setRunByLang(Lang.get());
            job.setTaskClassname("kd.fi.calx.algox.diff.DeleteStdCostDiffBillTask");
            job.setRunByUserId(RequestContext.get().getCurrUserId());
            taskIds.add(JobClient.dispatch((JobInfo)job));
        });
        Calendar calendar = Calendar.getInstance();
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            if (runningTasks.size() == totalBatch) {
                QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                failTtaskFilter.and("status", "=", (Object)"FAILED");
                failTtaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                HashSet<String> failTaskIds = new HashSet<String>(16);
                if (failTasks == null || failTasks.size() <= 0) break;
                DiffAllocHelper.writeLog(logger, "--------------DiffAllocHelper.deleteAllocResult_exist_failTask:" + failTasks.size());
                for (DynamicObject taskInfo : failTasks) {
                    failTaskIds.add(taskInfo.getString("id"));
                }
                QFilter taskFilter = new QFilter("ftaskid", "in", failTaskIds);
                DataSet failJobErrors = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.balance.StdCostDiffRecalOp.failTasksQuery", (String)"sch_errorjob", (String)"ferrorreason", (QFilter[])taskFilter.toArray(), null);
                for (Row row : failJobErrors) {
                    String OpName = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%1$s", (String)"DiffAllocHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]);
                    String errorKey = ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0", (String)"DiffAllocHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]);
                    String error = row.getString("ferrorreason");
                    String errorReason = "";
                    errorReason = error.indexOf(errorKey) > 0 ? ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u672a\u5b8c\u6210\uff0c\u8bf7\u5728\u4f59\u989d\u66f4\u65b0\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocHelper_3", (String)"fi-calx-algox", (Object[])new Object[0]) : error.substring(1, 255);
                    String taskName = String.format(OpName, errorReason);
                    if (kd.bos.util.StringUtils.isEmpty((String)errorReason)) continue;
                    DiffAllocHelper.writeLog(logger, "--------------DiffAllocHelper.deleteAllocResult_exist_failTask:throw new KDBizException");
                    throw new KDBizException(taskName);
                }
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.info("PartitionTaskService execute", (Object)e);
            }
        }
        Lists.partition(submitBillIds, (int)2000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)option);
            ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
            if (!operResult.isSuccess()) {
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                }
                errors.add(operResult.getMessage());
                result.setError(errors);
                result.setSuccess(false);
            }
            long endTime = System.currentTimeMillis();
            logger.info("--------------DiffAllocHelper.deleteAllocResult unsbumit noaudit->unsbumit lot adjBillList size:" + list.size());
            logger.info("--------------DiffAllocHelper.deleteAllocResult unsbumit noaudit->unsbumit lot adjBillList time:" + (endTime - beginTime));
        });
        noAuditBillIds.addAll(submitBillIds);
        Lists.partition(noAuditBillIds, (int)2000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            QFilter deleFilter = new QFilter("id", "in", list);
            DeleteServiceHelper.delete((String)"cal_stdcostdiffbill", (QFilter[])deleFilter.toArray());
            long endTime = System.currentTimeMillis();
            logger.info("--------------DiffAllocHelper.deleteAllocResult delete noaudit->delete lot adjBillList size:" + list.size());
            logger.info("--------------DiffAllocHelper.deleteAllocResult delete noaudit->delete lot adjBillList time:" + (endTime - beginTime));
        });
        DiffAllocHelper.deleteCostAdjustBillByNewBal(param, paramEntry, result);
        if (!param.isAllocByCostSys()) {
            Set<Long> crossRecordEntryIds = dataFactory.getGenCrossMonthGroupBill();
            param.setCrossRecordEntryIds(new HashSet<Long>(crossRecordEntryIds));
        }
        DiffAllocHelper.chargeOffedMergeAgain(paramEntry);
        return result;
    }

    private static void chargeOffedMergeAgain(DiffAllocParamterEntry paramEntry) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CHARGE_OFFED_MERGE_AGAIN).booleanValue()) {
            return;
        }
        String isGroupDiffBill = CalDbParamServiceHelper.getString("isgroupdiffbill", null);
        if (!"true".equals(isGroupDiffBill)) {
            return;
        }
        QFilter filter = new QFilter("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        if (paramEntry.getCalRangeId() > 0L) {
            filter.and("entryentity.calrange", "=", (Object)paramEntry.getCalRangeId());
        }
        filter.and("ischargeoffed", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"chargeOffedMergeAgain", (String)"cal_stdcostdiffbill", (String)"id,entryentity.groupdiffbillid as groupdiffbillid", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> stdBillIds = new HashSet<Long>(100);
        HashSet<Long> groupBillIdSet = new HashSet<Long>(100);
        for (Row row : dataSet) {
            stdBillIds.add(row.getLong("id"));
            Long groupDiffBillId = row.getLong("groupdiffbillid");
            if (groupDiffBillId == null || groupDiffBillId == 0L) continue;
            groupBillIdSet.add(groupDiffBillId);
        }
        if (!groupBillIdSet.isEmpty()) {
            Lists.partition(new ArrayList(groupBillIdSet), (int)5000).forEach(list -> {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costdiffgroupbill", (Object[])list.toArray(new Object[0]), (OperateOption)option);
                DeleteServiceHelper.delete((String)"cal_costdiffgroupbill", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            });
            Lists.partition(new ArrayList(stdBillIds), (int)5000).forEach(list -> {
                String updateSql = "UPDATE t_cal_stdcostdiffentry SET FGROUPDIFFBILLNUM = ' ',FGROUPDIFFBILLID = 0 WHERE FID in (" + StringUtils.join((Collection)list, (String)",") + ")";
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql);
            });
        }
        HashMap<String, HashSet<Long>> diffBillEntryIdMap = new HashMap<String, HashSet<Long>>(16);
        diffBillEntryIdMap.put("diffbillid", stdBillIds);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"createDiffGroupBill", (Object[])new Object[]{diffBillEntryIdMap});
    }

    public static void deleteCostAdjustBillByNewBal(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, DiffAllocResultInfo result1) {
        DiffAllocResultInfo tempResult = new DiffAllocResultInfo();
        Map<String, DiffAllocParamterEntry> entrys = param.getEntityEntry();
        if (paramEntry == null) {
            return;
        }
        QFilter filter = new QFilter("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        filter.and("costaccount.id", "=", (Object)paramEntry.getCostAccountId());
        if (paramEntry.getCalRangeId() > 0L) {
            filter.and("entryentity.calrange", "=", (Object)paramEntry.getCalRangeId());
        }
        if (!param.isAllocByCostSys()) {
            filter.and("billtype", "not in", (Object)new Long[]{920039909711047680L, 920040553033394176L});
        }
        filter.and("createtype", "=", (Object)"W");
        filter.and("isvoucher", "=", (Object)Character.valueOf('0'));
        filter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        filter.and("ischargeoff", "=", (Object)Boolean.FALSE);
        if (paramEntry.getMatIdSet() != null && paramEntry.getMatIdSet().size() > 0) {
            String matConditionType = param.getMatConditionType();
            filter.and("entryentity.material.id", "B".equals(matConditionType) ? "not in" : "in", paramEntry.getMatIdSet());
        }
        DataSet adjBillData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjust_subentity", (String)"id,billstatus", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> noAuditBillIds = new ArrayList<Long>(1000);
        HashSet<Long> auditBillIds = new HashSet<Long>(1000);
        ArrayList<Long> submitBillIds = new ArrayList<Long>(1000);
        for (Row row : adjBillData) {
            if ("C".equals(row.getString("billstatus"))) {
                auditBillIds.add(row.getLong("id"));
                continue;
            }
            if ("B".equals(row.getString("billstatus"))) {
                submitBillIds.add(row.getLong("id"));
                continue;
            }
            noAuditBillIds.add(row.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        if (!auditBillIds.isEmpty()) {
            int batchSize = 5000;
            int totalBatch = auditBillIds.size() % batchSize == 0 ? auditBillIds.size() / batchSize : auditBillIds.size() / batchSize + 1;
            HashSet taskIds = new HashSet(16);
            Lists.partition(new ArrayList(auditBillIds), (int)batchSize).forEach(list -> {
                DynamicObject taskParam = BusinessDataServiceHelper.newDynamicObject((String)"cal_taskparam");
                taskParam.set("param_tag", (Object)SerializationUtils.toJsonString((Object)list));
                taskParam.set("functionnum", (Object)"diffalloc_unaudit");
                long paramId = DBServiceHelper.genLongIds((String)"cal_taskparam", (int)1)[0];
                taskParam.set("id", (Object)paramId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskParam});
                HashMap<String, Long> jobParams = new HashMap<String, Long>();
                jobParams.put("paramid", paramId);
                JobInfo job = new JobInfo();
                String OpName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355\uff0c\u603b\u3010%1$s\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:%2$s", (String)"PartitionTask_3", (String)"fi-calx-algox", (Object[])new Object[0]);
                OpName = String.format(OpName, totalBatch, RequestContext.get().getUserName());
                job.setName(OpName);
                job.setJobType(JobType.BIZ);
                job.setParams(jobParams);
                job.setAppId("calx");
                job.setRunByLang(Lang.get());
                job.setTaskClassname("kd.fi.calx.algox.diff.DeleteCostAdjustBillTask");
                job.setRunByUserId(RequestContext.get().getCurrUserId());
                taskIds.add(JobClient.dispatch((JobInfo)job));
            });
            Calendar calendar = Calendar.getInstance();
            while (true) {
                QFilter completedFilter = new QFilter("id", "in", taskIds);
                completedFilter.and("status", "in", completedTaskStatus);
                DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
                if (runningTasks.size() == totalBatch) {
                    QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                    failTtaskFilter.and("status", "=", (Object)"FAILED");
                    failTtaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                    DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                    HashSet<String> failTaskIds = new HashSet<String>(16);
                    if (failTasks == null || failTasks.size() <= 0) break;
                    for (DynamicObject taskInfo : failTasks) {
                        failTaskIds.add(taskInfo.getString("id"));
                    }
                    QFilter taskFilter = new QFilter("ftaskid", "in", failTaskIds);
                    DataSet failJobErrors = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.opplugin.balance.StdCostDiffRecalOp.failTasksQuery", (String)"sch_errorjob", (String)"ferrorreason", (QFilter[])taskFilter.toArray(), null);
                    for (Row row : failJobErrors) {
                        String OpName = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a%1$s", (String)"DiffAllocHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]);
                        String errorKey = ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0", (String)"DiffAllocHelper_2", (String)"fi-calx-algox", (Object[])new Object[0]);
                        String error = row.getString("ferrorreason");
                        String errorReason = "";
                        errorReason = error.indexOf(errorKey) > 0 ? ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u672a\u5b8c\u6210\uff0c\u8bf7\u5728\u4f59\u989d\u66f4\u65b0\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffAllocHelper_3", (String)"fi-calx-algox", (Object[])new Object[0]) : error.substring(1, 255);
                        String taskName = String.format(OpName, errorReason);
                        if (kd.bos.util.StringUtils.isEmpty((String)errorReason)) continue;
                        throw new KDBizException(taskName);
                    }
                    break;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.info("PartitionTaskService execute", (Object)e);
                }
            }
        }
        if (!submitBillIds.isEmpty()) {
            Lists.partition(submitBillIds, (int)2000).forEach(list -> {
                long beginTime = System.currentTimeMillis();
                OperationResult operResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"cal_costadjust_subentity", (Object[])list.toArray(), (OperateOption)option);
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                if (!operResult.isSuccess()) {
                    for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                        errors.add(operatorInfo.getMessage());
                    }
                    errors.add(operResult.getMessage());
                    tempResult.setError(errors);
                    tempResult.setSuccess(false);
                }
                long endTime = System.currentTimeMillis();
                logger.info("--------------DiffAllocHelper.deleteAllocResult unsbumit noaudit->unsbumit lot adjBillList size:" + list.size());
                logger.info("--------------DiffAllocHelper.deleteAllocResult unsbumit noaudit->unsbumit lot adjBillList time:" + (endTime - beginTime));
            });
        }
        noAuditBillIds.addAll(submitBillIds);
        if (!noAuditBillIds.isEmpty()) {
            Lists.partition(noAuditBillIds, (int)2000).forEach(list -> {
                long beginTime = System.currentTimeMillis();
                QFilter deleFilter = new QFilter("id", "in", list);
                DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
                long endTime = System.currentTimeMillis();
                logger.info("--------------DiffAllocHelper.deleteAllocResult delete noaudit->delete lot adjBillList size:" + list.size());
                logger.info("--------------DiffAllocHelper.deleteAllocResult delete noaudit->delete lot adjBillList time:" + (endTime - beginTime));
            });
        }
        if (!tempResult.isSuccess()) {
            result1.setSuccess(Boolean.FALSE);
            result1.getError().addAll(result1.getError());
        }
    }

    public static DiffAllocResultInfo deleteAllocResult(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, DiffAllocDataFactory dataFactory) {
        DiffAllocResultInfo result = new DiffAllocResultInfo();
        return result;
    }

    private static void deleteInBillCostAdj(QFilter filter, DiffAllocResultInfo result, DiffAllocParamterEntry parmEntry) {
    }

    public static Map<Long, String> getDiffAllocStrategy(List<Long> costAccountIds) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        QFilter filter = new QFilter("costaccount.id", "in", costAccountIds);
        DynamicObjectCollection reductStrategys = QueryServiceHelper.query((String)"cad_sysparam", (String)"costaccount.id as costAccountId,reductstrategy", (QFilter[])filter.toArray(), (String)null);
        if (reductStrategys != null && !reductStrategys.isEmpty()) {
            for (DynamicObject reductStrategy : reductStrategys) {
                result.put(reductStrategy.getLong("costAccountId"), reductStrategy.getString("reductstrategy"));
            }
        } else {
            for (Long costAccountId : costAccountIds) {
                result.put(costAccountId, "OVERALL_REDUCT");
            }
        }
        return result;
    }

    public static String[] getDivideBasis(Long costAccountId) {
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        DynamicObject divideBasisObj = costAccount.getDynamicObject("dividebasis");
        return divideBasisObj.getString("dividebasis").split(",");
    }

    public static String getDivideBasisForCalrange(Long costAccountId) {
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        DynamicObject divideBasisObj = costAccount.getDynamicObject("dividebasis");
        String dividebasisStr = divideBasisObj.getString("dividebasis");
        StringBuilder queryStr = new StringBuilder();
        if (dividebasisStr != null && dividebasisStr.length() > 0 && dividebasisStr.split(",").length > 0) {
            for (String field : dividebasisStr.split(",")) {
                queryStr.append(",entry.").append(field).append(" as ").append(field);
            }
            return queryStr.toString();
        }
        return "";
    }

    public static String mergDiffAllocDims(String equationSetDims, String equalityDims) {
        if (!equationSetDims.contains("material") && !equalityDims.contains("material")) {
            equalityDims = equalityDims + ",material";
        }
        if (equationSetDims == null || equationSetDims.isEmpty()) {
            return equalityDims;
        }
        if (equalityDims == null || equalityDims.isEmpty()) {
            return equationSetDims;
        }
        HashSet<String> equationSetDimStrs = new HashSet<String>(16);
        StringBuilder dimsStr = new StringBuilder();
        for (String dim : equationSetDims.split(",")) {
            dimsStr.append(dim).append(",");
            equationSetDimStrs.add(dim);
        }
        for (String dim : equalityDims.split(",")) {
            if (equationSetDimStrs.contains(dim)) continue;
            dimsStr.append(dim).append(",");
        }
        return dimsStr.substring(0, dimsStr.length() - 1);
    }

    public static void writeLog(String content) {
        try {
            DynamicObject purpriceInfo = BusinessDataServiceHelper.loadSingle((Object)1081392404591852546L, (String)"cal_purpricediff");
            logger.info("#################:" + content + "\u2014\u2014>endperiod:" + purpriceInfo.getString("endperiod") + "@peirod:" + purpriceInfo.getString("period"));
        }
        catch (Exception e) {
            logger.error("DiffAllocHelper->writeLog(java.lang.String) error", (Throwable)e);
        }
    }

    public static void writeLog(Log logger, String content) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CALX_IS_DEBUG).booleanValue()) {
            return;
        }
        logger.info(content);
    }

    public static void writeLog(Log logger, String content, Object ... params) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CALX_IS_DEBUG).booleanValue()) {
            return;
        }
        logger.info(content, params);
    }

    public static Long writeLogBegin(Log logger, String content) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return 0L;
        }
        logger.info(content);
        return TimeServiceHelper.getTimeStamp();
    }

    public static void writeLogEnd(Log logger, String content, Long startTime) {
        Long endTime = TimeServiceHelper.getTimeStamp();
        Long time = endTime - startTime;
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return;
        }
        logger.info(content + ",time:" + time);
    }

    public static String getDiffAllocDimsAlias(String billEntityNumber, String[] allodDims, String preFalg) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder selectFields = new StringBuilder();
        for (String field : allodDims) {
            IDataEntityProperty property = entityType.findProperty(field);
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (property == null || "assist".equals(field) || "material".equals(field)) continue;
            String alias = "name";
            if ("tracknumber".equals(field) || "configuredcode".equals(field)) {
                alias = "number";
            }
            if (entityType.findProperty(field) instanceof BasedataProp) {
                if (isEntryProp) {
                    selectFields.append(",");
                    selectFields.append(parentProp.getName());
                    selectFields.append(".");
                    selectFields.append(field);
                    selectFields.append(".");
                    selectFields.append(alias);
                    selectFields.append(" as ");
                    selectFields.append(preFalg);
                    selectFields.append(field);
                    selectFields.append("name");
                    continue;
                }
                selectFields.append(",");
                selectFields.append(field);
                selectFields.append(".");
                selectFields.append(alias);
                selectFields.append(" as ");
                selectFields.append(preFalg);
                selectFields.append(field);
                selectFields.append("name");
                continue;
            }
            if (isEntryProp) {
                selectFields.append(",");
                selectFields.append(parentProp.getName());
                selectFields.append(".");
                selectFields.append(field);
                selectFields.append(" as ");
                selectFields.append(preFalg);
                selectFields.append(field);
                selectFields.append("name");
                continue;
            }
            selectFields.append(",");
            selectFields.append(field);
            selectFields.append(" as ");
            selectFields.append(preFalg);
            selectFields.append(field);
            selectFields.append("name");
        }
        return selectFields.toString();
    }

    public static boolean getCostElementByCostAccount(long costAccountId) {
        QFilter q = new QFilter("id", "=", (Object)costAccountId).and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (QFilter[])q.toArray());
        if (costAccount == null) {
            return false;
        }
        Long calPolicyId = costAccount.getLong("calpolicy.id");
        QFilter q1 = new QFilter("id", "=", (Object)calPolicyId);
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_calpolicy", (QFilter[])q1.toArray());
        return calPolicy.getBoolean("calbycostelement");
    }

    public static Set<Long> getHasVoucherDiffBill(boolean isGroup, DataSet adjBillData) {
        Set<Long> hasVoucherDiffBill = new HashSet<Long>(16);
        if (isGroup) {
            HashMap<Long, HashSet<Long>> diffBillGroupBillMap = new HashMap<Long, HashSet<Long>>(16);
            HashSet<Long> allGroupBillIds = new HashSet<Long>(16);
            for (Row row : adjBillData) {
                Long diffBillId = row.getLong("id");
                Long groupBillId = row.getLong("groupdiffbillid");
                HashSet<Long> groupBillIdSet = (HashSet<Long>)diffBillGroupBillMap.get(diffBillId);
                if (groupBillIdSet == null) {
                    groupBillIdSet = new HashSet<Long>(16);
                }
                groupBillIdSet.add(groupBillId);
                diffBillGroupBillMap.put(diffBillId, groupBillIdSet);
                allGroupBillIds.add(groupBillId);
            }
            if (!allGroupBillIds.isEmpty()) {
                Map diffBillMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"DeleteSingleDimDiffGroupBill", (Object[])new Object[]{allGroupBillIds, diffBillGroupBillMap});
                hasVoucherDiffBill = (Set)diffBillMap.get("hasvoucherdiffbill");
            }
        }
        return hasVoucherDiffBill;
    }

    public static void checkBalModel() {
        if (!CalBalanceModelHelper.isNewBalance()) {
            String remark = ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u66f4\u65b0\u4e3a\u8001\u7248\u672c\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u5dee\u5f02\u5206\u644a\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DiffAllocHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]);
            throw new KDBizException(remark);
        }
    }
}

