/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.diff.EntityExInfo;

public class ExFieldHelper {
    private Map<String, String> fieldStrCache = new HashMap<String, String>();
    private Map<String, Field[]> simpleFieldStrCache = new HashMap<String, Field[]>();

    public String getAllExFields(String billEntityNumber) {
        return this.getAllExFields(billEntityNumber, "");
    }

    public String getAllExFields(String billEntityNumber, String preStr) {
        String fieldStr = this.fieldStrCache.get(billEntityNumber);
        if (fieldStr != null) {
            return fieldStr;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder sb = new StringBuilder();
        List<String> exFieldSet = this.getExFieldSet();
        for (String field : exFieldSet) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            sb.append(',');
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            sb.append(" as ");
            sb.append(preStr);
            sb.append(field);
        }
        fieldStr = sb.toString();
        this.fieldStrCache.put(billEntityNumber, fieldStr);
        return fieldStr;
    }

    public Field[] getAllExSimpleFields(String billEntityNumber) {
        Field[] fieldArrray = this.simpleFieldStrCache.get(billEntityNumber);
        if (fieldArrray != null) {
            return fieldArrray;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        ArrayList<Field> dynamicFields = new ArrayList<Field>(16);
        List<String> exFieldSet = this.getExFieldSet();
        for (String field : exFieldSet) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) continue;
            if (entityType.findProperty(field) instanceof BasedataProp) {
                dynamicFields.add(new Field(field, (DataType)DataType.LongType));
                continue;
            }
            dynamicFields.add(new Field(field, (DataType)DataType.StringType));
        }
        this.simpleFieldStrCache.put(billEntityNumber, dynamicFields.toArray(new Field[0]));
        return dynamicFields.toArray(new Field[0]);
    }

    public List<EntityExInfo> getEntityExInfos(String billEntityNumber) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        ArrayList<EntityExInfo> entityExInfos = new ArrayList<EntityExInfo>(16);
        List<String> exFieldSet = this.getExFieldSet();
        HashSet dealedFields = new HashSet(16);
        for (String field : exFieldSet) {
            IDataEntityProperty property;
            if (dealedFields.contains(field) || (property = entityType.findProperty(field)) == null) continue;
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            EntityExInfo entityExInfo = new EntityExInfo();
            if (isEntryProp) {
                entityExInfo.setEntryName(parentProp.getName());
            }
            entityExInfo.setPropertyName(field);
            entityExInfo.setDbField(property.getAlias());
            entityExInfos.add(entityExInfo);
        }
        return entityExInfos;
    }

    public List<String> getExFieldSet() {
        ArrayList<String> exFieldSet = new ArrayList<String>(16);
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)"im_saloutbill");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("calbill", "=", (Object)"cal_outcalbill"));
        DynamicObjectCollection purRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"id,fieldmap.calfield,fieldmap.isextendfield", (QFilter[])filter.toArray(), (String)"id");
        for (DynamicObject rule : purRules) {
            if (!rule.getBoolean("fieldmap.isextendfield")) continue;
            exFieldSet.add(rule.getString("fieldmap.calfield"));
        }
        return exFieldSet;
    }

    public String getExFieldNoCalSet(String entitynumber) {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)"im_saloutbill");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("calbill", "=", (Object)"cal_outcalbill"));
        DynamicObjectCollection purRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"id,fieldmap.calfield,fieldmap.isextendfield", (QFilter[])filter.toArray(), (String)"id");
        StringBuilder sb = new StringBuilder();
        for (DynamicObject rule : purRules) {
            if (!rule.getBoolean("fieldmap.isextendfield")) continue;
            sb.append(",").append(rule.getString("fieldmap.calfield"));
        }
        return sb.toString();
    }

    public static String getSelectFieldsStr(String billEntityNumber, String feilds, String preFlag) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder sb = new StringBuilder();
        for (String field : feilds.split(",")) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            sb.append(',');
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            sb.append(" as ");
            sb.append(preFlag);
            sb.append(field);
        }
        return sb.substring(1);
    }
}

