/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;
import kd.fi.calx.algox.diff.CostAdjustDetailParams;
import kd.fi.calx.algox.diff.EntityExInfo;
import kd.fi.calx.algox.diff.helper.CalStdcostdiffbillHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.diff.model.StdCostDiffBillModel;
import kd.fi.calx.algox.groupbill.GroupBillHolder;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;

public class MITStdDiffCostAdjustBillHelper {
    protected RowMeta rowMeta;
    protected static final String diffTypes = "G,H,K,P,Q,R,M,S,T,C,X,W,Y";
    private static final String[] indexStrs = new String[]{"id", "seq", "sub_material", "costelement", "costsubelement", "sub_currency", "sub_adjustamt", "ddiff_g", "ddiff_h", "ddiff_k", "ddiff_p", "ddiff_q", "ddiff_r", "ddiff_m", "ddiff_s", "ddiff_t", "ddiff_c", "ddiff_x", "ddiff_w", "ddiff_y", "sub_material_id", "costelement_id", "costsubelement_id", "sub_currency_id"};
    private List<EntityExInfo> entityExInfos = new ExFieldHelper().getEntityExInfos("cal_stdcostdiffbill");
    private static final Log logger = LogFactory.getLog(MITStdDiffCostAdjustBillHelper.class);

    public void genStdCostDiffBill(LocalRow row, Map<Long, DynamicObject> idAndCostRecord, Map<Long, DynamicObject> entryIdAndCostRecordEntry, Map<String, List<StdCostDiffBillModel>> stdCostDiffBills, List<CostAdjustDetailParams> params, Map<Long, Long> elementCache_subIdAndId, BigDecimal diff, Map<String, BigDecimal> costRecordGroupIdAndSubElementAmt, Map<String, BigDecimal> idsAndSubElement, GroupBillHolder groupBillHolder) {
        this.dealStdCostBillHeader(row, idAndCostRecord, entryIdAndCostRecordEntry, stdCostDiffBills);
        this.dealStdCostBillEntry(row, idAndCostRecord, entryIdAndCostRecordEntry, stdCostDiffBills, diff);
        this.dealStdCostBillDetail(row, idAndCostRecord, entryIdAndCostRecordEntry, stdCostDiffBills, params, elementCache_subIdAndId, costRecordGroupIdAndSubElementAmt, idsAndSubElement, groupBillHolder);
    }

    private void dealStdCostBillHeader(LocalRow row, Map<Long, DynamicObject> idAndCostRecord, Map<Long, DynamicObject> entryIdAndCostRecordEntry, Map<String, List<StdCostDiffBillModel>> costAdjustBills) {
        Long headid = row.getHeadid();
        DynamicObject costRecord = idAndCostRecord.get(headid);
        String headerKey = this.getStdCostDiffBillHeadKey(row, entryIdAndCostRecordEntry);
        List<StdCostDiffBillModel> costAdjustBillModels = costAdjustBills.get(headerKey);
        if (costAdjustBillModels == null) {
            costAdjustBillModels = new ArrayList<StdCostDiffBillModel>(16);
            costAdjustBillModels.add(new StdCostDiffBillModel());
            costAdjustBills.put(headerKey, costAdjustBillModels);
        } else if (costAdjustBillModels.get(costAdjustBillModels.size() - 1).getEntrys().size() > 1000) {
            costAdjustBillModels.add(new StdCostDiffBillModel());
        } else {
            return;
        }
        Object[] head = new Object[22];
        costAdjustBillModels.get(costAdjustBillModels.size() - 1).setHeaders(head);
        Object[] head_l = new Object[4];
        costAdjustBillModels.get(costAdjustBillModels.size() - 1).setHeaders_l(head_l);
        long costAdjustId = DBServiceHelper.genLongIds((String)"cal_stdcostdiffbill", (int)1)[0];
        head[0] = costAdjustId;
        head_l[0] = costAdjustId;
        head_l[1] = DBServiceHelper.genStringIds((String)"t_cal_costadjustbill_l", (int)1)[0];
        head[1] = costRecord.get("period");
        head[2] = costRecord.get("calorg");
        head[3] = costRecord.get("costaccount");
        head[4] = "B";
        head[5] = "";
        String costAdjustType = "A";
        String calbilltype = idAndCostRecord.get(headid).getString("calbilltype");
        if ("OUT".equals(calbilltype)) {
            costAdjustType = "B";
        }
        head[6] = costAdjustType;
        head[7] = costRecord.get("bizdate");
        head[8] = costRecord.get("bookdate");
        head[9] = costRecord.get("id");
        head[10] = "bd_customer";
        head[11] = CostAdjustBilCreateTypeEnum.CAL_OUT.getValue();
        head[12] = costRecord.get("localcurrency");
        head[13] = costRecord.get("adminorg");
        head[14] = "IN".equals(calbilltype) ? costRecord.get("supplier") : costRecord.get("customer");
        head_l[2] = ResManager.getLanguage();
        head_l[3] = "";
        head[15] = "CBTZ" + costAdjustId;
        Long userId = RequestContext.get().getCurrUserId();
        Date date = TimeServiceHelper.now();
        head[16] = userId;
        head[17] = date;
        head[18] = userId;
        head[19] = date;
        head[20] = userId;
        head[21] = date;
    }

    private void dealStdCostBillEntry(LocalRow row, Map<Long, DynamicObject> idAndCostRecord, Map<Long, DynamicObject> entryIdAndCostRecordEntry, Map<String, List<StdCostDiffBillModel>> stdCostDiffBills, BigDecimal diff) {
        Long headid = row.getHeadid();
        Long entryId = row.getEntryId();
        DynamicObject costRecordEntry = entryIdAndCostRecordEntry.get(entryId);
        DynamicObject costRecord = idAndCostRecord.get(headid);
        String headerKey = this.getStdCostDiffBillHeadKey(row, entryIdAndCostRecordEntry);
        List<StdCostDiffBillModel> StdCostDiffBillModels = stdCostDiffBills.get(headerKey);
        StdCostDiffBillModel costAdjustBillModel = StdCostDiffBillModels.get(StdCostDiffBillModels.size() - 1);
        String entryKey = costRecord.get("id").toString() + "@" + costRecordEntry.get("entry.id");
        Object[] entry = costAdjustBillModel.getEntrys().get(entryKey);
        if (entry != null) {
            int index = 1;
            BigDecimal totalDiff = BigDecimal.ZERO;
            for (String diffType : diffTypes.split(",")) {
                BigDecimal currAdjAmt = BigDecimal.ZERO;
                if ("T".equals(diffType)) {
                    currAdjAmt = diff;
                }
                entry[22 + index++] = currAdjAmt;
                totalDiff = totalDiff.add(currAdjAmt);
            }
            entry[22] = totalDiff;
            return;
        }
        entry = new Object[57 + this.entityExInfos.size()];
        costAdjustBillModel.getEntrys().put(entryKey, entry);
        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
        if (costAdjustBillModel == null) {
            return;
        }
        entry[0] = costAdjustBillModel.getHeaders()[0];
        entry[1] = costAdjustEntryId;
        entry[2] = costAdjustBillModel.getEntrySeq();
        entry[3] = costRecord.get("storageorgunit");
        entry[4] = costRecordEntry.get("entry.material");
        entry[5] = costRecordEntry.get("entry.mversion");
        entry[6] = costRecordEntry.get("entry.assist");
        entry[7] = costRecordEntry.get("entry.lot");
        entry[8] = costRecordEntry.get("entry.baseunit");
        entry[9] = costRecordEntry.get("entry.warehouse");
        entry[10] = costRecordEntry.get("entry.location");
        entry[11] = costRecordEntry.get("entry.invtype");
        entry[12] = costRecord.get("biztype");
        entry[13] = costRecordEntry.get("entry.invstatus");
        entry[14] = costRecordEntry.get("entry.ownertype");
        entry[15] = costRecordEntry.get("entry.owner");
        entry[16] = costRecordEntry.get("entry.project");
        entry[17] = costRecordEntry.get("entry.tracknumber");
        entry[18] = costRecordEntry.get("entry.configuredcode");
        entry[19] = costRecordEntry.get("entry.calrange");
        entry[20] = costRecordEntry.get("entry.caldimension");
        entry[21] = costRecordEntry.get("entry.accounttype");
        int index = 1;
        BigDecimal totalDiff = BigDecimal.ZERO;
        for (String diffType : diffTypes.split(",")) {
            BigDecimal currAdjAmt = BigDecimal.ZERO;
            if ("T".equals(diffType)) {
                currAdjAmt = diff;
            }
            entry[22 + index++] = currAdjAmt;
            totalDiff = totalDiff.add(currAdjAmt);
        }
        entry[22] = totalDiff;
        entry[36] = costRecord.get("id");
        entry[37] = costRecordEntry.get("entry.id");
        entry[38] = costRecord.get("billnumber");
        entry[39] = "cal_stdcostdiffbill";
        entry[40] = costRecordEntry.get("entry.seq");
        entry[41] = null;
        entry[42] = null;
        entry[43] = headid;
        entry[44] = costRecord.getString("billno");
        entry[45] = 0L;
        entry[46] = 0;
        entry[47] = "cal_costrecord_subentity";
        entry[48] = costRecord.get("biztype");
        entry[49] = costRecord.get("transtype");
        entry[50] = costRecordEntry.get("entry.queuetype");
        entry[51] = costRecordEntry.get("entry.signnum");
        entry[53] = costRecordEntry.get("entry.ecostcenter");
        entry[54] = costRecordEntry.get("entry.productline");
        entry[55] = costRecordEntry.get("entry.noupdatecalfields");
        entry[56] = costRecordEntry.get("entry.stocktype");
        MainEntityType stdCostDffBillEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        for (int i = 0; i < this.entityExInfos.size(); ++i) {
            entry[57 + i] = MITStdDiffCostAdjustBillHelper.getExFieldValue(costRecordEntry, stdCostDffBillEntityType, this.entityExInfos.get(i).getPropertyName());
        }
    }

    public static Object getExFieldValue(DynamicObject costRecordEntry, MainEntityType stdCostDffBillEntityType, String exField) {
        IDataEntityProperty srcProperty = stdCostDffBillEntityType.findProperty(exField);
        if (srcProperty != null) {
            return costRecordEntry.get("entry." + exField);
        }
        return null;
    }

    private void dealStdCostBillDetail(LocalRow row, Map<Long, DynamicObject> idAndCostRecord, Map<Long, DynamicObject> entryIdAndCostRecordEntry, Map<String, List<StdCostDiffBillModel>> stdCostDiffBills, List<CostAdjustDetailParams> params, Map<Long, Long> elementCache_subIdAndId, Map<String, BigDecimal> costRecordGroupIdAndSubElementAmt, Map<String, BigDecimal> idsAndSubElementAmt, GroupBillHolder groupBillHolder) {
        Long headid = row.getHeadid();
        Long entryId = row.getEntryId();
        DynamicObject costRecord = idAndCostRecord.get(headid);
        DynamicObject costRecordEntry = entryIdAndCostRecordEntry.get(entryId);
        Map<Long, BigDecimal> elementCostMap = row.getElementCostMap();
        for (Map.Entry<Long, BigDecimal> entrySet : elementCostMap.entrySet()) {
            BigDecimal adjustAmt;
            Long subElementId = entrySet.getKey();
            BigDecimal amt = entrySet.getValue();
            String groupDetailKey = headid + "#" + entryId + "#" + subElementId;
            BigDecimal stdAmt = idsAndSubElementAmt.get(groupDetailKey) == null ? BigDecimal.ZERO : idsAndSubElementAmt.get(groupDetailKey);
            BigDecimal costRecordAmt = costRecordGroupIdAndSubElementAmt.get(groupDetailKey) == null ? BigDecimal.ZERO : costRecordGroupIdAndSubElementAmt.get(groupDetailKey);
            BigDecimal oldAmt = stdAmt.add(costRecordAmt);
            DiffAllocHelper.writeLog(logger, "groupKey : {},cost : {}, std : {},costrecord : {}", groupDetailKey, oldAmt, stdAmt, costRecordAmt);
            BigDecimal diffAmount = amt.subtract(oldAmt);
            String headerKey = this.getStdCostDiffBillHeadKey(row, entryIdAndCostRecordEntry);
            List<StdCostDiffBillModel> stdCostDiffBillModels = stdCostDiffBills.get(headerKey);
            String entryKey = costRecord.get("id").toString() + "@" + costRecordEntry.get("entry.id");
            Object[] entry = null;
            StdCostDiffBillModel currStdCostDiffBillModel = null;
            for (StdCostDiffBillModel stdCostDiffBillModel : stdCostDiffBillModels) {
                if (!stdCostDiffBillModel.getEntrys().containsKey(entryKey)) continue;
                currStdCostDiffBillModel = stdCostDiffBillModel;
                entry = stdCostDiffBillModel.getEntrys().get(entryKey);
            }
            long detailId = DBServiceHelper.genLongIds((String)"t_cal_costadjust_detail", (int)1)[0];
            if (entry == null) {
                return;
            }
            if (elementCache_subIdAndId.get(subElementId) == null) {
                HashSet<Long> existKeys = new HashSet<Long>(elementCache_subIdAndId.keySet());
                HashSet<Long> queryKeys = new HashSet<Long>(elementCostMap.keySet());
                queryKeys.removeAll(existKeys);
                DynamicObject[] elementDynamicObjects = BusinessDataServiceHelper.load((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{new QFilter("subelement.id", "in", queryKeys)}, null);
                Stream.of(elementDynamicObjects).forEach(a -> elementCache_subIdAndId.put(a.getDynamicObject("subelement").getLong("id"), a.getDynamicObject("element").getLong("id")));
            }
            Long costElementId = elementCache_subIdAndId.get(subElementId);
            boolean index = true;
            BigDecimal totalDiff = BigDecimal.ZERO;
            for (String diffType : diffTypes.split(",")) {
                BigDecimal currAdjAmt = BigDecimal.ZERO;
                if ("T".equals(diffType)) {
                    currAdjAmt = diffAmount;
                }
                totalDiff = totalDiff.add(currAdjAmt);
            }
            CostAdjustDetailParams param = new CostAdjustDetailParams();
            if (currStdCostDiffBillModel != null) {
                Object[] entrys = currStdCostDiffBillModel.getEntrys().get(entryKey);
                Long entryid = Long.valueOf(entrys[1].toString());
                param.setEntryid(entryid);
            }
            param.setCostElementId(costElementId);
            param.setCostSubElementId(subElementId);
            param.setAdjustAmt(BigDecimal.ZERO);
            if (diffAmount.compareTo(BigDecimal.ZERO) != 0) {
                param.setAdjustAmt(diffAmount);
            }
            if ((adjustAmt = param.getAdjustAmt()).compareTo(BigDecimal.ZERO) == 0) continue;
            CalStdcostdiffbillHelper.setParamSubDdiffAmt("T", adjustAmt, param);
            params.add(param);
        }
    }

    public void saveStdCostDiffBillToDB(Map<String, List<StdCostDiffBillModel>> stdCostDiffBills) {
        int index;
        int batch_size = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        StringBuilder headInsertSql = new StringBuilder();
        headInsertSql.append("insert into t_cal_stdcostdiff(");
        headInsertSql.append("FID,fperiodid,forgid,fcostaccount,fbillstatus,");
        headInsertSql.append("fbillsrctype,fbiztype,fbizdate,fbookdate,fsrcbilltypeid,");
        headInsertSql.append("fcstypeid,fcreatetype,fcurrencyid,fadminorgid,");
        headInsertSql.append("fcustsupplierid,fbillno,fcreatorid,fcreatetime,fmodifierid,");
        headInsertSql.append("fmodifytime,fauditorid,fauditdate,fcalstatus)");
        headInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'A')");
        StringBuilder headInsertSql_l = new StringBuilder();
        headInsertSql_l.append("insert into t_cal_stdcostdiff_l(");
        headInsertSql_l.append("FID,FPKID,FLOCALEID,FREMARK)");
        headInsertSql_l.append("values(?,?,?,?)");
        StringBuilder entryInsertSql = new StringBuilder();
        entryInsertSql.append("insert into t_cal_stdcostdiffentry(");
        entryInsertSql.append("fid,fentryid,fseq,fstorageorgunitid,fmaterialid,");
        entryInsertSql.append("fmversionid,fauxpropertyid,flot,fbaseunitid,fwarehsouseid,");
        entryInsertSql.append("flocationid,finvtypeid,finvbilltype,finvstatusid,fownertype,");
        entryInsertSql.append("fownerid,fprojectid,ftracknumberid,fconfiguredcodeid,fcalrangeid,");
        entryInsertSql.append("fcaldimensionid,faccounttype,fadjustamt,FDiff_G,FDiff_H,");
        entryInsertSql.append("FDiff_K,FDiff_P,FDiff_Q,FDiff_R,FDiff_M,");
        entryInsertSql.append("FDiff_S,FDiff_T,FDiff_C,FDiff_X,FDiff_W,");
        entryInsertSql.append("FDiff_Y,finvbillid,finvbillentryid,finvbillnum,finvbizentityobject,");
        entryInsertSql.append("finventryseq,finvbizdate,finvauditdate,fsrcbillid,fsrcbillnum,");
        entryInsertSql.append("fsrcbillentryid,fsrcentryseq,fsrcbizentityobject,finvbiztypeid,ftranstype,");
        entryInsertSql.append("fqueuetype,fsignnum,fsubentryentity,fentrystatus,fecalstatus,");
        entryInsertSql.append("fecostcenterid,fproductlineid,fnoupdatecalfields,fstocktypeid");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",").append(this.entityExInfos.get(index).getDbField());
        }
        entryInsertSql.append(")");
        entryInsertSql.append("values(?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,?,?,?,?,?,?,?,");
        entryInsertSql.append("?,?,?,'C','A',?,?,?,?");
        for (index = 0; index < this.entityExInfos.size(); ++index) {
            entryInsertSql.append(",?");
        }
        entryInsertSql.append(")");
        DBRoute route = new DBRoute("cal");
        ArrayList<Object[]> heads = new ArrayList<Object[]>(16);
        ArrayList<Object[]> heads_l = new ArrayList<Object[]>(16);
        HashSet<Object[]> entrys = new HashSet<Object[]>(16);
        for (Map.Entry<String, List<StdCostDiffBillModel>> stdCostDiffBillModelsMap : stdCostDiffBills.entrySet()) {
            for (StdCostDiffBillModel stdCostDiffBillModel : stdCostDiffBillModelsMap.getValue()) {
                heads.add(stdCostDiffBillModel.getHeaders());
                heads_l.add(stdCostDiffBillModel.getHeaders_l());
                entrys.addAll(stdCostDiffBillModel.getEntrys().values());
            }
        }
        Lists.partition(heads, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql.toString(), (List)list);
            }
        });
        Lists.partition(heads_l, (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)headInsertSql_l.toString(), (List)list);
            }
        });
        Lists.partition((List)Lists.newArrayList(entrys), (int)batch_size).forEach(list -> {
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)route, (String)entryInsertSql.toString(), (List)list);
            }
        });
    }

    private Object dealJsonData(Object val, Object[] detailVals) {
        if (val == null) {
            JSONObject valJson = new JSONObject();
            JSONArray datas = new JSONArray();
            datas.add((Object)detailVals);
            valJson.put("data", (Object)datas);
            valJson.put("index", JSON.toJSON((Object)indexStrs));
            val = valJson.toJSONString();
        } else {
            JSONObject vaJson = JSON.parseObject((String)val.toString());
            JSONArray data = vaJson.getJSONArray("data");
            data.add((Object)detailVals);
            val = vaJson.toString();
        }
        return val;
    }

    private String getStdCostDiffBillHeadKey(LocalRow row, Map<Long, DynamicObject> entryIdAndCostRecordEntry) {
        StringBuilder headKey = new StringBuilder();
        Long headid = row.getHeadid();
        Long entryId = row.getEntryId();
        Long materialId = entryIdAndCostRecordEntry.get(entryId).getLong("entry.material");
        headKey.append(headid).append("#");
        headKey.append(materialId);
        return headKey.toString();
    }

    private String createBillNo(DynamicObject bill, String orgId) {
        String billNo = CodeRuleServiceHelper.getNumber(null, (DynamicObject)bill, (String)orgId);
        if (StringUtils.isEmpty((String)billNo) || "".equals(billNo.trim())) {
            billNo = String.valueOf(System.currentTimeMillis());
        }
        return billNo;
    }

    public void auditCostAdjust(Long[] newDiffBills, List<CostAdjustDetailParams> paramsList) {
        if (newDiffBills == null || newDiffBills.length == 0) {
            return;
        }
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])newDiffBills, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            String errorMsg = result.getMessage();
            if (!StringUtils.isBlank((String)errorMsg)) {
                msg.append(errorMsg);
            }
            List errors = result.getAllErrorOrValidateInfo();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
    }
}

