/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.BalanceDimFieldParser;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.function.DealUnDiffBillReduceFunction;
import kd.fi.calx.algox.diff.function.DealUnDiffNoUpdateReduceFunction;
import kd.fi.calx.algox.diff.function.DiffAllocDebugFunction;
import kd.fi.calx.algox.diff.function.FilterByAllocDimValsFunctionNew;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.JsonEntryServiceHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.ArrayUtils;

public class NewUnDiffAllocStdBillHelper {
    private static final Log logger = LogFactory.getLog(NewUnDiffAllocStdBillHelper.class);
    private static final String[] DIFF_ADJUSTBILL_CREATETYPE = new String[]{"B", "D", "I", "B-A1", "U", "J"};
    private BalanceDimFieldParser balanceDimFieldParser = new BalanceDimFieldParser();
    private Set<String> dimFields = this.balanceDimFieldParser.getDimFields();
    private RowMeta newdDiffDataMeta;
    private RowMeta costRecordDataMeta;
    private RowMeta balanceDataMeta;

    public NewUnDiffAllocStdBillHelper() {
        this.buildNewdDiffDataMeta();
        this.buildCostRecordDataMeta();
        this.buildBlanceDataMeta();
    }

    public void dealUnDiffAllocWizardCostAdjust(DiffAllocParamterEntry paramEntry, DiffAllocParamter param) {
        String loggerKey = "NewUnDiffAllocStdBillHelper->";
        Long calOrgId = paramEntry.getCalOrgId();
        AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
        boolean isundiffalloc = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"isundiffalloc");
        if (!isundiffalloc) {
            return;
        }
        Long costAccountId = paramEntry.getCostAccountId();
        Long periodId = paramEntry.getPeriodId();
        if (null == costAccountId || null == periodId || costAccountId == 0L || periodId == 0L) {
            logger.info(loggerKey + "costAccountId or periodId is null");
            return;
        }
        Long calRangeId = paramEntry.getCalRangeId();
        Set<Object> matIdSet = paramEntry.getMatIdSet();
        logger.info(loggerKey + "matIdSet:" + matIdSet);
        DataSet oldDiffDataSet = this.getOldDiffBillDataSet(paramEntry, calRangeId, matIdSet);
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        HashSet<Long> recordIds = new HashSet<Long>(16);
        for (Row row : oldDiffDataSet) {
            recordEntryIds.add(row.getLong("invbillentryid"));
            recordIds.add(row.getLong("invbillid"));
        }
        if (recordEntryIds.isEmpty() || recordIds.isEmpty()) {
            return;
        }
        String diffalloccols = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"diffalloccols");
        logger.info(loggerKey + "diffalloccols:" + diffalloccols);
        StringBuilder diffsb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)diffalloccols)) {
            String[] diffallos;
            for (String diffallo : diffallos = diffalloccols.split(",")) {
                if (StringUtils.isEmpty((String)diffallo)) continue;
                diffsb.append(diffallo);
                diffsb.append(",");
            }
        }
        JobSession session = AlgoX.createSession((String)"kd.fi.calx.algox.diff.helper.NewUnDiffAllocStdBillHelper");
        ExFieldHelper exFieldHelper = new ExFieldHelper();
        DataSetX oldDiffBillDataSet = this.getOldDiffBillInputDataSetX(paramEntry, calRangeId, matIdSet, session, exFieldHelper);
        oldDiffBillDataSet = oldDiffBillDataSet.filter((FilterFunction)new FilterByAllocDimValsFunctionNew(oldDiffBillDataSet.getRowMeta(), param, paramEntry));
        oldDiffBillDataSet = this.printDataSetX(oldDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>oldDiffBillDataSet1");
        oldDiffBillDataSet = oldDiffBillDataSet.groupBy("costaccount,material".split(",")).reduceGroup((GroupReduceFunction)new DealUnDiffNoUpdateReduceFunction(oldDiffBillDataSet.getRowMeta()));
        oldDiffBillDataSet = this.printDataSetX(oldDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>oldDiffBillDataSet2");
        DataSetX newdDiffBillDataSet = session.fromInput(this.getNewEdDiffBillInput(paramEntry, calRangeId, matIdSet));
        ArrayList<Field> repeatfields = new ArrayList<Field>(16);
        ArrayList<String> repeatvalues = new ArrayList<String>(16);
        repeatfields.add(new Field("hasconsonle", (DataType)DataType.StringType));
        repeatvalues.add("1");
        newdDiffBillDataSet = newdDiffBillDataSet.addFields(repeatfields.toArray(new Field[0]), repeatvalues.toArray());
        newdDiffBillDataSet = this.printDataSetX(newdDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>newdDiffBillDataSet");
        oldDiffBillDataSet = oldDiffBillDataSet.leftJoin(newdDiffBillDataSet).on("id", "srcbillid").on("entryid", "srcbillentryid").select(oldDiffBillDataSet.getRowMeta().getFieldNames(), new String[]{"hasconsonle"});
        oldDiffBillDataSet = this.printDataSetX(oldDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>oldDiffBillDataSet3");
        oldDiffBillDataSet = oldDiffBillDataSet.filter("hasconsonle is null");
        DataSetX inRecordSet = session.fromInput(this.getCostRecordBaseqtyInput(recordEntryIds, recordIds));
        inRecordSet = this.printDataSetX(inRecordSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>inRecordSet");
        String[] joinDims = new String[]{"calorg", "material"};
        if (diffsb.length() > 0) {
            diffalloccols = diffsb.append("material").toString();
            joinDims = diffalloccols.split(",");
        }
        String[] leftFields = oldDiffBillDataSet.getRowMeta().getFieldNames();
        String[] rightFields = new String[]{"baseqty"};
        oldDiffBillDataSet = oldDiffBillDataSet.leftJoin(inRecordSet).on("invbillentryid", "entryid").select(leftFields, rightFields);
        DataSetX unRepeatBillDataSet = oldDiffBillDataSet.groupBy(ArrayUtils.concatAll(new String[]{"invbillentryid", "createtype"}, new String[][]{joinDims})).max("baseqty");
        DataSetX inSumAdjustSet = unRepeatBillDataSet.groupBy(ArrayUtils.concatAll(new String[]{"createtype"}, new String[][]{joinDims})).sum("baseqty");
        String[] fieldNames = oldDiffBillDataSet.getRowMeta().getFieldNames();
        StringBuilder fieldNameSb = new StringBuilder();
        for (String fieldName : fieldNames) {
            if (!StringUtils.isNotEmpty((String)fieldName) || "baseqty".equals(fieldName)) continue;
            fieldNameSb.append(fieldName);
            fieldNameSb.append(",");
        }
        String fieldNameStr = fieldNameSb.substring(0, fieldNameSb.length() - 1);
        JoinDataSetX joinAdjustSet = oldDiffBillDataSet.leftJoin(inSumAdjustSet);
        joinAdjustSet = this.joinOnSelectDims(joinAdjustSet, ArrayUtils.concatAll(new String[]{"createtype"}, new String[][]{joinDims}));
        oldDiffBillDataSet = joinAdjustSet.select(fieldNameStr.split(","), new String[]{"baseqty"});
        oldDiffBillDataSet = this.printDataSetX(oldDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>oldDiffBillDataSet4");
        oldDiffBillDataSet = this.getBalanceSetQty(calRangeId, periodId, costAccountId, oldDiffBillDataSet, matIdSet, joinDims, session);
        oldDiffBillDataSet = this.printDataSetX(oldDiffBillDataSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>oldDiffBillDataSet5");
        oldDiffBillDataSet = oldDiffBillDataSet.filter("baseqty > periodendqty or periodendqty is null");
        int batch_size = CalDbParamServiceHelper.getInteger(CalDbParamConstant.BALUPDATE_BATCHSIZE);
        oldDiffBillDataSet = oldDiffBillDataSet.groupBy(new String[]{"material"}).reduceGroup((GroupReduceFunction)new DealUnDiffBillReduceFunction(oldDiffBillDataSet.getRowMeta(), batch_size, exFieldHelper.getEntityExInfos("cal_stdcostdiffbill")));
        DataSetOutput resultSet = new DataSetOutput(oldDiffBillDataSet.getRowMeta());
        oldDiffBillDataSet.output((Output)resultSet);
        String resultId = resultSet.getId();
        session.commit(60, TimeUnit.MINUTES);
        DataSet dataSet = session.readDataSet(resultId);
        HashSet<Long> newIdSet = new HashSet<Long>(16);
        for (Row row : dataSet) {
            String[] idStrs;
            String ids = row.getString("hasconsonle");
            if (!StringUtils.isNotEmpty((String)ids)) continue;
            for (String id : idStrs = ids.split(",")) {
                if (!StringUtils.isNotEmpty((String)id)) continue;
                newIdSet.add(Long.parseLong(id));
            }
        }
        if (newIdSet.size() > 0) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("createtype", "W");
            Lists.partition((List)Lists.newArrayList(newIdSet), (int)1000).forEach(list -> OperationServiceHelper.executeOperate((String)"updatebal", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)operateOption));
            String isGroupDiffBill = CalDbParamServiceHelper.getString("isgroupdiffbill", null);
            if ("true".equals(isGroupDiffBill)) {
                HashMap<String, HashSet<Long>> diffBillIdMap = new HashMap<String, HashSet<Long>>(16);
                diffBillIdMap.put("diffbillid", newIdSet);
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"createDiffGroupBill", (Object[])new Object[]{diffBillIdMap});
            }
        }
    }

    private DataSetX getOldDiffBillInputDataSetX(DiffAllocParamterEntry paramEntry, Long calRangeId, Set<Object> allMatIDs, JobSession session, ExFieldHelper exFieldHelper) {
        QFilter filter = new QFilter("createtype", "in", (Object)DIFF_ADJUSTBILL_CREATETYPE);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(paramEntry.getCostAccountId());
        if (currentPeriod != null) {
            Date beginDate = currentPeriod.getDate("begindate");
            filter.and("entryentity.invbizdate", "<", (Object)beginDate);
        }
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (allMatIDs != null && allMatIDs.size() > 0) {
            filter.and("entryentity.material", "in", allMatIDs);
        }
        filter.and("ischargeoff", "=", (Object)false);
        filter.and("ischargeoffed", "=", (Object)false);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        String selectAllStr = this.getCostAdjustBizField();
        List<String> extFieldSet = exFieldHelper.getExFieldSet();
        StringBuilder sb = new StringBuilder();
        if (extFieldSet != null && !extFieldSet.isEmpty()) {
            for (String extField : extFieldSet) {
                IDataEntityProperty property;
                if (selectAllStr.contains(extField) || (property = entityType.findProperty(extField)) == null) continue;
                IDataEntityType parentProp = property.getParent();
                boolean isEntryProp = parentProp instanceof EntryType;
                sb.append(',');
                if (isEntryProp) {
                    sb.append(parentProp.getName());
                    sb.append('.');
                }
                sb.append(extField);
                sb.append(" as ");
                sb.append(extField);
            }
        }
        if (sb.length() > 0) {
            StringBuilder selectSb = new StringBuilder();
            selectSb.append(selectAllStr);
            selectSb.append((CharSequence)sb);
            selectAllStr = selectSb.toString();
        }
        DataSetX oldDiffBillDataSetX = JsonEntryServiceHelper.queryDataSetX(this.getClass().getName(), session, "cal_stdcostdiffbill", selectAllStr, "entryentity.subentryentity", filter.toArray(), null);
        return oldDiffBillDataSetX;
    }

    private Input[] getCostRecordBaseqtyInput(Set<Long> recordEntryIds, Set<Long> recordIds) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        QFilter recordFilter = new QFilter("entry.id", "in", recordEntryIds);
        if (recordIds != null && recordIds.size() > 0) {
            recordFilter.and("id", "in", recordIds);
        }
        inputList.add(new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", "entry.id as entryid,entry.baseqty as baseqty", recordFilter.toArray(), this.costRecordDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private Input[] getNewEdDiffBillInput(DiffAllocParamterEntry paramEntry, Long calRangeId, Set<Object> allMatIDs) {
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        QFilter filter = new QFilter("createtype", "=", (Object)Character.valueOf('W'));
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (allMatIDs != null && allMatIDs.size() > 0) {
            filter.and("entryentity.material", "in", allMatIDs);
        }
        inputList.add(new OrmInput(this.getClass().getName(), "cal_stdcostdiffbill", "entryentity.srcbillid as srcbillid,entryentity.srcbillentryid as srcbillentryid", filter.toArray(), this.newdDiffDataMeta));
        return inputList.toArray(new Input[inputList.size()]);
    }

    private String getCostAdjustBizField() {
        StringBuilder select = new StringBuilder();
        String costAdjustFields = this.balanceDimFieldParser.getDetailDimFields("cal_stdcostdiffbill", "entryentity");
        select.append(costAdjustFields);
        select.append("id as id,billno as billno,entryentity.id as entryid,entryentity.seq as seq,calorg as calorg");
        select.append(",billstatus as billstatus,createtype as createtype,entryentity.adjustamt as adjustamt,period as period");
        select.append(",entryentity.diff_g as diff_g,entryentity.diff_h as diff_h,entryentity.diff_k as diff_k");
        select.append(",entryentity.diff_p as diff_p,entryentity.diff_q as diff_q,entryentity.diff_r as diff_r");
        select.append(",entryentity.diff_m as diff_m,entryentity.diff_s as diff_s,entryentity.diff_t as diff_t");
        select.append(",entryentity.diff_c as diff_c,entryentity.diff_x as diff_x,entryentity.diff_w as diff_w");
        select.append(",entryentity.diff_y as diff_y");
        select.append(",currency as currency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision");
        select.append(",entryentity.accounttype as accounttype,entryentity.invbizdate as invbizdate,entryentity.calrange as calrange");
        select.append(",entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid,entryentity.caldimension as caldimension,entryentity.noupdatecalfields as noupdatecalfields,entryentity.stocktype as stocktype,entryentity.subentryentity.costelement as costelement,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt as sub_adjustamt,entryentity.subentryentity.ddiff_g as ddiff_g,entryentity.subentryentity.ddiff_p as ddiff_p,entryentity.subentryentity.ddiff_q as ddiff_q,entryentity.subentryentity.ddiff_r as ddiff_r,entryentity.subentryentity.ddiff_m as ddiff_m,entryentity.subentryentity.ddiff_s as ddiff_s,entryentity.subentryentity.ddiff_t as ddiff_t,entryentity.subentryentity.ddiff_c as ddiff_c,entryentity.subentryentity.ddiff_x as ddiff_x,entryentity.subentryentity.ddiff_w as ddiff_w,entryentity.subentryentity.ddiff_y as ddiff_y,entryentity.subentryentity.ddiff_h as ddiff_h,entryentity.subentryentity.ddiff_k as ddiff_k,biztype as biztype,billtype as billtype,adminorg as adminorg,bizdate as bizdate,bookdate as bookdate,custsupplier as custsupplier,cstype as cstype,entryentity.baseunit as baseunit,entryentity.ecostcenter as ecostcenter,entryentity.invauditdate as invauditdate,entryentity.invbilltype as invbilltype,entryentity.invbiztype as invbiztype,entryentity.invbillnum as invbillnum,entryentity.inventryseq as inventryseq,entryentity.feeprojectid as feeprojectid,entryentity.productline as productline,entryentity.queuetype as queuetype,entryentity.signnum as signnum");
        return select.toString();
    }

    private JoinDataSetX joinOnSelectDims(JoinDataSetX joinDataSet, String[] joinDims) {
        for (String joinDim : joinDims) {
            joinDataSet = joinDataSet.on(joinDim, joinDim);
        }
        return joinDataSet;
    }

    private DataSetX getBalanceSetQty(Long calRangeId, Long periodId, Long costaccountId, DataSetX inAllAdjustSet, Set<Object> materialEntryIds, String[] joinDims, JobSession session) {
        DynamicObject currentPeriod;
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        if (materialEntryIds != null && materialEntryIds.size() > 0) {
            filter.and("material", "in", materialEntryIds);
        }
        if ((currentPeriod = PeriodHelper.getCurrentPeriod(costaccountId)) != null) {
            int periodNum = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
            filter.and("period", "<", (Object)periodNum);
            filter.and("endperiod", ">=", (Object)periodNum);
        }
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("calrange", "=", (Object)calRangeId);
        }
        filter.and("accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        ArrayList<OrmInput> inputList = new ArrayList<OrmInput>();
        inputList.add(new OrmInput(this.getClass().getName(), "cal_bal", this.getBalanceBizField(), filter.toArray(), this.balanceDataMeta));
        DataSetX balanceSet = session.fromInput(inputList.toArray(new Input[inputList.size()]));
        balanceSet = this.groupIgnoreElement(balanceSet);
        balanceSet = balanceSet.groupBy(joinDims).sum("periodendqty");
        balanceSet = this.printDataSetX(balanceSet, "NewUnDiffAllocStdBillHelper.dealUnDiffAllocWizardCostAdjust\u2014>balanceSet");
        JoinDataSetX joinDataSet = inAllAdjustSet.leftJoin(balanceSet);
        joinDataSet = this.joinOnSelectDims(joinDataSet, joinDims);
        inAllAdjustSet = joinDataSet.select(inAllAdjustSet.getRowMeta().getFieldNames(), new String[]{"periodendqty"});
        return inAllAdjustSet;
    }

    private String getBalanceBizField() {
        StringBuilder select = new StringBuilder();
        for (String dimField : this.dimFields) {
            select.append(dimField).append(",");
        }
        select.append("period,period as periodid,baseqty_bal as periodendqty,calorg");
        return select.toString();
    }

    private DataSetX groupIgnoreElement(DataSetX balanceSet) {
        StringBuilder groupFields = new StringBuilder();
        for (String dimField : this.dimFields) {
            if ("costsubelement".equals(dimField) || "costelement".equals(dimField)) continue;
            groupFields.append(dimField).append(",");
        }
        groupFields.append("period,periodid,calorg");
        boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        balanceSet = balCompress ? balanceSet.groupBy(groupFields.toString().split(",")).sum("periodendqty") : balanceSet.groupBy(groupFields.toString().split(",")).max("periodendqty");
        return balanceSet;
    }

    private void buildNewdDiffDataMeta() {
        this.newdDiffDataMeta = ORM.create().createRowMeta("cal_stdcostdiffbill", "entryentity.srcbillid as srcbillid,entryentity.srcbillentryid as srcbillentryid");
    }

    private void buildCostRecordDataMeta() {
        this.costRecordDataMeta = ORM.create().createRowMeta("cal_costrecord_subentity", "entry.id as entryid,entry.baseqty as baseqty");
    }

    private void buildBlanceDataMeta() {
        this.balanceDataMeta = ORM.create().createRowMeta("cal_bal", this.getBalanceBizField());
    }

    private DataSetX printDataSetX(DataSetX dataSetX, String logDesc) {
        if (!CalDbParamServiceHelper.getBoolean(CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return dataSetX;
        }
        DiffAllocDebugFunction debugFunction = new DiffAllocDebugFunction(dataSetX.getRowMeta(), logDesc);
        dataSetX = dataSetX.reduceGroup((GroupReduceFunction)debugFunction);
        return dataSetX;
    }

    private DataSet getOldDiffBillDataSet(DiffAllocParamterEntry paramEntry, Long calRangeId, Set<Object> allMatIDs) {
        QFilter filter = new QFilter("createtype", "in", (Object)DIFF_ADJUSTBILL_CREATETYPE);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(paramEntry.getCostAccountId());
        if (currentPeriod != null) {
            Date beginDate = currentPeriod.getDate("begindate");
            filter.and("entryentity.invbizdate", "<", (Object)beginDate);
        }
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (allMatIDs != null && allMatIDs.size() > 0) {
            filter.and("entryentity.material", "in", allMatIDs);
        }
        filter.and("ischargeoff", "=", (Object)false);
        filter.and("ischargeoffed", "=", (Object)false);
        DataSet oldDiffBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)"entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid", (QFilter[])filter.toArray(), null);
        return oldDiffBillDataSet;
    }
}

