/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.BalanceDimFieldParser;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.CostAdjustDetailParams;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.function.DealAlgoNoUpdateCalFields;
import kd.fi.calx.algox.diff.function.FilterDataSetFunctionNew;
import kd.fi.calx.algox.diff.helper.CalStdcostdiffbillHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CommonSettingHelper;
import kd.fi.calx.algox.helper.PeriodHelper;
import kd.fi.calx.algox.util.ArrayUtils;

public class OldUnDiffAllocStdBillHelper {
    private static final Log logger = LogFactory.getLog(OldUnDiffAllocStdBillHelper.class);
    private static final String[] DIFF_ADJUSTBILL_CREATETYPE = new String[]{"B", "D", "I", "B-A1", "U", "J"};
    private static final String[] DIFF_TYPES = new String[]{"G", "H", "K", "P", "Q", "R", "M", "S", "T", "C", "W", "X", "Y"};
    private static final String[] AMT_FIELDS = new String[]{"diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y"};
    private BalanceDimFieldParser balanceDimFieldParser = new BalanceDimFieldParser();
    private Set<String> dimFields = this.balanceDimFieldParser.getDimFields();
    private Set<Long> oldDiffBillIdSet = new HashSet<Long>(16);
    private Map<String, BigDecimal> oldAdjEntryRateMap = new HashMap<String, BigDecimal>(16);

    public void dealUnDiffAllocWizardCostAdjust(DiffAllocParamterEntry paramEntry, DiffAllocParamter param) {
        String loggerKey = "OldUnDiffAllocStdBillHelper_>";
        Long calOrgId = paramEntry.getCalOrgId();
        AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
        boolean isundiffalloc = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"isundiffalloc");
        logger.info(loggerKey + "isundiffalloc\uff1a" + isundiffalloc);
        if (!isundiffalloc) {
            return;
        }
        Long costAccountId = paramEntry.getCostAccountId();
        Long periodId = paramEntry.getPeriodId();
        if (null == costAccountId || null == periodId || costAccountId == 0L || periodId == 0L) {
            logger.info(loggerKey + "costAccountId or periodId is null");
            return;
        }
        String diffalloccols = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"diffalloccols");
        logger.info(loggerKey + "diffalloccols:" + diffalloccols);
        StringBuilder diffsb = new StringBuilder();
        if (!StringUtils.isEmpty((String)diffalloccols)) {
            String[] diffallos;
            for (String diffallo : diffallos = diffalloccols.split(",")) {
                if (StringUtils.isEmpty((String)diffallo)) continue;
                diffsb.append(diffallo);
                diffsb.append(",");
            }
        }
        Long calRangeId = paramEntry.getCalRangeId();
        Set<Object> matIdSet = paramEntry.getMatIdSet();
        logger.info(loggerKey + "matIdSet:" + matIdSet);
        DataSet oldDiffBillDataSet = this.getOldDiffBillDataSet(paramEntry, calRangeId, matIdSet);
        oldDiffBillDataSet = oldDiffBillDataSet.filter((FilterFunction)new FilterDataSetFunctionNew(oldDiffBillDataSet.getRowMeta(), param, paramEntry, ""));
        oldDiffBillDataSet = oldDiffBillDataSet.reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(oldDiffBillDataSet.getRowMeta()));
        HashSet<Long> recordEntryIds = new HashSet<Long>(16);
        HashSet<Long> materialEntryIds = new HashSet<Long>(16);
        HashSet<Long> recordIds = new HashSet<Long>(16);
        HashSet<Long> oldCostAdjustIds = new HashSet<Long>(16);
        HashSet<Long> oldCostAdjustentryIds = new HashSet<Long>(16);
        for (Row row : oldDiffBillDataSet.copy()) {
            recordEntryIds.add(row.getLong("invbillentryid"));
            materialEntryIds.add(row.getLong("material"));
            recordIds.add(row.getLong("invbillid"));
            oldCostAdjustIds.add(row.getLong("id"));
            oldCostAdjustentryIds.add(row.getLong("entryid"));
        }
        logger.info(loggerKey + "oldDiffBillDataSet0");
        if (!recordEntryIds.isEmpty()) {
            HashSet<Long> hasoldCostAdjustIds = new HashSet<Long>(16);
            HashSet<Long> hasoldCostAdjustentryIds = new HashSet<Long>(16);
            if (!oldCostAdjustIds.isEmpty()) {
                QFilter qFilter = new QFilter("createtype", "=", (Object)Character.valueOf('W'));
                qFilter.and("entryentity.srcbillid", "in", oldCostAdjustIds);
                qFilter.and("entryentity.srcbillentryid", "in", oldCostAdjustentryIds);
                DataSet oldDiffBillDataSett = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)"id,entryentity.srcbillid,entryentity.srcbillentryid", (QFilter[])qFilter.toArray(), null);
                for (Row tt : oldDiffBillDataSett) {
                    hasoldCostAdjustIds.add(tt.getLong("entryentity.srcbillid"));
                    hasoldCostAdjustentryIds.add(tt.getLong("entryentity.srcbillentryid"));
                }
            }
            DataSet inRecordSet = this.getCostRecordBaseqty(recordEntryIds, recordIds);
            String[] joinDims = new String[]{"calorg", "material"};
            if (diffsb.length() > 0) {
                diffalloccols = diffsb.append("material").toString();
                joinDims = diffalloccols.split(",");
            }
            String[] leftFields = ArrayUtils.concatAll(new String[]{"id", "entryid", "invbillentryid", "createtype", "accounttype", "periodid", "entryseq", "adjustamt", "diff_g", "diff_h", "diff_k", "diff_p", "diff_q", "diff_r", "diff_m", "diff_s", "diff_t", "diff_c", "diff_x", "diff_w", "diff_y", "invbizdate", "amtprecision"}, new String[][]{joinDims});
            String[] rightFields = new String[]{"baseqty"};
            oldDiffBillDataSet = oldDiffBillDataSet.leftJoin(inRecordSet).on("invbillentryid", "entryid").select(leftFields, rightFields).finish();
            DataSet unRepeatBillDataSet = oldDiffBillDataSet.groupBy(ArrayUtils.concatAll(new String[]{"invbillentryid", "createtype"}, new String[][]{joinDims})).max("baseqty").finish();
            logger.info(loggerKey + "oldDiffBillDataSet1");
            DataSet inSumAdjustSet = unRepeatBillDataSet.groupBy(ArrayUtils.concatAll(new String[]{"createtype"}, new String[][]{joinDims})).sum("baseqty").finish();
            JoinDataSet joinAdjustSet = oldDiffBillDataSet.leftJoin(inSumAdjustSet);
            joinAdjustSet = this.joinOnSelectDims(joinAdjustSet, ArrayUtils.concatAll(new String[]{"createtype"}, new String[][]{joinDims}));
            oldDiffBillDataSet = joinAdjustSet.select(oldDiffBillDataSet.getRowMeta().getFieldNames(), new String[]{"baseqty as  totaladjustqty"}).finish();
            logger.info(loggerKey + "oldDiffBillDataSet2");
            oldDiffBillDataSet = this.getBalanceSetQty(calRangeId, periodId, costAccountId, oldDiffBillDataSet, materialEntryIds, joinDims);
            ArrayList<Object> newDiffBillList = new ArrayList<DynamicObject>(200);
            oldDiffBillDataSet = oldDiffBillDataSet.filter("totaladjustqty > periodendqty or periodendqty is null");
            for (Object row : oldDiffBillDataSet) {
                DiffAllocHelper.writeLog(logger, loggerKey + "oldDiffBillDataSet3");
                Long l = row.getLong("id");
                Long entryid = row.getLong("entryid");
                if (!hasoldCostAdjustIds.isEmpty() && hasoldCostAdjustIds.contains(l) && !hasoldCostAdjustentryIds.isEmpty() && hasoldCostAdjustentryIds.contains(entryid)) continue;
                this.dealUnDiffBillOutCost((Row)row, newDiffBillList);
                if (newDiffBillList.size() <= 100) continue;
                if (newDiffBillList != null && newDiffBillList.size() > 0) {
                    DiffAllocHelper.writeLog(logger, loggerKey + "newDiffBillList=" + newDiffBillList.size());
                    SaveServiceHelper.save((DynamicObject[])newDiffBillList.toArray(new DynamicObject[newDiffBillList.size()]));
                    HashSet<Long> newDiffBillIdset = new HashSet<Long>(newDiffBillList.size());
                    for (DynamicObject dynamicObject : newDiffBillList) {
                        newDiffBillIdset.add(dynamicObject.getLong("id"));
                    }
                    DiffAllocHelper.writeLog(logger, loggerKey + "newDiffBillIdset=" + newDiffBillIdset);
                    DynamicObject[] newDiffBills = BusinessDataServiceHelper.load((Object[])newDiffBillIdset.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
                    DiffAllocHelper.writeLog(logger, loggerKey + "oldDiffBillIdSet=" + this.oldDiffBillIdSet);
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])this.oldDiffBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
                    Map<Long, DynamicObject> oldAdjEntryInfoMap = this.getOldAdjEntryInfoMap(dynamicObjectArray);
                    List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(newDiffBills, oldAdjEntryInfoMap);
                    this.auditCostAdjust(newDiffBills, paramsList);
                    if (this.oldDiffBillIdSet != null && this.oldDiffBillIdSet.size() > 0) {
                        this.oldDiffBillIdSet.clear();
                    }
                }
                newDiffBillList = new ArrayList(16);
            }
            if (newDiffBillList.size() > 0) {
                logger.info(loggerKey + "newDiffBillList=" + newDiffBillList.size());
                SaveServiceHelper.save((DynamicObject[])newDiffBillList.toArray(new DynamicObject[newDiffBillList.size()]));
                HashSet<Long> newDiffBillIdset = new HashSet<Long>(newDiffBillList.size());
                for (DynamicObject dynamicObject : newDiffBillList) {
                    newDiffBillIdset.add(dynamicObject.getLong("id"));
                }
                logger.info(loggerKey + "newDiffBillIdset=" + newDiffBillIdset);
                DynamicObject[] newDiffBills = BusinessDataServiceHelper.load((Object[])newDiffBillIdset.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
                logger.info(loggerKey + "oldDiffBillIdSet=" + this.oldDiffBillIdSet);
                if (this.oldDiffBillIdSet != null && this.oldDiffBillIdSet.size() > 0) {
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])this.oldDiffBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
                    Map<Long, DynamicObject> oldAdjEntryInfoMap = this.getOldAdjEntryInfoMap(dynamicObjectArray);
                    List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(newDiffBills, oldAdjEntryInfoMap);
                    this.auditCostAdjust(newDiffBills, paramsList);
                    this.oldDiffBillIdSet.clear();
                }
            }
        }
    }

    private void auditCostAdjust(DynamicObject[] newDiffBills, List<CostAdjustDetailParams> paramsList) {
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper__> newDiffBills params:" + params);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])newDiffBills, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"GPAPrevCostAdjustHelper_1", (String)"fi-calx-algox", (Object[])new Object[0]));
            String errorMsg = result.getMessage();
            if (!StringUtils.isBlank((String)errorMsg)) {
                msg.append(errorMsg);
            }
            List errors = result.getAllErrorOrValidateInfo();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            throw new KDBizException(msg.toString());
        }
    }

    private DataSet getOldDiffBillDataSet(DiffAllocParamterEntry paramEntry, Long calRangeId, Set<Object> allMatIDs) {
        QFilter filter = new QFilter("createtype", "in", (Object)DIFF_ADJUSTBILL_CREATETYPE);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        filter.and("costaccount", "=", (Object)paramEntry.getCostAccountId());
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(paramEntry.getCostAccountId());
        if (currentPeriod != null) {
            Date beginDate = currentPeriod.getDate("begindate");
            filter.and("entryentity.invbizdate", "<", (Object)beginDate);
        }
        filter.and("period", "=", (Object)paramEntry.getPeriodId());
        filter.and("bookdate", ">=", (Object)paramEntry.getStartDate());
        filter.and("bookdate", "<=", (Object)paramEntry.getEndDate());
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("entryentity.calrange", "=", (Object)calRangeId);
        }
        if (allMatIDs != null && allMatIDs.size() > 0) {
            filter.and("entryentity.material", "in", allMatIDs);
        }
        filter.and("ischargeoff", "=", (Object)false);
        filter.and("ischargeoffed", "=", (Object)false);
        DataSet oldDiffBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getCostAdjustBizField(), (QFilter[])filter.toArray(), null);
        return oldDiffBillDataSet;
    }

    private String getCostAdjustBizField() {
        StringBuilder select = new StringBuilder();
        String costAdjustFields = this.balanceDimFieldParser.getCostAdjustFields();
        select.append(costAdjustFields);
        select.append("id,billno,entryentity.id as entryid,entryentity.seq as entryseq,calorg");
        select.append(",isvoucher,TO_INT(period.periodyear*100+period.periodnumber) as periodid,billstatus,createtype,entryentity.adjustamt as adjustamt");
        select.append(",entryentity.diff_g as diff_g,entryentity.diff_h as diff_h,entryentity.diff_k as diff_k");
        select.append(",entryentity.diff_p as diff_p,entryentity.diff_q as diff_q,entryentity.diff_r as diff_r");
        select.append(",entryentity.diff_m as diff_m,entryentity.diff_s as diff_s,entryentity.diff_t as diff_t");
        select.append(",entryentity.diff_c as diff_c,entryentity.diff_x as diff_x,entryentity.diff_w as diff_w");
        select.append(",entryentity.diff_y as diff_y");
        select.append(",currency as localcurrency,currency.amtprecision as amtprecision,currency.priceprecision as priceprecision");
        select.append(",entryentity.accounttype as accounttype,entryentity.invbizdate as invbizdate,entryentity.calrange as calrange");
        select.append(",entryentity.invbillid as invbillid,entryentity.invbillentryid as invbillentryid,entryentity.caldimension as caldimension,entryentity.noupdatecalfields as noupdatecalfields,entryentity.stocktype as stocktype");
        return select.toString();
    }

    private DataSet getCostRecordBaseqty(Set<Long> recordEntryIds, Set<Long> recordIds) {
        QFilter recordFilter = new QFilter("entry.id", "in", recordEntryIds);
        if (recordIds != null && recordIds.size() > 0) {
            recordFilter.and("id", "in", recordIds);
        }
        String recordFields = "entry.id as entryid,entry.baseqty as baseqty";
        DataSet inRecordSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)recordFields, (QFilter[])recordFilter.toArray(), null);
        return inRecordSet;
    }

    private JoinDataSet joinOnSelectDims(JoinDataSet joinDataSet, String[] joinDims) {
        for (String joinDim : joinDims) {
            joinDataSet = joinDataSet.on(joinDim, joinDim);
        }
        return joinDataSet;
    }

    private DataSet getBalanceSetQty(Long calRangeId, Long periodId, Long costaccountId, DataSet inAllAdjustSet, Set<Long> materialEntryIds, String[] joinDims) {
        DynamicObject currentPeriod;
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        if (materialEntryIds != null && materialEntryIds.size() > 0) {
            filter.and("material", "in", materialEntryIds);
        }
        if ((currentPeriod = PeriodHelper.getCurrentPeriod(costaccountId)) != null) {
            int periodNum = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
            filter.and("period", "<", (Object)periodNum);
            filter.and("endperiod", ">=", (Object)periodNum);
        }
        if (calRangeId != null && calRangeId != 0L) {
            filter.and("calrange", "=", (Object)calRangeId);
        }
        filter.and("accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        DataSet balanceSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceEntity, (String)this.getBalanceBizField(), (QFilter[])filter.toArray(), null);
        if (CalBalanceModelHelper.isNewBalance()) {
            balanceSet = this.groupIgnoreElement(balanceSet);
        }
        balanceSet = balanceSet.groupBy(joinDims).sum("periodendqty").finish();
        JoinDataSet joinDataSet = inAllAdjustSet.join(balanceSet, JoinType.LEFT);
        joinDataSet = this.joinOnSelectDims(joinDataSet, joinDims);
        inAllAdjustSet = joinDataSet.select(inAllAdjustSet.getRowMeta().getFieldNames(), new String[]{"periodendqty"}).finish();
        return inAllAdjustSet;
    }

    private String getBalanceBizField() {
        StringBuilder select = new StringBuilder();
        for (String dimField : this.dimFields) {
            select.append(dimField).append(",");
        }
        if (CalBalanceModelHelper.isNewBalance()) {
            select.append("period,period as periodid,baseqty_bal as periodendqty");
        } else {
            select.append("period,period as periodid,periodendqty");
        }
        select.append(",calorg");
        return select.toString();
    }

    private DataSet groupIgnoreElement(DataSet balanceSet) {
        StringBuilder groupFields = new StringBuilder();
        for (String dimField : this.dimFields) {
            if ("costsubelement".equals(dimField) || "costelement".equals(dimField)) continue;
            groupFields.append(dimField).append(",");
        }
        groupFields.append("period,periodid,calorg");
        GroupbyDataSet groupByDataSet = balanceSet.groupBy(groupFields.toString().split(","));
        boolean balCompress = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (balCompress) {
            groupByDataSet.sum("periodendqty");
        } else {
            groupByDataSet.max("periodendqty");
        }
        balanceSet = groupByDataSet.finish().select(balanceSet.getRowMeta().getFieldNames());
        return balanceSet;
    }

    private void dealUnDiffBillOutCost(Row row, List<DynamicObject> outCostAdjustList) {
        BigDecimal outAdjustAmt = BigDecimal.ZERO;
        BigDecimal outdiff_g = BigDecimal.ZERO;
        BigDecimal outdiff_h = BigDecimal.ZERO;
        BigDecimal outdiff_k = BigDecimal.ZERO;
        BigDecimal outdiff_p = BigDecimal.ZERO;
        BigDecimal outdiff_q = BigDecimal.ZERO;
        BigDecimal outdiff_r = BigDecimal.ZERO;
        BigDecimal outdiff_m = BigDecimal.ZERO;
        BigDecimal outdiff_s = BigDecimal.ZERO;
        BigDecimal outdiff_t = BigDecimal.ZERO;
        BigDecimal outdiff_c = BigDecimal.ZERO;
        BigDecimal outdiff_x = BigDecimal.ZERO;
        BigDecimal outdiff_w = BigDecimal.ZERO;
        BigDecimal outdiff_y = BigDecimal.ZERO;
        BigDecimal totaladjustqty = row.getBigDecimal("totaladjustqty");
        if (totaladjustqty != null) {
            DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> totaladjustqty=" + totaladjustqty.doubleValue());
        }
        BigDecimal periodbeginqty = row.getBigDecimal("periodendqty");
        BigDecimal adjustcost = row.getBigDecimal("adjustamt");
        BigDecimal rate = BigDecimal.ONE;
        boolean isAllZero = true;
        for (String field : AMT_FIELDS) {
            BigDecimal fieldAmt = row.getBigDecimal(field);
            if (fieldAmt == null || fieldAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            isAllZero = false;
            break;
        }
        BigDecimal diff_g = row.getBigDecimal("diff_g");
        BigDecimal diff_h = row.getBigDecimal("diff_h");
        BigDecimal diff_k = row.getBigDecimal("diff_k");
        BigDecimal diff_p = row.getBigDecimal("diff_p");
        BigDecimal diff_q = row.getBigDecimal("diff_q");
        BigDecimal diff_r = row.getBigDecimal("diff_r");
        BigDecimal diff_m = row.getBigDecimal("diff_m");
        BigDecimal diff_s = row.getBigDecimal("diff_s");
        BigDecimal diff_t = row.getBigDecimal("diff_t");
        BigDecimal diff_c = row.getBigDecimal("diff_c");
        BigDecimal diff_x = row.getBigDecimal("diff_x");
        BigDecimal diff_w = row.getBigDecimal("diff_w");
        BigDecimal diff_y = row.getBigDecimal("diff_y");
        if (null == periodbeginqty || periodbeginqty.compareTo(BigDecimal.ZERO) <= 0) {
            DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> periodbeginqty is null or 0,adjustcost=" + adjustcost);
            if (!isAllZero) {
                outAdjustAmt = adjustcost.negate();
                outdiff_g = diff_g.negate();
                outdiff_h = diff_h.negate();
                outdiff_k = diff_k.negate();
                outdiff_p = diff_p.negate();
                outdiff_q = diff_q.negate();
                outdiff_r = diff_r.negate();
                outdiff_m = diff_m.negate();
                outdiff_s = diff_s.negate();
                outdiff_t = diff_t.negate();
                outdiff_c = diff_c.negate();
                outdiff_x = diff_x.negate();
                outdiff_w = diff_w.negate();
                outdiff_y = diff_y.negate();
                rate = rate.negate();
                DynamicObject outCostAdjustBill1 = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, true, rate);
                outCostAdjustList.add(outCostAdjustBill1);
                outAdjustAmt = adjustcost;
                outdiff_g = diff_g;
                outdiff_h = diff_h;
                outdiff_k = diff_k;
                outdiff_p = diff_p;
                outdiff_q = diff_q;
                outdiff_r = diff_r;
                outdiff_m = diff_m;
                outdiff_s = diff_s;
                outdiff_t = diff_t;
                outdiff_c = diff_c;
                outdiff_x = diff_x;
                outdiff_w = diff_w;
                outdiff_y = diff_y;
                rate = BigDecimal.ONE;
                DynamicObject outCostAdjustBill2 = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, false, rate);
                outCostAdjustList.add(outCostAdjustBill2);
            }
        } else {
            DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> periodbeginqty =" + periodbeginqty.doubleValue() + ",adjustcost=" + adjustcost);
            if (!isAllZero) {
                outAdjustAmt = adjustcost.negate();
                rate = rate.negate();
                outdiff_g = diff_g.negate();
                outdiff_h = diff_h.negate();
                outdiff_k = diff_k.negate();
                outdiff_p = diff_p.negate();
                outdiff_q = diff_q.negate();
                outdiff_r = diff_r.negate();
                outdiff_m = diff_m.negate();
                outdiff_s = diff_s.negate();
                outdiff_t = diff_t.negate();
                outdiff_c = diff_c.negate();
                outdiff_x = diff_x.negate();
                outdiff_w = diff_w.negate();
                outdiff_y = diff_y.negate();
                DynamicObject outCostAdjustBill1 = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, true, rate);
                outCostAdjustList.add(outCostAdjustBill1);
                outAdjustAmt = adjustcost.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_g = diff_g.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_h = diff_h.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_k = diff_k.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_p = diff_p.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_q = diff_q.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_r = diff_r.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_m = diff_m.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_s = diff_s.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_t = diff_t.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_c = diff_c.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_x = diff_x.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_w = diff_w.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                outdiff_y = diff_y.multiply(periodbeginqty).divide(totaladjustqty, (int)row.getInteger("amtprecision"), RoundingMode.HALF_UP);
                rate = periodbeginqty.divide(totaladjustqty, 10, RoundingMode.HALF_UP);
                if (outAdjustAmt.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObject outCostAdjustBill2 = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, true, rate);
                    outCostAdjustList.add(outCostAdjustBill2);
                }
                outAdjustAmt = adjustcost.subtract(outAdjustAmt);
                outdiff_g = diff_g.subtract(outdiff_g);
                outdiff_h = diff_h.subtract(outdiff_h);
                outdiff_k = diff_k.subtract(outdiff_k);
                outdiff_p = diff_p.subtract(outdiff_p);
                outdiff_q = diff_q.subtract(outdiff_q);
                outdiff_r = diff_r.subtract(outdiff_r);
                outdiff_m = diff_m.subtract(outdiff_m);
                outdiff_s = diff_s.subtract(outdiff_s);
                outdiff_t = diff_t.subtract(outdiff_t);
                outdiff_c = diff_c.subtract(outdiff_c);
                outdiff_x = diff_x.subtract(outdiff_x);
                outdiff_w = diff_w.subtract(outdiff_w);
                outdiff_y = diff_y.subtract(outdiff_y);
                rate = BigDecimal.ONE.subtract(rate);
                if (outAdjustAmt.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObject outCostAdjustBill3 = this.createCostAdjustBill(row.getLong("id"), row.getLong("invbillentryid"), outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, false, rate);
                    outCostAdjustList.add(outCostAdjustBill3);
                }
            }
        }
    }

    private DynamicObject createCostAdjustBill(Long adjustId, Long invenrtyid, BigDecimal outAdjustAmt, BigDecimal outdiff_g, BigDecimal outdiff_h, BigDecimal outdiff_k, BigDecimal outdiff_p, BigDecimal outdiff_q, BigDecimal outdiff_r, BigDecimal outdiff_m, BigDecimal outdiff_s, BigDecimal outdiff_t, BigDecimal outdiff_c, BigDecimal outdiff_x, BigDecimal outdiff_w, BigDecimal outdiff_y, boolean isupdatecost, BigDecimal rate) {
        DynamicObject costAdjustInfo = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"cal_stdcostdiffbill");
        DynamicObject outCostAdjustBill = this.createCostAdjustHead(costAdjustInfo, isupdatecost, rate);
        this.addCostAdjustBillEntry(invenrtyid, outAdjustAmt, outdiff_g, outdiff_h, outdiff_k, outdiff_p, outdiff_q, outdiff_r, outdiff_m, outdiff_s, outdiff_t, outdiff_c, outdiff_x, outdiff_w, outdiff_y, costAdjustInfo, outCostAdjustBill);
        return outCostAdjustBill;
    }

    private DynamicObject createCostAdjustHead(DynamicObject costAdjustInfo, boolean isupdatecost, BigDecimal rate) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        costAdjustBill.set("calorg", (Object)costAdjustInfo.getDynamicObject("calorg"));
        costAdjustBill.set("costaccount", (Object)costAdjustInfo.getDynamicObject("costaccount"));
        String number = this.createBillNo(costAdjustBill, String.valueOf(costAdjustInfo.getDynamicObject("calorg").getPkValue()));
        costAdjustBill.set("billno", (Object)number);
        this.oldAdjEntryRateMap.put(number, rate);
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("biztype", (Object)costAdjustInfo.getString("biztype"));
        costAdjustBill.set("billtype", (Object)costAdjustInfo.getDynamicObject("billtype"));
        costAdjustBill.set("currency", costAdjustInfo.get("currency"));
        costAdjustBill.set("period", costAdjustInfo.get("period"));
        costAdjustBill.set("createtype", (Object)"W");
        costAdjustBill.set("adminorg", (Object)costAdjustInfo.getDynamicObject("adminorg"));
        costAdjustBill.set("bizdate", (Object)costAdjustInfo.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)costAdjustInfo.getDate("bookdate"));
        Long userId = RequestContext.get().getCurrUserId();
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("creator", (Object)userId);
        costAdjustBill.set("createtime", (Object)date);
        costAdjustBill.set("modifier", (Object)userId);
        costAdjustBill.set("modifytime", (Object)date);
        costAdjustBill.set("auditor", (Object)userId);
        costAdjustBill.set("auditdate", (Object)date);
        costAdjustBill.set("isupdatecost", (Object)isupdatecost);
        costAdjustBill.set("remark", (Object)ResManager.loadKDString((String)"\u672a\u5206\u644a\u5dee\u5f02\u5dee\u5f02\u5206\u644a\u751f\u6210", (String)"UnDiffAllocWizardCostAdjustHelper_0", (String)"fi-calx-algox", (Object[])new Object[0]));
        costAdjustBill.set("billsrctype", (Object)"D");
        costAdjustBill.set("custsupplier", costAdjustInfo.get("custsupplier"));
        costAdjustBill.set("cstype", (Object)costAdjustInfo.getString("cstype"));
        return costAdjustBill;
    }

    private void addCostAdjustBillEntry(Long invenrtyid, BigDecimal outAdjustAmt, BigDecimal outdiff_g, BigDecimal outdiff_h, BigDecimal outdiff_k, BigDecimal outdiff_p, BigDecimal outdiff_q, BigDecimal outdiff_r, BigDecimal outdiff_m, BigDecimal outdiff_s, BigDecimal outdiff_t, BigDecimal outdiff_c, BigDecimal outdiff_x, BigDecimal outdiff_w, BigDecimal outdiff_y, DynamicObject costAdjustInfo, DynamicObject costAdjustBillHead) {
        DynamicObjectCollection costAdjustEntrys = costAdjustInfo.getDynamicObjectCollection("entryentity");
        DynamicObject costAdjustEntry = null;
        for (DynamicObject entry : costAdjustEntrys) {
            if (invenrtyid.compareTo(entry.getLong("invbillentryid")) != 0) continue;
            costAdjustEntry = entry;
            break;
        }
        if (costAdjustEntry == null) {
            return;
        }
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costAdjustEntry.get("storageorgunit"));
        entry.set("material", costAdjustEntry.get("material"));
        entry.set("mversion", costAdjustEntry.get("mversion"));
        entry.set("assist", costAdjustEntry.get("assist"));
        entry.set("lot", costAdjustEntry.get("lot"));
        entry.set("baseunit", costAdjustEntry.get("baseunit"));
        if (outAdjustAmt != null) {
            DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> addCostAdjustBillEntry outAdjustAmt=" + outAdjustAmt.doubleValue());
        }
        entry.set("adjustamt", (Object)outAdjustAmt);
        entry.set("diff_g", (Object)outdiff_g);
        entry.set("diff_h", (Object)outdiff_h);
        entry.set("diff_k", (Object)outdiff_k);
        entry.set("diff_p", (Object)outdiff_p);
        entry.set("diff_q", (Object)outdiff_q);
        entry.set("diff_r", (Object)outdiff_r);
        entry.set("diff_m", (Object)outdiff_m);
        entry.set("diff_s", (Object)outdiff_s);
        entry.set("diff_t", (Object)outdiff_t);
        entry.set("diff_c", (Object)outdiff_c);
        entry.set("diff_x", (Object)outdiff_x);
        entry.set("diff_w", (Object)outdiff_w);
        entry.set("diff_y", (Object)outdiff_y);
        entry.set("warehouse", costAdjustEntry.get("warehouse"));
        entry.set("location", costAdjustEntry.get("location"));
        entry.set("ownertype", costAdjustEntry.get("ownertype"));
        entry.set("owner", costAdjustEntry.get("owner"));
        entry.set("ecostcenter", costAdjustEntry.get("ecostcenter"));
        entry.set("project", costAdjustEntry.get("project"));
        entry.set("invbizdate", costAdjustEntry.get("invbizdate"));
        entry.set("invauditdate", costAdjustEntry.get("invauditdate"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("srcbilltype", (Object)1596453016129512448L);
        entry.set("srcbizentityobject", (Object)"cal_stdcostdiffbill");
        entry.set("srcbillnum", costAdjustInfo.get("billno"));
        entry.set("srcentryseq", costAdjustEntry.get("seq"));
        entry.set("srcbillid", costAdjustInfo.get("id"));
        entry.set("srcbillentryid", costAdjustEntry.get("id"));
        entry.set("invtype", costAdjustEntry.get("invtype"));
        entry.set("invstatus", costAdjustEntry.get("invstatus"));
        entry.set("calrange", costAdjustEntry.get("calrange"));
        entry.set("caldimension", costAdjustEntry.get("caldimension"));
        entry.set("accounttype", costAdjustEntry.get("accounttype"));
        entry.set("invbilltype", costAdjustEntry.get("invbilltype"));
        entry.set("invbiztype", costAdjustEntry.get("invbiztype"));
        entry.set("invbillnum", costAdjustEntry.get("invbillnum"));
        entry.set("invbillid", costAdjustEntry.get("invbillid"));
        entry.set("inventryseq", costAdjustEntry.get("inventryseq"));
        entry.set("feeprojectid", costAdjustEntry.get("feeprojectid"));
        entry.set("tracknumber", costAdjustEntry.get("tracknumber"));
        entry.set("configuredcode", costAdjustEntry.get("configuredcode"));
        entry.set("productline", costAdjustEntry.get("productline"));
        entry.set("noupdatecalfields", costAdjustEntry.get("noupdatecalfields"));
        entry.set("stocktype", costAdjustEntry.get("stocktype"));
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        CommonSettingHelper.setExFieldValue(exFieldSet, costAdjustEntityType, costAdjustEntityType, entry, costAdjustEntry);
        this.oldDiffBillIdSet.add(costAdjustInfo.getLong("id"));
    }

    private String createBillNo(DynamicObject bill, String orgId) {
        String billNo = CodeRuleServiceHelper.getNumber(null, (DynamicObject)bill, (String)orgId);
        if (StringUtils.isEmpty((String)billNo) || "".equals(billNo.trim())) {
            billNo = String.valueOf(System.currentTimeMillis());
        }
        return billNo;
    }

    private Map<Long, DynamicObject> getOldAdjEntryInfoMap(DynamicObject[] oldDiffBills) {
        HashMap<Long, DynamicObject> entryInfosMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject oldDiffBill : oldDiffBills) {
            DynamicObjectCollection entrys = oldDiffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                entryInfosMap.put(entry.getLong("id"), entry);
            }
        }
        return entryInfosMap;
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] newDiffBills, Map<Long, DynamicObject> oldAdjEntryInfoMap) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject newDiffBill : newDiffBills) {
            DynamicObjectCollection newDiffBillEntry = newDiffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject outentry : newDiffBillEntry) {
                for (String diffType : DIFF_TYPES) {
                    BigDecimal oldTotalAmount = outentry.getBigDecimal("diff_" + diffType.toLowerCase());
                    long entryId = outentry.getLong("id");
                    Long srcBillEntryId = outentry.getLong("srcbillentryid");
                    String number = newDiffBill.getString("billno");
                    BigDecimal rate = this.oldAdjEntryRateMap.get(number);
                    if (!oldAdjEntryInfoMap.containsKey(srcBillEntryId)) continue;
                    DynamicObject inEntry = oldAdjEntryInfoMap.get(srcBillEntryId);
                    DynamicObjectCollection inEntryDetails = inEntry.getDynamicObjectCollection("subentryentity");
                    BigDecimal rateTotalAmount = BigDecimal.ZERO;
                    BigDecimal diffAmount = BigDecimal.ZERO;
                    Long maxEntryId = 0L;
                    BigDecimal maxDetailAmount = BigDecimal.ZERO;
                    DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> buildCostAdjustDetail rate=" + rate);
                    if (rate.compareTo(BigDecimal.ONE) != 0 && rate.compareTo(BigDecimal.ONE.negate()) != 0) {
                        for (DynamicObject detail : inEntryDetails) {
                            Long detailId = detail.getLong("id");
                            BigDecimal newSubAdjustamt = detail.getBigDecimal("ddiff_" + diffType.toLowerCase()).multiply(rate).setScale(newDiffBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP);
                            rateTotalAmount = rateTotalAmount.add(newSubAdjustamt);
                            if (newSubAdjustamt.compareTo(maxDetailAmount) <= 0) continue;
                            maxDetailAmount = newSubAdjustamt;
                            maxEntryId = detailId;
                        }
                        diffAmount = oldTotalAmount.subtract(rateTotalAmount);
                    }
                    DiffAllocHelper.writeLog(logger, "OldUnDiffAllocStdBillHelper_> buildCostAdjustDetail diffAmount=" + diffAmount.doubleValue());
                    for (DynamicObject detail : inEntryDetails) {
                        CostAdjustDetailParams param = new CostAdjustDetailParams();
                        param.setEntryid(entryId);
                        param.setCostElementId(detail.getLong("costelement.id"));
                        param.setCostSubElementId(detail.getLong("costsubelement.id"));
                        Long detailId = detail.getLong("id");
                        if (diffAmount.compareTo(BigDecimal.ZERO) != 0) {
                            if (maxEntryId.longValue() == detailId.longValue()) {
                                param.setAdjustAmt(detail.getBigDecimal("ddiff_" + diffType.toLowerCase()).multiply(rate).setScale(newDiffBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP).add(diffAmount));
                            } else {
                                param.setAdjustAmt(detail.getBigDecimal("ddiff_" + diffType.toLowerCase()).multiply(rate).setScale(newDiffBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP));
                            }
                        } else {
                            param.setAdjustAmt(detail.getBigDecimal("ddiff_" + diffType.toLowerCase()).multiply(rate).setScale(newDiffBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP));
                        }
                        BigDecimal adjustAmt = BigDecimal.ZERO;
                        adjustAmt = param.getAdjustAmt();
                        if (adjustAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        CalStdcostdiffbillHelper.setParamSubDdiffAmt(diffType, adjustAmt, param);
                        paramsList.add(param);
                    }
                }
            }
        }
        return paramsList;
    }
}

