/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.AbstractAccountType;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.accounttype.FIFOCalAT;
import kd.fi.calx.algox.accounttype.FIFOPeriodCalAT;
import kd.fi.calx.algox.accounttype.IAccountType;
import kd.fi.calx.algox.accounttype.MovedAvgIntimeAT;
import kd.fi.calx.algox.accounttype.StandardCostCalAT;
import kd.fi.calx.algox.accounttype.WeightedAvgAT;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.function.CommonInfo;

public abstract class AbstractAccountTypeFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 9008907713319392661L;
    protected static Log log = LogFactory.getLog(AbstractAccountTypeFunction.class);
    private RowMeta rowMeta;
    private RowMeta resultRowMeta;
    private CommonInfo commonInfo;
    private Map<Long, CostAccount> costAccountMap;

    public AbstractAccountTypeFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap) {
        this.rowMeta = rowMeta;
        this.resultRowMeta = this.buildResultMeta(commonInfo);
        this.commonInfo = commonInfo;
        this.costAccountMap = costAccountMap;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    protected final AccountTypeContext createContext(Collector collector) {
        AccountTypeContext ctx = new AccountTypeContext(collector, this.resultRowMeta, this.commonInfo);
        return ctx;
    }

    protected final DataSet createDataSet(Iterable<RowX> iterable) {
        Algo algo = Algo.create((String)"kd.fi.cal.calculate.AccountTypeCalFunction");
        Iterator<RowX> rowIt = iterable.iterator();
        return algo.createDataSet((Iterator)new RowXIterator(rowIt), this.rowMeta);
    }

    private RowMeta buildResultMeta(CommonInfo commonInfo) {
        Map<Long, CostSubElement> elementMap = commonInfo.getElementMap();
        int elementSize = elementMap.size();
        Field[] resultFields = new Field[elementSize * 2 + 33];
        resultFields[0] = new Field("entryid", (DataType)DataType.LongType);
        resultFields[1] = new Field("calbycostelement", (DataType)DataType.BooleanType);
        resultFields[2] = new Field("baseqty", (DataType)DataType.BigDecimalType);
        resultFields[3] = new Field("priceprecision", (DataType)DataType.IntegerType);
        resultFields[4] = new Field("amtprecision", (DataType)DataType.IntegerType);
        resultFields[5] = new Field("actualCost", (DataType)DataType.BigDecimalType);
        resultFields[6] = new Field("materialcost", (DataType)DataType.BigDecimalType);
        resultFields[7] = new Field("fee", (DataType)DataType.BigDecimalType);
        resultFields[8] = new Field("processcost", (DataType)DataType.BigDecimalType);
        resultFields[9] = new Field("manufacturecost", (DataType)DataType.BigDecimalType);
        resultFields[10] = new Field("resource", (DataType)DataType.BigDecimalType);
        resultFields[11] = new Field("costaccount", (DataType)DataType.LongType);
        resultFields[12] = new Field("bizdate", (DataType)DataType.DateType);
        resultFields[13] = new Field("unitactualcost", (DataType)DataType.BigDecimalType);
        resultFields[14] = new Field("unitmaterialcost", (DataType)DataType.BigDecimalType);
        resultFields[15] = new Field("unitfee", (DataType)DataType.BigDecimalType);
        resultFields[16] = new Field("unitprocesscost", (DataType)DataType.BigDecimalType);
        resultFields[17] = new Field("unitmanufacturecost", (DataType)DataType.BigDecimalType);
        resultFields[18] = new Field("unitresource", (DataType)DataType.BigDecimalType);
        resultFields[19] = new Field("headid", (DataType)DataType.LongType);
        resultFields[20] = new Field("recentcostid", (DataType)DataType.LongType);
        resultFields[21] = new Field("recentcostqty", (DataType)DataType.BigDecimalType);
        resultFields[22] = new Field("recentcost", (DataType)DataType.BigDecimalType);
        resultFields[23] = new Field("calrptid", (DataType)DataType.LongType);
        resultFields[24] = new Field("rcidmod", (DataType)DataType.IntegerType);
        resultFields[25] = new Field("iscalculated", (DataType)DataType.BooleanType);
        resultFields[26] = new Field("modvalue", (DataType)DataType.IntegerType);
        resultFields[27] = new Field("billtypenum", (DataType)DataType.StringType);
        resultFields[28] = new Field("designatedcost", (DataType)DataType.BooleanType);
        resultFields[29] = new Field("calbilltype", (DataType)DataType.StringType);
        resultFields[30] = new Field("costpricesource", (DataType)DataType.StringType);
        resultFields[31] = new Field("costpricesourcetype", (DataType)DataType.StringType);
        resultFields[32] = new Field("enablejoincalute", (DataType)DataType.BooleanType);
        Set<Long> elementIds = elementMap.keySet();
        int i = 33;
        for (Long elementId : elementIds) {
            resultFields[i++] = new Field(elementId.toString(), (DataType)DataType.BigDecimalType);
            resultFields[i++] = new Field(elementId.toString() + "unitcost", (DataType)DataType.BigDecimalType);
        }
        return new RowMeta(resultFields);
    }

    protected final LinkedHashMap<String, CalRangeDataSet> mergeCalRangeData(DataSet CANDMDataSet, List<Map<String, Object>> groupList) {
        DataSetBuilder builder;
        String calRangeId;
        String calDimensionValue;
        LinkedHashMap<String, CalRangeDataSet> calRangeDataMap = new LinkedHashMap<String, CalRangeDataSet>(16);
        HashMap<String, DataSetBuilder> calRangeDataBuilderMap = new HashMap<String, DataSetBuilder>(16);
        for (Map<String, Object> groupValue : groupList) {
            Integer ingroupseq = (Integer)groupValue.get("ingroupseq");
            String accountType = (String)groupValue.get("accountType");
            if (((Boolean)groupValue.get("isEmptyRange")).booleanValue()) {
                String key = groupValue.get("divideBasisValue").toString() + groupValue.get("calDimensionValue").toString();
                calRangeDataMap.put(key, new CalRangeDataSet(null, ingroupseq, accountType));
                calRangeDataBuilderMap.put(key, Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(CANDMDataSet.getRowMeta()));
                continue;
            }
            calDimensionValue = groupValue.get("calDimensionValue").toString();
            calRangeId = groupValue.get("calRange").toString();
            String key = calRangeId + calDimensionValue;
            CalRangeDataSet rangeSet = calRangeDataMap.get(key);
            if (rangeSet != null) continue;
            calRangeDataMap.put(key, new CalRangeDataSet(null, ingroupseq, accountType));
            calRangeDataBuilderMap.put(key, Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(CANDMDataSet.getRowMeta()));
        }
        for (Row row : CANDMDataSet) {
            String key;
            boolean isEmptyRange = row.getBoolean("isEmptyRange");
            if (isEmptyRange) {
                key = row.get("divideBasisValue").toString() + row.get("calDimensionValue").toString();
            } else {
                calDimensionValue = row.get("calDimensionValue").toString();
                calRangeId = row.get("calRange").toString();
                key = calRangeId + calDimensionValue;
            }
            builder = (DataSetBuilder)calRangeDataBuilderMap.get(key);
            builder.append(row);
        }
        for (Map.Entry calRangeDataSetEntry : calRangeDataMap.entrySet()) {
            String key = (String)calRangeDataSetEntry.getKey();
            CalRangeDataSet calRangeDataSet = (CalRangeDataSet)calRangeDataSetEntry.getValue();
            builder = (DataSetBuilder)calRangeDataBuilderMap.get(key);
            calRangeDataSet.setDataSet(builder.build());
        }
        return calRangeDataMap;
    }

    protected final String buildFilterStr(Map<String, Object> groupValue) {
        StringBuilder filterStr = new StringBuilder();
        filterStr.append("divideBasis = ");
        filterStr.append(groupValue.get("divideBasis"));
        filterStr.append(" and ");
        filterStr.append("divideBasisValue = '");
        filterStr.append(groupValue.get("divideBasisValue"));
        filterStr.append("' and ");
        filterStr.append("calRange = ");
        filterStr.append(groupValue.get("calRange"));
        filterStr.append(" and ");
        filterStr.append("calDimension = ");
        filterStr.append(groupValue.get("calDimension"));
        filterStr.append(" and ");
        filterStr.append("calDimensionValue = '");
        filterStr.append(groupValue.get("calDimensionValue"));
        filterStr.append("' and ");
        filterStr.append("accountType = '");
        filterStr.append(groupValue.get("accountType"));
        filterStr.append('\'');
        return filterStr.toString();
    }

    protected final List<Map<String, Object>> getGroupList(DataSet rptSet) {
        ArrayList<Map<String, Object>> groupValueList = new ArrayList<Map<String, Object>>(16);
        while (rptSet.hasNext()) {
            Row row = rptSet.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("divideBasis", row.get("divideBasis"));
            map.put("divideBasisValue", row.get("divideBasisValue"));
            map.put("calRange", row.get("calRange"));
            map.put("calDimension", row.get("calDimension"));
            map.put("calDimensionValue", row.get("calDimensionValue"));
            map.put("accountType", row.get("accountType"));
            map.put("ingroupseq", row.get("ingroupseq"));
            map.put("isEmptyRange", row.get("isEmptyRange"));
            groupValueList.add(map);
        }
        return groupValueList;
    }

    protected final void execute(AccountTypeContext ctx, List<IAccountType> accountTypeList) {
        for (IAccountType accountType : accountTypeList) {
            accountType.calculateOut();
        }
        for (IAccountType accountType : accountTypeList) {
            accountType.afterAllCalculate();
        }
    }

    protected final IAccountType createAccountType(String accountType, AccountTypeContext ctx, DataSet dataSet) {
        AbstractAccountType at = null;
        Map<String, Integer> runningModeMap = this.commonInfo.getRunningModeMap();
        if (AccountTypeEnum.WEIGHTAVG.getValue().equals(accountType)) {
            at = new WeightedAvgAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.WEIGHTAVG.getValue()), this.costAccountMap);
        } else if (AccountTypeEnum.SPPRICE.getValue().equals(accountType)) {
            at = new WeightedAvgAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.SPPRICE.getValue()), this.costAccountMap);
        } else if (AccountTypeEnum.MOVEDAVG_INTIME.getValue().equals(accountType)) {
            at = new MovedAvgIntimeAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()));
        } else if (AccountTypeEnum.FIFO.getValue().equals(accountType)) {
            at = new FIFOCalAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.FIFO.getValue()));
        } else if (AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(accountType)) {
            at = new FIFOPeriodCalAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue()));
        } else if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
            at = new StandardCostCalAT(ctx, dataSet, runningModeMap.get(AccountTypeEnum.STANDARDCOST.getValue()));
        }
        return at;
    }

    protected static final class CalRangeDataSet {
        private DataSet dataSet;
        private String accountType;

        public CalRangeDataSet(DataSet dataSet, Integer ingroupseq, String accountType) {
            this.dataSet = dataSet;
            this.accountType = accountType;
        }

        public void setDataSet(DataSet dataSet) {
            this.dataSet = dataSet;
        }

        private void union(DataSet set) {
            this.dataSet = this.dataSet.union(set);
        }

        private void addDataSet(DataSet ... sets) {
            this.dataSet = this.dataSet.union(sets);
        }

        protected String getAccountType() {
            return this.accountType;
        }

        protected DataSet getDataSet() {
            return this.dataSet;
        }
    }

    private static class RowXIterator
    implements Iterator<Object[]>,
    Serializable {
        private static final long serialVersionUID = 2887514307777228209L;
        private Iterator<RowX> iterable;

        RowXIterator(Iterator<RowX> iterable) {
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.iterable.hasNext();
        }

        @Override
        public Object[] next() {
            return this.iterable.next().values();
        }
    }
}

