/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.balance.BalanceCalculator;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.groupbill.GroupBillHolder;
import kd.fi.calx.algox.helper.CostPrice4CalxHelper;

public class AccountTypeContext
implements Serializable {
    private static final long serialVersionUID = -6421755584046840053L;
    private GroupBillHolder groupBillHolder;
    private Collector collector;
    private RowMeta resultRowMeta;
    private CommonInfo commonInfo;
    private CostPrice4CalxHelper priceHelper;
    private static final int avgno = 8;

    public CostPrice4CalxHelper getPriceHelper() {
        if (this.priceHelper == null) {
            this.priceHelper = new CostPrice4CalxHelper();
        }
        return this.priceHelper;
    }

    public AccountTypeContext(Collector collector, RowMeta resultRowMeta, CommonInfo info) {
        this.collector = collector;
        this.resultRowMeta = resultRowMeta;
        this.groupBillHolder = new GroupBillHolder(info.getElementMap(), info.getRunningModeMap(), info.getParamCache(), info.enableRework());
        this.groupBillHolder.setCommonInfo(info);
        this.commonInfo = info;
    }

    public Object[] createUpdateInfo(LocalRow row) {
        Field[] fields = this.resultRowMeta.getFields();
        Object[] obj = new Object[fields.length];
        obj[0] = row.getEntryId();
        obj[1] = row.isCalbycostelement();
        obj[2] = row.getBaseqty().multiply(row.getSignnum());
        obj[3] = 10;
        obj[4] = row.getAmtprecision();
        obj[19] = row.getHeadid();
        return obj;
    }

    public void setUpdateCost(LocalRow row, Object[] obj) {
        BigDecimal signnum = row.getSignnum();
        obj[5] = row.getActualCost().multiply(signnum);
        obj[6] = row.getMaterialcost().multiply(signnum);
        obj[7] = row.getFee().multiply(signnum);
        obj[8] = row.getProcesscost().multiply(signnum);
        obj[9] = row.getManufacturecost().multiply(signnum);
        obj[10] = row.getResource().multiply(signnum);
        obj[11] = row.getCostaccountid();
        obj[12] = row.getBizDate();
        obj[13] = row.getUnitActualCost();
        obj[14] = row.getUnitMaterialCost();
        obj[15] = row.getUnitFee();
        obj[16] = row.getUnitProcessCost();
        obj[17] = row.getUnitManufactureCost();
        obj[18] = row.getUnitResource();
        obj[19] = row.getHeadid();
        obj[25] = row.iscalculated();
        obj[26] = row.getHeadid().hashCode() % 8;
        obj[27] = row.getBilltypenum();
        obj[28] = row.isDesignatedcost();
        obj[29] = row.getCalbilltype();
        obj[30] = row.getCostpricesource();
        obj[31] = row.getCostpriceSourceType();
        obj[32] = row.isEnableJoinCalute();
        for (Map.Entry<Long, BigDecimal> entry : row.getElementCostMap().entrySet()) {
            obj[this.resultRowMeta.getFieldIndex((String)entry.getKey().toString())] = entry.getValue().multiply(signnum);
        }
        for (Map.Entry<Long, BigDecimal> entry : row.getElementUnitCostMap().entrySet()) {
            obj[this.resultRowMeta.getFieldIndex((String)new StringBuilder().append((String)entry.getKey().toString()).append((String)"unitcost").toString())] = entry.getValue();
        }
    }

    public void collectCostUpdateInfo(Object[] costRecordUpdateInfo) {
        RowX updateInfoRow = new RowX(costRecordUpdateInfo);
        this.collector.collect(updateInfoRow);
    }

    public GroupBillHolder getGroupBillHolder() {
        return this.groupBillHolder;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public boolean isWriteRpt() {
        return this.commonInfo.isWriteRpt();
    }

    public boolean isOnlyWriteErrRpt() {
        return this.commonInfo.isOnlyWriteErrRpt();
    }

    public BalanceCalculator getBalanceCalculator() {
        return this.commonInfo.getBalanceCalculator();
    }

    public Map<Long, CostSubElement> getElementMap() {
        return this.commonInfo.getElementMap();
    }

    public ParamCache getParamCache() {
        return this.commonInfo.getParamCache();
    }

    public boolean enableRework() {
        return this.commonInfo.enableRework();
    }

    public boolean enableBalanceNeg() {
        return this.commonInfo.enableBalanceNeg();
    }

    public boolean enableLoopInBill() {
        return this.commonInfo.enableLoopInBill();
    }

    public boolean enableNoSrcOutReturn() {
        return this.commonInfo.enableNoSrcOutReturn();
    }

    public boolean enableZeroPrice() {
        return this.commonInfo.enableZeroPrice();
    }

    public boolean enableAvgNegPrice() {
        return this.commonInfo.enableAvgNegPrice();
    }

    public List<String> getCalGroupCostImplClasses() {
        return this.commonInfo.getCalGroupCostImplClasses();
    }

    public boolean enableMatrix() {
        return this.commonInfo.isMatrix();
    }

    public boolean enableCostatenddateenable() {
        return this.commonInfo.isCostatenddateenable();
    }

    public Date getCostatenddate() {
        return this.commonInfo.getCostatenddate();
    }

    public boolean enableCoverdesigoutcost() {
        return this.commonInfo.isCoverdesigoutcost();
    }
}

