/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.calx.algox.CostSubElement;

public class BuildCostRecordUpdateInfoFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 463091442032589099L;
    private RowMeta rowMeta;
    private RowMeta resultMeta;
    private Map<Long, CostSubElement> elementMap;
    private int amtprecision = 2;
    private static final int avgno = 8;

    public BuildCostRecordUpdateInfoFunction(RowMeta rowMeta, Map<Long, CostSubElement> elementMap) {
        this.rowMeta = rowMeta;
        this.elementMap = elementMap;
        this.resultMeta = this.buildResultMeta();
    }

    private RowMeta buildResultMeta() {
        Field[] resultFields = new Field[]{new Field("entryid", (DataType)DataType.LongType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("actualcost", (DataType)DataType.BigDecimalType), new Field("materialcost", (DataType)DataType.BigDecimalType), new Field("fee", (DataType)DataType.BigDecimalType), new Field("processcost", (DataType)DataType.BigDecimalType), new Field("manufacturecost", (DataType)DataType.BigDecimalType), new Field("resource", (DataType)DataType.BigDecimalType), new Field("elementinfo", (DataType)DataType.StringType), new Field("mod", (DataType)DataType.IntegerType), new Field("costAccount", (DataType)DataType.LongType), new Field("bizdate", (DataType)DataType.DateType), new Field("unitactualcost", (DataType)DataType.BigDecimalType), new Field("unitmaterialcost", (DataType)DataType.BigDecimalType), new Field("unitfee", (DataType)DataType.BigDecimalType), new Field("unitprocesscost", (DataType)DataType.BigDecimalType), new Field("unitmanufacturecost", (DataType)DataType.BigDecimalType), new Field("unitresource", (DataType)DataType.BigDecimalType), new Field("elementunitinfo", (DataType)DataType.StringType), new Field("headid", (DataType)DataType.LongType), new Field("billtypenum", (DataType)DataType.StringType), new Field("designatedcost", (DataType)DataType.BooleanType), new Field("calbilltype", (DataType)DataType.StringType), new Field("costpricesource", (DataType)DataType.StringType), new Field("costpricesourcetype", (DataType)DataType.StringType), new Field("enablejoincalute", (DataType)DataType.BooleanType)};
        return new RowMeta(resultFields);
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap<Long, Map<String, BigDecimal>> elementUpdateMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        HashMap<Long, Long> childAPeriodMap = new HashMap<Long, Long>(16);
        Iterator<RowX> it = iterable.iterator();
        BigDecimal totalQty = null;
        Long coreEntryId = null;
        boolean isFirstRow = true;
        HashMap<String, BigDecimal> totalElementCost = new HashMap<String, BigDecimal>(16);
        HashMap<Long, Long> costAccountAndEntryIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Date> bizDateAndEntryIdMap = new HashMap<Long, Date>(16);
        BigDecimal currentTotalQty = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, String> billTypeMap = new HashMap<Long, String>(16);
        HashMap<Long, Map<String, BigDecimal>> unitCostUpdateMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        HashMap<String, BigDecimal> totalElementUnitCost = new HashMap<String, BigDecimal>(16);
        HashMap<Long, Long> childBPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> entryidAndHeadIdMap = new HashMap<Long, Long>(16);
        boolean isWriteoffEnd = true;
        long lastChildAId = 0L;
        long sourceEntryId = 0L;
        HashMap<String, BigDecimal> totalElementCostMapA = new HashMap<String, BigDecimal>(16);
        HashMap<Long, String> costpricesourceMap = new HashMap<Long, String>(16);
        HashMap<Long, String> costPriceSourceTypeMap = new HashMap<Long, String>(16);
        HashMap<Long, Boolean> enableJoinCaluteMap = new HashMap<Long, Boolean>(16);
        while (it.hasNext()) {
            RowX row = it.next();
            coreEntryId = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            String costpricesource = row.getString(this.rowMeta.getFieldIndex("costpricesource"));
            String calbilltype = row.getString(this.rowMeta.getFieldIndex("calbilltype"));
            Boolean designatedcost = row.getBoolean(this.rowMeta.getFieldIndex("designatedcost"));
            Object designatedcoststr = "0";
            if (designatedcost.booleanValue()) {
                designatedcoststr = "1";
            }
            costpricesourceMap.put(coreEntryId, costpricesource + "_" + calbilltype + "_" + (String)designatedcoststr);
            String costpricesourcetype = row.getString(this.rowMeta.getFieldIndex("costpricesourcetype"));
            Boolean enablejoincalute = row.getBoolean(this.rowMeta.getFieldIndex("enablejoincalute"));
            costPriceSourceTypeMap.put(coreEntryId, costpricesourcetype);
            enableJoinCaluteMap.put(coreEntryId, enablejoincalute);
            sourceEntryId = coreEntryId;
            costAccountAndEntryIdMap.put(coreEntryId, row.getLong(this.rowMeta.getFieldIndex("costaccount")));
            bizDateAndEntryIdMap.put(coreEntryId, row.getDate(this.rowMeta.getFieldIndex("bizdate")));
            entryidAndHeadIdMap.put(coreEntryId, row.getLong(this.rowMeta.getFieldIndex("headid")));
            if (isFirstRow) {
                this.amtprecision = (Integer)this.getValue(row, "amtprecision");
                totalQty = (BigDecimal)this.getValue(row, "baseqty");
                totalElementCost.put("actualcost", (BigDecimal)this.getValue(row, "actualcost"));
                totalElementCost.put("materialcost", (BigDecimal)this.getValue(row, "materialcost"));
                totalElementCost.put("fee", (BigDecimal)this.getValue(row, "fee"));
                totalElementCost.put("processcost", (BigDecimal)this.getValue(row, "processcost"));
                totalElementCost.put("manufacturecost", (BigDecimal)this.getValue(row, "manufacturecost"));
                totalElementCost.put("resource", (BigDecimal)this.getValue(row, "resource"));
                totalElementUnitCost.put("unitactualcost", (BigDecimal)this.getValue(row, "unitactualcost"));
                totalElementUnitCost.put("unitmaterialcost", (BigDecimal)this.getValue(row, "unitmaterialcost"));
                totalElementUnitCost.put("unitfee", (BigDecimal)this.getValue(row, "unitfee"));
                totalElementUnitCost.put("unitprocesscost", (BigDecimal)this.getValue(row, "unitprocesscost"));
                totalElementUnitCost.put("unitmanufacturecost", (BigDecimal)this.getValue(row, "unitmanufacturecost"));
                totalElementUnitCost.put("unitresource", (BigDecimal)this.getValue(row, "unitresource"));
                for (Long elementId : this.elementMap.keySet()) {
                    BigDecimal elementCost = (BigDecimal)this.getValue(row, elementId.toString());
                    BigDecimal elementUnitCost = (BigDecimal)this.getValue(row, elementId.toString() + "unitcost");
                    if (elementCost != null) {
                        totalElementCost.put(elementId.toString(), elementCost);
                    }
                    if (elementUnitCost == null) continue;
                    totalElementUnitCost.put(elementId.toString() + "unitcost", elementUnitCost);
                }
                qtyMap.put(coreEntryId, totalQty);
                billTypeMap.put(coreEntryId, row.getString(this.rowMeta.getFieldIndex("billtypenum")));
                elementUpdateMap.put(coreEntryId, totalElementCost);
                unitCostUpdateMap.put(coreEntryId, totalElementUnitCost);
                isFirstRow = false;
            }
            Long childId = row.getLong(this.rowMeta.getFieldIndex("childid"));
            Long writeoffendperiod = row.getLong(this.rowMeta.getFieldIndex("writeoffendperiod"));
            if (null != writeoffendperiod && writeoffendperiod == 0L) {
                isWriteoffEnd = false;
            }
            if (childId == null) continue;
            costAccountAndEntryIdMap.put(childId, row.getLong(this.rowMeta.getFieldIndex("costaccount")));
            bizDateAndEntryIdMap.put(childId, row.getDate(this.rowMeta.getFieldIndex("bizdate")));
            entryidAndHeadIdMap.put(childId, row.getLong(this.rowMeta.getFieldIndex("childheadid")));
            BigDecimal childQty = (BigDecimal)this.getValue(row, "childbaseqty");
            qtyMap.put(childId, childQty);
            String writeOffStatus = (String)this.getValue(row, "writeoffstatus");
            Long writeOffPeriod = row.getLong(this.rowMeta.getFieldIndex("writeoffperiod"));
            if ("A".equals(writeOffStatus)) {
                if (childId > lastChildAId) {
                    lastChildAId = childId;
                }
                childAPeriodMap.put(childId, writeOffPeriod);
                HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>(16);
                currentTotalQty = currentTotalQty.add(childQty);
                for (Map.Entry entry : totalElementCost.entrySet()) {
                    String elementId = (String)entry.getKey();
                    BigDecimal totalCost = (BigDecimal)entry.getValue();
                    BigDecimal thisCost = totalCost.multiply(childQty).divide(totalQty, this.amtprecision, RoundingMode.HALF_UP);
                    costMap.put(elementId, thisCost);
                    if (!totalElementCostMapA.containsKey(elementId)) {
                        totalElementCostMapA.put(elementId, thisCost);
                        continue;
                    }
                    BigDecimal elementCost = (BigDecimal)totalElementCostMapA.get(elementId);
                    totalElementCostMapA.put(elementId, elementCost.add(thisCost));
                }
                elementUpdateMap.put(childId, costMap);
                unitCostUpdateMap.put(childId, new HashMap(totalElementUnitCost));
                continue;
            }
            if (!"B".equals(writeOffStatus)) continue;
            childBPeriodMap.put(childId, writeOffPeriod);
        }
        if (isWriteoffEnd && lastChildAId != 0L) {
            Map sourceCostMap = (Map)elementUpdateMap.get(sourceEntryId);
            Map lastChildACostMap = (Map)elementUpdateMap.get(lastChildAId);
            HashMap<String, BigDecimal> newCostMapA = new HashMap<String, BigDecimal>(lastChildACostMap.size());
            for (Map.Entry entry : lastChildACostMap.entrySet()) {
                String elementId = (String)entry.getKey();
                BigDecimal totalCost = (BigDecimal)entry.getValue();
                BigDecimal costDiff = ((BigDecimal)sourceCostMap.get(elementId)).subtract((BigDecimal)totalElementCostMapA.get(elementId));
                newCostMapA.put(elementId, totalCost.add(costDiff));
            }
            elementUpdateMap.put(lastChildAId, newCostMapA);
        }
        for (Map.Entry entryB : childBPeriodMap.entrySet()) {
            Long childIdB = (Long)entryB.getKey();
            Long writeOffPeriodB = (Long)entryB.getValue();
            Map totalCostMap = (Map)elementUpdateMap.get(coreEntryId);
            HashMap<String, BigDecimal> costMapB = new HashMap<String, BigDecimal>(totalCostMap.size());
            for (Map.Entry entry : totalCostMap.entrySet()) {
                String elementId = (String)entry.getKey();
                BigDecimal totalCost = (BigDecimal)entry.getValue();
                for (Map.Entry e : childAPeriodMap.entrySet()) {
                    Long childIdA = (Long)e.getKey();
                    Long writeOffPeriodA = (Long)e.getValue();
                    if (writeOffPeriodA > writeOffPeriodB) continue;
                    Map costMapA = (Map)elementUpdateMap.get(childIdA);
                    totalCost = totalCost.subtract((BigDecimal)costMapA.get(elementId));
                }
                costMapB.put(elementId, totalCost);
            }
            elementUpdateMap.put(childIdB, costMapB);
            unitCostUpdateMap.put(childIdB, new HashMap(totalElementUnitCost));
        }
        this.buildAndSaveUpdateInfos(qtyMap, unitCostUpdateMap, elementUpdateMap, collector, costAccountAndEntryIdMap, bizDateAndEntryIdMap, entryidAndHeadIdMap, billTypeMap, costpricesourceMap, costPriceSourceTypeMap, enableJoinCaluteMap);
    }

    private void buildAndSaveUpdateInfos(Map<Long, BigDecimal> qtyMap, Map<Long, Map<String, BigDecimal>> unitCostUpdateMap, Map<Long, Map<String, BigDecimal>> elementUpdateMap, Collector collector, Map<Long, Long> costAccountAndEntryIdMap, Map<Long, Date> bizDateAndEntryIdMap, Map<Long, Long> entryidAndHeadIdMap, Map<Long, String> billTypeMap, Map<Long, String> costpricesourceMap, Map<Long, String> costPriceSourceTypeMap, Map<Long, Boolean> enableJoinCaluteMap) {
        for (Map.Entry<Long, Map<String, BigDecimal>> entry : elementUpdateMap.entrySet()) {
            Long recordId = entry.getKey();
            Long costAccount = costAccountAndEntryIdMap.get(recordId);
            Date bizDate = bizDateAndEntryIdMap.get(recordId);
            BigDecimal qty = qtyMap.get(recordId);
            String billTypeNum = billTypeMap.get(recordId);
            Map<String, BigDecimal> costMap = entry.getValue();
            Map<String, BigDecimal> unitCostMap = unitCostUpdateMap.get(recordId);
            Object[] row = new Object[this.resultMeta.getFields().length];
            BigDecimal manufacturecost = costMap.remove("manufacturecost");
            BigDecimal resource = costMap.remove("resource");
            BigDecimal actualcost = costMap.remove("actualcost");
            BigDecimal materialCost = costMap.remove("materialcost");
            BigDecimal fee = costMap.remove("fee");
            BigDecimal processcost = costMap.remove("processcost");
            BigDecimal unitactualcost = unitCostMap.remove("unitactualcost");
            BigDecimal unitmaterialcost = unitCostMap.remove("unitmaterialcost");
            BigDecimal unitfee = unitCostMap.remove("unitfee");
            BigDecimal unitprocesscost = unitCostMap.remove("unitprocesscost");
            BigDecimal unitmanufacturecost = unitCostMap.remove("unitmanufacturecost");
            BigDecimal unitresource = unitCostMap.remove("unitresource");
            row[0] = recordId;
            row[1] = qty;
            row[2] = actualcost;
            row[3] = materialCost;
            row[4] = fee;
            row[5] = processcost;
            row[6] = manufacturecost;
            row[7] = resource;
            try {
                row[8] = JSONUtils.toString(costMap);
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            Long headId = entryidAndHeadIdMap.get(recordId);
            row[9] = headId.hashCode() % 8;
            row[10] = costAccount;
            row[11] = bizDate;
            row[12] = unitactualcost;
            row[13] = unitmaterialcost;
            row[14] = unitfee;
            row[15] = unitprocesscost;
            row[16] = unitmanufacturecost;
            row[17] = unitresource;
            try {
                row[18] = JSONUtils.toString(unitCostMap);
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            row[19] = headId;
            row[20] = billTypeNum;
            boolean designatedcost = false;
            row[21] = designatedcost;
            row[22] = " ";
            row[23] = " ";
            String costpricesource = costpricesourceMap.get(recordId);
            if (!StringUtils.isEmpty((CharSequence)costpricesource)) {
                String[] costpricesources = costpricesource.split("_");
                if ("1".equals(costpricesources[2])) {
                    designatedcost = true;
                }
                row[21] = designatedcost;
                if (costpricesources[1] != null && !"null".equals(costpricesources[1])) {
                    row[22] = costpricesources[1];
                }
                if (costpricesources[0] != null && !"null".equals(costpricesources[0])) {
                    row[23] = costpricesources[0];
                }
            }
            row[24] = costPriceSourceTypeMap.get(recordId);
            if (costpricesource == null) {
                row[21] = false;
                row[23] = " ";
                row[24] = "splitbill";
            }
            row[25] = enableJoinCaluteMap.get(recordId);
            collector.collect(new RowX(row));
        }
    }

    private Object getValue(RowX row, String field) {
        return row.get(this.rowMeta.getFieldIndex(field));
    }
}

