/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.balance.BalanceCalculator;
import kd.fi.calx.algox.helper.CostPrice4CalxHelper;

public class CommonInfo
implements Serializable {
    private static final long serialVersionUID = 7353741132243721763L;
    private boolean isWriteRpt;
    private boolean onlyWriteErrRpt;
    private Map<Long, CostSubElement> elementMap;
    private ParamCache paramCache;
    private BalanceCalculator balanceCalculator;
    private Map<String, Integer> runningModeMap;
    private CostPrice4CalxHelper priceHelper;
    private Boolean enableRework;
    private Boolean enableZeroPrice;
    private Boolean enableBalanceNeg;
    private Boolean enableNoSrcOutReturn;
    private Boolean enableLoopInBill;
    private Map<Long, CalRange> calRangeInfoMap;
    private Date calOutTime;
    private String calNumber;
    private String taskId;
    private List<String> calGroupCostImplClasses;
    private RowMeta groupInfoRowMeta;
    private boolean costatenddateenable = false;
    private Date costatenddate;
    private boolean voucherdutweightedavgat = false;
    private boolean desigoutweightedavgat = false;
    private boolean coverdesigoutcost = false;
    private boolean matrix = false;
    private Boolean enableAvgNegPrice;

    public boolean isMatrix() {
        return this.matrix;
    }

    public void setMatrix(boolean matrix) {
        this.matrix = matrix;
    }

    public List<String> getCalGroupCostImplClasses() {
        return this.calGroupCostImplClasses;
    }

    public void setCalGroupCostImplClasses(List<String> calGroupCostImplClasses) {
        this.calGroupCostImplClasses = calGroupCostImplClasses;
    }

    public Map<Long, CalRange> getCalRangeInfoMap() {
        return this.calRangeInfoMap;
    }

    public void setCalRangeInfoMap(Map<Long, CalRange> calRangeInfoMap) {
        this.calRangeInfoMap = calRangeInfoMap;
    }

    public boolean isWriteRpt() {
        return this.isWriteRpt;
    }

    public void setWriteRpt(boolean isWriteRpt) {
        this.isWriteRpt = isWriteRpt;
    }

    public boolean isOnlyWriteErrRpt() {
        return this.onlyWriteErrRpt;
    }

    public void setOnlyWriteErrRpt(boolean onlyWriteErrRpt) {
        this.onlyWriteErrRpt = onlyWriteErrRpt;
    }

    public Map<Long, CostSubElement> getElementMap() {
        return this.elementMap;
    }

    public void setElementMap(Map<Long, CostSubElement> elementMap) {
        this.elementMap = elementMap;
    }

    public ParamCache getParamCache() {
        return this.paramCache;
    }

    public void setParamCache(ParamCache paramCache) {
        this.paramCache = paramCache;
    }

    public BalanceCalculator getBalanceCalculator() {
        return this.balanceCalculator;
    }

    public void setBalanceCalculator(BalanceCalculator balanceCalculator) {
        this.balanceCalculator = balanceCalculator;
    }

    public Map<String, Integer> getRunningModeMap() {
        return this.runningModeMap;
    }

    public void setRunningModeMap(Map<String, Integer> runningModeMap) {
        this.runningModeMap = runningModeMap;
    }

    public CostPrice4CalxHelper getPriceHelper() {
        if (this.priceHelper == null) {
            this.priceHelper = new CostPrice4CalxHelper();
        }
        return this.priceHelper;
    }

    public CommonInfo() {
        QFilter priceSchemeFilter = new QFilter("entityobject", "=", (Object)"cal_out_calculate");
        priceSchemeFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"cal_pricescheme", (String)"id,priceobject", (QFilter[])priceSchemeFilter.toArray());
        HashSet<String> priceObjects = new HashSet<String>(16);
        for (DynamicObject object : collection) {
            priceObjects.add(object.getString("priceobject"));
        }
        this.enableRework = priceObjects.contains("K");
        this.enableZeroPrice = priceObjects.contains("E");
        this.enableBalanceNeg = priceObjects.contains("H");
        this.enableNoSrcOutReturn = priceObjects.contains("I");
        this.enableLoopInBill = priceObjects.contains("D");
        this.enableAvgNegPrice = priceObjects.contains("L");
    }

    public boolean enableRework() {
        return this.enableRework;
    }

    public void invockCostprice4Rework(CalCulateOutParams param) {
        Collection<CalCulateOutParamEntry> entrys = param.getEntrys().values();
        HashMap<Long, Set> paramMap = new HashMap<Long, Set>(16);
        for (CalCulateOutParamEntry entry : entrys) {
            Long costaccountId = entry.getCostAccountId();
            Set<Object> materialIds = entry.getMaterialIdSet();
            Set materialIdSet = paramMap.computeIfAbsent(costaccountId, k -> new HashSet(16));
            if (materialIds == null || materialIds.isEmpty()) continue;
            for (Object materialId : materialIds) {
                materialIdSet.add(Long.valueOf(materialId.toString()));
            }
        }
        HashMap<String, String> commonParam = new HashMap<String, String>(16);
        commonParam.put("priceobject", "K");
        commonParam.put("entityobject", "cal_out_calculate");
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostPrice4CostRecordService", (String)"updateCostFromCostPrice", (Object[])new Object[]{paramMap, commonParam});
    }

    public Boolean enableZeroPrice() {
        return this.enableZeroPrice;
    }

    public Boolean enableAvgNegPrice() {
        return this.enableAvgNegPrice;
    }

    public Boolean enableBalanceNeg() {
        return this.enableBalanceNeg;
    }

    public Boolean enableNoSrcOutReturn() {
        return this.enableNoSrcOutReturn;
    }

    public Boolean enableLoopInBill() {
        return this.enableLoopInBill;
    }

    public void setGroupInfoRowMeta(RowMeta rowMeta) {
        this.groupInfoRowMeta = rowMeta;
    }

    public RowMeta getGroupInfoRowMeta() {
        return this.groupInfoRowMeta;
    }

    public void setCalOutTime(Date calOutTime) {
        this.calOutTime = calOutTime;
    }

    public Date getCalOutTime() {
        return this.calOutTime;
    }

    public void setCalNumber(String calNumber) {
        if (StringUtils.isEmpty((String)calNumber)) {
            calNumber = "";
        }
        this.calNumber = calNumber;
    }

    public String getCalNumber() {
        return this.calNumber;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isCostatenddateenable() {
        return this.costatenddateenable;
    }

    public void setCostatenddateenable(boolean costatenddateenable) {
        this.costatenddateenable = costatenddateenable;
    }

    public Date getCostatenddate() {
        return this.costatenddate;
    }

    public void setCostatenddate(Date costatenddate) {
        this.costatenddate = costatenddate;
    }

    public boolean isVoucherdutweightedavgat() {
        return this.voucherdutweightedavgat;
    }

    public void setVoucherdutweightedavgat(boolean voucherdutweightedavgat) {
        this.voucherdutweightedavgat = voucherdutweightedavgat;
    }

    public boolean isDesigoutweightedavgat() {
        return this.desigoutweightedavgat;
    }

    public void setDesigoutweightedavgat(boolean desigoutweightedavgat) {
        this.desigoutweightedavgat = desigoutweightedavgat;
    }

    public boolean isCoverdesigoutcost() {
        return this.coverdesigoutcost;
    }

    public void setCoverdesigoutcost(boolean coverdesigoutcost) {
        this.coverdesigoutcost = coverdesigoutcost;
    }
}

