/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.balance.BalanceCalculator;
import kd.fi.calx.algox.constant.CostAdjustBilCreateTypeEnum;

public class CostAdjustDeleteFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 4519087883057217029L;
    private static final Log logger = LogFactory.getLog(CostAdjustDeleteFunction.class);
    private RowMeta srcRowMeta;
    private BalanceCalculator calculator;
    private Map<String, Integer> runningModeMap;

    public CostAdjustDeleteFunction(RowMeta srcRowMeta, BalanceCalculator calculator, Map<String, Integer> runningModeMap) {
        this.srcRowMeta = srcRowMeta;
        this.calculator = calculator;
        this.runningModeMap = runningModeMap;
    }

    public RowMeta getResultRowMeta() {
        return this.srcRowMeta;
    }

    public void reduce(Iterable<RowX> it, Collector collector) {
        String createtype;
        Iterator<RowX> iterator = it.iterator();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        Long billId = null;
        String status = null;
        Long calOrgId = null;
        while (iterator.hasNext()) {
            RowX paramRowX = iterator.next();
            if (billId == null) {
                if (this.isVoucher(paramRowX)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u524d\u671f\u51fa\u5e93\u6210\u672c\u8c03\u6574\u6216\u6210\u7ec4\u6210\u672c\u8c03\u6574\u7c7b\u578b\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u3002", (String)"CostAdjustDeleteFunction_6", (String)"fi-calx-algox", (Object[])new Object[0]), this.getCostAccountName(paramRowX), this.getBillno(paramRowX));
                    throw new KDBizException(msg);
                }
                billId = this.getBillId(paramRowX);
                status = this.getBillStatus(paramRowX);
                calOrgId = paramRowX.getLong(this.srcRowMeta.getFieldIndex("calorg"));
            }
            entryIdSet.add(this.getBillEntryId(paramRowX));
        }
        DynamicObject costAdjustBill = null;
        try {
            costAdjustBill = BusinessDataServiceHelper.loadSingle(billId, (String)"cal_costadjust_subentity");
        }
        catch (Exception e) {
            logger.error("CostAdjustDeleteFunction reduce", (Throwable)e);
        }
        AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
        Boolean deleteprecostadj = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"deleteprecostadj");
        String string = createtype = costAdjustBill == null ? null : costAdjustBill.getString("createtype");
        if (costAdjustBill == null || !this.isCoverOrIncrementRun(costAdjustBill) || (0 != this.runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) || 0 != this.runningModeMap.get(AccountTypeEnum.WEIGHTAVG.getValue()) || 0 != this.runningModeMap.get(AccountTypeEnum.SPPRICE.getValue())) && deleteprecostadj != null && !deleteprecostadj.booleanValue() && !StringUtils.isEmpty((String)createtype) && CostAdjustBilCreateTypeEnum.CAL_OUT_BEFORE_PERIOD.getValue().equals(createtype)) {
            return;
        }
        try (TXHandle handler = TX.requiresNew();){
            if ("C".equals(status)) {
                this.doOperation("unaudit", costAdjustBill);
                this.calculator.updateBalance4CostAdjustDel(entryIdSet.toArray());
            }
            if ("B".equals(status)) {
                this.doOperation("unsubmit", costAdjustBill);
            }
            costAdjustBill.set("billstatus", (Object)"A");
            this.doOperation("delete", costAdjustBill);
        }
    }

    private boolean isCoverOrIncrementRun(DynamicObject costAdjustBill) {
        for (DynamicObject entry : costAdjustBill.getDynamicObjectCollection("entryentity")) {
            if (this.runningModeMap.get(entry.getString("accounttype")) != 1 && this.runningModeMap.get(entry.getString("accounttype")) != 2) continue;
            return true;
        }
        return false;
    }

    private String getCostAccountName(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("costaccountname"));
    }

    private boolean isVoucher(RowX row) {
        return row.getBoolean(this.srcRowMeta.getFieldIndex("isvoucher"));
    }

    private String getBillStatus(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("billstatus"));
    }

    private Long getBillId(RowX row) {
        return row.getLong(this.srcRowMeta.getFieldIndex("id"));
    }

    private Long getBillEntryId(RowX row) {
        return row.getLong(this.srcRowMeta.getFieldIndex("entryid"));
    }

    private String getBillno(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("billno"));
    }

    private void doOperation(String operateKey, DynamicObject costAdjustBill) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreop", "true");
        option.setVariableValue("unwriteoff", "true");
        option.setVariableValue("ignoreValidation", "true");
        if ("delete".equals(operateKey)) {
            Long id = costAdjustBill.getLong("id");
            QFilter qFilter = new QFilter("id", "=", (Object)id);
            DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{qFilter});
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operateKey, (String)"cal_costadjust_subentity", (DynamicObject[])new DynamicObject[]{costAdjustBill}, (OperateOption)option);
        if (result.isSuccess()) {
            return;
        }
        StringBuilder errorMsg = new StringBuilder();
        String msg = String.format(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u5931\u8d25\uff1a%1$s", (String)"CostAdjustDeleteFunction_2", (String)"fi-calx-algox", (Object[])new Object[0]), result.getMessage());
        errorMsg.append(msg);
        errorMsg.append('\n');
        for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
            OperateInfo operror = (OperateInfo)error;
            errorMsg.append(operror.getMessage());
            errorMsg.append('\n');
        }
        throw new KDBizException(errorMsg.toString());
    }
}

