/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.accounttype.CostAdjustInfo;
import kd.fi.calx.algox.accounttype.LocalRow;
import kd.fi.calx.algox.report.CalOutRptHolder;

public class CostDomainDataInfo {
    private CalOutRptHolder holder;
    private Long recentCostId;
    private Map<Long, BigDecimal> currentTotalElementCostMap = new HashMap<Long, BigDecimal>(16);
    private BigDecimal currentTotalQty = BigDecimal.ZERO;
    private BigDecimal currentTotalCost = BigDecimal.ZERO;
    private boolean isEmptyRange;
    private int pricePrecision = 10;
    private Long currency = 0L;
    private int calPricePrecision = 10;
    private int qtyPrecision = 2;
    private int amtPrecision = 2;
    private BigDecimal currentUnitCost = BigDecimal.ZERO;
    private Map<Long, BigDecimal> currentElementUnitCost = new HashMap<Long, BigDecimal>();
    private boolean hasPriceFailed = false;
    private boolean hasPriceFailedBill = false;
    private Long rowId = null;
    private LocalRow row = null;
    private List<LocalRow> exceptionRow = new ArrayList<LocalRow>();
    private Map<Long, Object[]> toUpdatedRowMap = new HashMap<Long, Object[]>();
    private Map<Long, Object[]> toUpdatedGroupRowMap = new HashMap<Long, Object[]>(16);
    private Map<Long, CostAdjustInfo> adjustInfoMap = new HashMap<Long, CostAdjustInfo>();
    private List<LocalRow> tempInGroupRow = new ArrayList<LocalRow>();
    private long divideBasis;
    private String divideBasisStr;
    private long calDimension;
    private String calDimensionStr;
    private String calDimensionValue;
    private long calRangeId;
    private long calOrgId;
    private long costAccountId;
    private long materialId;
    private Long periodId;

    public CostDomainDataInfo() {
    }

    public CostDomainDataInfo(Map<Long, CostSubElement> elementMap, Row row) {
        this.holder = new CalOutRptHolder();
        this.recentCostId = row.getLong("recentcostid");
        for (Long elementId : elementMap.keySet()) {
            this.getCurrentTotalElementCostMap().put(elementId, BigDecimal.ZERO);
        }
        this.calOrgId = row.getLong("calorg");
        this.costAccountId = row.getLong("costaccount");
        this.materialId = row.getLong("material");
        this.amtPrecision = row.getInteger("amtprecision");
        this.pricePrecision = row.getInteger("priceprecision");
        this.qtyPrecision = row.getInteger("qtyprecision");
        this.currency = row.getLong("localcurrency");
        this.periodId = row.getLong("periodid");
        this.calDimension = row.getLong("calDimension");
        this.calDimensionStr = row.getString("calDimensionStr");
        if (!StringUtils.isEmpty((String)this.calDimensionStr) && this.calDimensionStr.endsWith(",")) {
            this.calDimensionStr = this.calDimensionStr.substring(0, this.calDimensionStr.length() - 1);
        }
        this.calDimensionValue = row.getString("calDimensionValue");
        this.divideBasis = row.getLong("divideBasis");
        this.divideBasisStr = row.getString("divideBasisStr");
        if (this.divideBasisStr.endsWith(",")) {
            this.divideBasisStr = this.divideBasisStr.substring(0, this.divideBasisStr.length() - 1);
        }
        this.calRangeId = row.getLong("calRange");
        this.isEmptyRange = row.getBoolean("isEmptyRange");
        this.initRptHolder();
    }

    private void initRptHolder() {
        this.holder.setCalDimensionID(this.calDimension);
        this.holder.setDivideBasisID(this.divideBasis);
        this.holder.setCalDimensionValue(this.calDimensionValue);
        this.holder.setAccountType(AccountTypeEnum.MOVEDAVG_INTIME.getValue());
        this.holder.setCalOrgID(this.calOrgId);
        this.holder.setCostAccountID(this.costAccountId);
        this.holder.setMaterialID(this.materialId);
        this.holder.setPeriodID(this.periodId);
        this.holder.setCalRangeID(this.calRangeId);
    }

    public Map<Long, BigDecimal> getCurrentTotalElementCostMap() {
        return this.currentTotalElementCostMap;
    }

    public void setCurrentTotalElementCostMap(Map<Long, BigDecimal> currentTotalElementCostMap) {
        this.currentTotalElementCostMap = currentTotalElementCostMap;
    }

    public CalOutRptHolder getHolder() {
        return this.holder;
    }

    public void setHolder(CalOutRptHolder holder) {
        this.holder = holder;
    }

    public BigDecimal getCurrentTotalQty() {
        return this.currentTotalQty;
    }

    public void setCurrentTotalQty(BigDecimal currentTotalQty) {
        this.currentTotalQty = currentTotalQty;
    }

    public BigDecimal getCurrentTotalCost() {
        return this.currentTotalCost;
    }

    public void setCurrentTotalCost(BigDecimal currentTotalCost) {
        this.currentTotalCost = currentTotalCost;
    }

    public boolean isEmptyRange() {
        return this.isEmptyRange;
    }

    public void setEmptyRange(boolean isEmptyRange) {
        this.isEmptyRange = isEmptyRange;
    }

    public int getPricePrecision() {
        return this.pricePrecision;
    }

    public void setPricePrecision(int pricePrecision) {
        this.pricePrecision = pricePrecision;
    }

    public Long getCurrency() {
        return this.currency;
    }

    public void setCurrency(Long currency) {
        this.currency = currency;
    }

    public int getCalPricePrecision() {
        return this.calPricePrecision;
    }

    public void setCalPricePrecision(int calPricePrecision) {
        this.calPricePrecision = calPricePrecision;
    }

    public int getQtyPrecision() {
        return this.qtyPrecision;
    }

    public void setQtyPrecision(int qtyPrecision) {
        this.qtyPrecision = qtyPrecision;
    }

    public int getAmtPrecision() {
        return this.amtPrecision;
    }

    public void setAmtPrecision(int amtPrecision) {
        this.amtPrecision = amtPrecision;
    }

    public BigDecimal getCurrentUnitCost() {
        return this.currentUnitCost;
    }

    public void setCurrentUnitCost(BigDecimal currentUnitCost) {
        this.currentUnitCost = currentUnitCost;
    }

    public Map<Long, BigDecimal> getCurrentElementUnitCost() {
        return this.currentElementUnitCost;
    }

    public void setCurrentElementUnitCost(Map<Long, BigDecimal> currentElementUnitCost) {
        this.currentElementUnitCost = currentElementUnitCost;
    }

    public boolean isHasPriceFailed() {
        return this.hasPriceFailed;
    }

    public void setHasPriceFailed(boolean hasPriceFailed) {
        this.hasPriceFailed = hasPriceFailed;
    }

    public Long getRowId() {
        return this.rowId;
    }

    public void setRowId(Long rowId) {
        this.rowId = rowId;
    }

    public LocalRow getRow() {
        return this.row;
    }

    public void setRow(LocalRow row) {
        this.row = row;
    }

    public List<LocalRow> getExceptionRow() {
        return this.exceptionRow;
    }

    public void setExceptionRow(List<LocalRow> exceptionRow) {
        this.exceptionRow = exceptionRow;
    }

    public Map<Long, Object[]> getToUpdatedRowMap() {
        return this.toUpdatedRowMap;
    }

    public void setToUpdatedRowMap(Map<Long, Object[]> toUpdatedRowMap) {
        this.toUpdatedRowMap = toUpdatedRowMap;
    }

    public Map<Long, Object[]> getToUpdatedGroupRowMap() {
        return this.toUpdatedGroupRowMap;
    }

    public void setToUpdatedGroupRowMap(Map<Long, Object[]> toUpdatedGroupRowMap) {
        this.toUpdatedGroupRowMap = toUpdatedGroupRowMap;
    }

    public Map<Long, CostAdjustInfo> getAdjustInfoMap() {
        return this.adjustInfoMap;
    }

    public void setAdjustInfoMap(Map<Long, CostAdjustInfo> adjustInfoMap) {
        this.adjustInfoMap = adjustInfoMap;
    }

    public List<LocalRow> getTempInGroupRow() {
        return this.tempInGroupRow;
    }

    public void setTempInGroupRow(List<LocalRow> tempInGroupRow) {
        this.tempInGroupRow = tempInGroupRow;
    }

    public boolean isHasPriceFailedBill() {
        return this.hasPriceFailedBill;
    }

    public void setHasPriceFailedBill(boolean hasPriceFailedBill) {
        this.hasPriceFailedBill = hasPriceFailedBill;
    }

    public Long getRecentCostId() {
        return this.recentCostId;
    }

    public void setRecentCostId(Long recentCostId) {
        this.recentCostId = recentCostId;
    }
}

