/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class CostRecordCheckCostFunction
extends FlatMapFunction {
    private static final long serialVersionUID = 5762722982258256085L;
    private RowMeta srcRowMeta;

    public CostRecordCheckCostFunction(RowMeta srcRowMeta) {
        this.srcRowMeta = srcRowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcRowMeta;
    }

    public void flatMap(RowX paramRowX, Collector paramCollector) {
        if (!this.isInGroup(paramRowX) && "IN".equals(this.getCalBillType(paramRowX)) && !this.isPresent(paramRowX).booleanValue() && !this.isUnitActualCostCorrect(paramRowX).booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u7684\u5165\u5e93\u7c7b\u578b\u6838\u7b97\u6210\u672c\u8bb0\u5f55,\u5b58\u5728\u5206\u5f55\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u8bb0\u5f55,\u8bf7\u68c0\u67e5\u3002\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%2$s", (String)"CostRecordCheckCostFunction_3", (String)"fi-calx-algox", (Object[])new Object[0]), this.getCostAccountName(paramRowX), this.getBillno(paramRowX)));
            throw new KDBizException(errorMsg.toString());
        }
        paramCollector.collect(paramRowX);
    }

    private boolean isInGroup(RowX row) {
        Long groupid = row.getLong(this.srcRowMeta.getFieldIndex("groupid"));
        return groupid != null && !groupid.equals(0L);
    }

    private String getCostAccountName(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("costaccountname"));
    }

    private String getBillno(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("billno"));
    }

    private BigDecimal getActualCost(RowX row) {
        return row.getBigDecimal(this.srcRowMeta.getFieldIndex("actualcost"));
    }

    private BigDecimal getQty(RowX row) {
        return row.getBigDecimal(this.srcRowMeta.getFieldIndex("baseqty"));
    }

    private String getCalBillType(RowX row) {
        return row.getString(this.srcRowMeta.getFieldIndex("calbilltype"));
    }

    private Boolean isPresent(RowX row) {
        return row.getBoolean(this.srcRowMeta.getFieldIndex("ispresent"));
    }

    private Boolean isUnitActualCostCorrect(RowX row) {
        BigDecimal actualCost = this.getActualCost(row);
        BigDecimal qty = this.getQty(row);
        if (actualCost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
            return Boolean.FALSE;
        }
        return actualCost.signum() == qty.signum();
    }
}

