/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.function.CostRecordUpdateFunction;

public class CostRecordUpdateCalFlagFunction
extends GroupReduceFunction {
    protected static Log log = LogFactory.getLog(CostRecordUpdateFunction.class);
    private static final long serialVersionUID = 3934156157801826311L;
    private static final String UPDATE_COSTRECORD = "update t_cal_calcostrecordentry set fiscalculated = ? where fentryid = ?";
    private RowMeta rowMeta;
    private int BATCH_SIZE = 1000;

    public CostRecordUpdateCalFlagFunction(RowMeta rowMeta, Integer BATCH_SIZE) {
        this.rowMeta = rowMeta;
        this.BATCH_SIZE = BATCH_SIZE;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        Iterator<RowX> it = arg0.iterator();
        ArrayList<Object[]> recordUpdate_list = new ArrayList<Object[]>();
        HashSet<Long> costAccountIds = new HashSet<Long>();
        Date startDate = null;
        Date endDate = null;
        while (it.hasNext()) {
            RowX row = it.next();
            Long entryid = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            costAccountIds.add(row.getLong(this.rowMeta.getFieldIndex("costAccount")));
            Date bizDate = row.getDate(this.rowMeta.getFieldIndex("bizdate"));
            if (startDate == null || startDate.after(bizDate)) {
                startDate = bizDate;
            }
            if (endDate == null || endDate.before(bizDate)) {
                endDate = bizDate;
            }
            row.getBoolean(this.rowMeta.getFieldIndex("iscalculated"));
            Object[] recordUpdateparams = new Object[]{"1", entryid};
            recordUpdate_list.add(recordUpdateparams);
        }
        Date newStDate = startDate;
        Date newEdDate = endDate;
        log.info("#################CostRecordUpdateCalFlagFunction->costAccountIDs:" + costAccountIds);
        DBRoute route = new DBRoute("cal");
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)newEdDate)});){
            ctx.set();
            Lists.partition(recordUpdate_list, (int)this.BATCH_SIZE).forEach(list1 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_COSTRECORD, (List)list1);
                    }
                    catch (Throwable e) {
                        log.info("CostRecordUpdateCalFlagFunction->recordUpdate_list Throwable erro");
                        log.error(e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateCalFlagFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\uff1a" + list1.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
                log.info("#################CostRecordUpdateCalFlagFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\u5f53\u524d\u6279\u6b21\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
    }
}

