/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.calx.algox.constant.CostPriceSourceTypeEnum;

public class CostRecordUpdateFunction
extends GroupReduceFunction {
    protected static Log log = LogFactory.getLog(CostRecordUpdateFunction.class);
    private static final long serialVersionUID = 3934156157801826311L;
    private static final String UPDATE_COSTRECORD = "update t_cal_calcostrecordentry set funitactualcost=? , factualcost = ?, funitmaterialcost = ?, fmaterialcost = ?, funitfee = ?, ffee = ?, funitprocesscost = ?, fprocesscost = ?, funitmanufacturecost = ?, fmanufacturecost = ?, funitresource = ?, fresource = ?, fiscalculated = ?, fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
    private static final String UPDATE_COSTRECORD_DETAIL = "update t_cal_costrecord_detail set funitactualcost=? , factualcost = ? where fentryid = ? and fcostsubelementid = ?";
    private RowMeta rowMeta;
    private RowMeta resultMeta;
    private static final int priceprecision = 10;
    private int BATCH_SIZE = 1000;

    public CostRecordUpdateFunction(RowMeta rowMeta, RowMeta resultMeta, Integer BATCH_SIZE) {
        this.rowMeta = rowMeta;
        this.resultMeta = resultMeta;
        this.BATCH_SIZE = BATCH_SIZE;
    }

    public RowMeta getResultRowMeta() {
        return this.resultMeta;
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        Iterator<RowX> it = arg0.iterator();
        ArrayList<Object[]> recordUpdate_list = new ArrayList<Object[]>();
        ArrayList<Object[]> elementUpdate_list = new ArrayList<Object[]>();
        HashSet<Long> costAccountIds = new HashSet<Long>();
        HashSet<Long> headIds = new HashSet<Long>();
        Date startDate = null;
        Date endDate = null;
        while (it.hasNext()) {
            RowX row = it.next();
            Long entryid = row.getLong(this.rowMeta.getFieldIndex("entryid"));
            Long headid = row.getLong(this.rowMeta.getFieldIndex("headid"));
            String billTypeNum = row.getString(this.rowMeta.getFieldIndex("billtypenum"));
            costAccountIds.add(row.getLong(this.rowMeta.getFieldIndex("costAccount")));
            Date bizDate = row.getDate(this.rowMeta.getFieldIndex("bizdate"));
            if (startDate == null || startDate.after(bizDate)) {
                startDate = bizDate;
            }
            if (endDate == null || endDate.before(bizDate)) {
                endDate = bizDate;
            }
            BigDecimal baseqty = row.getBigDecimal(this.rowMeta.getFieldIndex("baseqty"));
            Object[] recordUpdateparams = this.createRecordUpdateObj(entryid, baseqty, row);
            recordUpdate_list.add(recordUpdateparams);
            String elementinfo = row.getString(this.rowMeta.getFieldIndex("elementinfo"));
            String elementunitinfo = row.getString(this.rowMeta.getFieldIndex("elementunitinfo"));
            Map costMap = null;
            Map unitCostMap = null;
            try {
                costMap = (Map)JSONUtils.cast((String)elementinfo, Map.class, (Class[])new Class[]{String.class, BigDecimal.class});
                unitCostMap = (Map)JSONUtils.cast((String)elementunitinfo, Map.class, (Class[])new Class[]{String.class, BigDecimal.class});
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            for (Map.Entry entry : costMap.entrySet()) {
                Object[] elementUpdate_params = this.createRecird_ElementUpdateObj(entryid, baseqty, Long.parseLong((String)entry.getKey()), (BigDecimal)entry.getValue(), (BigDecimal)unitCostMap.get((String)entry.getKey() + "unitcost"));
                elementUpdate_list.add(elementUpdate_params);
            }
            headIds.add(headid);
            arg1.collect(new RowX(new Object[]{entryid, headid, billTypeNum}));
        }
        Date newStDate = startDate;
        Date newEdDate = endDate;
        log.info("#################CostRecordUpdateFunction->costAccountIDs:" + costAccountIds);
        log.info("#################CostRecordUpdateFunction\u2014>recordUpdate_list.size:" + recordUpdate_list.size());
        log.info("#################CostRecordUpdateFunction\u2014>elementUpdate_list.size:" + elementUpdate_list.size());
        DBRoute route = new DBRoute("cal");
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)newEdDate)});){
            ctx.set();
            Lists.partition(recordUpdate_list, (int)this.BATCH_SIZE).forEach(list1 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_COSTRECORD, (List)list1);
                    }
                    catch (Throwable e) {
                        log.error("CostRecordUpdateFunction->recordUpdate_list Throwable erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\uff1a" + list1.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry\u5206\u5f55\u5f53\u524d\u6279\u6b21\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
        ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)newEdDate)});
        var14_14 = null;
        try {
            ctx.set();
            Lists.partition(elementUpdate_list, (int)this.BATCH_SIZE).forEach(list3 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)route, (String)UPDATE_COSTRECORD_DETAIL, (List)list3);
                    }
                    catch (Throwable e) {
                        log.error("CostRecordUpdateFunction->elementUpdate_list erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry_Detail\u5206\u5f55\uff1a" + list3.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var14_14 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)newStDate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)newEdDate)});
        var14_14 = null;
        try {
            ctx.set();
            Lists.partition(new ArrayList(headIds), (int)this.BATCH_SIZE).forEach(list4 -> {
                Long startTime = System.currentTimeMillis();
                try (TXHandle handler = TX.requiresNew();){
                    try {
                        StringBuilder sb = new StringBuilder();
                        Iterator iterator = list4.iterator();
                        while (iterator.hasNext()) {
                            long id = (Long)iterator.next();
                            sb.append(id).append(",");
                        }
                        String ids = sb.substring(0, sb.length() - 1);
                        String sql = "update t_cal_calcostrecord set fcostupdatetime = getDate() where fid in (" + ids + ")";
                        DB.execute((DBRoute)route, (String)sql);
                    }
                    catch (Throwable e) {
                        log.error("CostRecordUpdateFunction->elementUpdate_list erro", e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                Long endTime = System.currentTimeMillis();
                log.info("#################CostRecordUpdateFunction\u2014>\u66f4\u65b0COSTRECORDEntry_Detail\u5206\u5f55\uff1a" + list4.size() + "\u6761,\u8017\u65f6" + (endTime - startTime) / 1000L + "\u79d2");
            });
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var14_14 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    private Object[] createRecordUpdateObj(Long recordId, BigDecimal qty, RowX row) {
        String costpricesourcetype;
        BigDecimal unitresource;
        BigDecimal unitmanufacturecost;
        BigDecimal unitprocesscost;
        BigDecimal unitfee;
        BigDecimal unitmaterialcost;
        BigDecimal actualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("actualcost"));
        BigDecimal materialCost = row.getBigDecimal(this.rowMeta.getFieldIndex("materialcost"));
        BigDecimal fee = row.getBigDecimal(this.rowMeta.getFieldIndex("fee"));
        BigDecimal processcost = row.getBigDecimal(this.rowMeta.getFieldIndex("processcost"));
        BigDecimal manufacturecost = row.getBigDecimal(this.rowMeta.getFieldIndex("manufacturecost"));
        BigDecimal resource = row.getBigDecimal(this.rowMeta.getFieldIndex("resource"));
        BigDecimal unitactualcost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitactualcost"));
        if (unitactualcost == null || unitactualcost.compareTo(BigDecimal.ZERO) == 0) {
            unitactualcost = actualcost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if ((unitmaterialcost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmaterialcost"))) == null || unitmaterialcost.compareTo(BigDecimal.ZERO) == 0) {
            unitmaterialcost = materialCost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if ((unitfee = row.getBigDecimal(this.rowMeta.getFieldIndex("unitfee"))) == null || unitfee.compareTo(BigDecimal.ZERO) == 0) {
            unitfee = fee.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if ((unitprocesscost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitprocesscost"))) == null || unitprocesscost.compareTo(BigDecimal.ZERO) == 0) {
            unitprocesscost = processcost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if ((unitmanufacturecost = row.getBigDecimal(this.rowMeta.getFieldIndex("unitmanufacturecost"))) == null || unitmanufacturecost.compareTo(BigDecimal.ZERO) == 0) {
            unitmanufacturecost = manufacturecost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        if ((unitresource = row.getBigDecimal(this.rowMeta.getFieldIndex("unitresource"))) == null || unitresource.compareTo(BigDecimal.ZERO) == 0) {
            unitresource = resource.divide(qty, 10, RoundingMode.HALF_UP);
        }
        boolean designatedcost = row.getBoolean(this.rowMeta.getFieldIndex("designatedcost"));
        String costpricesource = row.getString(this.rowMeta.getFieldIndex("costpricesource"));
        String designatedcostStr = "0";
        if (designatedcost) {
            designatedcostStr = "1";
        }
        if ("splitbill".equals(costpricesourcetype = row.getString(this.rowMeta.getFieldIndex("costpricesourcetype")))) {
            costpricesource = " ";
            designatedcostStr = "0";
        } else if (StringUtils.isNotEmpty((CharSequence)costpricesourcetype)) {
            String designated = CostPriceSourceTypeEnum.getDesignatedByCostPriceSource(costpricesourcetype);
            if ("1".equals(designated)) {
                designatedcostStr = "1";
            }
            costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, costpricesourcetype);
        }
        return new Object[]{unitactualcost, actualcost, unitmaterialcost, materialCost, unitfee, fee, unitprocesscost, processcost, unitmanufacturecost, manufacturecost, unitresource, resource, "1", costpricesource, designatedcostStr, recordId};
    }

    private Object[] createRecird_ElementUpdateObj(Long recordId, BigDecimal qty, long elementId, BigDecimal cost, BigDecimal unitCost) {
        BigDecimal currentUnitCost = unitCost;
        if (currentUnitCost == null || currentUnitCost.compareTo(BigDecimal.ZERO) == 0) {
            currentUnitCost = cost.divide(qty, 10, RoundingMode.HALF_UP);
        }
        return new Object[]{currentUnitCost, cost, recordId, elementId};
    }
}

