/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CalOutDataRangeHolder;

public class FilterBalanceByCalRangeFunction
extends FilterFunction {
    private static final long serialVersionUID = 763926548853031910L;
    private RowMeta rowMeta;
    private List<CalOutDataRangeHolder.CalOutRange> calOutRangeList;

    public FilterBalanceByCalRangeFunction(RowMeta rowMeta, List<CalOutDataRangeHolder.CalOutRange> calOutRangeList) {
        this.rowMeta = rowMeta;
        this.calOutRangeList = calOutRangeList;
    }

    public boolean test(RowX row) {
        return this.isInCalRange(row);
    }

    private Long getCalRangeId(RowX row) {
        return row.getLong(this.rowMeta.getFieldIndex("calRange"));
    }

    private Long getPeriodID(RowX row) {
        return row.getLong(this.rowMeta.getFieldIndex("periodid"));
    }

    private Long getMaterialID(RowX row) {
        return row.getLong(this.rowMeta.getFieldIndex("material"));
    }

    private boolean isInCalRange(RowX row) {
        Long calRangeId = this.getCalRangeId(row);
        Long periodId = this.getPeriodID(row);
        Long materialId = this.getMaterialID(row);
        for (CalOutDataRangeHolder.CalOutRange range : this.calOutRangeList) {
            if (!calRangeId.equals(range.getCalRangeId()) || !periodId.equals(range.getPeriodId())) continue;
            if (range.isAllMaterial()) {
                return true;
            }
            for (Set<Object> materialIdSet : range.getMaterialSetList()) {
                if (!materialIdSet.contains(materialId)) continue;
                return true;
            }
        }
        return false;
    }
}

