/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.util.ArrayUtils;

public class GroupIdBakFunction
extends GroupReduceFunction {
    private final RowMeta srcMeta;

    public GroupIdBakFunction(RowMeta rowMeta) {
        this.srcMeta = rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        HashSet<String> groupIds = new HashSet<String>(16);
        while (iterator.hasNext()) {
            RowX row = iterator.next();
            String groupId = row.getString(this.srcMeta.getFieldIndex("groupid"));
            if (groupId != null && !groupId.equals("0") && !groupIds.add(groupId)) {
                groupId = "0";
            }
            collector.collect(new RowX(ArrayUtils.concatAll(row.values(), new Object[][]{{groupId}})));
        }
    }

    public RowMeta getResultRowMeta() {
        return new RowMeta(ArrayUtils.concatAll(this.srcMeta.getFields(), new Field[][]{{new Field("groupidbak", (DataType)DataType.StringType)}}));
    }
}

