/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.IAccountType;
import kd.fi.calx.algox.function.AbstractAccountTypeFunction;
import kd.fi.calx.algox.function.AccountTypeContext;
import kd.fi.calx.algox.function.CommonInfo;

public class InAccountTypeFunction
extends AbstractAccountTypeFunction {
    private static final long serialVersionUID = 3755512488177842536L;

    public InAccountTypeFunction(RowMeta rowMeta, CommonInfo commonInfo, Map<Long, CostAccount> costAccountMap) {
        super(rowMeta, commonInfo, costAccountMap);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        try (DataSet dataSet = this.createDataSet(iterable);){
            AccountTypeContext ctx = this.createContext(collector);
            DataSet rptSet = dataSet.copy().groupBy(new String[]{"divideBasis", "divideBasisValue", "calRange", "calDimension", "calDimensionValue", "accountType", "isEmptyRange"}).min("ingroupseq").finish().orderBy(new String[]{"ingroupseq"});
            List<Map<String, Object>> groupList = this.getGroupList(rptSet);
            DataSet orderDataSet = dataSet.orderBy(new String[]{"ingroupseq", "bizbillentryid", "calbilltype desc", "grouptype desc"});
            for (Row row : orderDataSet.copy()) {
                ctx.getGroupBillHolder().addGroupRecord(row);
            }
            LinkedHashMap<String, AbstractAccountTypeFunction.CalRangeDataSet> calRangeDataMap = this.mergeCalRangeData(orderDataSet, groupList);
            ArrayList<IAccountType> accountTypeList = new ArrayList<IAccountType>();
            for (AbstractAccountTypeFunction.CalRangeDataSet data : calRangeDataMap.values()) {
                IAccountType accountType = this.createAccountType(data.getAccountType(), ctx, data.getDataSet());
                if (accountType == null) continue;
                accountTypeList.add(accountType);
            }
            this.execute(ctx, accountTypeList);
        }
    }
}

