/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.function.InAccountTypeFunction;

public class MatchCalRangeFunction
extends FlatMapFunction {
    private static final long serialVersionUID = -6012286028519875632L;
    private static Log log = LogFactory.getLog(InAccountTypeFunction.class);
    private RowMeta rowMeta;
    private RowMeta resultRowMeta;
    private Map<Long, CostAccount> costAccountMap;
    private static final char CONNECTOR = '_';
    private List<String> costDomainList = Arrays.asList("calDimensionValue", "calrange", "costaccount", "divideBasisValue", "material");

    public MatchCalRangeFunction(RowMeta rowMeta, Map<Long, CostAccount> costAccountMap) {
        this.rowMeta = rowMeta;
        this.resultRowMeta = this.createResultMeta(rowMeta);
        this.costAccountMap = costAccountMap;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public void flatMap(RowX row, Collector collector) {
        try {
            Long costaccountid = (Long)this.getRowValue(row, "costaccount", false);
            Long calrangeid = (Long)this.getRowValue(row, "calrangeid", false);
            String rowtype = (String)this.getRowValue(row, "rowtype", false);
            CostAccount costAccount = this.costAccountMap.get(costaccountid);
            for (CalRange calRange : costAccount.getNotEmptyCalRange()) {
                if ("3".equals(rowtype) || "4".equals(rowtype)) {
                    if (!calRange.getRangeId().equals(calrangeid)) continue;
                    this.collectNewRow(row, costAccount, calRange, collector, false);
                    return;
                }
                CalRange.CalRangeEntry rangeEntry = calRange.getValidCalRangeEntry(row, this.rowMeta);
                if (rangeEntry == null) continue;
                this.collectNewRow(row, costAccount, calRange, collector, false);
                return;
            }
            CalRange emptyRange = costAccount.getEmptyCalRange();
            if (emptyRange == null) {
                return;
            }
            this.collectNewRow(row, costAccount, emptyRange, collector, true);
        }
        catch (Exception e) {
            log.error("MatchCalRangeFunction\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private RowMeta createResultMeta(RowMeta rowMeta) {
        Field[] sourceFields = rowMeta.getFields();
        int sourceArrLength = sourceFields.length;
        Field divideBasis = new Field("divideBasis", (DataType)DataType.LongType);
        Field divideBasisStr = new Field("divideBasisStr", (DataType)DataType.StringType);
        Field divideBasisValue = new Field("divideBasisValue", (DataType)DataType.StringType);
        Field calRange = new Field("calRange", (DataType)DataType.LongType);
        Field calDimension = new Field("calDimension", (DataType)DataType.LongType);
        Field calDimensionStr = new Field("calDimensionStr", (DataType)DataType.StringType);
        Field calDimensionValue = new Field("calDimensionValue", (DataType)DataType.StringType);
        Field accountType = new Field("accountType", (DataType)DataType.StringType);
        Field isEmptyRange = new Field("isEmptyRange", (DataType)DataType.BooleanType);
        Field costdomianid = new Field("costdomainid", (DataType)DataType.StringType);
        Field[] resultFields = new Field[sourceArrLength + 10];
        System.arraycopy(sourceFields, 0, resultFields, 0, sourceArrLength);
        resultFields[sourceArrLength] = divideBasis;
        resultFields[sourceArrLength + 1] = divideBasisStr;
        resultFields[sourceArrLength + 2] = divideBasisValue;
        resultFields[sourceArrLength + 3] = calRange;
        resultFields[sourceArrLength + 4] = calDimension;
        resultFields[sourceArrLength + 5] = calDimensionStr;
        resultFields[sourceArrLength + 6] = calDimensionValue;
        resultFields[sourceArrLength + 7] = accountType;
        resultFields[sourceArrLength + 8] = isEmptyRange;
        resultFields[sourceArrLength + 9] = costdomianid;
        return new RowMeta(resultFields);
    }

    private void collectNewRow(RowX row, CostAccount costAccount, CalRange range, Collector collector, boolean isEmptyRange) {
        Long materialId = (Long)this.getRowValue(row, "material", false);
        int sourceCount = this.rowMeta.getFieldCount();
        RowX resultRow = new RowX(this.resultRowMeta.getFieldCount());
        for (int i = 0; i < sourceCount; ++i) {
            resultRow.set(i, row.get(i));
        }
        resultRow.set(sourceCount, (Object)costAccount.getDivideBasisID());
        StringBuilder sb = new StringBuilder();
        StringBuilder valueSb = new StringBuilder();
        for (String basis : costAccount.getDivideBasis()) {
            valueSb.append(this.getRowValue(row, basis, true));
            valueSb.append('_');
            sb.append(basis);
            sb.append(',');
        }
        if (sb.length() != 0 && sb.toString().endsWith(",")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        resultRow.set(sourceCount + 1, (Object)sb.toString());
        String divideBasisValue = valueSb.toString();
        if (!isEmptyRange) {
            divideBasisValue = "";
        }
        resultRow.set(sourceCount + 2, (Object)divideBasisValue);
        Long rangeId = range.getRangeId();
        resultRow.set(sourceCount + 3, (Object)range.getRangeId());
        String mGroupNo = (String)this.getRowValue(row, "materialGroupNo", false);
        String spCaldimension = null;
        spCaldimension = costAccount.getSpCaldimension(rangeId.toString(), materialId.toString(), mGroupNo);
        Long calDimensionID = 0L;
        String calDimesionStr = "";
        if (spCaldimension == null) {
            calDimensionID = range.getCalDimensionID();
            calDimesionStr = range.getCaldimension();
        } else {
            String[] spArr = spCaldimension.split("@");
            calDimensionID = Long.valueOf(spArr[0]);
            calDimesionStr = spArr[1];
        }
        resultRow.set(sourceCount + 4, (Object)calDimensionID);
        sb.setLength(0);
        valueSb.setLength(0);
        if (!StringUtils.isEmpty((String)calDimesionStr)) {
            for (String dimension : calDimesionStr.split(",")) {
                valueSb.append(this.getRowValue(row, dimension, true));
                valueSb.append('_');
            }
        }
        resultRow.set(sourceCount + 5, (Object)calDimesionStr);
        resultRow.set(sourceCount + 6, (Object)valueSb.toString());
        String accountType = null;
        accountType = costAccount.getSpAccountType(rangeId.toString(), materialId.toString(), mGroupNo);
        if (accountType == null) {
            accountType = range.getAccountType();
        }
        resultRow.set(sourceCount + 7, (Object)accountType);
        resultRow.set(sourceCount + 8, (Object)range.isEmpty());
        String rowType = (String)this.getRowValue(row, "rowtype", false);
        if ((accountType.equals(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) || accountType.equals(AccountTypeEnum.FIFO.getValue())) && (rowType.equals("1") || rowType.equals("2"))) {
            Long currentPeriod = costAccount.getCurrentPeriod();
            resultRow.set(this.rowMeta.getFieldIndex("periodid"), (Object)currentPeriod);
        }
        resultRow.set(sourceCount + 9, (Object)this.getCostDomainID(resultRow, costAccount, range, calDimesionStr));
        collector.collect(resultRow);
    }

    private Object getRowValue(RowX row, String field, boolean isDivideOrCaldimension) {
        int index = this.rowMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (isDivideOrCaldimension && (value == null || value.equals(""))) {
            value = "#";
        }
        return value;
    }

    private String getCostDomainID(RowX row, CostAccount costAccount, CalRange range, String calDimesionStr) {
        CalRange emptyCalRange = costAccount.getEmptyCalRange();
        StringBuilder divideVal = new StringBuilder();
        if (emptyCalRange != null && emptyCalRange.getRangeId().compareTo(range.getRangeId()) == 0) {
            for (String basis : costAccount.getDivideBasis()) {
                divideVal.append(this.getRowValue(row, basis, true));
                divideVal.append('_');
            }
        } else {
            divideVal.append("");
        }
        StringBuilder calDimesionVal = new StringBuilder();
        if (!StringUtils.isEmpty((String)calDimesionStr)) {
            for (String dimension : calDimesionStr.split(",")) {
                calDimesionVal.append(this.getRowValue(row, dimension, true));
                calDimesionVal.append('_');
            }
        }
        Long materialId = (Long)this.getRowValue(row, "material", false);
        Long periodId = (Long)this.getRowValue(row, "periodid", false);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("calDimensionValue", calDimesionVal.toString());
        map.put("calrange", range.getRangeId());
        map.put("costaccount", costAccount.getId());
        map.put("divideBasisValue", divideVal.toString());
        map.put("material", materialId);
        map.put("period", periodId);
        return this.getCostDomainDimsionKey(map);
    }

    private String getCostDomainDimsionKey(Map<String, Object> map) {
        StringBuilder dimensionStr = new StringBuilder();
        for (String field : this.costDomainList) {
            Object value = map.get(field);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
        String domainId = MatchCalRangeFunction.getSHA256Base64Str(dimensionStr.toString());
        return domainId;
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }
}

