/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.function;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.CalRange;
import kd.fi.calx.algox.CostAccount;

public class MatchRecentCostCostDomainFunction
extends FlatMapFunction {
    private static final long serialVersionUID = -2125941122376567922L;
    private static Log log = LogFactory.getLog(MatchRecentCostCostDomainFunction.class);
    private RowMeta rowMeta;
    private RowMeta resultRowMeta;
    private Map<Long, CostAccount> costAccountMap;
    private static final char CONNECTOR = '_';
    private List<String> costDomainList = Arrays.asList("calDimensionValue", "calrange", "costaccount", "divideBasisValue", "material");

    public MatchRecentCostCostDomainFunction(RowMeta rowMeta, Map<Long, CostAccount> costAccountMap) {
        this.rowMeta = rowMeta;
        this.resultRowMeta = this.createResultMeta(rowMeta);
        this.costAccountMap = costAccountMap;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public void flatMap(RowX row, Collector collector) {
        try {
            Long costaccountid = (Long)this.getRowValue(row, "costaccount", false);
            Long calrangeid = (Long)this.getRowValue(row, "calrangeid", false);
            CostAccount costAccount = this.costAccountMap.get(costaccountid);
            for (CalRange calRange : costAccount.getNotEmptyCalRange()) {
                if (!calRange.getRangeId().equals(calrangeid)) continue;
                this.collectNewRow(row, costAccount, calRange, collector);
                return;
            }
            CalRange emptyRange = costAccount.getEmptyCalRange();
            if (emptyRange == null) {
                return;
            }
            this.collectNewRow(row, costAccount, emptyRange, collector);
        }
        catch (Exception e) {
            log.error("MatchRecentCostCostDomainFunction\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private RowMeta createResultMeta(RowMeta rowMeta) {
        Field[] sourceFields = rowMeta.getFields();
        int sourceArrLength = sourceFields.length;
        Field costdomianid = new Field("costdomainid", (DataType)DataType.StringType);
        Field[] resultFields = new Field[sourceArrLength + 1];
        System.arraycopy(sourceFields, 0, resultFields, 0, sourceArrLength);
        resultFields[sourceArrLength] = costdomianid;
        return new RowMeta(resultFields);
    }

    private void collectNewRow(RowX row, CostAccount costAccount, CalRange range, Collector collector) {
        Long materialId = (Long)this.getRowValue(row, "material", false);
        int sourceCount = this.rowMeta.getFieldCount();
        RowX resultRow = new RowX(this.resultRowMeta.getFieldCount());
        for (int i = 0; i < sourceCount; ++i) {
            resultRow.set(i, row.get(i));
        }
        if (range == null || range.getRangeId() == 0L) {
            Long emptyRangeId = costAccount.getEmptyCalRange() == null ? Long.valueOf(0L) : costAccount.getEmptyCalRange().getRangeId();
            resultRow.set(this.rowMeta.getFieldIndex("calrangeid"), (Object)emptyRangeId);
            range = costAccount.getEmptyCalRange();
        }
        String mGroupNo = (String)this.getRowValue(row, "materialGroupNo", false);
        String spCaldimension = null;
        Long rangeId = range.getRangeId();
        spCaldimension = costAccount.getSpCaldimension(rangeId.toString(), materialId.toString(), mGroupNo);
        String calDimesionStr = "";
        if (spCaldimension == null) {
            calDimesionStr = range.getCaldimension();
        } else {
            String[] spArr = spCaldimension.split("@");
            calDimesionStr = spArr[1];
        }
        resultRow.set(sourceCount, (Object)this.getCostDomainID(row, costAccount, range, calDimesionStr));
        collector.collect(resultRow);
    }

    private Object getRowValue(RowX row, String field, boolean isDivideOrCaldimension) {
        int index = this.rowMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (isDivideOrCaldimension && (value == null || value.equals(""))) {
            value = "#";
        }
        return value;
    }

    private String getCostDomainID(RowX row, CostAccount costAccount, CalRange range, String calDimesionStr) {
        CalRange emptyCalRange = costAccount.getEmptyCalRange();
        StringBuilder divideVal = new StringBuilder();
        if (emptyCalRange != null && emptyCalRange.getRangeId().compareTo(range.getRangeId()) == 0) {
            for (String basis : costAccount.getDivideBasis()) {
                divideVal.append(this.getRowValue(row, basis, true));
                divideVal.append('_');
            }
        } else {
            divideVal.append("");
        }
        StringBuilder calDimesionVal = new StringBuilder();
        if (!StringUtils.isEmpty((String)calDimesionStr)) {
            for (String dimension : calDimesionStr.split(",")) {
                calDimesionVal.append(this.getRowValue(row, dimension, true));
                calDimesionVal.append('_');
            }
        }
        Long materialId = (Long)this.getRowValue(row, "material", false);
        Long periodId = costAccount.getCurrentPeriod();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("calDimensionValue", calDimesionVal.toString());
        map.put("calrange", range.getRangeId());
        map.put("costaccount", costAccount.getId());
        map.put("divideBasisValue", divideVal.toString());
        map.put("material", materialId);
        map.put("period", periodId);
        return this.getCostDomainDimsionKey(map);
    }

    private String getCostDomainDimsionKey(Map<String, Object> map) {
        StringBuilder dimensionStr = new StringBuilder();
        for (String field : this.costDomainList) {
            Object value = map.get(field);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
        String domainId = MatchRecentCostCostDomainFunction.getSHA256Base64Str(dimensionStr.toString());
        return domainId;
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }
}

